/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.trigger.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.MessageContext;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupResource;
import org.globus.mds.aggregator.impl.AggregatorSink;
import org.globus.mds.aggregator.impl.AggregatorSource;
import org.globus.mds.aggregator.types.AggregatorConfig;
import org.globus.mds.aggregator.types.AggregatorContent;
import org.globus.mds.aggregator.types.AggregatorData;
import org.globus.mds.trigger.impl.TriggerConfiguration;
import org.globus.mds.trigger.types.ActionResult;
import org.globus.mds.trigger.types.TriggerInvalidityTime;
import org.globus.mds.trigger.types.TriggerRuleType;
import org.globus.mds.trigger.types.TriggerStatusArray;
import org.globus.mds.trigger.types.TriggerStatusType;
import org.globus.mds.usefulrp.AccumulatorResourceProperty;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleTopicList;
import org.globus.wsrf.impl.servicegroup.EntryResourcePropertyTopic;
import org.globus.wsrf.impl.servicegroup.ServiceGroupConstants;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TriggerResource
extends AggregatorServiceGroupResource
implements AggregatorSink,
TopicListAccessor {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$trigger$impl$TriggerResource == null ? (class$org$globus$mds$trigger$impl$TriggerResource = TriggerResource.class$("org.globus.mds.trigger.impl.TriggerResource")) : class$org$globus$mds$trigger$impl$TriggerResource).getName());
    private ResourceKey resourceKey = null;
    public static final String TRIGGER_NS = "http://mds.globus.org/2004/08/trigger";
    public static final QName RP_SET = new QName("http://mds.globus.org/2004/08/trigger", "TriggerRP");
    public static final QName FIRE_COUNT_RP = new QName("http://mds.globus.org/2004/08/trigger", "ActionsFiredCount");
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = TriggerResource.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    protected Calendar terminationTime;
    private Hashtable executionTable;
    private ResourcePropertySet propSet;
    private TopicList topicList;
    private String[] strings = null;
    private int fooctr = 0;
    private TriggerConfiguration triggerConfig = null;
    private String baseDir;
    AccumulatorResourceProperty fireCountRP;
    static /* synthetic */ Class class$org$globus$mds$trigger$impl$TriggerResource;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;
    static /* synthetic */ Class class$org$globus$mds$trigger$types$TriggerStatusArray;
    static /* synthetic */ Class class$org$globus$mds$trigger$types$TriggerRuleType;

    public TriggerResource() {
        super.init(RP_SET);
        this.baseDir = TriggerResource.getBaseDirectory();
        this.propSet = this.getResourcePropertySet();
        this.topicList = new SimpleTopicList((ResourceProperties)this);
        ReflectionResourceProperty prop = null;
        EntryResourcePropertyTopic rpTopic = new EntryResourcePropertyTopic(this.propSet.get(ServiceGroupConstants.ENTRY));
        this.propSet.add((ResourceProperty)rpTopic);
        this.topicList.addTopic((Topic)rpTopic);
        try {
            prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.TERMINATION_TIME, (Object)this);
            this.propSet.add((ResourceProperty)prop);
            prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.CURRENT_TIME, (Object)this);
            this.propSet.add((ResourceProperty)prop);
            this.fireCountRP = new AccumulatorResourceProperty(FIRE_COUNT_RP);
            this.propSet.add((ResourceProperty)prop);
            this.loadCompatibleSources(this);
            this.executionTable = this.getTriggerConfiguration().getExecutableMappingTable();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trigger resource contains the following executable mapping table: " + this.executionTable.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error during TriggerResource creation: ", (Throwable)e);
        }
    }

    public TriggerConfiguration getTriggerConfiguration() {
        if (this.triggerConfig != null) {
            return this.triggerConfig;
        }
        MessageContext ctx = MessageContext.getCurrentContext();
        String servicePath = ctx.getTargetService();
        String jndiName = "java:comp/env//services/" + servicePath + "/triggerConfiguration";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will read configuration from jndi name: " + jndiName));
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.triggerConfig = (TriggerConfiguration)initialContext.lookup(jndiName);
            return this.triggerConfig;
        }
        catch (NamingException e) {
            logger.error((Object)("when performing JNDI lookup for " + jndiName + ": " + e));
        }
        catch (Exception e) {
            logger.error((Object)("when performing JNDI lookup for " + jndiName + ": " + e));
        }
        return this.triggerConfig;
    }

    public void setResourceKey(ResourceKey k) throws Exception {
        if (this.resourceKey != null) {
            throw new Exception("Resource key can only be set once.");
        }
        this.resourceKey = k;
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public void setTerminationTime(Calendar time) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set Termination time called: " + time.getTime()));
        }
        this.terminationTime = time;
    }

    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    public TopicList getTopicList() {
        return this.topicList;
    }

    public void deliver(AnyContentType messageObj, AggregatorServiceGroupEntryResource entry) {
        try {
            TriggerStatusArray triggerStatusArray;
            MessageElement[] messages;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("In trigger service deliver, with message " + AnyHelper.toSingleString((AnyContentType)messageObj)));
            }
            if ((messages = messageObj.get_any()) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Trigger resource will not process null message(s), no action(s) will be taken");
                }
                return;
            }
            Document inputDoc = null;
            try {
                inputDoc = this.anyToNewDocument(messageObj, TRIGGER_NS, "trigger:inputMessage");
            }
            catch (Exception e) {
                logger.error((Object)"Error assembling input document. No action will be taken");
                return;
            }
            if (!inputDoc.getDocumentElement().hasChildNodes()) {
                logger.warn((Object)"Input message contains no data. No action will be taken");
                return;
            }
            ResourcePropertySet rpSet = entry.getResourcePropertySet();
            ResourceProperty contentRP = rpSet.get(ServiceGroupConstants.CONTENT);
            AggregatorContent content = entry.getContent();
            AggregatorConfig aggregatorConfig = content.getAggregatorConfig();
            AggregatorData aggregatorData = content.getAggregatorData();
            try {
                triggerStatusArray = (TriggerStatusArray)ObjectDeserializer.toObject((SOAPElement)aggregatorData.get_any()[0], (Class)(class$org$globus$mds$trigger$types$TriggerStatusArray == null ? (class$org$globus$mds$trigger$types$TriggerStatusArray = TriggerResource.class$("org.globus.mds.trigger.types.TriggerStatusArray")) : class$org$globus$mds$trigger$types$TriggerStatusArray));
            }
            catch (Exception e) {
                triggerStatusArray = new TriggerStatusArray();
                if (e instanceof NullPointerException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Unable to locate existing TriggerStatusArray, creating new trigger status object array");
                    }
                }
                logger.warn((Object)("Unexpected exception while deserializing AggregatorData into internal TriggerStatusArray" + e));
            }
            Hashtable<String, TriggerStatusType> triggerStatusTable = new Hashtable<String, TriggerStatusType>();
            TriggerStatusType[] statusArray = triggerStatusArray.getTriggerStatus();
            if (statusArray != null) {
                for (int i = 0; i < statusArray.length; ++i) {
                    triggerStatusTable.put(statusArray[i].getTriggerID(), statusArray[i]);
                }
            }
            MessageElement[] any = aggregatorConfig.get_any();
            ArrayList<MessageElement> configResults = new ArrayList<MessageElement>();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking config for trigger rule(s):  " + AnyHelper.toSingleString((MessageElement[])any)));
            }
            TriggerRuleType triggerRule = null;
            TriggerStatusType triggerStatus = null;
            int triggerRules = 0;
            for (int i = 0; i < any.length; ++i) {
                TriggerInvalidityTime[] invalidity;
                if (ObjectDeserializer.contains((SOAPElement)any[i], (Class)(class$org$globus$mds$trigger$types$TriggerRuleType == null ? TriggerResource.class$("org.globus.mds.trigger.types.TriggerRuleType") : class$org$globus$mds$trigger$types$TriggerRuleType))) {
                    try {
                        triggerRule = (TriggerRuleType)ObjectDeserializer.toObject((SOAPElement)any[i], (Class)(class$org$globus$mds$trigger$types$TriggerRuleType == null ? TriggerResource.class$("org.globus.mds.trigger.types.TriggerRuleType") : class$org$globus$mds$trigger$types$TriggerRuleType));
                    }
                    catch (DeserializationException de) {
                        logger.warn((Object)("Could not deserialize trigger rule type: " + (Object)((Object)de)));
                        continue;
                    }
                    String triggerID = triggerRule.getTriggerID();
                    if (triggerID == null) {
                        triggerID = uuidGen.nextUUID();
                        triggerRule.setTriggerID(triggerID);
                        triggerStatus = new TriggerStatusType();
                        triggerStatus.setTriggerID(triggerID);
                        triggerStatus.setMatchingRule(triggerRule.getMatchingRule());
                        triggerStatusTable.put(triggerID, triggerStatus);
                    } else {
                        triggerStatus = (TriggerStatusType)triggerStatusTable.get(triggerID);
                        if (triggerStatus == null) {
                            logger.warn((Object)("Internal error: Unable to locate trigger status for a registered trigger rule. The trigger rule " + triggerID + " is not valid and will not be processed."));
                            continue;
                        }
                    }
                    configResults.add((MessageElement)ObjectSerializer.toSOAPElement((Object)triggerRule, (QName)triggerRule.getTypeDesc().getXmlType()));
                    ++triggerRules;
                } else {
                    configResults.add(any[i]);
                    continue;
                }
                String xpath = triggerRule.getMatchingRule();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing trigger rule, XPath expression is: " + xpath));
                }
                boolean evaluateBoolean = false;
                Boolean bool = triggerRule.getEvaluateBoolean();
                if (bool != null) {
                    evaluateBoolean = bool;
                }
                boolean fire = false;
                triggerStatus.setRuleLastCheckedAt(Calendar.getInstance());
                Document outputDoc = null;
                try {
                    outputDoc = this.evaluateXPath(inputDoc, xpath, triggerRule.getNamespaceMappings(), evaluateBoolean);
                }
                catch (Exception e) {
                    String error = "Trigger was not eligible to fire due to exception while evaluating XPath rule: " + e;
                    logger.warn((Object)error);
                    triggerStatus.setStatusInfo(error);
                    continue;
                }
                if (outputDoc != null) {
                    if (outputDoc.getDocumentElement().hasChildNodes()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Trigger scheduled to fire! XPath query result was: " + XmlUtils.toString((Document)outputDoc)));
                        }
                        fire = true;
                    } else {
                        String msg = "XPath query returned no results (or false) - trigger was not eligible to fire";
                        triggerStatus.setStatusInfo(msg);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)msg);
                        }
                    }
                }
                Calendar now = Calendar.getInstance();
                if (!fire) {
                    triggerStatus.setConditionTrueSince(null);
                }
                if (fire && triggerStatus.getConditionTrueSince() == null) {
                    triggerStatus.setConditionTrueSince(now);
                }
                if (fire) {
                    long minimumFiringInterval;
                    long actionFiredInterval;
                    String msg;
                    if (triggerStatus.getConditionTrueSince() != null && triggerRule.getMinimumMatchTime() != null) {
                        long minimumMatchTime;
                        long conditionTrueDuration = now.getTime().getTime() - triggerStatus.getConditionTrueSince().getTime().getTime();
                        if (conditionTrueDuration < (minimumMatchTime = (long)(triggerRule.getMinimumMatchTime() * 1000))) {
                            fire = false;
                            msg = "Inhibited trigger action because condition not true for sufficient time: the condition has been true for " + Long.toString(conditionTrueDuration) + " milliseconds, while the minimum match time is set to " + Long.toString(minimumMatchTime) + " milliseconds.";
                            triggerStatus.setStatusInfo(msg);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)msg);
                            }
                        } else {
                            Calendar last = Calendar.getInstance();
                            last.setTimeInMillis(now.getTime().getTime() - minimumMatchTime);
                            triggerStatus.setConditionTrueSince(last);
                        }
                    }
                    if (triggerStatus.getActionFiredAt() != null && triggerRule.getMinimumFiringInterval() != null && (actionFiredInterval = now.getTime().getTime() - triggerStatus.getActionFiredAt().getTime().getTime()) < (minimumFiringInterval = (long)(triggerRule.getMinimumFiringInterval() * 1000))) {
                        fire = false;
                        msg = "Inhibited trigger action because minimumFiringInterval not met: the action was triggered " + Long.toString(actionFiredInterval) + " milliseconds ago, while the minimum firing interval is set to " + Long.toString(minimumFiringInterval) + " milliseconds.";
                        triggerStatus.setStatusInfo(msg);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)msg);
                        }
                    }
                }
                if (fire && (invalidity = triggerRule.getInvalidityTime()) != null && invalidity.length > 0) {
                    Calendar startTime = null;
                    Calendar endTime = null;
                    for (int n = 0; n < invalidity.length; ++n) {
                        startTime = invalidity[n].getStartTime();
                        endTime = invalidity[n].getEndTime();
                        if (!now.after(startTime) || !now.before(endTime)) continue;
                        SimpleDateFormat sdf = new SimpleDateFormat("EEE d MMM yyyy HH:mm:ss zZ");
                        triggerStatus.setStatusInfo("The trigger action was inhibited because the execution time fell within the following invalidity time range: [" + sdf.format(startTime.getTime()) + "] to [" + sdf.format(endTime.getTime()) + "]");
                        fire = false;
                        break;
                    }
                }
                boolean disableUnmodifiedActionScriptInput = false;
                boolean enableFilteredActionScriptInput = false;
                bool = triggerRule.getDisableUnmodifiedActionScriptInput();
                if (bool != null) {
                    disableUnmodifiedActionScriptInput = bool;
                }
                if ((bool = triggerRule.getEnableFilteredActionScriptInput()) != null) {
                    enableFilteredActionScriptInput = bool;
                }
                if (!fire) continue;
                try {
                    Element actionResultElement = this.runAction(triggerRule, disableUnmodifiedActionScriptInput ? null : inputDoc, enableFilteredActionScriptInput ? outputDoc : null, entry, aggregatorConfig);
                    triggerStatus.setActionFiredAt(Calendar.getInstance());
                    this.fireCountRP.accumulate(1L);
                    ActionResult actionResult = new ActionResult();
                    MessageElement[] m = new MessageElement[]{new MessageElement(actionResultElement)};
                    actionResult.set_any(m);
                    triggerStatus.setActionOutput(actionResult);
                    String msg = "The trigger action was executed successfully";
                    triggerStatus.setStatusInfo(msg);
                    continue;
                }
                catch (Exception e) {
                    String error = "Exception while attempting to execute the trigger action: " + e;
                    logger.warn((Object)error);
                    triggerStatus.setStatusInfo(error);
                }
            }
            if (triggerRules == 0) {
                logger.info((Object)"A message was delivered, but no valid trigger rules were present in the configuration. No actions were taken.");
                return;
            }
            try {
                aggregatorConfig.set_any(configResults.toArray(new MessageElement[0]));
            }
            catch (Exception e) {
                logger.error((Object)"Exception while updating configuration into service group content", (Throwable)e);
            }
            try {
                triggerStatusArray.setTriggerStatus(triggerStatusTable.values().toArray(new TriggerStatusType[0]));
                MessageElement[] messageElementArray = new MessageElement[1];
                messageElementArray[0] = (MessageElement)ObjectSerializer.toSOAPElement((Object)triggerStatusArray, (QName)triggerStatusArray.getTypeDesc().getXmlType());
                aggregatorData.set_any(messageElementArray);
                entry.setContent(content);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while updating trigger action result output into service group content", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"End of trigger resource deliver");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unhandled exception in trigger resource deliver method: " + e));
        }
    }

    public Document evaluateXPath(Document inputDoc, String xPathExpression, String[] namespaces, boolean evaluateBoolean) throws Exception {
        Document outputDoc = XmlUtils.newDocument();
        Node outputRoot = outputDoc.appendChild(outputDoc.createElementNS(TRIGGER_NS, "trigger:xpathResult"));
        Document namespaceDoc = XmlUtils.newDocument();
        namespaceDoc.appendChild(namespaceDoc.createElementNS(TRIGGER_NS, "trigger:namespaceMap"));
        if (namespaces != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Namespace mappings detected...");
            }
            this.setNamespaces(namespaceDoc.getDocumentElement(), namespaces);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applying xpath " + xPathExpression + " to " + XmlUtils.toString((Document)inputDoc)));
        }
        XObject result = null;
        try {
            result = XPathAPI.eval((Node)inputDoc.getDocumentElement(), (String)xPathExpression, (Node)namespaceDoc.getDocumentElement());
        }
        catch (Exception e) {
            throw new Exception("Exception during trigger matchingRule XPath statement evaluation: " + e);
        }
        if (result instanceof XBoolean) {
            boolean outputBoolean = true;
            if (evaluateBoolean && !((XBoolean)result).bool()) {
                outputBoolean = false;
            }
            if (outputBoolean) {
                outputRoot.appendChild(outputDoc.importNode((Node)new Text(result.str()), true));
            }
        } else if (result instanceof XNumber || result instanceof XString) {
            MessageElement element = new MessageElement((CharacterData)new Text(result.str()));
            outputRoot.appendChild(outputDoc.importNode((Node)element, true));
        } else if (result instanceof XNodeSet) {
            XNodeSet set = (XNodeSet)result;
            NodeList list = set.nodelist();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node instanceof Document) {
                    outputRoot.appendChild(outputDoc.importNode((Node)new MessageElement(((Document)node).getDocumentElement()), true));
                    continue;
                }
                if (node instanceof Element) {
                    outputRoot.appendChild(outputDoc.importNode((Node)new MessageElement((Element)node), true));
                    continue;
                }
                if (node instanceof Attr) {
                    outputRoot.appendChild(outputDoc.importNode((Node)new MessageElement((CharacterData)new Text(((Attr)node).getNodeValue() + " ")), true));
                    continue;
                }
                if (node instanceof CharacterData) {
                    outputRoot.appendChild(outputDoc.importNode((Node)new MessageElement((CharacterData)new Text(((CharacterData)node).getData())), true));
                    continue;
                }
                throw new Exception(i18n.getMessage("unsupportedXpathReturn", (Object)node.getClass().getName()));
            }
        } else {
            throw new Exception(i18n.getMessage("unsupportedXpathReturn", (Object)result));
        }
        return outputDoc;
    }

    private void setNamespaces(Element node, String[] namespaces) {
        if (namespaces != null && namespaces.length > 0) {
            for (int i = 0; i < namespaces.length; ++i) {
                StringTokenizer st;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding user-specified namespace to search context: " + namespaces[i]));
                }
                if ((st = new StringTokenizer(namespaces[i], "=")).countTokens() % 2 != 0) {
                    logger.warn((Object)"Error parsing user-supplied namespace mapping: invalid token in namespace prefix and uri - check string format.");
                    continue;
                }
                while (st.hasMoreTokens()) {
                    node.setAttributeNS("http://www.w3.org/2000/xmlns/", st.nextToken(), st.nextToken());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element runAction(TriggerRuleType rule, Document inputDoc, Document outputDoc, AggregatorServiceGroupEntryResource entry, AggregatorConfig config) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Performing trigger action.");
        }
        String commandline = "";
        commandline = commandline + this.baseDir;
        commandline = commandline + "/libexec/trigger/";
        String triggerName = rule.getActionScript();
        String triggerFile = (String)this.executionTable.get(triggerName);
        if (triggerFile == null) {
            throw new Exception("Could not locate an executable file name mapped to the specified trigger name (check service jndi-config.xml): " + triggerName);
        }
        commandline = commandline + triggerFile;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will execute: " + commandline));
        }
        StringBuffer actionInput = new StringBuffer();
        actionInput.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        actionInput.append("<trigger:actionInput xmlns:trigger=\"http://mds.globus.org/2004/08/trigger\">");
        if (inputDoc != null) {
            actionInput.append(XmlUtils.toString((Element)inputDoc.getDocumentElement()));
        }
        if (outputDoc != null) {
            actionInput.append(XmlUtils.toString((Element)outputDoc.getDocumentElement()));
        }
        EndpointReferenceType memberEPR = entry.getMemberEPR();
        actionInput.append(ObjectSerializer.toString((Object)memberEPR, (QName)memberEPR.getTypeDesc().getXmlType()));
        actionInput.append(ObjectSerializer.toString((Object)config, (QName)config.getTypeDesc().getXmlType()));
        actionInput.append("</trigger:actionInput>");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Action script input: " + actionInput.toString()));
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(commandline);
        }
        catch (IOException e) {
            throw new Exception("Could not execute " + commandline + " with exception: " + e);
        }
        PrintStream o = new PrintStream(process.getOutputStream());
        try {
            o.println(actionInput.toString());
        }
        catch (Exception e) {
            logger.warn((Object)("Exception while writing into action script stdin: " + e));
        }
        finally {
            o.close();
        }
        Document responseDoc = null;
        try {
            responseDoc = XMLUtils.newDocument((InputStream)process.getInputStream());
        }
        catch (Exception e) {
            throw new Exception("Exception while parsing output from action script: " + e);
        }
        return responseDoc.getDocumentElement();
    }

    private Document anyToNewDocument(AnyContentType any, String docRootURI, String docRootLocalPart) throws Exception {
        try {
            Document responseDoc = XMLUtils.newDocument();
            Node node = responseDoc.appendChild(responseDoc.createElementNS(docRootURI, docRootLocalPart));
            Element[] elements = AnyHelper.toElement((MessageElement[])any.get_any());
            for (int i = 0; elements != null && i < elements.length; ++i) {
                if (elements[i] == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("message element " + i + " is null."));
                    continue;
                }
                node.appendChild(responseDoc.importNode(elements[i], true));
            }
            return responseDoc;
        }
        catch (Exception e) {
            logger.error((Object)("Unhandled exception creating multi-part message document" + e));
            throw e;
        }
    }

    private Document createErrorDocument(String error) throws Exception {
        try {
            Document responseDoc = XMLUtils.newDocument();
            Node node = responseDoc.appendChild(responseDoc.createElementNS(TRIGGER_NS, "trigger:actionScriptRuntimeError"));
            node.setNodeValue(error);
            return responseDoc;
        }
        catch (Exception e) {
            logger.error((Object)("Unhandled exception creating error response document" + e));
            throw e;
        }
    }

    private static String getBaseDirectory() {
        return ContainerConfig.getBaseDirectory();
    }

    public void initialize(Object parameters) {
    }

    public void terminate() {
    }

    public void setSource(AggregatorSource source) {
    }

    public AggregatorSource getSource() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

