/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.webmds.tomcatAdmin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.globus.wsrf.config.ContainerConfig;

public class WebmdsCreateContextFile {
    private static final String OUTPUT_FILENAME = "webmds.xml";

    public static void main(String[] args) {
        String directoryName;
        String[] unparsedArgs;
        Options options = new Options();
        options.addOption("f", "force", false, "overwrite existing webmds.xml file");
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        boolean force = false;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (commandLine == null) {
            System.err.println("error parsing command line");
            System.exit(-1);
        }
        if (commandLine.hasOption("f")) {
            force = true;
        }
        if ((unparsedArgs = commandLine.getArgs()).length != 1) {
            System.err.println("Wrong number of arguments (was " + Integer.toString(unparsedArgs.length) + ")");
            System.exit(1);
        }
        if ((directoryName = unparsedArgs[0]) == null) {
            System.err.println("no directory name specified");
            System.exit(-1);
        }
        File outFile = new File(directoryName, OUTPUT_FILENAME);
        try {
            if (!outFile.createNewFile() && !force) {
                System.err.println("File " + outFile.getName() + " already exists");
                System.exit(-1);
            }
        }
        catch (IOException e) {
            System.err.println("error creating " + outFile.getName() + ": " + e.getMessage());
            System.exit(-1);
        }
        FileWriter out = null;
        try {
            out = new FileWriter(outFile, false);
        }
        catch (IOException e) {
            System.err.println("error writing " + outFile.getName() + ": " + e.getMessage());
            System.exit(-1);
        }
        if (out == null) {
            System.err.println("Error opening " + outFile.getName() + " for writing");
            System.exit(1);
        }
        try {
            out.write("<!-- Context configuration file for WebMDS -->\n\n<Context path=\"/webmds\" docBase=\"" + ContainerConfig.getGlobusLocation() + "/lib/webmds\"/>\n");
            out.close();
        }
        catch (IOException e) {
            System.err.println("error writing " + outFile.getName() + ": " + e.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }
}

