/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.webmds;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.globus.mds.webmds.Parameter;
import org.globus.mds.webmds.ParameterMap;
import org.globus.mds.webmds.ParameterMapException;
import org.globus.mds.webmds.WebmdsConfigEntry;
import org.globus.mds.webmds.WebmdsConfigException;
import org.globus.mds.webmds.WebmdsException;
import org.globus.mds.webmds.WebmdsUtil;
import org.globus.mds.webmds.WebmdsXmlSource;
import org.globus.mds.webmdsConfig.WebmdsConfigType;
import org.globus.mds.webmdsConfig.WebmdsGlobalConfigType;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsrf.faults.BaseFaultType;
import org.xml.sax.InputSource;

public final class WebmdsServlet
extends HttpServlet {
    private static final String XML_CONFIG_DIRECTORY_NAME = "configDirectory";
    public static final String INFO_SOURCE_ARG_NAME = "info";
    public static final String XSL_SOURCE_ARG_NAME = "xsl";
    public static final String REQUEST_XSL_PARAM_PREFIX = "xslParam";
    private static final String URI_XSL_PARAM = "baseURI";
    private static final String INFO_SOURCE_INFO_XSL_PARAM = "requestInfo";
    private static final String INFO_SOURCE_NAME_XSL_PARAM = "infoSource";
    public static final String BASE_DIRECTORY_NAME = "baseDirectory";
    private static final String DEFAULT_GLOBAL_CONFIG_FILE_NAME = "globalconfig.xml";
    private static final String GLOBAL_CONFIG_FILE_PROPERTY_NAME = "webmds.globalConfig";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private String contentType = null;
    private ParameterMap initParameters = null;
    private WebmdsConfigEntry[] configEntryArray = null;
    private WebmdsUtil webmdsUtil = null;
    private WebmdsGlobalConfigType globalConfig = null;
    static /* synthetic */ Class class$org$globus$mds$webmdsConfig$WebmdsConfigType;
    static /* synthetic */ Class class$org$globus$mds$webmdsConfig$WebmdsGlobalConfigType;

    /*
     * Unable to fully structure code
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        writer = response.getWriter();
        this.contentType = null;
        requestParameters = this.getRequestParameters(request);
        if (requestParameters == null) {
            if (this.newStyleErrors()) {
                this.fail(response, "No " + "info" + " argument was specified to WebMDS.  This probably indicates an error in the HTML form or URL used to invoke WebMDS");
                return;
            }
            throw new WebmdsException("No " + "info" + " argument was specified.");
        }
        infoSourceParam = (Parameter)requestParameters.get("info");
        if (infoSourceParam == null) {
            if (this.newStyleErrors()) {
                this.fail(response, "No " + "info" + " argument was specified to WebMDS.  This probably indicates an error in the HTML form or URL used to invoke WebMDS");
                return;
            }
            throw new WebmdsException("No " + "info" + " argument was specified.");
        }
        xslSourceName = null;
        if (this.newStyleErrors()) {
            try {
                infoSourceName = infoSourceParam.getSingleValue();
                infoXmlSource = this.getXmlSource(infoSourceName, false);
                infoSource = this.getSource(infoSourceName, infoXmlSource, requestParameters);
                if (infoSource == null) {
                    this.displayResults(writer, "Your query returned null results");
                    return;
                }
                xslSourceParam = (Parameter)requestParameters.get("xsl");
                if (xslSourceParam == null) ** GOTO lbl43
                xslSourceName = xslSourceParam.getSingleValue();
            }
            catch (WebmdsException e) {
                this.fail(response, (Throwable)e);
                return;
            }
            catch (BaseFaultType e) {
                this.fail(response, e);
                return;
            }
        } else {
            infoSourceName = infoSourceParam.getSingleValue();
            infoXmlSource = this.getXmlSource(infoSourceName, false);
            infoSource = this.getSource(infoSourceName, infoXmlSource, requestParameters);
            xslSourceParam = (Parameter)requestParameters.get("xsl");
            if (xslSourceParam != null) {
                xslSourceName = xslSourceParam.getSingleValue();
            }
        }
lbl43:
        // 5 sources

        if (xslSourceName == null) {
            transformer = new TransformerIdentityImpl();
            this.contentType = new String("text/xml");
        } else {
            if (this.newStyleErrors()) {
                try {
                    xslXmlSource = this.getXmlSource(xslSourceName, true);
                    xslSource = this.getSource(xslSourceName, xslXmlSource, requestParameters);
                    contentTypeParam = (Parameter)this.initParameters.get(WebmdsConfigEntry.getContentTypeParamName(xslSourceName));
                    if (contentTypeParam == null) ** GOTO lbl66
                    this.contentType = contentTypeParam.getSingleValue();
                }
                catch (WebmdsException e) {
                    this.fail(response, (Throwable)e);
                    return;
                }
                catch (BaseFaultType e) {
                    this.fail(response, e);
                    return;
                }
            } else {
                xslXmlSource = this.getXmlSource(xslSourceName, true);
                xslSource = this.getSource(xslSourceName, xslXmlSource, requestParameters);
                contentTypeParam = (Parameter)this.initParameters.get(WebmdsConfigEntry.getContentTypeParamName(xslSourceName));
                if (contentTypeParam != null) {
                    this.contentType = contentTypeParam.getSingleValue();
                }
            }
lbl66:
            // 5 sources

            transformerFactory = TransformerFactory.newInstance();
            try {
                transformer = transformerFactory.newTransformer(xslSource);
            }
            catch (TransformerConfigurationException e) {
                if (this.newStyleErrors()) {
                    this.fail(response, "Error initializing XSL transformation.  This usually indicates a syntax error in the specified XSL file", e);
                    return;
                }
                throw new WebmdsException("Error initializing xsl transformation", e);
            }
            this.setXslParameters((Transformer)transformer, requestParameters);
        }
        transformer.setParameter("requestInfo", infoXmlSource.getRequestInfo());
        transformer.setParameter("infoSource", infoSourceName);
        uriParam = this.nonXslURIString(request, requestParameters);
        transformer.setParameter("baseURI", this.nonXslURIString(request, requestParameters));
        if (this.contentType == null) {
            this.contentType = "text/html";
        }
        response.setContentType(this.contentType);
        try {
            transformer.transform(infoSource, new StreamResult(writer));
        }
        catch (TransformerException e) {
            if (!this.newStyleErrors()) {
                throw new WebmdsException("Error performing xsl transformation", e);
            }
            this.fail(response, "Error performing xsl transformation.  This may indicate badly formatted XML from the XML source or an error in the XSL file.", e);
            return;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        String configDirectoryNameString = config.getInitParameter(XML_CONFIG_DIRECTORY_NAME);
        if (configDirectoryNameString == null) {
            throw new WebmdsException("No " + XML_CONFIG_DIRECTORY_NAME + " parameter has been configured.");
        }
        this.initParameters = new ParameterMap();
        this.webmdsUtil = new WebmdsUtil();
        ServletContext context = config.getServletContext();
        String baseDirectory = context.getRealPath("/");
        if (baseDirectory != null) {
            this.webmdsUtil.setDirectoryName(baseDirectory);
        }
        Enumeration paramNames = config.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (name == null) continue;
            Parameter parameter = Parameter.createSingleValuedParameter(name, config.getInitParameter(name));
            this.initParameters.putParameter(parameter);
        }
        this.readGlobalConfig();
        Parameter param = Parameter.createSingleValuedParameter("globalconfig.newStyleErrors", Boolean.toString(this.newStyleErrors()));
        this.initParameters.putParameter(param);
        File configDirectory = this.webmdsUtil.newFile(configDirectoryNameString);
        if (configDirectory == null) {
            throw new ServletException("Bad configuration directory '" + configDirectoryNameString + "'");
        }
        File[] configFiles = configDirectory.listFiles();
        if (configFiles == null) {
            throw new WebmdsException("Bad configuration directory '" + configDirectoryNameString + "'");
        }
        this.configEntryArray = new WebmdsConfigEntry[configFiles.length];
        for (int i = 0; i < configFiles.length; ++i) {
            try {
                this.configEntryArray[i] = this.initWebmdsConfigEntry(configFiles[i]);
                continue;
            }
            catch (IOException e) {
                throw new WebmdsException(e);
            }
        }
    }

    private WebmdsConfigEntry initWebmdsConfigEntry(File configFile) throws ServletException, IOException {
        WebmdsConfigType config;
        WebmdsConfigType configType = new WebmdsConfigType();
        FileInputStream inFile = new FileInputStream(configFile);
        InputSource source = new InputSource(inFile);
        try {
            config = (WebmdsConfigType)ObjectDeserializer.deserialize((InputSource)source, (Class)(class$org$globus$mds$webmdsConfig$WebmdsConfigType == null ? (class$org$globus$mds$webmdsConfig$WebmdsConfigType = WebmdsServlet.class$("org.globus.mds.webmdsConfig.WebmdsConfigType")) : class$org$globus$mds$webmdsConfig$WebmdsConfigType));
        }
        catch (DeserializationException e) {
            throw new WebmdsException((Exception)((Object)e));
        }
        catch (NullPointerException e) {
            throw new WebmdsConfigException("Error parsing a wsdd file.  This may mean that the servlet container (typically Tomcat) was started from the $GLOBUS_LOCATION directory, in which case restarting from a different directory will fix the problem.", e);
        }
        inFile.close();
        if (config == null || config.getClassName() == null) {
            throw new ServletException("Error in config file " + configFile.getAbsolutePath());
        }
        WebmdsConfigEntry configEntry = new WebmdsConfigEntry(configFile.getName(), config);
        configEntry.init();
        return configEntry;
    }

    private WebmdsXmlSource getXmlSource(String sourceName, boolean checkXSL) throws WebmdsException {
        WebmdsXmlSource webmdsXmlSource;
        WebmdsConfigEntry config = this.findConfigEntry(sourceName);
        if (config == null) {
            throw new WebmdsException("No configuration information for '" + sourceName + "'");
        }
        if (checkXSL) {
            if (!config.isSuitableForXSL()) {
                throw new WebmdsException("The '" + sourceName + "' XML source has not been configured to be used as a source of XSL.  To change this, set the " + "suitableForXSL" + " parameter to 'true' in the config entry for '" + sourceName + "' on the WebMDS server.");
            }
            if (this.contentType == null) {
                this.contentType = config.getContentType();
            }
        }
        try {
            webmdsXmlSource = (WebmdsXmlSource)config.getSourceClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new WebmdsException("Error instantiating xml source class for " + sourceName, e);
        }
        catch (IllegalAccessException e) {
            throw new WebmdsException("Error instantiating xml source class for " + sourceName, e);
        }
        webmdsXmlSource.init(this.webmdsUtil);
        return webmdsXmlSource;
    }

    private Source getSource(String sourceName, WebmdsXmlSource webmdsXmlSource, ParameterMap requestParams) throws ServletException, IOException {
        WebmdsConfigEntry config = this.findConfigEntry(sourceName);
        if (config == null) {
            throw new WebmdsException("No configuration information for " + sourceName);
        }
        ParameterMap submappedRequestParams = requestParams.prefixedSubMap(WebmdsConfigEntry.getCustomParamPrefix(sourceName));
        ParameterMap configParams = config.getParams();
        Parameter param = Parameter.createSingleValuedParameter("globalconfig.allowUserSpecifiedQuery", Boolean.toString(this.allowUserSpecifiedQuery()));
        configParams.putParameter(param);
        return webmdsXmlSource.getXmlSource(sourceName, configParams, submappedRequestParams);
    }

    private WebmdsConfigEntry findConfigEntry(String sourceName) {
        for (int i = 0; i < this.configEntryArray.length; ++i) {
            if (!this.configEntryArray[i].getName().equals(sourceName)) continue;
            return this.configEntryArray[i];
        }
        return null;
    }

    private ParameterMap getRequestParameters(HttpServletRequest request) throws ParameterMapException {
        Enumeration paramNames = request.getParameterNames();
        if (paramNames == null) {
            return null;
        }
        ParameterMap paramMap = new ParameterMap();
        while (paramNames.hasMoreElements()) {
            String key = (String)paramNames.nextElement();
            if (key == null) continue;
            Parameter parameter = new Parameter(key, request.getParameterValues(key));
            paramMap.putParameter(parameter);
        }
        if (paramMap.size() == 0) {
            return null;
        }
        return paramMap;
    }

    private void setXslParameters(Transformer transformer, ParameterMap paramMap) throws WebmdsException {
        if (paramMap == null) {
            return;
        }
        ParameterMap xslParamMap = paramMap.prefixedSubMap(REQUEST_XSL_PARAM_PREFIX);
        if (xslParamMap == null) {
            return;
        }
        Set keySet = xslParamMap.keySet();
        if (keySet == null) {
            return;
        }
        String[] keys = keySet.toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            Parameter xslParam = (Parameter)xslParamMap.get(keys[i]);
            transformer.setParameter(xslParam.getName(), xslParam.getSingleValue());
        }
    }

    private String nonXslURIString(HttpServletRequest request, ParameterMap paramMap) {
        String separator = "?";
        StringBuffer uriBuf = new StringBuffer(request.getRequestURI());
        if (paramMap == null) {
            return uriBuf.toString();
        }
        Set keySet = paramMap.keySet();
        if (keySet == null) {
            return uriBuf.toString();
        }
        String[] keys = keySet.toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String[] values;
            Parameter param = (Parameter)paramMap.get(keys[i]);
            if (param.getName().equals(XSL_SOURCE_ARG_NAME) || param.getName().startsWith(REQUEST_XSL_PARAM_PREFIX) || (values = param.getValues()) == null) continue;
            for (int j = 0; j < values.length; ++j) {
                if (values[j] == null) continue;
                uriBuf.append(separator);
                uriBuf.append(param.getName());
                uriBuf.append("=");
                uriBuf.append(values[j]);
                separator = "&";
            }
        }
        return uriBuf.toString();
    }

    private void fail(HttpServletResponse response, String introMessage, Throwable e) throws IOException {
        response.setStatus(500);
        PrintWriter out = response.getWriter();
        String errorType = e == null ? "WebMDS Error" : "WebMDS Exception";
        out.println("<html>");
        out.println("<head><title>" + errorType + "</title></head>");
        out.println("<body>");
        out.println("<h2>" + errorType + "</h2>");
        FaultHelper helper = null;
        Throwable t = e;
        String message = null;
        if (introMessage != null) {
            out.println("<p>");
            out.println(introMessage);
            out.println("</p>");
        }
        while (message == null && t != null) {
            message = t.getMessage();
            t = t.getCause();
        }
        String[] descriptions = null;
        if (e != null) {
            if (e instanceof BaseFaultType) {
                helper = new FaultHelper((BaseFaultType)e, true);
                descriptions = helper.getDescription();
                message = helper.getMessage();
            } else {
                message = e.getMessage();
            }
            if (message == null && descriptions == null) {
                Throwable cause = e.getCause();
                if (cause instanceof BaseFaultType) {
                    helper = new FaultHelper((BaseFaultType)cause, true);
                    message = helper.getMessage();
                    descriptions = helper.getDescription();
                } else {
                    message = cause.getMessage();
                }
            }
        }
        if (descriptions != null && descriptions[0] != null) {
            out.println("<h3>Description</h3>");
            int i = descriptions.length;
            while (i > 0) {
                out.println("<p>");
                out.println(descriptions[--i]);
                out.println("</p>");
            }
        }
        if (message != null) {
            out.println("<h3>Message</h3>");
            out.println("<p>");
            out.println(message);
            out.println("</p>");
        }
        out.println("<h3>Detail:</h3>");
        out.println("<pre>");
        int i = 0;
        while (e != null && i++ < 10) {
            e.printStackTrace(out);
            if (e instanceof BaseFaultType) {
                helper = new FaultHelper((BaseFaultType)e, true);
                helper.printStackTrace(out);
                break;
            }
            e = e.getCause();
        }
        out.println("</pre>");
        out.println("</body>");
        out.println("</html>");
    }

    private void fail(HttpServletResponse response, String message) throws IOException {
        this.fail(response, message, null);
    }

    private void fail(HttpServletResponse response, Throwable e) throws IOException {
        this.fail(response, null, e);
    }

    private void readGlobalConfig() throws WebmdsConfigException {
        FileInputStream configStream;
        String fileName = System.getProperty(GLOBAL_CONFIG_FILE_PROPERTY_NAME);
        if (fileName == null) {
            fileName = DEFAULT_GLOBAL_CONFIG_FILE_NAME;
        }
        File configFile = this.webmdsUtil.newFile(fileName);
        try {
            configStream = new FileInputStream(configFile);
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            InputSource source = new InputSource(configStream);
            this.globalConfig = (WebmdsGlobalConfigType)ObjectDeserializer.deserialize((InputSource)source, (Class)(class$org$globus$mds$webmdsConfig$WebmdsGlobalConfigType == null ? (class$org$globus$mds$webmdsConfig$WebmdsGlobalConfigType = WebmdsServlet.class$("org.globus.mds.webmdsConfig.WebmdsGlobalConfigType")) : class$org$globus$mds$webmdsConfig$WebmdsGlobalConfigType));
        }
        catch (DeserializationException e) {
            throw new WebmdsConfigException("Error parsing global configuration file " + configFile.getAbsolutePath(), (Exception)((Object)e));
        }
        catch (NullPointerException e) {
            throw new WebmdsConfigException("Error parsing a wsdd file.  This may mean that the servlet container (typically Tomcat) was started from the $GLOBUS_LOCATION directory, in which case restarting from a different directory will fix the problem.", e);
        }
    }

    private void displayResults(PrintWriter out, String results) {
        out.println("<html>");
        out.println("<head><title>WebMDS Results</title></head>");
        out.println("<body>");
        out.println("<p>");
        out.println(results);
        out.println("</p>");
        out.println("</body>");
        out.println("</html>");
    }

    private boolean newStyleErrors() {
        boolean result = false;
        if (this.globalConfig != null) {
            result = this.globalConfig.isNewStyleErrors();
        }
        return result;
    }

    private boolean allowUserSpecifiedQuery() {
        boolean result = false;
        if (this.globalConfig != null) {
            result = this.globalConfig.isAllowUserSpecifiedQuery();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

