/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.webmds;

import org.globus.mds.webmds.Parameter;
import org.globus.mds.webmds.ParameterMap;
import org.globus.mds.webmds.WebmdsConfigException;
import org.globus.mds.webmds.WebmdsException;
import org.globus.mds.webmdsConfig.NamedParamType;
import org.globus.mds.webmdsConfig.WebmdsConfigType;

public class WebmdsConfigEntry {
    public static final String SUITABLE_FOR_XSL_NAME = "suitableForXSL";
    private Class sourceClass = null;
    private String name = null;
    private ParameterMap params = null;
    private static final String XML_SOURCE_PREFIX_NAME = "xmlSource";
    private static final String XML_SOURCE_PARAM_SEGMENT = "param";
    private static final String XML_SOURCE_CLASS_NAME_SEGMENT = "class";
    private static final String CONTENT_TYPE_PARAM_NAME_SEGMENT = "contentType";
    private WebmdsConfigType config;

    public WebmdsConfigEntry(String name, WebmdsConfigType config) {
        this.name = name;
        this.config = config;
    }

    public void init() throws WebmdsException {
        if (this.config == null) {
            throw new WebmdsConfigException("null config");
        }
        if (this.config.getClassName() == null) {
            throw new WebmdsException("null class name in " + this.name + " config entry");
        }
        try {
            this.sourceClass = Class.forName(this.config.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new WebmdsException(e);
        }
        this.params = new ParameterMap();
        NamedParamType[] configParams = this.config.getParameter();
        if (configParams != null) {
            for (int i = 0; i < configParams.length; ++i) {
                this.params.putParameter(Parameter.createSingleValuedParameter(configParams[i].getName(), configParams[i].getValue()));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public ParameterMap getParams() {
        return this.params;
    }

    public boolean isSuitableForXSL() {
        Boolean result = this.config.getSuitableForXSL();
        if (result == null) {
            return false;
        }
        return result;
    }

    public String getContentType() {
        return this.config.getContentType();
    }

    public static String getCustomParamPrefix(String name) {
        return new String(WebmdsConfigEntry.getSourcePrefix(name) + "." + XML_SOURCE_PARAM_SEGMENT);
    }

    public static String getContentTypeParamName(String name) {
        return new String(WebmdsConfigEntry.getSourcePrefix(name) + "." + CONTENT_TYPE_PARAM_NAME_SEGMENT);
    }

    public static String getSourcePrefix(String name) {
        return new String("xmlSource." + name);
    }
}

