/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.webmds;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.globus.mds.webmds.ReflectionException;

public class Reflection {
    public static Object call(Class theClass, String methodName, Object[] arguments, Class[] argumentTypes) throws ReflectionException, InvocationTargetException {
        if (theClass == null || methodName == null) {
            throw new ReflectionException("Class or method name is null");
        }
        Method method = null;
        try {
            method = theClass.getMethod(methodName, argumentTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Class " + theClass.getName() + " does not have method " + methodName, e);
        }
        return Reflection.invokeMethod(theClass, method, arguments);
    }

    public static Object call(Class theClass, String methodName, Object[] arguments) throws ReflectionException, InvocationTargetException {
        Class[] argumentTypes;
        if (theClass == null || methodName == null) {
            throw new ReflectionException("Class or method name is null");
        }
        if (arguments == null) {
            argumentTypes = null;
        } else {
            argumentTypes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] == null) {
                    throw new ReflectionException("Can't determine argument type from null argument");
                }
                argumentTypes[i] = arguments[i].getClass();
            }
        }
        return Reflection.call(theClass, methodName, arguments, argumentTypes);
    }

    public static Object call(String className, String methodName, Object[] arguments, Class[] argumentTypes) throws ReflectionException, InvocationTargetException {
        Class<?> theClass;
        if (className == null) {
            throw new ReflectionException("Null class name");
        }
        try {
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Class " + className + " not found.", e);
        }
        return Reflection.call(theClass, methodName, arguments, argumentTypes);
    }

    public static Object call(String className, String methodName, Object[] arguments) throws ReflectionException, InvocationTargetException {
        Class<?> theClass;
        if (className == null) {
            throw new ReflectionException("Null class name");
        }
        try {
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Class " + className + " not found.", e);
        }
        return Reflection.call(theClass, methodName, arguments);
    }

    public static Object invokeMethod(Class theClass, Method method, Object[] arguments) throws ReflectionException, InvocationTargetException {
        Object instance;
        if (method == null) {
            throw new ReflectionException("Attempt to invoke null method");
        }
        try {
            instance = theClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("error instantiating class " + theClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException("error instantiating class " + theClass.getName(), e);
        }
        try {
            return method.invoke(instance, arguments);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("error invoking method", e);
        }
    }
}

