/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.webmds;

import java.util.HashMap;
import java.util.Set;
import org.globus.mds.webmds.Parameter;
import org.globus.mds.webmds.ParameterMapException;

public class ParameterMap
extends HashMap {
    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("Attempt to add map entry with null key");
        }
        Object returnValue = this.get(key);
        Parameter param = (Parameter)value;
        super.put(key, value);
        return returnValue;
    }

    public Object putParameter(Parameter param) throws ParameterMapException {
        if (param == null) {
            throw new ParameterMapException("attempt to add a null parameter to the map");
        }
        if (param.getName() == null) {
            throw new ParameterMapException("attempt to add a parameter with null name to the map");
        }
        return this.put(param.getName(), param);
    }

    public ParameterMap prefixedSubMap(String prefix) throws ParameterMapException {
        String fixedPrefix = prefix == null ? new String(".") : new String(prefix + ".");
        int prefixLength = fixedPrefix.length();
        Set keySet = this.keySet();
        if (keySet == null) {
            return null;
        }
        ParameterMap result = new ParameterMap();
        String[] keys = keySet.toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String oldKey = keys[i];
            if (!oldKey.startsWith(fixedPrefix)) continue;
            Parameter oldParam = (Parameter)this.get(oldKey);
            String newKey = oldKey.substring(prefixLength);
            Parameter newParam = new Parameter(newKey, oldParam.getValues());
            result.putParameter(newParam);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public String debugKeyString() throws ParameterMapException {
        String keyString = new String();
        Set keySet = this.keySet();
        if (keySet == null) {
            return null;
        }
        String[] keys = keySet.toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                keyString = keyString + ", ";
            }
            keyString = keyString + keys[i];
        }
        return keyString;
    }
}

