/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.webmds;

import org.globus.mds.webmds.ParameterException;

public class Parameter {
    private String paramName;
    private String[] paramValues;

    public Parameter(String name, String[] values) {
        this.init(name, values);
    }

    public Parameter(char[] name, char[] value) {
        String[] values = new String[]{new String(value)};
        this.init(new String(name), values);
    }

    public static Parameter createSingleValuedParameter(String name, String value) {
        String[] values = new String[]{value};
        return new Parameter(name, values);
    }

    private void init(String name, String[] values) {
        String[] trimmedValues = null;
        if (values != null) {
            trimmedValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) {
                    trimmedValues[i] = null;
                    continue;
                }
                trimmedValues[i] = values[i].trim();
                if (trimmedValues[i].length() != 0) continue;
                trimmedValues[i] = null;
            }
        }
        this.paramName = name;
        this.paramValues = trimmedValues;
    }

    public String getName() {
        return this.paramName;
    }

    public String[] getValues() {
        return this.paramValues;
    }

    public String getSingleValue() throws ParameterException {
        if (this.paramValues == null) {
            throw new ParameterException("Parameter has no values");
        }
        if (this.paramValues.length != 1) {
            throw new ParameterException("Parameter '" + this.getName() + "' has " + Integer.toString(this.paramValues.length) + " values.");
        }
        return this.paramValues[0];
    }
}

