/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.opensaml.AuthorizationAdvice;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAttributeDesignator;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectAttributeReferenceAdvice
extends AuthorizationAdvice {
    final String ELEM_NAME = "SubjectAttributeReferenceAdvice";
    final String ATTRIB_NAME = "Reference";
    private ArrayList attribDesignator = new ArrayList();
    private String referenceURI = null;
    Logger log = Logger.getLogger(this.getClass());

    public SubjectAttributeReferenceAdvice(String reference, Collection designator) throws SAMLException {
        if (reference == null || reference.trim().equals("")) {
            throw new SAMLException("Reference URI is required");
        }
        this.referenceURI = reference;
        if (designator != null) {
            this.log.debug((Object)"Attribute designator is null");
            this.attribDesignator.addAll(designator);
        }
        this.log.debug((Object)("Parameters: " + this.referenceURI));
    }

    public SubjectAttributeReferenceAdvice(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SubjectAttributeReferenceAdvice(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public String getReferenceURI() {
        return this.referenceURI;
    }

    public Iterator getAttribDesignator() {
        return ((AbstractList)this.attribDesignator).iterator();
    }

    public Collection getAttribDesignatorCol() {
        return this.attribDesignator;
    }

    public void addAttribDesignator(Collection attrib) {
        if (attrib != null) {
            this.attribDesignator.addAll(attrib);
        }
    }

    public Node toDOM(Document doc) {
        Element elem = doc.createElementNS("http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/", "SubjectAttributeReferenceAdvice");
        elem.setAttributeNS("http://www.gridforum.org/namespaces/2003/06/ogsa-authz/saml/", "Reference", this.referenceURI);
        if (this.attribDesignator != null) {
            Iterator it = ((AbstractList)this.attribDesignator).iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof SAMLAttributeDesignator)) continue;
                elem.appendChild(((SAMLAttributeDesignator)obj).toDOM(doc));
            }
        }
        this.root = elem;
        return this.root;
    }

    public void fromDOM(Element e) throws SAMLException {
        this.referenceURI = e.getAttribute("Reference");
        if (this.referenceURI == null || this.referenceURI.trim().equals("")) {
            throw new MalformedException(SAMLException.REQUESTER, "SubjectAttributeReferenceAdvice.fromDOM() requires referenceURI");
        }
        this.log.debug((Object)("ReferenceURI " + this.referenceURI));
        NodeList desigNodes = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeDesignator");
        int i = 0;
        while (i < desigNodes.getLength()) {
            SAMLAttributeDesignator attribDesig = new SAMLAttributeDesignator((Element)desigNodes.item(i));
            this.attribDesignator.add(attribDesig);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        SubjectAttributeReferenceAdvice advice = (SubjectAttributeReferenceAdvice)obj;
        if (this.compareStrings(this.referenceURI, advice.getReferenceURI())) {
            return this.attribDesignator.containsAll(advice.getAttribDesignatorCol());
        }
        return false;
    }
}

