/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.util.Collection;
import org.opensaml.BindingException;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SOAPException
extends BindingException
implements Cloneable {
    public static final QName CLIENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    public static final QName SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName MUSTUNDERSTAND = new QName("http://schemas.xmlsoap.org/soap/envelope/", "MustUnderstand");
    public static final QName VERSION = new QName("http://schemas.xmlsoap.org/soap/envelope/", "VersionMismatch");

    protected SOAPException(Element e) throws SAMLException {
        super(e);
    }

    public SOAPException(String msg) {
        super(msg);
    }

    public SOAPException(String msg, Exception e) {
        super(msg, e);
    }

    public SOAPException(Collection codes, String msg) {
        super(codes, msg);
    }

    public SOAPException(Collection codes, Exception e) {
        super(codes, e);
    }

    public SOAPException(Collection codes, String msg, Exception e) {
        super(codes, msg, e);
    }

    public SOAPException(QName code, String msg) {
        super(code, msg);
    }

    public SOAPException(QName code, Exception e) {
        super(code, e);
    }

    public SOAPException(QName code, String msg, Exception e) {
        super(code, msg, e);
    }

    public void fromDOM(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException("SOAPException.fromDOM() given an empty DOM");
        }
        this.root = e;
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "http://schemas.xmlsoap.org/soap/envelope/", "Fault")) {
            throw new MalformedException(SAMLException.RESPONDER, "SOAPException.fromDOM() requires soap:Fault at root");
        }
        Node code = e.getFirstChild();
        while (code != null && code.getNodeType() != 1) {
            code = code.getNextSibling();
        }
        QName q = QName.getQNameTextNode((Text)code.getFirstChild());
        if (q == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLException.fromDOM() unable to evaluate faultcode value");
        }
        this.codes.add(q);
        Node m = code.getNextSibling();
        while (!(m == null || m.getNodeType() == 1 && XML.isElementNamed(e, null, "faultstring"))) {
            m = m.getNextSibling();
        }
        if (m != null) {
            this.msg = m.getFirstChild().getNodeValue();
        }
    }

    public Node toDOM(Document doc) throws DOMException {
        if (this.root != null) {
            if (this.root.getOwnerDocument() != doc) {
                this.root = doc.importNode(this.root, true);
            }
        } else {
            Element s = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            s.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
            Element sc = doc.createElementNS(null, "faultcode");
            if (this.codes == null || this.codes.isEmpty()) {
                sc.appendChild(doc.createTextNode("soap:Server"));
            } else {
                sc.appendChild(doc.createTextNode("soap:" + ((QName)this.codes.get(0)).getLocalName()));
            }
            s.appendChild(sc);
            if (this.getMessage() != null) {
                Element msg = doc.createElementNS(null, "faultstring");
                msg.appendChild(doc.createTextNode(this.getMessage()));
                s.appendChild(msg);
            }
            this.root = s;
        }
        return this.root;
    }
}

