/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLSubject
extends SAMLObject
implements Cloneable {
    private String name = null;
    private String nameQualifier = null;
    private String format = null;
    private ArrayList confirmationMethods = new ArrayList();
    private String confirmationData = null;
    protected Element keyInfo = null;
    public static final String ARTIFACT01 = "urn:oasis:names:tc:SAML:1.0:cm:artifact-01";
    public static final String CONF_BEARER = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    public static final String HOLDER_KEY = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    public static final String SENDER_VOUCHES = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";

    public SAMLSubject(String name, String nameQualifier, String format, Collection confirmationMethods, String confirmationData, Element keyInfo) throws SAMLException {
        this.name = name;
        this.nameQualifier = nameQualifier;
        this.format = format;
        this.confirmationData = confirmationData;
        if (confirmationMethods != null) {
            this.confirmationMethods.addAll(confirmationMethods);
        }
        this.keyInfo = keyInfo;
    }

    public SAMLSubject(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLSubject(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Subject")) {
            throw new MalformedException("SAMLSubject.fromDOM() requires saml:Subject at root");
        }
        Node n = e.getFirstChild();
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        if (n != null && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier")) {
            this.nameQualifier = ((Element)n).getAttributeNS(null, "NameQualifier");
            if (this.nameQualifier.trim().equals("")) {
                this.nameQualifier = null;
            }
            this.format = ((Element)n).getAttributeNS(null, "Format");
            if (this.format.trim().equals("")) {
                this.format = null;
            }
            this.name = n.getFirstChild().getNodeValue();
            if (this.name.trim().equals("")) {
                this.name = null;
            }
            n = n.getNextSibling();
            while (n != null && n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
        }
        if (n != null && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation")) {
            NodeList nlist = ((Element)n).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod");
            int i = 0;
            while (nlist != null && i < nlist.getLength()) {
                this.confirmationMethods.add(nlist.item(i).getFirstChild().getNodeValue());
                ++i;
            }
            nlist = ((Element)n).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData");
            if (nlist != null && nlist.getLength() == 1) {
                this.confirmationData = nlist.item(0).getFirstChild().getNodeValue();
            }
            if ((nlist = ((Element)n).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo")) != null && nlist.getLength() == 1) {
                this.keyInfo = (Element)nlist.item(0);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public String getFormat() {
        return this.format;
    }

    public Iterator getConfirmationMethods() {
        return ((AbstractList)this.confirmationMethods).iterator();
    }

    public Collection getConfirmationMethodColl() {
        return this.confirmationMethods;
    }

    public String getConfirmationData() {
        return this.confirmationData;
    }

    public Element getKeyInfo() {
        return this.keyInfo;
    }

    public Node toDOM() {
        return this.keyInfo == null ? super.toDOM() : this.toDOM(this.keyInfo.getOwnerDocument());
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element subject = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Subject");
        subject.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        if (this.name != null) {
            Element nameid = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
            if (this.nameQualifier != null && this.nameQualifier.length() > 0) {
                nameid.setAttributeNS(null, "NameQualifier", this.nameQualifier);
            }
            if (this.format != null && this.format.length() > 0) {
                nameid.setAttributeNS(null, "Format", this.format);
            }
            nameid.appendChild(doc.createTextNode(this.name));
            subject.appendChild(nameid);
        }
        if (this.confirmationMethods.size() > 0) {
            Element conf = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
            Iterator i = ((AbstractList)this.confirmationMethods).iterator();
            while (i.hasNext()) {
                conf.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod")).appendChild(doc.createTextNode((String)i.next()));
            }
            if (this.confirmationData != null && this.confirmationData.length() > 0) {
                conf.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")).appendChild(doc.createTextNode(this.confirmationData));
            }
            if (this.keyInfo != null) {
                if (this.keyInfo.getOwnerDocument() != doc) {
                    this.keyInfo = (Element)doc.importNode(this.keyInfo, true);
                }
                conf.appendChild(this.keyInfo);
            }
            subject.appendChild(conf);
        }
        this.root = subject;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubject dup = (SAMLSubject)super.clone();
        dup.confirmationMethods = (ArrayList)this.confirmationMethods.clone();
        if (this.keyInfo != null) {
            dup.keyInfo = (Element)this.keyInfo.cloneNode(true);
        }
        return dup;
    }

    public boolean equals(SAMLSubject subject) {
        if (this.compareStrings(this.confirmationData, subject.getConfirmationData()) && this.compareStrings(this.name, subject.getName()) && this.compareStrings(this.nameQualifier, subject.getNameQualifier()) && this.compareStrings(this.format, subject.getFormat())) {
            Collection col = subject.getConfirmationMethodColl();
            return this.confirmationMethods.containsAll(col);
        }
        return false;
    }
}

