/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLResponse
extends SAMLSignedObject {
    private String responseId = null;
    private String inResponseTo = null;
    private Date issueInstant = null;
    private String recipient = null;
    private ArrayList assertions = new ArrayList();
    private SAMLException e = null;

    protected void insertSignature() throws SAMLException {
        this.root.insertBefore(this.getSignatureElement(), this.root.getFirstChild());
    }

    public SAMLResponse(String inResponseTo, String recipient, Collection assertions, SAMLException e) throws SAMLException {
        this.issueInstant = new Date();
        this.inResponseTo = inResponseTo;
        this.recipient = recipient;
        this.e = e;
        if (assertions != null) {
            this.assertions.addAll(assertions);
        }
    }

    public SAMLResponse(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLResponse(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Response")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse.fromDOM() requires samlp:Response at root");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (Integer.parseInt(e.getAttributeNS(null, "MajorVersion")) != 1) {
                throw new MalformedException(SAMLException.VERSION, "SAMLResponse() detected incompatible response major version of " + e.getAttributeNS(null, "MajorVersion"));
            }
            this.issueInstant = formatter.parse(e.getAttributeNS(null, "IssueInstant"));
            this.inResponseTo = e.getAttributeNS(null, "InResponseTo");
            this.responseId = e.getAttributeNS(null, "ResponseID");
            this.recipient = e.getAttributeNS(null, "Recipient");
            Node n = e.getFirstChild();
            while (!(n == null || n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:protocol", "Status"))) {
                n = n.getNextSibling();
            }
            this.e = SAMLException.getInstance((Element)n);
            Iterator it = this.e.getCodes();
            if (it.hasNext() && !it.next().equals(SAMLException.SUCCESS)) {
                throw this.e;
            }
            NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
            int i = 0;
            while (nlist != null && i < nlist.getLength()) {
                this.assertions.add(new SAMLAssertion((Element)nlist.item(i)));
                ++i;
            }
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse() detected an invalid datetime while parsing response", (Exception)ex);
        }
    }

    public String getResponseId() {
        return this.responseId;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public Iterator getAssertions() {
        return ((AbstractList)this.assertions).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        Element r = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Response");
        r.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        r.setAttributeNS(null, "MajorVersion", "1");
        r.setAttributeNS(null, "MinorVersion", "0");
        this.responseId = new SAMLIdentifier().toString();
        r.setAttributeNS(null, "ResponseID", this.responseId);
        if (this.inResponseTo != null) {
            r.setAttributeNS(null, "InResponseTo", this.inResponseTo);
        }
        r.setAttributeNS(null, "IssueInstant", formatter.format(this.issueInstant));
        if (this.recipient != null) {
            r.setAttributeNS(null, "Recipient", this.recipient);
        }
        if (this.e != null) {
            r.appendChild(this.e.toDOM(doc));
        } else {
            Element status = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Status");
            Element code = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
            code.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            code.setAttributeNS(null, "Value", "samlp:" + SAMLException.SUCCESS.getLocalName());
            status.appendChild(code);
            r.appendChild(status);
        }
        Iterator i = ((AbstractList)this.assertions).iterator();
        while (i.hasNext()) {
            r.appendChild(((SAMLAssertion)i.next()).toDOM(doc));
        }
        this.root = r;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLResponse dup = (SAMLResponse)super.clone();
        if (this.e != null) {
            dup.e = (SAMLException)this.e.clone();
        }
        Iterator i = ((AbstractList)this.assertions).iterator();
        while (i.hasNext()) {
            dup.assertions.add(((SAMLAssertion)i.next()).clone());
        }
        return dup;
    }
}

