/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SAMLObject
implements Cloneable {
    protected Node root = null;
    protected Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$org$opensaml$SAMLObject;

    protected static Element fromStream(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            NDC.push((String)"fromStream");
            Logger.getLogger((String)(class$org$opensaml$SAMLObject == null ? (class$org$opensaml$SAMLObject = SAMLObject.class$("org.opensaml.SAMLObject")) : class$org$opensaml$SAMLObject).getName()).error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLObject.fromStream() caught exception while parsing a stream", e);
        }
    }

    public void fromDOM(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException("SAMLObject.fromDOM() given an empty DOM");
        }
        this.root = e;
    }

    public void toStream(OutputStream out) throws IOException {
        try {
            Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            out.write(c.canonicalizeSubtree(this.toDOM(), Init.getProperty("inclusive-namespace-prefixes")));
        }
        catch (InvalidCanonicalizerException e) {
            throw new IOException(e.getMessage());
        }
        catch (CanonicalizationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public byte[] toBase64() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toStream(out);
        return Base64.encode((byte[])out.toByteArray(), (int)0).getBytes();
    }

    public Node toDOM(Document doc) throws DOMException {
        if (this.root != null && this.root.getOwnerDocument() != doc) {
            this.root = doc.importNode(this.root, true);
        }
        return this.root;
    }

    public Node toDOM() throws DOMException {
        if (this.root != null) {
            return this.root;
        }
        return this.toDOM(XML.parserPool.newDocument());
    }

    protected Node plantRoot() {
        if (this.root != null) {
            Node domroot = this.root;
            while (domroot.getParentNode() != null && domroot.getParentNode().getNodeType() != 9) {
                domroot = domroot.getParentNode();
            }
            Element e = this.root.getOwnerDocument().getDocumentElement();
            if (e != null && e != domroot) {
                this.root.getOwnerDocument().replaceChild(domroot, e);
            } else if (e == null) {
                this.root.getOwnerDocument().appendChild(domroot);
            }
        }
        return this.root;
    }

    protected Object clone() throws CloneNotSupportedException {
        SAMLObject dup = (SAMLObject)super.clone();
        dup.root = null;
        return dup;
    }

    public String toString() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.toStream(os);
            return os.toString("UTF8");
        }
        catch (IOException e) {
            NDC.push((String)"toString");
            this.log.error((Object)"caught an I/O exception while serializing XML");
            NDC.pop();
            return "";
        }
    }

    public boolean compareStrings(String str1, String str2) {
        if (str1 != null) {
            if (str2 == null) {
                return false;
            }
            if (!str1.equals(str2)) {
                return false;
            }
        } else if (str2 != null) {
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

