/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.UnsupportedExtensionException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class SAMLCondition
extends SAMLObject
implements Cloneable {
    protected static Hashtable conditionTypeMap = new Hashtable();

    static void regFactory(QName type, String className) {
        conditionTypeMap.put(type, className);
    }

    static void unregFactory(QName type) {
        conditionTypeMap.remove(type);
    }

    static SAMLCondition getInstance(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLCondition.getInstance() given an empty DOM");
        }
        try {
            if (XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Condition")) {
                String className = (String)conditionTypeMap.get(QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type"));
                if (className == null) {
                    throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLCondition.getInstance() unable to locate an implementation of specified condition type");
                }
                Class<?> implementation = Class.forName(className);
                Class[] paramtypes = new Class[]{Class.forName("org.w3c.dom.Element")};
                Object[] params = new Object[]{e};
                Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
                return (SAMLCondition)ctor.newInstance(params);
            }
            String className = (String)conditionTypeMap.get(new QName(e.getNamespaceURI(), e.getLocalName()));
            if (className == null) {
                throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLCondition.getInstance() unable to locate an implementation of specified condition type");
            }
            Class<?> implementation = Class.forName(className);
            Class[] paramtypes = new Class[]{Class.forName("org.w3c.dom.Element")};
            Object[] params = new Object[]{e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLCondition)ctor.newInstance(params);
        }
        catch (ClassNotFoundException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to locate implementation class for condition", (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to bind to constructor for condition", (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to build implementation object for condition", (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() unable to access implementation of condition", (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Throwable e2 = ex.getTargetException();
            if (e2 instanceof SAMLException) {
                throw (SAMLException)e2;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLCondition.getInstance() caught unknown exception while building condition object: " + e2.getMessage());
        }
    }

    static SAMLCondition getInstance(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return SAMLCondition.getInstance(doc.getDocumentElement());
        }
        catch (SAXException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLCondition").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLCondition.getInstance() caught exception while parsing a stream", (Exception)e);
        }
        catch (IOException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLCondition").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLCondition.getInstance() caught exception while parsing a stream", (Exception)e);
        }
    }
}

