/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorizationDecisionQuery
extends SAMLQuery
implements Cloneable {
    protected SAMLSubject subject = null;
    protected String resource = null;
    protected ArrayList actions = new ArrayList();
    protected ArrayList evidence = new ArrayList();

    protected SAMLAuthorizationDecisionQuery() {
    }

    public SAMLAuthorizationDecisionQuery(SAMLSubject subject, String resource, Collection actions, Collection evidence) throws SAMLException {
        if (subject == null) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionQuery() requires subject");
        }
        if (resource == null) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionQuery() requires resource");
        }
        if (actions == null || actions.size() == 0) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionQuery() requires at least one action");
        }
        this.subject = subject;
        this.resource = resource;
        this.actions.addAll(actions);
        if (evidence != null) {
            this.evidence.addAll(evidence);
        }
    }

    public SAMLAuthorizationDecisionQuery(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthorizationDecisionQuery(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        this.ensureAuthzDecisionQuery(e);
        this.extractFromDOM(e);
    }

    private void ensureAuthzDecisionQuery(Element e) throws SAMLException {
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery")) {
            QName q = QName.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && q != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(q.getNamespaceURI()) && "AuthorizationDecisionQueryType".equals(q.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionQuery.fromDOM() requires samlp:AuthorizationDecisionQuery at root");
            }
        }
    }

    protected void extractFromDOM(Element e) throws SAMLException {
        this.resource = e.getAttributeNS(null, "Resource");
        Node n = e.getFirstChild();
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        this.subject = new SAMLSubject((Element)n);
        n = n.getNextSibling();
        while (n != null) {
            if (n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Action")) {
                this.actions.add(new SAMLAction((Element)n));
            } else if (n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence")) {
                Node n2 = n.getFirstChild();
                while (n2 != null) {
                    if (n2.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                        this.evidence.add(new SAMLAssertion((Element)n2));
                    } else if (n2.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
                        this.evidence.add(n2.getFirstChild().getNodeValue());
                    }
                    n2 = n2.getNextSibling();
                }
            }
            n = n.getNextSibling();
        }
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public String getResource() {
        return this.resource;
    }

    public Iterator getActions() {
        return ((AbstractList)this.actions).iterator();
    }

    public Collection getActionsCol() {
        return this.actions;
    }

    public Collection getEvidenceCol() {
        return this.evidence;
    }

    public Iterator getEvidence() {
        return ((AbstractList)this.evidence).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element q = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery");
        this.root = this.toDOM(doc, q);
        return this.root;
    }

    public Node toDOM(Document doc, Element q) {
        q.setAttributeNS(null, "Resource", this.resource);
        q.appendChild(this.subject.toDOM(doc));
        Iterator i = ((AbstractList)this.actions).iterator();
        while (i.hasNext()) {
            q.appendChild(((SAMLAction)i.next()).toDOM(doc));
        }
        i = ((AbstractList)this.evidence).iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof SAMLAssertion) {
                q.appendChild(((SAMLAssertion)o).toDOM(doc));
                continue;
            }
            if (!(o instanceof String)) continue;
            Element aidr = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AssertionIDRef");
            aidr.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            q.appendChild(aidr).appendChild(doc.createTextNode((String)o));
        }
        return q;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthorizationDecisionQuery dup = (SAMLAuthorizationDecisionQuery)super.clone();
        dup.subject = (SAMLSubject)this.subject.clone();
        Iterator i = ((AbstractList)this.actions).iterator();
        while (i.hasNext()) {
            dup.actions.add(((SAMLAction)i.next()).clone());
        }
        Iterator i2 = ((AbstractList)this.evidence).iterator();
        while (i2.hasNext()) {
            Object o = i2.next();
            if (o instanceof SAMLAssertion) {
                dup.evidence.add(((SAMLAssertion)o).clone());
                continue;
            }
            if (!(o instanceof String)) continue;
            dup.evidence.add(o);
        }
        return dup;
    }

    public boolean equals(Object obj) {
        SAMLAuthorizationDecisionQuery query = (SAMLAuthorizationDecisionQuery)obj;
        if (this.compareStrings(this.resource, query.getResource()) && this.subject.equals(query.getSubject()) && this.actions.containsAll(query.getActionsCol())) {
            return this.evidence.containsAll(query.getEvidenceCol());
        }
        return false;
    }
}

