/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorityBinding
extends SAMLObject
implements Cloneable {
    private String binding = null;
    private String location = null;
    private QName authorityKind = null;

    public SAMLAuthorityBinding(String binding, String location, QName authorityKind) throws SAMLException {
        if (binding == null || binding.length() == 0) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAuthorityBinding() requires binding protocol");
        }
        if (location == null || location.length() == 0) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAuthorityBinding() requires location");
        }
        if (authorityKind == null) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAuthorityBinding() requires kind of authority");
        }
        this.binding = binding;
        this.location = location;
        this.authorityKind = authorityKind;
    }

    public SAMLAuthorityBinding(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAuthorityBinding(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthorityBinding() requires saml:AuthorityBinding at root");
        }
        this.binding = e.getAttributeNS(null, "Binding");
        this.location = e.getAttributeNS(null, "Location");
        this.authorityKind = QName.getQNameAttribute(e, null, "AuthorityKind");
    }

    public String getBinding() {
        return this.binding;
    }

    public String getLocation() {
        return this.location;
    }

    public QName getAuthorityKind() {
        return this.authorityKind;
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element ab = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        ab.setAttributeNS(null, "Binding", this.binding);
        ab.setAttributeNS(null, "Location", this.location);
        if (!"urn:oasis:names:tc:SAML:1.0:protocol".equals(this.authorityKind.getNamespaceURI())) {
            ab.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:kind", this.authorityKind.getNamespaceURI());
            ab.setAttributeNS(null, "AuthorityKind", "kind:" + this.authorityKind.getLocalName());
        } else {
            ab.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            ab.setAttributeNS(null, "AuthorityKind", "samlp:" + this.authorityKind.getLocalName());
        }
        this.root = ab;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

