/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLAttribute
extends SAMLObject
implements Cloneable {
    private static Hashtable attributeMap = new Hashtable();
    protected String name = null;
    protected String namespace = null;
    protected QName type = null;
    protected long lifetime = 0L;
    protected ArrayList values = new ArrayList();

    static void regFactory(String name, String namespace, String className) {
        attributeMap.put(namespace + "!!" + name, className);
    }

    static void unregFactory(String name, String namespace) {
        attributeMap.remove(namespace + "!!" + name);
    }

    static SAMLAttribute getInstance(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttribute.getInstance() given an empty DOM");
        }
        String name = e.getAttributeNS(null, "AttributeName");
        String namespace = e.getAttributeNS(null, "AttributeNamespace");
        if (name == null || namespace == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttribute.getInstance() can't find AttributeName or Namespace on root element");
        }
        String className = (String)attributeMap.get(namespace + "!!" + name);
        if (className == null) {
            return new SAMLAttribute(e);
        }
        try {
            Class<?> implementation = Class.forName(className);
            Class[] paramtypes = new Class[]{Class.forName("org.w3c.dom.Element")};
            Object[] params = new Object[]{e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLAttribute)ctor.newInstance(params);
        }
        catch (ClassNotFoundException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to locate implementation class for attribute", (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to bind to constructor for attribute", (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to build implementation object for attribute", (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to access implementation of attribute", (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Throwable e2 = ex.getTargetException();
            if (e2 instanceof SAMLException) {
                throw (SAMLException)e2;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() caught unknown exception while building attribute object: " + e2.getMessage());
        }
    }

    static SAMLAttribute getInstance(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return SAMLAttribute.getInstance(doc.getDocumentElement());
        }
        catch (SAXException e) {
            NDC.push((String)"SAMLAttribute");
            Category.getInstance((String)"getInstance").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)e);
        }
        catch (IOException e) {
            NDC.push((String)"SAMLAttribute");
            Category.getInstance((String)"getInstance").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)e);
        }
    }

    public SAMLAttribute(String name, String namespace, QName type, long lifetime, Collection values) throws SAMLException {
        if (name == null || name.length() == 0 || namespace == null || namespace.length() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttribute() requires attribute name and namespace");
        }
        this.name = name;
        this.namespace = namespace;
        this.type = type;
        this.lifetime = lifetime;
        if (values != null) {
            this.values.addAll(values);
        }
    }

    public SAMLAttribute(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttribute(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator")) {
            throw new MalformedException("SAMLAttribute.fromDOM() requires saml:Attribute[Designator] at root");
        }
        this.name = e.getAttributeNS(null, "AttributeName");
        this.namespace = e.getAttributeNS(null, "AttributeNamespace");
        NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
        if (nlist.getLength() > 0) {
            int i = 0;
            while (i < nlist.getLength()) {
                if (this.type == null) {
                    this.type = QName.getQNameAttribute((Element)nlist.item(i), "http://www.w3.org/2001/XMLSchema-instance", "type");
                }
                if (this.accept((Element)nlist.item(i))) {
                    this.addValue((Element)nlist.item(i));
                }
                ++i;
            }
        }
    }

    void addValues(Element e) {
        NodeList nlist = e.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
        int i = 0;
        while (nlist != null && i < nlist.getLength()) {
            if (this.type == null) {
                this.type = QName.getQNameAttribute((Element)nlist.item(i), "http://www.w3.org/2001/XMLSchema-instance", "type");
            }
            this.addValue((Element)nlist.item(i));
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public QName getType() {
        return this.type;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public Iterator getValues() {
        return ((AbstractList)this.values).iterator();
    }

    public boolean accept(Element e) {
        return true;
    }

    public boolean addValue(Element e) {
        Node n = e.getFirstChild();
        if (this.accept(e)) {
            if (n != null && n.getNodeType() == 3) {
                this.values.add(n.getNodeValue());
                return true;
            }
            this.log.warn((Object)"rejecting an AttributeValue without a simple, non-empty text node");
        }
        return false;
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        a.setAttributeNS(null, "AttributeName", this.name);
        a.setAttributeNS(null, "AttributeNamespace", this.namespace);
        String xsitype = null;
        if (this.type != null) {
            String prefix;
            if ("http://www.w3.org/2001/XMLSchema".equals(this.type.getNamespaceURI())) {
                prefix = "xsd";
            } else {
                a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typens", this.type.getNamespaceURI());
                prefix = "typens";
            }
            xsitype = prefix + ":" + this.type.getLocalName();
        }
        Iterator i = ((AbstractList)this.values).iterator();
        while (i.hasNext()) {
            Element v = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
            if (this.type != null) {
                v.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", xsitype);
            }
            v.appendChild(doc.createTextNode(i.next().toString()));
            a.appendChild(v);
        }
        this.root = a;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttribute dup = (SAMLAttribute)super.clone();
        dup.values = (ArrayList)this.values.clone();
        return dup;
    }
}

