/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAdvice;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSignedObject;
import org.opensaml.SAMLStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAssertion
extends SAMLSignedObject
implements Cloneable {
    private String assertionId = null;
    private String issuer = null;
    private Date issueInstant = null;
    private Date notBefore = null;
    private Date notOnOrAfter = null;
    private ArrayList conditions = new ArrayList();
    private SAMLAdvice advice = null;
    private ArrayList statements = new ArrayList();

    protected void insertSignature() throws SAMLException {
        this.root.appendChild(this.getSignatureElement());
    }

    public SAMLAssertion(String issuer, Date notBefore, Date notOnOrAfter, Collection conditions, SAMLAdvice advice, Collection statements) throws SAMLException {
        if (issuer == null || issuer.length() == 0) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLAssertion() requires issuer and at least one statement");
        }
        if (conditions != null) {
            this.conditions.addAll(conditions);
        }
        this.advice = advice;
        if (statements != null) {
            this.statements.addAll(statements);
        }
        this.issuer = issuer;
        this.notBefore = notBefore;
        this.notOnOrAfter = notOnOrAfter;
    }

    public SAMLAssertion(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAssertion(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() requires saml:Assertion at root");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (Integer.parseInt(e.getAttributeNS(null, "MajorVersion")) != 1) {
                throw new MalformedException(SAMLException.VERSION, "SAMLAssertion.fromDOM() detected incompatible assertion major version of " + e.getAttributeNS(null, "MajorVersion"));
            }
            this.issuer = e.getAttributeNS(null, "Issuer");
            this.assertionId = e.getAttributeNS(null, "AssertionID");
            this.issueInstant = formatter.parse(e.getAttributeNS(null, "IssueInstant"));
            boolean complete = true;
            Node n = e.getFirstChild();
            while (n != null) {
                if (n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions")) {
                    e = (Element)n;
                    if (e.hasAttributeNS(null, "NotBefore")) {
                        this.notBefore = formatter.parse(e.getAttributeNS(null, "NotBefore"));
                    }
                    if (e.hasAttributeNS(null, "NotOnOrAfter")) {
                        this.notOnOrAfter = formatter.parse(e.getAttributeNS(null, "NotOnOrAfter"));
                    }
                    Node cond = e.getFirstChild();
                    while (cond != null) {
                        if (cond.getNodeType() == 1) {
                            this.conditions.add(SAMLCondition.getInstance((Element)cond));
                        }
                        cond = cond.getNextSibling();
                    }
                } else if (n.getNodeType() == 1 && XML.isElementNamed((Element)n, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice")) {
                    this.advice = new SAMLAdvice((Element)n);
                } else if (n.getNodeType() == 1 && !XML.isElementNamed((Element)n, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
                    this.statements.add(SAMLStatement.getInstance((Element)n));
                }
                n = n.getNextSibling();
            }
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() detected an invalid datetime while parsing assertion", (Exception)ex);
        }
    }

    public String getAssertionID() {
        return this.assertionId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public Iterator getStatements() {
        return ((AbstractList)this.statements).iterator();
    }

    public SAMLAdvice getAdvice() {
        return this.advice;
    }

    public Iterator getConditions() {
        return ((AbstractList)this.conditions).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        Element assertion = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        assertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        assertion.setAttributeNS(null, "MajorVersion", "1");
        assertion.setAttributeNS(null, "MinorVersion", "0");
        this.assertionId = new SAMLIdentifier().toString();
        assertion.setAttributeNS(null, "AssertionID", this.assertionId);
        assertion.setAttributeNS(null, "Issuer", this.issuer);
        assertion.setAttributeNS(null, "IssueInstant", formatter.format(new Date()));
        if (this.conditions.size() > 0 || this.notBefore != null || this.notOnOrAfter != null) {
            Element conds = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
            if (this.notBefore != null) {
                conds.setAttributeNS(null, "NotBefore", formatter.format(this.notBefore));
            }
            if (this.notOnOrAfter != null) {
                conds.setAttributeNS(null, "NotOnOrAfter", formatter.format(this.notOnOrAfter));
            }
            assertion.appendChild(conds);
            Iterator i = ((AbstractList)this.conditions).iterator();
            while (i.hasNext()) {
                conds.appendChild(((SAMLCondition)i.next()).toDOM(doc));
            }
        }
        if (this.advice != null) {
            assertion.appendChild(this.advice.toDOM(doc));
        }
        Iterator i = ((AbstractList)this.statements).iterator();
        while (i.hasNext()) {
            assertion.appendChild(((SAMLStatement)i.next()).toDOM(doc));
        }
        this.root = assertion;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAssertion dup = (SAMLAssertion)super.clone();
        Iterator i = ((AbstractList)this.conditions).iterator();
        while (i.hasNext()) {
            dup.conditions.add(((SAMLCondition)i.next()).clone());
        }
        dup.advice = (SAMLAdvice)this.advice.clone();
        Iterator i2 = ((AbstractList)this.statements).iterator();
        while (i2.hasNext()) {
            dup.statements.add(((SAMLStatement)i2.next()).clone());
        }
        return dup;
    }
}

