/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.Init;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAdvice
extends SAMLObject
implements Cloneable {
    private ArrayList advice = new ArrayList();

    public SAMLAdvice(Collection advice) throws SAMLException {
        if (advice != null) {
            Iterator i = advice.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj instanceof String || obj instanceof SAMLAssertion || obj instanceof Element && !((Element)obj).getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    advice.add(obj);
                    continue;
                }
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAdvice() can only process Strings, SAMLAssertions, or DOM elements from a non-saml namespace");
            }
        }
    }

    public SAMLAdvice(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAdvice(InputStream in) throws SAMLException {
        this.fromDOM(SAMLObject.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (Init.getBoolProperty("strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAdvice.fromDOM() requires saml:Action at root");
        }
    }

    public Iterator getData() {
        return ((AbstractList)this.advice).iterator();
    }

    public Node toDOM(Document doc) {
        this.root = super.toDOM(doc);
        if (this.root != null) {
            return this.root;
        }
        Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Advice");
        this.root = a;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAdvice dup = (SAMLAdvice)super.clone();
        Iterator i = ((AbstractList)this.advice).iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof String) {
                dup.advice.add(obj);
                continue;
            }
            if (obj instanceof SAMLAssertion) {
                dup.advice.add(((SAMLAssertion)obj).clone());
                continue;
            }
            dup.advice.add(((Element)obj).cloneNode(true));
        }
        return dup;
    }
}

