/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.utils.AuthorizationHelper;
import org.globus.exec.service.utils.DelegatedCredential;
import org.globus.exec.service.utils.GlobusShToolsProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.util.Base64;
import org.globus.util.I18n;
import org.globus.util.PEMUtils;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.utils.PerformanceLog;

public class UserProxyCreator
implements Runnable {
    static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$utils$UserProxyCreator == null ? (class$org$globus$exec$service$utils$UserProxyCreator = UserProxyCreator.class$("org.globus.exec.service.utils.UserProxyCreator")) : class$org$globus$exec$service$utils$UserProxyCreator).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = UserProxyCreator.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$utils$UserProxyCreator == null ? (class$org$globus$exec$service$utils$UserProxyCreator = UserProxyCreator.class$("org.globus.exec.service.utils.UserProxyCreator")) : class$org$globus$exec$service$utils$UserProxyCreator).getName() + ".performance");
    private DelegatedCredential credential = null;
    static /* synthetic */ Class class$org$globus$exec$service$utils$UserProxyCreator;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public UserProxyCreator(DelegatedCredential credential) {
        this.credential = credential;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        InputStream stdout = null;
        OutputStream proxyFileOutputStream = null;
        try {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Creating job user proxy.");
                }
                X509Certificate userProxy = null;
                performanceLogger.start();
                GlobusShToolsProperties toolPathProps = GlobusShToolsProperties.getInstance();
                Process proc = null;
                String sudo = toolPathProps.getProperty("GLOBUS_SH_SUDO");
                if (sudo == null) throw new IOException(i18n.getMessage("MissingSudo"));
                if (sudo.length() == 0) {
                    throw new IOException(i18n.getMessage("MissingSudo"));
                }
                FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
                String proxyTool = new File(factoryHomeConfiguration.getGlobusLocation() + "/libexec/globus-gram-local-proxy-tool").toString();
                String gridMapAndExecute = new File(factoryHomeConfiguration.getGlobusLocation() + "/libexec/globus-gridmap-and-execute").toString();
                String gridMapFile = ContainerSecurityConfig.getConfig().getSecurityDescriptor().getGridMapFile();
                boolean authzGridmap = AuthorizationHelper.isAuthorizationGridmap();
                Vector<String> commandVector = new Vector<String>();
                if (!System.getProperty("user.name").equals(this.credential.localUserId)) {
                    commandVector.add(sudo);
                    commandVector.add("-u");
                    commandVector.add(this.credential.localUserId);
                    commandVector.add("-S");
                    if (authzGridmap) {
                        commandVector.add(gridMapAndExecute);
                        if (gridMapFile != null) {
                            commandVector.add("-g");
                            commandVector.add(gridMapFile);
                        }
                    }
                }
                commandVector.add(proxyTool);
                commandVector.add(factoryHomeConfiguration.getGlobusLocation());
                commandVector.add("-write");
                commandVector.add(this.credential.userProxyFile.getPath());
                if (logger.isDebugEnabled()) {
                    StringBuffer commandBuffer = new StringBuffer(commandVector.size() * 2);
                    for (int index = 0; index < commandVector.size(); ++index) {
                        if (index > 0) {
                            commandBuffer.append(" ");
                        }
                        commandBuffer.append(commandVector.get(index));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Executing command:\n" + commandBuffer.toString()));
                    }
                }
                proc = Runtime.getRuntime().exec(commandVector.toArray(new String[0]));
                stdout = proc.getInputStream();
                int proxyType = CertUtil.isLimitedProxy((int)this.credential.credential.getProxyType()) ? 2 : 3;
                InputStream derRequest = UserProxyCreator.getDERRequest(stdout);
                if (derRequest == null) {
                    BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    String stderrLine = stderr.readLine();
                    while (stderrLine != null) {
                        if (stderrLine.trim().indexOf("Password:") != 0) continue;
                        String errorMessage = i18n.getMessage("MisconfiguredSudo", (Object[])new String[]{"globus-gram-local-proxy-tool", this.credential.localUserId});
                        throw new RuntimeException(errorMessage);
                    }
                    stderr.close();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"at createCertificate()");
                }
                performanceLogger.start();
                userProxy = BouncyCastleCertProcessingFactory.getDefault().createCertificate(derRequest, this.credential.credential.getCertificateChain()[0], this.credential.credential.getPrivateKey(), (int)this.credential.credential.getTimeLeft(), proxyType);
                performanceLogger.stop("createCertificate()");
                proxyFileOutputStream = new BufferedOutputStream(proc.getOutputStream());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"at writeProxy()");
                }
                UserProxyCreator.writeProxy(userProxy, this.credential.credential.getCertificateChain(), proxyFileOutputStream);
                proxyFileOutputStream.close();
                proxyFileOutputStream = null;
                int rc = 0;
                try {
                    rc = proc.waitFor();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (rc != 0) {
                    this.credential.removeUserProxy();
                    throw new IOException(I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = UserProxyCreator.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName()).getMessage("changeOwnerFailed", (Object[])new String[]{this.credential.localUserId, this.credential.userProxyFile.getPath()}));
                }
                performanceLogger.stop("write user proxy");
            }
            catch (Exception e) {
                throw new RuntimeException(i18n.getMessage("ProxyFileCreationError"), e);
            }
            Object var19_23 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            try {
                if (stdout != null) {
                    stdout.close();
                }
                if (proxyFileOutputStream == null) throw throwable;
                proxyFileOutputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (stdout != null) {
            stdout.close();
        }
        if (proxyFileOutputStream != null) {
            proxyFileOutputStream.close();
        }
        this.credential.setInitialized();
    }

    private static final void writePEM(OutputStream out, X509Certificate cert) throws CertificateEncodingException, IOException {
        PEMUtils.writeBase64((OutputStream)out, (String)"-----BEGIN CERTIFICATE-----", (byte[])Base64.encode((byte[])cert.getEncoded()), (String)"-----END CERTIFICATE-----");
    }

    private static void writeProxy(X509Certificate proxy, X509Certificate[] chain, OutputStream out) throws IOException {
        try {
            UserProxyCreator.writePEM(out, proxy);
            for (int i = 0; i < chain.length; ++i) {
                if (((Object)chain[i].getSubjectDN()).equals(chain[i].getIssuerDN())) continue;
                UserProxyCreator.writePEM(out, chain[i]);
            }
        }
        catch (CertificateEncodingException e) {
            throw new ChainedIOException(e.getMessage(), (Throwable)e);
        }
        out.flush();
    }

    private static InputStream getDERRequest(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        StringBuffer buff = new StringBuffer();
        boolean isReq = false;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("BEGIN CERTIFICATE REQUEST") != -1) {
                isReq = true;
                continue;
            }
            if (isReq && line.indexOf("END CERTIFICATE REQUEST") != -1) {
                byte[] data = Base64.decode((byte[])buff.toString().getBytes());
                return new ByteArrayInputStream(data);
            }
            if (!isReq) continue;
            buff.append(line);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

