/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.utils;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.TopicListenerDescriptionType;
import org.globus.exec.service.job.ManagedJobResourceImpl;
import org.globus.exec.service.job.PersistentManagedJobResource;
import org.globus.exec.service.utils.SubscriptionPersistenceUtils;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.utils.PerformanceLog;
import org.globus.wsrf.utils.XmlPersistenceHelper;

public class PersistenceHelper
extends XmlPersistenceHelper {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$utils$PersistenceHelper == null ? (class$org$globus$exec$service$utils$PersistenceHelper = PersistenceHelper.class$("org.globus.exec.service.utils.PersistenceHelper")) : class$org$globus$exec$service$utils$PersistenceHelper).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = PersistenceHelper.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$utils$PersistenceHelper == null ? (class$org$globus$exec$service$utils$PersistenceHelper = PersistenceHelper.class$("org.globus.exec.service.utils.PersistenceHelper")) : class$org$globus$exec$service$utils$PersistenceHelper).getName() + ".performance");
    private static final boolean TESTING = false;
    private PersistentManagedJobResource jobResource;
    static /* synthetic */ Class class$org$globus$exec$service$utils$PersistenceHelper;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public PersistenceHelper(PersistentManagedJobResource resource) throws IOException {
        super(resource.getWholeStateType());
        this.jobResource = resource;
    }

    public PersistentManagedJobResource getResource() {
        return this.jobResource;
    }

    public synchronized void store() throws ResourceException {
        if (!this.jobResource.getDirty()) {
            logger.debug((Object)"Dirty flag not set: resource will not be stored");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("storing resource " + this.jobResource.getID() + " with state " + this.jobResource.getState()));
        }
        try {
            ManagedJobResourceImpl.setResourceDatum(this.jobResource, "topicListener", SubscriptionPersistenceUtils.getSerializableListeners(this.jobResource.getTopicList()));
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("TopicSerializationError");
            logger.error((Object)errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        this.store(this.jobResource.getID(), this.jobResource.getWholeState(), this.jobResource.getWholeStateQName());
        this.jobResource.setDirty(false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("done storing resource " + this.jobResource.getID()));
        }
    }

    public synchronized void load(ResourceKey key) throws ResourceException {
        performanceLogger.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loading resource " + this.jobResource + " of key " + key));
        }
        Object loadedResourceStateBean = super.load((Object)key);
        this.jobResource.initializeWholeState(loadedResourceStateBean, this.jobResource.getResourcePropertiesQName(), key);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"reconstructing topic listeners based on deserialized persisted subscriptions");
            }
            TopicListenerDescriptionType[] serializableListeners = (TopicListenerDescriptionType[])this.jobResource.getResourceDatum("topicListener");
            SubscriptionPersistenceUtils.addSubscriptionListenersToTopics(serializableListeners, this.jobResource.getTopicList());
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("TopicRegistrationError");
            logger.error((Object)errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        this.jobResource.setDirty(false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("done loading  resource " + this.jobResource.getID() + " with state " + this.jobResource.getState()));
        }
        performanceLogger.stop("load(ResourceKey)");
    }

    public void remove() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Removing XML resource state file");
            logger.debug((Object)("resource class: " + this.jobResource.getClass().getName()));
            logger.debug((Object)("resource id: " + this.jobResource.getID().toString()));
        }
        super.remove(this.jobResource.getID());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

