/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.delegation.DelegationException;
import org.globus.delegation.DelegationListener;
import org.globus.delegation.DelegationUtil;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.utils.GlobusShToolsProperties;
import org.globus.exec.service.utils.UserProxyCreator;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.util.I18n;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.utils.PerformanceLog;

public class DelegatedCredential
implements DelegationListener {
    static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$utils$DelegatedCredential == null ? (class$org$globus$exec$service$utils$DelegatedCredential = DelegatedCredential.class$("org.globus.exec.service.utils.DelegatedCredential")) : class$org$globus$exec$service$utils$DelegatedCredential).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = DelegatedCredential.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$utils$DelegatedCredential == null ? (class$org$globus$exec$service$utils$DelegatedCredential = DelegatedCredential.class$("org.globus.exec.service.utils.DelegatedCredential")) : class$org$globus$exec$service$utils$DelegatedCredential).getName() + ".performance");
    GlobusCredential credential = null;
    String localUserId = null;
    File userProxyFile = null;
    private String delegationKey = null;
    private String userSubject;
    private boolean initialized = false;
    private String listenerId = null;
    private static Hashtable INSTANCES = new Hashtable();
    static /* synthetic */ Class class$org$globus$exec$service$utils$DelegatedCredential;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$java$lang$String;

    public static DelegatedCredential getDelegatedCredential(EndpointReferenceType delegationEndpoint, String localUserId, String userSubject) throws DelegationException, GeneralSecurityException, IOException {
        return DelegatedCredential.getDelegatedCredential(delegationEndpoint, localUserId, userSubject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DelegatedCredential getDelegatedCredential(EndpointReferenceType delegationEndpoint, String localUserId, String userSubject, File userProxyDirectory) throws DelegationException, GeneralSecurityException, IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering getDelegatedCredential()");
        }
        if (logger.isTraceEnabled()) {
            logger.debug((Object)("getting instance table for user " + localUserId));
        }
        Hashtable userInstances = null;
        Hashtable hashtable = INSTANCES;
        synchronized (hashtable) {
            userInstances = (Hashtable)INSTANCES.get(localUserId);
            if (userInstances == null) {
                userInstances = new Hashtable();
                INSTANCES.put(localUserId, userInstances);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.debug((Object)"checking for existing credential listener");
        }
        DelegatedCredential cred = null;
        Hashtable hashtable2 = userInstances;
        synchronized (hashtable2) {
            String delegationKey = DelegatedCredential.getDelegationKey(delegationEndpoint);
            if (userInstances.containsKey(delegationKey)) {
                DelegatedCredential savedCred = (DelegatedCredential)userInstances.get(delegationKey);
                if (userProxyDirectory != null && savedCred.userProxyFile == null) {
                    savedCred.userProxyFile = new File(userProxyDirectory, "gram_job_proxy_" + savedCred.delegationKey);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("userProxFile: " + savedCred.userProxyFile.toString()));
                    }
                    new UserProxyCreator(savedCred).run();
                }
                return savedCred;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("delegated credential endpoint (BEFORE): " + delegationEndpoint));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"new DelegatedCredential()");
            }
            performanceLogger.start();
            cred = new DelegatedCredential(delegationEndpoint, localUserId, userSubject, userProxyDirectory);
            performanceLogger.stop("new DelegatedCredential()");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("delegated credential endpoint (AFTER): " + delegationEndpoint));
            }
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new GlobusPrincipal(userSubject));
            performanceLogger.start();
            try {
                DelegationUtil.registerDelegationListener((EndpointReferenceType)delegationEndpoint, (DelegationListener)cred, (Subject)subject);
            }
            catch (DelegationException de) {
                cred.credentialDeleted();
                throw de;
            }
            performanceLogger.stop("DelegationUtil.registerDelegationListener()");
            performanceLogger.start();
            cred.initialize();
            performanceLogger.stop("cred.initialize()");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Leaving getDelegatedCredential()");
        }
        return cred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegatedCredential(EndpointReferenceType delegationEndpoint, String localUserId, String userSubject, File userProxyDirectory) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering DelegatedCredential()");
        }
        this.localUserId = localUserId;
        this.userSubject = userSubject;
        this.delegationKey = DelegatedCredential.getDelegationKey(delegationEndpoint);
        if (userProxyDirectory != null) {
            this.userProxyFile = new File(userProxyDirectory, "gram_job_proxy_" + this.delegationKey);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("userProxFile: " + this.userProxyFile.toString()));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"saving this instance to instance table");
        }
        Hashtable userInstances = null;
        Hashtable hashtable = INSTANCES;
        synchronized (hashtable) {
            userInstances = (Hashtable)INSTANCES.get(localUserId);
        }
        hashtable = userInstances;
        synchronized (hashtable) {
            userInstances.put(this.delegationKey, this);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Leaving DelegatedCredential()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DelegationException, GeneralSecurityException, IOException {
        try {
            DelegatedCredential delegatedCredential = this;
            synchronized (delegatedCredential) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"waiting to receive initial credential...");
                }
                while (!this.initialized) {
                    this.wait();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"done waiting...");
                }
            }
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("InterruptCredentialsAcquisition");
            logger.error((Object)errorMessage, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredential(GlobusCredential credential) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering setCredential()");
        }
        Hashtable<String, DelegatedCredential> userInstances = null;
        Hashtable<String, DelegatedCredential> hashtable = INSTANCES;
        synchronized (hashtable) {
            userInstances = (Hashtable<String, DelegatedCredential>)INSTANCES.get(this.localUserId);
            if (userInstances == null) {
                userInstances = new Hashtable<String, DelegatedCredential>();
                INSTANCES.put(this.localUserId, userInstances);
            }
        }
        hashtable = userInstances;
        synchronized (hashtable) {
            if (userInstances.get(this.delegationKey) == null) {
                userInstances.put(this.delegationKey, this);
            }
        }
        this.credential = credential;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("received a new credential:\n" + this.credential));
        }
        if (this.userProxyFile != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"at run()");
            }
            new UserProxyCreator(this).run();
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"at setInitialized()");
            }
            this.setInitialized();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Leaving setCredential()");
        }
    }

    synchronized void setInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobusCredential getCredential() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"waiting to receive initial credential...");
            }
            DelegatedCredential delegatedCredential = this;
            synchronized (delegatedCredential) {
                while (!this.initialized) {
                    this.wait();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"done waiting...");
            }
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("InterruptCredentialsAcquisition");
            logger.error((Object)errorMessage, (Throwable)e);
        }
        return this.credential;
    }

    public void removeUserProxy() throws GeneralSecurityException, IOException {
        if (this.userProxyFile == null || !this.userProxyFile.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ignoring job user proxy removal request.");
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Removing job user proxy.");
        }
        if (!System.getProperty("user.name").equals(this.localUserId)) {
            GlobusShToolsProperties toolPathProps = GlobusShToolsProperties.getInstance();
            String sudo = toolPathProps.getProperty("GLOBUS_SH_SUDO");
            FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
            String gridMapAndExecute = new File(factoryHomeConfiguration.getGlobusLocation() + "/libexec/globus-gridmap-and-execute").toString();
            String proxyTool = new File(factoryHomeConfiguration.getGlobusLocation() + "/libexec/globus-gram-local-proxy-tool").toString();
            String gridMapFile = null;
            try {
                gridMapFile = ContainerSecurityConfig.getConfig().getSecurityDescriptor().getGridMapFile();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String[] command = null;
            command = gridMapFile != null ? new String[]{sudo, "-u", this.localUserId, "-S", gridMapAndExecute, "-g", gridMapFile, proxyTool, factoryHomeConfiguration.getGlobusLocation(), "-delete", this.userProxyFile.getPath()} : new String[]{sudo, "-u", this.localUserId, "-S", gridMapAndExecute, proxyTool, factoryHomeConfiguration.getGlobusLocation(), "-delete", this.userProxyFile.getPath()};
            if (logger.isDebugEnabled()) {
                StringBuffer commandBuffer = new StringBuffer(command.length * 2);
                for (int index = 0; index < command.length; ++index) {
                    if (index > 0) {
                        commandBuffer.append(" ");
                    }
                    commandBuffer.append(command[index]);
                }
                logger.debug((Object)("Executing command:\n" + commandBuffer.toString()));
            }
            Process proc = Runtime.getRuntime().exec(command);
            proc.getOutputStream().close();
            BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String stderrLine = stderr.readLine();
            while (stderrLine != null) {
                if (stderrLine.trim().indexOf("Password:") != 0) continue;
                String errorMessage = i18n.getMessage("MisconfiguredSudo", (Object[])new String[]{"globus-gram-local-proxy-tool", this.localUserId});
                throw new RuntimeException(errorMessage);
            }
            stderr.close();
            proc.getInputStream().close();
        } else {
            this.userProxyFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void credentialDeleted() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"entering credentialDeleted()");
        }
        Hashtable userInstances = null;
        Hashtable hashtable = INSTANCES;
        synchronized (hashtable) {
            userInstances = (Hashtable)INSTANCES.get(this.localUserId);
        }
        hashtable = userInstances;
        synchronized (hashtable) {
            DelegatedCredential credObj = (DelegatedCredential)userInstances.remove(this.delegationKey);
            if (credObj != null) {
                DelegatedCredential delegatedCredential = credObj;
                synchronized (delegatedCredential) {
                    credObj.notifyAll();
                }
                logger.debug((Object)"removed DelegatedCredential object");
            }
        }
        try {
            this.removeUserProxy();
        }
        catch (Exception e) {
            logger.warn((Object)"unable to remove user proxy", (Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"leaving credentialDeleted()");
        }
    }

    public DelegatedCredential() {
    }

    public String getLocalUserId() {
        return this.localUserId;
    }

    public void setLocalUserId(String localUserId) {
        this.localUserId = localUserId;
    }

    public String getUserSubject() {
        return this.userSubject;
    }

    public void setUserSubject(String userSubject) {
        this.userSubject = userSubject;
    }

    public File getUserProxyFile() {
        return this.userProxyFile;
    }

    public void setUserProxyFile(File userProxyFile) {
        this.userProxyFile = userProxyFile;
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getDelegationKey() {
        return this.delegationKey;
    }

    public void setDelegationKey(String delegationKey) {
        this.delegationKey = delegationKey;
    }

    public String getId() {
        return this.listenerId;
    }

    public void setId(String listenerId) {
        this.listenerId = listenerId;
    }

    private static String getDelegationKey(EndpointReferenceType credentialEndpoint) {
        MessageElement[] refProps = credentialEndpoint.getProperties().get_any();
        String delegationKey = null;
        try {
            delegationKey = ((String)ObjectDeserializer.toObject((SOAPElement)refProps[0], (Class)(class$java$lang$String == null ? (class$java$lang$String = DelegatedCredential.class$("java.lang.String")) : class$java$lang$String))).trim();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to deserialize DelegationKey", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pulled out DelegationKey: " + delegationKey));
        }
        return delegationKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

