/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.utils;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceHome;

public class ConfigurationHelper {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$utils$ConfigurationHelper == null ? (class$org$globus$exec$service$utils$ConfigurationHelper = ConfigurationHelper.class$("org.globus.exec.service.utils.ConfigurationHelper")) : class$org$globus$exec$service$utils$ConfigurationHelper).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ConfigurationHelper.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    static /* synthetic */ Class class$org$globus$exec$service$utils$ConfigurationHelper;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public static ResourceHome getResourceHome(String service) throws NamingException {
        return (ResourceHome)ConfigurationHelper.getJNDIObject(service, "/home");
    }

    public static Object getResourceHomeConfiguration(String service) throws NamingException {
        return ConfigurationHelper.getJNDIObject(service, "homeConfiguration");
    }

    public static Object getResourceHomeConfiguration() throws NamingException, ResourceContextException {
        ResourceContext ctx = ResourceContext.getResourceContext();
        return ConfigurationHelper.getResourceHomeConfiguration(ctx.getService());
    }

    public static Object getServiceConfiguration(String service) throws NamingException {
        return ConfigurationHelper.getJNDIObject(service, "configuration");
    }

    public static Object getServiceConfiguration() throws NamingException, ResourceContextException {
        ResourceContext ctx = ResourceContext.getResourceContext();
        return ConfigurationHelper.getServiceConfiguration(ctx.getService());
    }

    public static Object getAuditDatabaseConfiguration(String service) throws NamingException {
        return ConfigurationHelper.getJNDIObject(service, "auditDatabaseConfiguration");
    }

    public static Object getAuditDatabaseConfiguration() throws NamingException, ResourceContextException {
        ResourceContext ctx = ResourceContext.getResourceContext();
        return ConfigurationHelper.getAuditDatabaseConfiguration(ctx.getService());
    }

    public static Object getJNDIObjectForCurrentService(String objectName) throws NamingException, ResourceContextException {
        ResourceContext ctx = ResourceContext.getResourceContext();
        return ConfigurationHelper.getJNDIObject(ctx.getService(), objectName);
    }

    public static Object getJNDIObject(String service, String objectName) throws NamingException {
        Object jndiObject;
        String jndiLookupString = null;
        try {
            InitialContext initialContext = new InitialContext();
            if (!objectName.startsWith("/")) {
                objectName = "/" + objectName;
            }
            jndiLookupString = ConfigurationHelper.getServiceJNDILocation(service) + objectName;
            jndiObject = initialContext.lookup(jndiLookupString);
        }
        catch (NamingException e) {
            String errorMessage = i18n.getMessage("JndiConfigError", jndiLookupString);
            logger.error((Object)(errorMessage + "\n" + e.getMessage()));
            throw e;
        }
        return jndiObject;
    }

    public static String getServiceJNDILocation(String service) {
        return "java:comp/env//services/" + service;
    }

    public static String getServiceJNDILocation() throws ResourceContextException {
        ResourceContext ctx = ResourceContext.getResourceContext();
        return "java:comp/env//services/" + ctx.getService();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

