/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.service.factory.ManagedJobFactoryService;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;

public class AuthorizationHelper {
    static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$utils$AuthorizationHelper == null ? (class$org$globus$exec$service$utils$AuthorizationHelper = AuthorizationHelper.class$("org.globus.exec.service.utils.AuthorizationHelper")) : class$org$globus$exec$service$utils$AuthorizationHelper).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = AuthorizationHelper.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static final String GRIDMAP_AUTHZ_PDP_NAME = "gridmap";
    private static boolean authorizationGridmap = false;
    static /* synthetic */ Class class$org$globus$exec$service$utils$AuthorizationHelper;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    private AuthorizationHelper() {
    }

    public static void initialize() {
        logger.debug((Object)"getting factory service name");
        String factoryServiceName = ManagedJobFactoryService.getServicePath();
        try {
            logger.debug((Object)("getting security descriptor for JNDI path " + factoryServiceName));
            ServiceSecurityDescriptor securityDescriptor = ServiceSecurityConfig.getSecurityDescriptor((String)factoryServiceName);
            logger.debug((Object)"getting authz PDP name");
            String authz = securityDescriptor.getAuthz();
            String[] authzPDPNames = null;
            if (authz != null) {
                authzPDPNames = authz.split(" ");
                for (int index = 0; index < authzPDPNames.length; ++index) {
                    logger.debug((Object)("Detected authorization PDP plugin \"" + authzPDPNames[index] + "\"."));
                    if (!authzPDPNames[index].equals(GRIDMAP_AUTHZ_PDP_NAME)) continue;
                    logger.debug((Object)"Using gridmap authorization PDP plugin.");
                    authorizationGridmap = true;
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to determine authorization PDP plugin name.", (Throwable)e);
            throw new RuntimeException("Unable to determine authorization PDP plugin name.", e);
        }
    }

    public static boolean isAuthorizationGridmap() {
        logger.debug((Object)"Entering/Exiting isAuthorizationGridmap()");
        return authorizationGridmap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

