/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.multi;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.FaultResourcePropertyType;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.ManagedMultiJobResourceDataType;
import org.globus.exec.generated.ManagedMultiJobResourcePropertiesType;
import org.globus.exec.generated.ManagedMultiJobResourceStateType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.service.job.PersistentManagedJobResource;
import org.globus.exec.service.multi.ManagedMultiJobResource;
import org.globus.exec.service.utils.PersistenceHelper;
import org.globus.exec.utils.ManagedMultiJobConstants;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.impl.DirtyFlagHolder;
import org.globus.wsrf.impl.PersistentResourceProperty;

public class PersistentManagedMultiJobResource
extends ManagedMultiJobResource
implements PersistentManagedJobResource {
    private Object dirtyCond = new Object();
    private static final QName WHOLE_STATE_ELEMENT = new QName("http://www.globus.org/namespaces/2004/10/gram/job/multi/state", "ManagedMultiJobResourceState");
    private PersistenceHelper persistenceHelper;
    private boolean dirty = true;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$multi$PersistentManagedMultiJobResource == null ? (class$org$globus$exec$service$multi$PersistentManagedMultiJobResource = PersistentManagedMultiJobResource.class$("org.globus.exec.service.multi.PersistentManagedMultiJobResource")) : class$org$globus$exec$service$multi$PersistentManagedMultiJobResource).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = PersistentManagedMultiJobResource.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static I18n coreI18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = PersistentManagedMultiJobResource.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    static /* synthetic */ Class class$org$globus$exec$generated$ManagedMultiJobResourceStateType;
    static /* synthetic */ Class class$org$globus$exec$service$multi$PersistentManagedMultiJobResource;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public void initializeWholeState(Object wholeResourceState, QName resourceElementQName, Object key) throws ResourceException {
        super.initializeWholeState(wholeResourceState, resourceElementQName, key);
        ManagedMultiJobResourceStateType wholeJobState = (ManagedMultiJobResourceStateType)wholeResourceState;
        this.setInternalRendezvousState(wholeJobState.getResourceData().getInternalRendezvousData());
    }

    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering run()");
        }
        super.run();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving run()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStateNotification(StateEnumeration state, boolean holding, FaultResourcePropertyType fault) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering processStateNotification()");
        }
        super.processStateNotification(state, holding, fault);
        Object object = this.dirtyCond;
        synchronized (object) {
            this.setDirty(true);
            this.store();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving processStateNotification()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFault(FaultType fault) {
        super.setFault(fault);
        Object object = this.dirtyCond;
        synchronized (object) {
            this.setDirty(true);
            try {
                this.store();
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("PostUpdateSaveError", (Object)fault);
                throw new RuntimeException(errorMessage, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(StateEnumeration state) throws Exception {
        super.setState(state);
        Object object = this.dirtyCond;
        synchronized (object) {
            this.setDirty(true);
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceProperty(QName name, Object value) {
        super.setResourceProperty(name, value);
        Object object = this.dirtyCond;
        synchronized (object) {
            this.setDirty(true);
            try {
                this.store();
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("PostUpdateSaveError", (Object)name);
                throw new RuntimeException(errorMessage, e);
            }
        }
    }

    public void setResourceDatum(String name, Object value) {
        this.setResourceDatumWithoutStoring(name, value);
        try {
            this.store();
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("PostUpdateSaveError", (Object)name);
            throw new RuntimeException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceDatumWithoutStoring(String name, Object value) {
        super.setResourceDatum(name, value);
        Object object = this.dirtyCond;
        synchronized (object) {
            this.setDirty(true);
        }
    }

    public Class getWholeStateType() {
        return class$org$globus$exec$generated$ManagedMultiJobResourceStateType == null ? (class$org$globus$exec$generated$ManagedMultiJobResourceStateType = PersistentManagedMultiJobResource.class$("org.globus.exec.generated.ManagedMultiJobResourceStateType")) : class$org$globus$exec$generated$ManagedMultiJobResourceStateType;
    }

    public QName getWholeStateQName() {
        return WHOLE_STATE_ELEMENT;
    }

    public QName getResourcePropertiesQName() {
        return ManagedMultiJobConstants.RESOURCE_PROPERTY_SET;
    }

    public Object getWholeState() {
        ManagedMultiJobResourceStateType resourceState = new ManagedMultiJobResourceStateType();
        resourceState.setResourceProperties((ManagedMultiJobResourcePropertiesType)this.getResourceBean());
        resourceState.setResourceData((ManagedMultiJobResourceDataType)this.getResourceData());
        this.getResourceData().setInternalRendezvousData(this.getInternalRendezvousState());
        return resourceState;
    }

    public synchronized void store() throws ResourceException {
        this.getPersistenceHelper().store();
    }

    public synchronized void load(ResourceKey key) throws ResourceException {
        this.getPersistenceHelper().load(key);
    }

    public void remove() throws ResourceException {
        logger.trace((Object)"calling super class remove()");
        ResourceException exception = null;
        try {
            super.remove();
        }
        catch (ResourceException re) {
            exception = re;
        }
        logger.trace((Object)"removing persistence data");
        this.getPersistenceHelper().remove();
        if (exception != null) {
            throw exception;
        }
    }

    private synchronized PersistenceHelper getPersistenceHelper() throws ResourceException {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new PersistenceHelper(this);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("PersistHelperCreationError");
                logger.error((Object)errorMessage, (Throwable)e);
                throw new ResourceException(errorMessage, (Throwable)e);
            }
        }
        return this.persistenceHelper;
    }

    protected ResourceProperty createNewResourceProperty(QName rpQName, Object resourceBean) throws Exception {
        ResourceProperty prop = super.createNewResourceProperty(rpQName, resourceBean);
        return new PersistentResourceProperty(prop, (DirtyFlagHolder)this);
    }

    public void setDirty(boolean changed) {
        this.dirty = changed;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

