/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.multi;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.util.Util;
import org.globus.exec.generated.CreateManagedJobInputType;
import org.globus.exec.generated.CreateManagedJobOutputType;
import org.globus.exec.generated.FaultResourcePropertyType;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.ManagedJobFactoryPortType;
import org.globus.exec.generated.ManagedJobPortType;
import org.globus.exec.generated.ManagedJobResourceDataType;
import org.globus.exec.generated.ManagedMultiJobResourceDataType;
import org.globus.exec.generated.ManagedMultiJobResourceStateType;
import org.globus.exec.generated.MultiJobDescriptionType;
import org.globus.exec.generated.NameValuePairType;
import org.globus.exec.generated.ReleaseInputType;
import org.globus.exec.generated.StateChangeNotificationMessageType;
import org.globus.exec.generated.StateChangeNotificationMessageWrapperType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.job.ManagedJobResourceImpl;
import org.globus.exec.service.multi.ManagedMultiJobHome;
import org.globus.exec.service.utils.DelegatedCredential;
import org.globus.exec.utils.FaultUtils;
import org.globus.exec.utils.JobDescriptionMap;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.ManagedMultiJobConstants;
import org.globus.exec.utils.client.ManagedJobClientHelper;
import org.globus.exec.utils.client.ManagedJobFactoryClientHelper;
import org.globus.exec.utils.rsl.RSLHelper;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.Topic;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.impl.SimpleTopic;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscriptionManager;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;
import org.w3c.dom.Element;

public class ManagedMultiJobResource
extends ManagedJobResourceImpl
implements RemoveCallback,
SecureResource,
NotifyCallback,
Runnable {
    private ResourceSecurityDescriptor securityDescriptor = null;
    private static Log logger;
    private static I18n i18n;
    private static I18n coreI18n;
    static /* synthetic */ Class class$org$globus$exec$generated$FaultType;
    static /* synthetic */ Class class$org$globus$exec$utils$JobDescriptionMap;
    static /* synthetic */ Class class$org$globus$exec$generated$JobDescriptionType;
    static /* synthetic */ Class class$java$beans$PropertyDescriptor;
    static /* synthetic */ Class class$org$oasis$wsn$TopicExpressionType;
    static /* synthetic */ Class class$org$globus$exec$service$multi$ManagedMultiJobResource;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$wsrf$utils$Resources;

    public void initializeWholeState(Object wholeResourceState, QName resourceElementQName, Object key) throws ResourceException {
        super.initializeWholeState(wholeResourceState, resourceElementQName, key);
        ManagedMultiJobResourceStateType wholeJobState = (ManagedMultiJobResourceStateType)wholeResourceState;
        this.setResourceData((ManagedJobResourceDataType)wholeJobState.getResourceData());
        this.initialize(wholeJobState.getResourceProperties(), resourceElementQName, key);
    }

    public void initialize(Object resourceBean, QName resourceElementQName, Object key) throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering initialize()");
        }
        super.initialize(resourceBean, resourceElementQName, key);
        String localUserId = (String)this.getResourcePropertySet().get(ManagedJobConstants.RP_LOCAL_USER_ID).get(0);
        this.initSecurity();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving initialize()");
        }
    }

    public void initSecurity() throws ResourceException {
        ResourceSecurityConfig securityConfig = new ResourceSecurityConfig("etc/gram-service/managed-job-security-config.xml");
        try {
            securityConfig.init();
        }
        catch (Exception e) {
            throw new ResourceException(i18n.getMessage("resourceSecurityInitializationFailed"), (Throwable)e);
        }
        this.securityDescriptor = securityConfig.getSecurityDescriptor();
        String userSubject = (String)this.getResourcePropertySet().get(ManagedJobConstants.RP_USER_SUBJECT).get(0);
        String localUserId = (String)this.getResourcePropertySet().get(ManagedJobConstants.RP_LOCAL_USER_ID).get(0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting resource securty grid map...\nSubject: " + userSubject + "\nLocal user ID: " + localUserId));
        }
        GridMap gridMap = new GridMap();
        gridMap.map(userSubject, localUserId);
        this.securityDescriptor.setGridMap(gridMap);
    }

    protected void initializeTopics() {
        super.initializeTopics();
        SimpleTopic stateChangeTopic = new SimpleTopic(ManagedJobConstants.RP_STATE);
        this.getTopicList().addTopic((Topic)stateChangeTopic);
    }

    public void remove() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering remove()");
        }
        if (this.getResourceData() != null && this.getResourceData().isStarted()) {
            this.destroySubJobs();
        }
        logger.debug((Object)("deleting cache directory for job resource " + this.getID()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving remove()");
        }
    }

    public synchronized void start() {
        boolean started = (Boolean)this.getResourceDatum("started");
        if (!started) {
            StateEnumeration state;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Entering start()");
            }
            if ((state = (StateEnumeration)this.getResourcePropertySet().get(ManagedJobConstants.RP_STATE).get(0)).equals((Object)StateEnumeration.Failed)) {
                return;
            }
            new Thread(this).start();
        }
    }

    public void run() {
        String errorMessage;
        FaultType fault = null;
        DelegatedCredential jobCredential = null;
        try {
            jobCredential = this.getJobCredential(null);
        }
        catch (Exception e) {
            errorMessage = i18n.getMessage("CredentialAcquisitionError");
            fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = ManagedMultiJobResource.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)this.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)this.getState(), null, (int)0);
        }
        if (jobCredential == null && fault == null) {
            String faultMessage = i18n.getMessage("MissingJobCredential");
            fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = ManagedMultiJobResource.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)this.getID()), (String)faultMessage, null, (StateEnumeration)((StateEnumeration)this.getResourceProperty(ManagedJobConstants.RP_STATE)), null, (int)0);
        }
        if (fault == null) {
            try {
                this.createSubJobs();
            }
            catch (Exception e) {
                String faultMessage = i18n.getMessage("subJobsCreationFailed");
                fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = ManagedMultiJobResource.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)this.getID()), (String)faultMessage, (Exception)e, (StateEnumeration)((StateEnumeration)this.getResourceProperty(ManagedJobConstants.RP_STATE)), null, (int)0);
            }
        }
        if (fault != null) {
            this.setFault(fault);
            try {
                this.setState(StateEnumeration.Failed);
            }
            catch (Exception e) {
                errorMessage = i18n.getMessage("MultiResourceSetStateToFailedAndNotifyError");
                throw new RuntimeException(errorMessage, e);
            }
        } else {
            this.getResourceData().setStarted(true);
        }
    }

    private void createSubJobs() throws RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering createSubJobs()");
        }
        JobDescriptionType jobDescription = this.getJobDescription();
        ResourceProperty subJobEndpointsRP = this.getResourcePropertySet().get(ManagedMultiJobConstants.RP_SUB_JOB_ENDPOINTS);
        MultiJobDescriptionType multiJobDescription = (MultiJobDescriptionType)jobDescription;
        JobDescriptionType[] subJobDescriptions = ManagedMultiJobResource.breakUpMultiJobDescription(multiJobDescription, this.getResourceData().getHandle());
        for (int index = 0; index < subJobDescriptions.length; ++index) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sub-Job RSL:\n" + RSLHelper.convertToString((JobDescriptionType)subJobDescriptions[index])));
            }
            EndpointReferenceType subJobEndpoint = this.createSubJob(subJobDescriptions[index], index);
            subJobEndpointsRP.set(index, (Object)subJobEndpoint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving createSubJobs()");
        }
    }

    private static JobDescriptionType[] breakUpMultiJobDescription(MultiJobDescriptionType multiJobDescription, String multiJobHandle) throws ResourceException {
        int i;
        JobDescriptionType[] subJobDescriptions = multiJobDescription.getJob();
        NameValuePairType[] multiEnvVars = multiJobDescription.getEnvironment();
        if (multiEnvVars != null) {
            for (i = 0; i < multiEnvVars.length; ++i) {
                for (int j = 0; j < subJobDescriptions.length; ++j) {
                    RSLHelper.addEnvironmentVariable((JobDescriptionType)subJobDescriptions[j], (String)multiEnvVars[i].getName(), (String)multiEnvVars[i].getValue());
                }
            }
        }
        for (i = 0; i < subJobDescriptions.length; ++i) {
            RSLHelper.addEnvironmentVariable((JobDescriptionType)subJobDescriptions[i], (String)"GLOBUS_GRAM_SUBJOB_RANK", (String)Integer.toString(i));
        }
        JobDescriptionMap multiJobAttributes = null;
        try {
            multiJobAttributes = new JobDescriptionMap((JobDescriptionType)multiJobDescription);
        }
        catch (Exception e) {
            throw new ResourceException(i18n.getMessage("objectCreationFailed", new Object[]{(class$org$globus$exec$utils$JobDescriptionMap == null ? (class$org$globus$exec$utils$JobDescriptionMap = ManagedMultiJobResource.class$("org.globus.exec.utils.JobDescriptionMap")) : class$org$globus$exec$utils$JobDescriptionMap).getName()}), (Throwable)e);
        }
        String[] attributeSkipList = new String[]{"job", "jobCredentialEndpoint", "stagingCredentialEndpoint", "factoryEndpoint"};
        Iterator attributeNames = multiJobAttributes.keySet().iterator();
        while (attributeNames.hasNext()) {
            String attributeName = (String)attributeNames.next();
            boolean skip = false;
            for (int index = 0; index < attributeSkipList.length; ++index) {
                if (!attributeName.equals(attributeSkipList[index])) continue;
                skip = true;
            }
            if (skip) continue;
            PropertyDescriptor propertyDescriptor = null;
            try {
                propertyDescriptor = new PropertyDescriptor(attributeName, class$org$globus$exec$generated$JobDescriptionType == null ? ManagedMultiJobResource.class$("org.globus.exec.generated.JobDescriptionType") : class$org$globus$exec$generated$JobDescriptionType);
            }
            catch (Exception e) {
                throw new ResourceException(i18n.getMessage("objectCreationFailed", new Object[]{(class$java$beans$PropertyDescriptor == null ? (class$java$beans$PropertyDescriptor = ManagedMultiJobResource.class$("java.beans.PropertyDescriptor")) : class$java$beans$PropertyDescriptor).getName()}), (Throwable)e);
            }
            Method readMethod = propertyDescriptor.getReadMethod();
            Method writeMethod = propertyDescriptor.getWriteMethod();
            boolean allMustHold = false;
            StateEnumeration holdState = null;
            if (attributeName.equals("holdState")) {
                allMustHold = true;
                holdState = (StateEnumeration)multiJobAttributes.get((Object)attributeName);
            }
            for (int index = 0; index < subJobDescriptions.length; ++index) {
                Object oldValue = null;
                try {
                    oldValue = readMethod.invoke((Object)subJobDescriptions[index], null);
                }
                catch (Exception e) {
                    throw new ResourceException(i18n.getMessage("beanMethodInvocationFailed", new Object[]{subJobDescriptions[index].getClass().getName(), readMethod.getName()}), (Throwable)e);
                }
                if (oldValue == null) {
                    try {
                        writeMethod.invoke((Object)subJobDescriptions[index], multiJobAttributes.get((Object)attributeName));
                        continue;
                    }
                    catch (Exception e) {
                        throw new ResourceException(i18n.getMessage("beanMethodInvocationFailed", new Object[]{subJobDescriptions[index].getClass().getName(), writeMethod.getName()}), (Throwable)e);
                    }
                }
                if (!attributeName.equals("holdState")) continue;
                if (allMustHold && !holdState.equals(oldValue)) {
                    throw new ResourceException(i18n.getMessage("unexpectedHoldState", new Object[]{holdState, oldValue}));
                }
                if (!allMustHold && index > 0) {
                    throw new ResourceException(i18n.getMessage("unexpectedHoldState", new Object[]{"null", oldValue}));
                }
                allMustHold = true;
                holdState = (StateEnumeration)oldValue;
            }
        }
        return subJobDescriptions;
    }

    private EndpointReferenceType createSubJob(JobDescriptionType subJobDescription, int subJobIndex) throws RemoteException {
        EndpointReferenceType factoryEndpoint;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering createSubJob()");
        }
        if ((factoryEndpoint = subJobDescription.getFactoryEndpoint()) == null) {
            throw new ResourceException(i18n.getMessage("jobDescriptionMissingEndpoint"));
        }
        ManagedJobFactoryPortType factoryPort = null;
        try {
            factoryPort = ManagedJobFactoryClientHelper.getPort((EndpointReferenceType)factoryEndpoint);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        this.setStubSecurity((Stub)factoryPort);
        EndpointReferenceType notificationConsumerEndpoint = null;
        try {
            NotificationConsumerManager notificationConsumerManager = ManagedMultiJobHome.getNotificationConsumerManager();
            LinkedList<QName> topicPath = new LinkedList<QName>();
            topicPath.add(ManagedJobConstants.RP_STATE);
            ResourceSecurityDescriptor securityDescriptor = new ResourceSecurityDescriptor();
            securityDescriptor.setAuthz("none");
            Vector<Object> authMethod = new Vector<Object>();
            FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
            String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
            if (wsTransportProtocol == null) {
                wsTransportProtocol = ServiceHost.getDefaultProtocol();
            }
            if (wsTransportProtocol.equals("http")) {
                authMethod.add(GSISecureMsgAuthMethod.BOTH);
            } else {
                authMethod.add(GSITransportAuthMethod.BOTH);
            }
            securityDescriptor.setAuthMethods(authMethod);
            notificationConsumerManager.startListening();
            notificationConsumerEndpoint = notificationConsumerManager.createNotificationConsumer(topicPath, (NotifyCallback)this, securityDescriptor);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notification consumer endpoint: " + notificationConsumerEndpoint));
            }
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("NotificationConsumerCreationError");
            throw new RuntimeException(errorMessage, e);
        }
        this.setResourceDatum("notificationConsumerEndpoint", notificationConsumerEndpoint);
        Subscribe subscribeRequest = new Subscribe();
        subscribeRequest.setConsumerReference(notificationConsumerEndpoint);
        TopicExpressionType topicExpression = null;
        try {
            topicExpression = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)ManagedJobConstants.RP_STATE);
        }
        catch (Exception e) {
            throw new RuntimeException(i18n.getMessage("objectCreationFailed", new Object[]{(class$org$oasis$wsn$TopicExpressionType == null ? (class$org$oasis$wsn$TopicExpressionType = ManagedMultiJobResource.class$("org.oasis.wsn.TopicExpressionType")) : class$org$oasis$wsn$TopicExpressionType).getName()}), e);
        }
        subscribeRequest.setTopicExpression(topicExpression);
        CreateManagedJobInputType jobCreationInput = new CreateManagedJobInputType();
        jobCreationInput.setJob(subJobDescription);
        jobCreationInput.setSubscribe(subscribeRequest);
        CreateManagedJobOutputType response = factoryPort.createManagedJob(jobCreationInput);
        ManagedMultiJobResourceDataType resourceData = (ManagedMultiJobResourceDataType)this.getResourceData();
        EndpointReferenceType subscriptionEndpoint = response.getSubscriptionEndpoint();
        resourceData.getSubscriptionEndpoint()[subJobIndex] = response.getSubscriptionEndpoint();
        EndpointReferenceType jobEndpoint = response.getManagedJobEndpoint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving createSubJob()");
        }
        return jobEndpoint;
    }

    private static String getResourceIdFromEndpoint(EndpointReferenceType endpoint) {
        if (endpoint == null) {
            return "null";
        }
        ReferencePropertiesType subJobEprReferenceProperties = endpoint.getProperties();
        MessageElement[] any = subJobEprReferenceProperties.get_any();
        Element element = null;
        try {
            element = AnyHelper.toElement((MessageElement)any[0]);
        }
        catch (Exception ee) {
            String errorMessage = i18n.getMessage("AnyToElementError");
            logger.error((Object)errorMessage, (Throwable)ee);
        }
        logger.debug((Object)("Reference Properties: " + XmlUtils.toString((Element)element)));
        String resourceId = null;
        if (element.hasChildNodes()) {
            resourceId = element.getFirstChild().getNodeValue();
        }
        logger.debug((Object)("Resource ID: " + resourceId));
        return resourceId;
    }

    void releaseSubJobs() throws RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering releaseSubJobs()");
        }
        JobDescriptionType jobDescription = this.getJobDescription();
        ResourceProperty subJobEndpointsRP = this.getResourcePropertySet().get(ManagedMultiJobConstants.RP_SUB_JOB_ENDPOINTS);
        MultiJobDescriptionType multiJobDescription = (MultiJobDescriptionType)jobDescription;
        JobDescriptionType[] subJobDescriptions = ManagedMultiJobResource.breakUpMultiJobDescription(multiJobDescription, this.getResourceData().getHandle());
        int subJobCount = (Integer)this.getResourceDatum("subJobCount");
        for (int index = 0; index < subJobCount; ++index) {
            EndpointReferenceType subJobEndpoint = (EndpointReferenceType)subJobEndpointsRP.get(index);
            this.releaseSubJob(subJobEndpoint, subJobDescriptions[index]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving releaseSubJobs()");
        }
    }

    private void releaseSubJob(EndpointReferenceType subJobEndpoint, JobDescriptionType subJobDescription) throws RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering releaseSubJob()");
        }
        ManagedJobPortType subJobPort = null;
        try {
            subJobPort = ManagedJobClientHelper.getPort((EndpointReferenceType)subJobEndpoint);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        this.setStubSecurity((Stub)subJobPort);
        subJobPort.release(new ReleaseInputType());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving releaseSubJob()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySubJobs() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering destroySubJobs()");
        }
        ManagedMultiJobResourceDataType resourceData = (ManagedMultiJobResourceDataType)this.getResourceData();
        logger.trace((Object)"Obtaining lock on resourceData");
        ManagedMultiJobResourceDataType managedMultiJobResourceDataType = resourceData;
        synchronized (managedMultiJobResourceDataType) {
            logger.trace((Object)"Obtained lock on resourceData");
            int subJobCount = (Integer)this.getResourceDatum("subJobCount");
            String errorMessage = null;
            Exception exception = null;
            if (!resourceData.isDestroyCalled()) {
                try {
                    this.unsubscribeToNotificationsForSubJobs();
                }
                catch (Exception e) {
                    errorMessage = i18n.getMessage("SubjobUnsubscribeError");
                    exception = e;
                    logger.debug((Object)errorMessage, (Throwable)exception);
                }
                JobDescriptionType jobDescription = this.getJobDescription();
                MultiJobDescriptionType multiJobDescription = (MultiJobDescriptionType)jobDescription;
                JobDescriptionType[] subJobDescriptions = ManagedMultiJobResource.breakUpMultiJobDescription(multiJobDescription, this.getResourceData().getHandle());
                ResourceProperty subJobEndpointsRP = this.getResourcePropertySet().get(ManagedMultiJobConstants.RP_SUB_JOB_ENDPOINTS);
                for (int index = 0; index < subJobCount; ++index) {
                    EndpointReferenceType subJobEndpoint = (EndpointReferenceType)subJobEndpointsRP.get(index);
                    try {
                        this.destroySubJob(subJobEndpoint, subJobDescriptions[index]);
                        continue;
                    }
                    catch (Exception e) {
                        errorMessage = i18n.getMessage("subJobDestroyFailed", new Object[]{ManagedMultiJobResource.getResourceIdFromEndpoint(subJobEndpoint)});
                        exception = e;
                        logger.debug((Object)errorMessage, (Throwable)exception);
                    }
                }
            } else {
                logger.debug((Object)"Ignoring second call to destroySubJobs()");
            }
            ((ManagedMultiJobResourceDataType)this.getResourceData()).setDestroyCalled(true);
            if (exception != null) {
                throw new ResourceException(errorMessage, (Throwable)exception);
            }
            logger.trace((Object)"Releasing lock on resourceData");
        }
        logger.trace((Object)"Released lock on resourceData");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving destroySubJobs()");
        }
    }

    private void unsubscribeToNotificationsForSubJobs() throws RemoteException {
        EndpointReferenceType notificationConsumerEndpoint;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering unsubscribeToNotificationsForSubJobs()");
        }
        if ((notificationConsumerEndpoint = this.getResourceData().getNotificationConsumerEndpoint()) != null) {
            try {
                NotificationConsumerManager notificationConsumerManager = null;
                FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
                String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
                if (wsTransportProtocol == null) {
                    wsTransportProtocol = ServiceHost.getDefaultProtocol();
                }
                if (wsTransportProtocol.equals("http")) {
                    notificationConsumerManager = NotificationConsumerManager.getInstance();
                } else {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
                    notificationConsumerManager = NotificationConsumerManager.getInstance(properties);
                }
                notificationConsumerManager.startListening();
                notificationConsumerManager.removeNotificationConsumer(notificationConsumerEndpoint);
            }
            catch (Exception e) {
                if (!this.getState().equals((Object)StateEnumeration.Failed)) {
                    String errorMessage = i18n.getMessage("NotificationConsumerRemovalError");
                    logger.debug((Object)errorMessage, (Throwable)e);
                    throw new RemoteException(errorMessage, e);
                }
                return;
            }
        }
        JobDescriptionType jobDescription = this.getJobDescription();
        MultiJobDescriptionType multiJobDescription = (MultiJobDescriptionType)jobDescription;
        JobDescriptionType[] subJobDescriptions = ManagedMultiJobResource.breakUpMultiJobDescription(multiJobDescription, this.getResourceData().getHandle());
        int subJobCount = (Integer)this.getResourceDatum("subJobCount");
        for (int index = 0; index < subJobCount; ++index) {
            EndpointReferenceType subscriptionEndpoint = null;
            try {
                subscriptionEndpoint = ((ManagedMultiJobResourceDataType)this.getResourceData()).getSubscriptionEndpoint(index);
                if (subscriptionEndpoint == null) continue;
                SubscriptionManager subscriptionPort = new WSBaseNotificationServiceAddressingLocator().getSubscriptionManagerPort(subscriptionEndpoint);
                try {
                    this.setStubSecurity((Stub)subscriptionPort);
                }
                catch (Exception e) {
                    if (!this.getState().equals((Object)StateEnumeration.Failed)) {
                        String errorMessage = i18n.getMessage("SubjobStubSecurityError");
                        logger.debug((Object)errorMessage, (Throwable)e);
                        throw new RemoteException(errorMessage, e);
                    }
                    return;
                }
                subscriptionPort.destroy(new Destroy());
                continue;
            }
            catch (Exception e) {
                EndpointReferenceType subJobEndpoint = null;
                ResourceProperty subJobEndpointsRP = this.getResourcePropertySet().get(ManagedMultiJobConstants.RP_SUB_JOB_ENDPOINTS);
                subJobEndpoint = (EndpointReferenceType)subJobEndpointsRP.get(index);
                throw new RemoteException(i18n.getMessage("subJobUnsubscribeFailed", new Object[]{ManagedMultiJobResource.getResourceIdFromEndpoint(subJobEndpoint)}), e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving unsubscribeToNotificationsForSubJobs()");
        }
    }

    private void destroySubJob(EndpointReferenceType subJobEndpoint, JobDescriptionType subJobDescription) throws RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering destroySubJob()");
        }
        if (subJobEndpoint == null) {
            logger.debug((Object)"Leaving destroySubJob() since subJobEndpoint is null");
            return;
        }
        ManagedJobPortType subJobPort = null;
        try {
            subJobPort = ManagedJobClientHelper.getPort((EndpointReferenceType)subJobEndpoint);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        try {
            this.setStubSecurity((Stub)subJobPort);
        }
        catch (RemoteException re) {
            if (this.getState().equals((Object)StateEnumeration.Failed)) {
                String faultDescription = this.getFault().getDescription().toString();
                logger.debug((Object)("Fault Description: " + faultDescription));
                if (faultDescription.equals(i18n.getMessage("subJobsCreationFailed"))) {
                    return;
                }
                throw re;
            }
            throw re;
        }
        subJobPort.destroy(new Destroy());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving destroySubJob()");
        }
    }

    private void setStubSecurity(Stub stub) throws RemoteException {
        FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
        String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
        String securityType = "org.globus.security.transport.type";
        if (wsTransportProtocol == null) {
            wsTransportProtocol = ServiceHost.getDefaultProtocol();
        }
        if (wsTransportProtocol.equals("http")) {
            securityType = "org.globus.security.secMsg.msg.type";
        }
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        if (securityType.equals("org.globus.security.secMsg.msg.type")) {
            secDesc.setGSISecureMsg(GSIConstants.SIGNATURE);
        } else {
            secDesc.setGSITransport(GSIConstants.SIGNATURE);
        }
        try {
            secDesc.setGSSCredential((GSSCredential)new GlobusGSSCredentialImpl(this.getJobCredential(null).getCredential(), 0));
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("GlobusCredentialToGSSError");
            throw new RemoteException(errorMessage, e);
        }
        ContainerSecurityConfig containerSecurityConfig = null;
        ContainerSecurityDescriptor containerSecurityDescriptor = null;
        Subject containerSubject = null;
        Set<Principal> principals = null;
        try {
            containerSecurityConfig = ContainerSecurityConfig.getConfig();
            containerSecurityDescriptor = containerSecurityConfig.getSecurityDescriptor();
            containerSubject = containerSecurityDescriptor.getSubject();
            if (containerSubject != null) {
                principals = containerSubject.getPrincipals();
            }
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("CredentialConfigurationError");
            throw new RuntimeException(errorMessage);
        }
        if (containerSubject != null) {
            if (containerSecurityConfig.getSecurityDescriptorFile() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Using default creds. Assume identity authz");
                }
                secDesc.setAuthz((Authorization)new IdentityAuthorization(((Object)principals.iterator().next()).toString()));
            } else if (containerSecurityDescriptor.getProxyFilename() != null) {
                logger.debug((Object)"Found proxy file configuration");
                secDesc.setAuthz((Authorization)new IdentityAuthorization(((Object)principals.iterator().next()).toString()));
            } else if (containerSecurityDescriptor.getCertFilename() != null && containerSecurityDescriptor.getKeyFilename() != null) {
                logger.debug((Object)"Found host and cert configuration.");
                secDesc.setAuthz((Authorization)HostAuthorization.getInstance());
            } else {
                logger.debug((Object)"No credentials specified, assuming user creds");
                secDesc.setAuthz((Authorization)new IdentityAuthorization(((Object)principals.iterator().next()).toString()));
            }
        } else {
            String errorMessage = i18n.getMessage("CredentialConfigurationError");
            throw new RuntimeException(errorMessage);
        }
        stub._setProperty("clientDescriptor", (Object)secDesc);
    }

    public void setState(StateEnumeration state) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("receiving request for state change to " + state.getValue()));
        }
        super.setState(state);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("State of job " + this.getID() + " changed to: " + this.getState().toString()));
        }
        Boolean holding = (Boolean)this.getResourcePropertySet().get(ManagedJobConstants.RP_HOLDING).get(0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Holding: " + holding));
        }
        ResourceProperty faultRP = this.getResourcePropertySet().get(ManagedJobConstants.RP_FAULT);
        FaultResourcePropertyType fault = null;
        if (state.equals((Object)StateEnumeration.Failed)) {
            fault = (FaultResourcePropertyType)faultRP.get(0);
        }
        StateChangeNotificationMessageType message = new StateChangeNotificationMessageType();
        message.setState(state);
        message.setHolding(holding.booleanValue());
        message.setFault(fault);
        StateChangeNotificationMessageWrapperType messageWrapper = new StateChangeNotificationMessageWrapperType();
        messageWrapper.setStateChangeNotificationMessage(message);
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(ManagedJobConstants.RP_STATE);
        Topic stateChangeTopic = this.getTopicList().getTopic(topicPath);
        logger.debug((Object)"Notifying of job state change to topic listeners");
        stateChangeTopic.notify((Object)messageWrapper);
    }

    public void registerCallback(List topicPath, NotifyCallback callback) {
    }

    public NotifyCallback getCallback(List topicPath) {
        return this;
    }

    public void deliver(List topicPath, EndpointReferenceType producerEndpoint, Object messageWrapper) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering deliver()");
            logger.debug((Object)("Notification Message Type: " + messageWrapper.getClass().getName()));
        }
        try {
            StateChangeNotificationMessageType message = ((StateChangeNotificationMessageWrapperType)messageWrapper).getStateChangeNotificationMessage();
            StateEnumeration state = message.getState();
            boolean holding = message.isHolding();
            FaultResourcePropertyType fault = message.getFault();
            this.processStateNotification(state, holding, fault);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("StateNotifProcessError");
            logger.error((Object)errorMessage, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving deliver()");
        }
    }

    public void processStateNotification(StateEnumeration state, boolean holding, FaultResourcePropertyType faultWrapper) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering processStateNotification()");
            logger.debug((Object)("Processing State " + state.toString()));
        }
        ManagedMultiJobResourceDataType resourceData = (ManagedMultiJobResourceDataType)this.getResourceData();
        int subJobCount = (Integer)this.getResourceDatum("subJobCount");
        StateEnumeration currentState = (StateEnumeration)this.getResourceProperty(ManagedJobConstants.RP_STATE);
        int holdingCount = (Integer)this.getResourceDatum("holdingCount");
        boolean allHolding = (Boolean)this.getResourceProperty(ManagedJobConstants.RP_HOLDING);
        if (holding) {
            resourceData.setHoldingCount(++holdingCount);
            if (holdingCount == subJobCount) {
                this.setResourceProperty(ManagedJobConstants.RP_HOLDING, Boolean.TRUE);
                this.setState(state);
            }
        } else {
            if (holdingCount > 0 && allHolding) {
                this.setResourceProperty(ManagedJobConstants.RP_HOLDING, Boolean.FALSE);
                resourceData.setHoldingCount(0);
            }
            if (!(!state.equals((Object)StateEnumeration.StageIn) || currentState.equals((Object)StateEnumeration.Pending) || currentState.equals((Object)StateEnumeration.Active) || currentState.equals((Object)StateEnumeration.StageOut) || currentState.equals((Object)StateEnumeration.CleanUp) || currentState.equals((Object)StateEnumeration.Done) || currentState.equals((Object)StateEnumeration.Failed))) {
                int stageInCount = resourceData.getStageInCount();
                resourceData.setStageInCount(++stageInCount);
                if (stageInCount == subJobCount) {
                    this.setState(state);
                }
            } else if (!(!state.equals((Object)StateEnumeration.Pending) || currentState.equals((Object)StateEnumeration.Active) || currentState.equals((Object)StateEnumeration.StageOut) || currentState.equals((Object)StateEnumeration.CleanUp) || currentState.equals((Object)StateEnumeration.Done) || currentState.equals((Object)StateEnumeration.Failed))) {
                int pendingCount = resourceData.getPendingCount();
                resourceData.setPendingCount(++pendingCount);
                if (pendingCount == subJobCount) {
                    this.setState(state);
                }
            } else if (!(!state.equals((Object)StateEnumeration.Active) || currentState.equals((Object)StateEnumeration.StageOut) || currentState.equals((Object)StateEnumeration.CleanUp) || currentState.equals((Object)StateEnumeration.Done) || currentState.equals((Object)StateEnumeration.Failed))) {
                int activeCount = resourceData.getActiveCount();
                resourceData.setActiveCount(++activeCount);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting activeCount to " + activeCount));
                }
                if (activeCount == subJobCount) {
                    this.setState(state);
                }
            } else if (state.equals((Object)StateEnumeration.StageOut) && !currentState.equals((Object)StateEnumeration.CleanUp) && !currentState.equals((Object)StateEnumeration.Done) && !currentState.equals((Object)StateEnumeration.Failed)) {
                int stageOutCount = resourceData.getStageOutCount() + 1;
                resourceData.setStageOutCount(stageOutCount);
                if (stageOutCount == subJobCount) {
                    this.setState(state);
                }
            } else if (state.equals((Object)StateEnumeration.CleanUp) && !currentState.equals((Object)StateEnumeration.Done) && !currentState.equals((Object)StateEnumeration.Failed)) {
                int cleanUpCount = resourceData.getCleanUpCount() + 1;
                resourceData.setCleanUpCount(cleanUpCount);
                if (cleanUpCount == subJobCount) {
                    this.setState(state);
                }
            } else if (state.equals((Object)StateEnumeration.Suspended)) {
                int suspendedCount = resourceData.getSuspendedCount();
                resourceData.setSuspendedCount(suspendedCount);
                if (suspendedCount == subJobCount) {
                    this.setState(state);
                }
            } else if (state.equals((Object)StateEnumeration.Done)) {
                int doneCount = resourceData.getDoneCount() + 1;
                resourceData.setDoneCount(doneCount);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting doneCount to " + doneCount));
                }
                if (doneCount == subJobCount) {
                    this.setState(state);
                }
            } else if (state.equals((Object)StateEnumeration.Failed)) {
                logger.trace((Object)"setting fault");
                this.setResourceProperty(ManagedJobConstants.RP_FAULT, faultWrapper);
                logger.trace((Object)"setting Failed state");
                try {
                    this.setState(StateEnumeration.Failed);
                }
                catch (Exception e) {
                    throw new ResourceException(" ", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving processStateNotification()");
        }
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        if (this.securityDescriptor != null) {
            logger.debug((Object)("MJR security descriptor authz: " + this.securityDescriptor.getAuthz()));
        } else {
            logger.debug((Object)"MRJR security descriptor is null");
        }
        return this.securityDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Util.registerTransport();
        logger = LogFactory.getLog((String)(class$org$globus$exec$service$multi$ManagedMultiJobResource == null ? (class$org$globus$exec$service$multi$ManagedMultiJobResource = ManagedMultiJobResource.class$("org.globus.exec.service.multi.ManagedMultiJobResource")) : class$org$globus$exec$service$multi$ManagedMultiJobResource).getName());
        i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedMultiJobResource.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
        coreI18n = I18n.getI18n((String)(class$org$globus$wsrf$utils$Resources == null ? (class$org$globus$wsrf$utils$Resources = ManagedMultiJobResource.class$("org.globus.wsrf.utils.Resources")) : class$org$globus$wsrf$utils$Resources).getName());
    }
}

