/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.multi;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.ManagedMultiJobResourceDataType;
import org.globus.exec.generated.ManagedMultiJobResourcePropertiesType;
import org.globus.exec.generated.ManagedMultiJobResourceStateType;
import org.globus.exec.generated.MultiJobDescriptionType;
import org.globus.exec.generated.ServiceLevelAgreementType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.FactoryServiceConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.job.ManagedJobHome;
import org.globus.exec.service.multi.ManagedMultiJobResource;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.ManagedMultiJobConstants;
import org.globus.exec.utils.rsl.RSLHelper;
import org.globus.exec.utils.service.ManagedJobHelper;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.PersistentResource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.PerformanceLog;
import org.globus.wsrf.utils.XmlPersistenceHelper;

public class ManagedMultiJobHome
extends ResourceHomeImpl
implements ManagedJobHome {
    private boolean recovered = false;
    private static UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private static NotificationConsumerManager NOTIFICATION_CONSUMER_MANAGER = null;
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$multi$ManagedMultiJobHome == null ? (class$org$globus$exec$service$multi$ManagedMultiJobHome = ManagedMultiJobHome.class$("org.globus.exec.service.multi.ManagedMultiJobHome")) : class$org$globus$exec$service$multi$ManagedMultiJobHome).getName());
    static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedMultiJobHome.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$multi$ManagedMultiJobHome == null ? (class$org$globus$exec$service$multi$ManagedMultiJobHome = ManagedMultiJobHome.class$("org.globus.exec.service.multi.ManagedMultiJobHome")) : class$org$globus$exec$service$multi$ManagedMultiJobHome).getName() + ".performance");
    static /* synthetic */ Class class$org$globus$exec$generated$ManagedMultiJobResourceStateType;
    static /* synthetic */ Class class$org$globus$wsrf$PersistentResource;
    static /* synthetic */ Class class$org$globus$exec$service$multi$ManagedMultiJobHome;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public synchronized void initialize() throws Exception {
        this.keyTypeName = ManagedJobConstants.RESOURCE_KEY_QNAME;
        super.initialize();
    }

    public synchronized void recover() throws ResourceException {
        if (!this.isResourcePersistent()) {
            String errorMessage = i18n.getMessage("PreconditionViolation", (Object)"!this.isResourcePersistent()");
            throw new RuntimeException(errorMessage);
        }
        logger.debug((Object)"Loading the home's list of resource keys");
        List resourceKeyValueList = null;
        try {
            XmlPersistenceHelper persistenceHelper = new XmlPersistenceHelper(class$org$globus$exec$generated$ManagedMultiJobResourceStateType == null ? (class$org$globus$exec$generated$ManagedMultiJobResourceStateType = ManagedMultiJobHome.class$("org.globus.exec.generated.ManagedMultiJobResourceStateType")) : class$org$globus$exec$generated$ManagedMultiJobResourceStateType);
            resourceKeyValueList = persistenceHelper.list();
        }
        catch (Exception e) {
            throw new ResourceException(i18n.getMessage("persistedResourcePropertiesDirectoryMissing"), (Throwable)e);
        }
        Iterator it = resourceKeyValueList.iterator();
        while (it.hasNext()) {
            String keyValue = (String)it.next();
            SimpleResourceKey key = ManagedJobHelper.getResourceKey((String)keyValue);
            ManagedMultiJobResource resource = (ManagedMultiJobResource)this.find((ResourceKey)key);
            logger.info((Object)("Added resource key " + keyValue + " to recovered home"));
        }
        this.recovered = true;
    }

    public ResourceKey create(Calendar initialTerminationTime, Calendar currentTime, String localResourceManager, JobDescriptionType jobDescription, String userSubject, String localUserId, String jobID, String serviceURL) throws Exception {
        if (!(jobDescription instanceof MultiJobDescriptionType) || ((MultiJobDescriptionType)jobDescription).getJob() == null) {
            throw new RemoteException(i18n.getMessage("singleJobNotSupported", new Object[]{localResourceManager}));
        }
        ManagedMultiJobHome.getNotificationConsumerManager();
        SimpleResourceKey key = jobID != null ? ManagedJobHelper.getResourceKey((String)jobID) : ManagedJobHelper.getResourceKey((String)uuidGen.nextUUID());
        EndpointReferenceType epr = AddressingUtils.createEndpointReference((String)serviceURL, (ResourceKey)key);
        String handle = ManagedJobHelper.getHandle((EndpointReferenceType)epr);
        RSLHelper.addEnvironmentVariable((JobDescriptionType)jobDescription, (String)"GLOBUS_GRAM_MULTIJOB_HANDLE", (String)ManagedJobHelper.getHandle((EndpointReferenceType)epr));
        ManagedMultiJobResource resource = null;
        try {
            resource = (ManagedMultiJobResource)this.find((ResourceKey)key);
            resource.getResourceData().setHandle(handle);
        }
        catch (NoSuchResourceException nsre) {
            logger.debug((Object)"new resource being created");
        }
        if (resource == null) {
            resource = (ManagedMultiJobResource)this.createNewInstance();
            resource.initializeWholeState(ManagedMultiJobHome.createResourceState(initialTerminationTime, currentTime, (MultiJobDescriptionType)jobDescription, userSubject, localUserId, handle), ManagedMultiJobConstants.RESOURCE_PROPERTY_SET, key);
            logger.debug((Object)("Created ManagedMultiJobResource with key value " + key.getValue()));
        }
        if (this.isResourcePersistent()) {
            ((PersistentResource)resource).store();
        }
        this.add((ResourceKey)key, resource);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ResourceKey key) throws ResourceException {
        ManagedMultiJobResource resource = (ManagedMultiJobResource)this.find(key);
        logger.debug((Object)"acquiring lock on resource");
        ManagedMultiJobResource managedMultiJobResource = resource;
        synchronized (managedMultiJobResource) {
            logger.debug((Object)"acquired lock on resource");
            if (logger.isDebugEnabled()) {
                ResourcePropertySet resourceProperties = resource.getResourcePropertySet();
                StateEnumeration state = (StateEnumeration)resourceProperties.get(ManagedJobConstants.RP_STATE).get(0);
                logger.debug((Object)("remove() called\nstate: " + state.toString()));
            }
            logger.debug((Object)"releasing lock on resource");
        }
        super.remove(key);
    }

    private static ManagedMultiJobResourceStateType createResourceState(Calendar initialTerminationTime, Calendar currentTime, MultiJobDescriptionType jobDescription, String userSubject, String localUserId, String handle) {
        ManagedMultiJobResourceStateType resourceState = new ManagedMultiJobResourceStateType();
        ManagedMultiJobResourcePropertiesType resourceBean = ManagedMultiJobHome.createResourcePropertiesBean(initialTerminationTime, currentTime, jobDescription, userSubject, localUserId);
        resourceState.setResourceProperties(resourceBean);
        ManagedMultiJobResourceDataType resourceData = new ManagedMultiJobResourceDataType();
        resourceData.setStarted(false);
        int subJobCount = jobDescription.getJob().length;
        resourceData.setSubJobCount(subJobCount);
        resourceData.setSubscriptionEndpoint(new EndpointReferenceType[subJobCount]);
        resourceData.setStageInCount(0);
        resourceData.setPendingCount(0);
        resourceData.setActiveCount(0);
        resourceData.setStageOutCount(0);
        resourceData.setSuspendedCount(0);
        resourceData.setDoneCount(0);
        resourceData.setFailedCount(0);
        resourceData.setHoldingCount(0);
        resourceData.setHandle(handle);
        resourceState.setResourceData(resourceData);
        return resourceState;
    }

    private static ManagedMultiJobResourcePropertiesType createResourcePropertiesBean(Calendar initialTerminationTime, Calendar currentTime, MultiJobDescriptionType jobDescription, String userSubject, String localUserId) {
        ManagedMultiJobResourcePropertiesType jobResourceProperties = new ManagedMultiJobResourcePropertiesType();
        jobResourceProperties.setTerminationTime(initialTerminationTime);
        jobResourceProperties.setCurrentTime(currentTime);
        jobResourceProperties.setState(StateEnumeration.Unsubmitted);
        jobResourceProperties.setServiceLevelAgreement(new ServiceLevelAgreementType(null, jobDescription));
        jobResourceProperties.setUserSubject(userSubject);
        jobResourceProperties.setLocalUserId(localUserId);
        int subJobCount = jobDescription.getJob().length;
        jobResourceProperties.setSubJobEndpoint(new EndpointReferenceType[subJobCount]);
        jobResourceProperties.setCapacity(subJobCount);
        jobResourceProperties.setRegistrantData(null);
        jobResourceProperties.setRendezvousCompleted(false);
        return jobResourceProperties;
    }

    public static ManagedMultiJobHome getHome() throws ResourceException {
        try {
            InitialContext initialContext = new InitialContext();
            ResourceContext ctx = ResourceContext.getResourceContext();
            String factoryConfigurationLookupString = "java:comp/env//services/" + ctx.getService() + "/configuration";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JNDI lookup string for service config:" + factoryConfigurationLookupString));
            }
            FactoryServiceConfiguration factoryConfiguration = (FactoryServiceConfiguration)initialContext.lookup(factoryConfigurationLookupString);
            String jobHomeLookupString = "java:comp/env//services/" + factoryConfiguration.getManagedMultiJobServicePath() + "/home";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JNDI lookup string for ManagedMultiJobHome: " + jobHomeLookupString));
            }
            return (ManagedMultiJobHome)initialContext.lookup(jobHomeLookupString);
        }
        catch (NamingException ne) {
            throw new ResourceException((Throwable)ne);
        }
        catch (ResourceContextException rce) {
            throw new ResourceException((Throwable)rce);
        }
    }

    public static NotificationConsumerManager getNotificationConsumerManager() {
        if (NOTIFICATION_CONSUMER_MANAGER == null) {
            FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
            String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
            if (wsTransportProtocol == null) {
                wsTransportProtocol = ServiceHost.getDefaultProtocol();
            }
            if (wsTransportProtocol.equals("http")) {
                NOTIFICATION_CONSUMER_MANAGER = NotificationConsumerManager.getInstance();
            } else {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
                NOTIFICATION_CONSUMER_MANAGER = NotificationConsumerManager.getInstance(properties);
            }
        }
        return NOTIFICATION_CONSUMER_MANAGER;
    }

    public boolean isResourcePersistent() {
        return (class$org$globus$wsrf$PersistentResource == null ? (class$org$globus$wsrf$PersistentResource = ManagedMultiJobHome.class$("org.globus.wsrf.PersistentResource")) : class$org$globus$wsrf$PersistentResource).isAssignableFrom(this.resourceClass);
    }

    public int getResourceCount() {
        return this.resources.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

