/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.job;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.delegation.DelegationException;
import org.globus.exec.generated.FaultResourcePropertyType;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.ManagedJobResourceDataType;
import org.globus.exec.generated.MultiJobDescriptionType;
import org.globus.exec.generated.ServiceLevelAgreementType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.service.job.ManagedJobResource;
import org.globus.exec.service.utils.DelegatedCredential;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.rendezvous.service.RendezvousResourceImpl;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;

public abstract class ManagedJobResourceImpl
extends RendezvousResourceImpl
implements ManagedJobResource {
    private Log logger = null;
    private Log localLogger = null;
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedJobResourceImpl.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private ManagedJobResourceDataType resourceData;
    private DelegatedCredential jobCredential = null;
    private DelegatedCredential stagingCredential = null;
    private static String JOB_CREDENTIAL_TYPE = "job";
    private static String STAGING_CREDENTIAL_TYPE = "staging";
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$exec$service$job$ManagedJobResourceImpl;
    static /* synthetic */ Class class$org$globus$exec$generated$FaultResourcePropertyType;

    public void initializeWholeState(Object wholeResourceState, QName resourcePropertiesQName, Object resourceKey) throws ResourceException {
        this.logger = LogFactory.getLog((String)((class$org$globus$exec$service$job$ManagedJobResourceImpl == null ? (class$org$globus$exec$service$job$ManagedJobResourceImpl = ManagedJobResourceImpl.class$("org.globus.exec.service.job.ManagedJobResourceImpl")) : class$org$globus$exec$service$job$ManagedJobResourceImpl).getName() + "." + ((ResourceKey)resourceKey).getValue().toString()));
    }

    public Object getResourceProperty(QName name) {
        ResourcePropertySet resourceProperties = this.getResourcePropertySet();
        ResourceProperty resourceProperty = resourceProperties.get(name);
        int size = resourceProperty.size();
        if (resourceProperty.getMetaData().getMaxOccurs() > 1) {
            ArrayList<Object> values = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                values.add(resourceProperty.get(i));
            }
            return values;
        }
        if (size == 0) {
            return null;
        }
        return resourceProperty.get(0);
    }

    public void setResourceProperty(QName name, boolean booleanValue) {
        this.setResourceProperty(name, new Boolean(booleanValue));
    }

    public void setResourceProperty(QName name, Object value) {
        ResourceProperty resourceProperty = this.getResourcePropertySet().get(name);
        if (resourceProperty.size() < 1) {
            resourceProperty.add(value);
        }
        resourceProperty.set(0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setResourceDatum(ManagedJobResource resource, String name, Object value) {
        Log localLogger = LogFactory.getLog((String)((class$org$globus$exec$service$job$ManagedJobResourceImpl == null ? (class$org$globus$exec$service$job$ManagedJobResourceImpl = ManagedJobResourceImpl.class$("org.globus.exec.service.job.ManagedJobResourceImpl")) : class$org$globus$exec$service$job$ManagedJobResourceImpl).getName() + "." + ((ResourceKey)resource.getID()).getValue().toString()));
        if (localLogger.isDebugEnabled()) {
            localLogger.debug((Object)("Setting resource datum " + name + " to value " + value));
        }
        ManagedJobResourceDataType resourceData = resource.getResourceData();
        localLogger.trace((Object)"Obtaining lock on resourceData");
        ManagedJobResourceDataType managedJobResourceDataType = resourceData;
        synchronized (managedJobResourceDataType) {
            localLogger.trace((Object)"Obtained lock on resourceData");
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(resourceData.getClass());
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceDataInstrospectError", (Object)resourceData.getClass().getName());
                throw new RuntimeException(errorMessage, e);
            }
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            boolean foundProperty = false;
            PropertyDescriptor propertyDescriptor = null;
            for (int index = 0; index < propertyDescriptors.length && !foundProperty; ++index) {
                propertyDescriptor = propertyDescriptors[index];
                if (!propertyDescriptor.getName().equals(name)) continue;
                foundProperty = true;
            }
            if (!foundProperty) {
                String errorMessage = i18n.getMessage("ResourceDatumNotFound", (Object)name);
                throw new RuntimeException(errorMessage);
            }
            Method writeMethod = propertyDescriptor.getWriteMethod();
            try {
                writeMethod.invoke((Object)resourceData, value);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceDatumSetError", (Object)name);
                throw new RuntimeException(errorMessage);
            }
            localLogger.trace((Object)"Releasing lock on resourceData");
        }
        localLogger.trace((Object)"Released lock on resourceData");
    }

    public void setResourceDatum(String name, boolean booleanValue) {
        this.setResourceDatum(name, new Boolean(booleanValue));
    }

    public void setResourceDatum(String name, Object value) {
        ManagedJobResourceImpl.setResourceDatum(this, name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResourceDatum(String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getting resource datum " + name));
        }
        Object value = null;
        ManagedJobResourceDataType resourceData = this.getResourceData();
        this.logger.trace((Object)"Obtaining lock on resourceData");
        ManagedJobResourceDataType managedJobResourceDataType = resourceData;
        synchronized (managedJobResourceDataType) {
            this.logger.trace((Object)"Obtained lock on resourceData");
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(resourceData.getClass());
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceDataInstrospectError", (Object)resourceData.getClass().getName());
                throw new RuntimeException(errorMessage, e);
            }
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            boolean foundProperty = false;
            PropertyDescriptor propertyDescriptor = null;
            for (int index = 0; index < propertyDescriptors.length && !foundProperty; ++index) {
                propertyDescriptor = propertyDescriptors[index];
                if (!propertyDescriptor.getName().equals(name)) continue;
                foundProperty = true;
            }
            if (!foundProperty) {
                String errorMessage = i18n.getMessage("ResourceDatumNotFound", (Object)name);
                throw new RuntimeException(errorMessage);
            }
            Method readMethod = propertyDescriptor.getReadMethod();
            try {
                value = readMethod.invoke((Object)resourceData, null);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceDatumGetError", (Object)name);
                throw new RuntimeException(errorMessage);
            }
            this.logger.trace((Object)"Releasing lock on resourceData");
        }
        this.logger.trace((Object)"Released lock on resourceData");
        return value;
    }

    public JobDescriptionType getJobDescription() {
        ServiceLevelAgreementType sla = (ServiceLevelAgreementType)this.getResourcePropertySet().get(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT).get(0);
        JobDescriptionType jobDescription = sla.getJob();
        if (jobDescription == null) {
            jobDescription = sla.getMultiJob();
        }
        return jobDescription;
    }

    protected void setJobDescription(JobDescriptionType jobDescription) {
        ServiceLevelAgreementType sla = (ServiceLevelAgreementType)this.getResourcePropertySet().get(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT).get(0);
        if (jobDescription instanceof MultiJobDescriptionType) {
            sla.setMultiJob((MultiJobDescriptionType)jobDescription);
        } else {
            sla.setJob(jobDescription);
        }
    }

    public FaultType getFault() {
        ResourceProperty faultRP = this.getResourcePropertySet().get(ManagedJobConstants.RP_FAULT);
        FaultResourcePropertyType faultWrapper = (FaultResourcePropertyType)faultRP.get(0);
        if (faultWrapper == null) {
            return null;
        }
        Throwable fault = null;
        fault = faultWrapper.getFault();
        if (fault != null || (fault = faultWrapper.getCredentialSerializationFault()) != null || (fault = faultWrapper.getInsufficientCredentialsFault()) != null || (fault = faultWrapper.getInternalFault()) != null || (fault = faultWrapper.getInvalidCredentialsFault()) != null || (fault = faultWrapper.getServiceLevelAgreementFault()) != null || (fault = faultWrapper.getExecutionFailedFault()) != null || (fault = faultWrapper.getFilePermissionsFault()) != null || (fault = faultWrapper.getInvalidPathFault()) != null || (fault = faultWrapper.getStagingFault()) != null || (fault = faultWrapper.getUnsupportedFeatureFault()) != null) {
            // empty if block
        }
        return fault;
    }

    public void setFault(FaultType fault) {
        ResourceProperty faultRP = this.getResourcePropertySet().get(ManagedJobConstants.RP_FAULT);
        Class<?> faultClass = ((Object)((Object)fault)).getClass();
        String faultClassName = faultClass.getName();
        String faultElementName = faultClassName.substring(faultClassName.lastIndexOf(46) + 1);
        this.logger.debug((Object)("fault element name: " + faultElementName));
        faultElementName = faultElementName.substring(0, faultElementName.length() - 4);
        this.logger.debug((Object)("fault element name: " + faultElementName));
        faultElementName = Introspector.decapitalize(faultElementName);
        this.logger.debug((Object)("fault element name: " + faultElementName));
        Method writeMethod = null;
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(faultElementName, class$org$globus$exec$generated$FaultResourcePropertyType == null ? (class$org$globus$exec$generated$FaultResourcePropertyType = ManagedJobResourceImpl.class$("org.globus.exec.generated.FaultResourcePropertyType")) : class$org$globus$exec$generated$FaultResourcePropertyType);
            writeMethod = propertyDescriptor.getWriteMethod();
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("FaultWriteMethodNotFound", (Object)faultClassName);
            throw new RuntimeException(errorMessage, e);
        }
        FaultResourcePropertyType faultWrapper = new FaultResourcePropertyType();
        try {
            writeMethod.invoke((Object)faultWrapper, new Object[]{fault});
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("FaultWriteMethodError", (Object)faultClassName);
            throw new RuntimeException(errorMessage, e);
        }
        faultRP.set(0, (Object)faultWrapper);
    }

    public DelegatedCredential getJobCredential(File userProxyDirectory) throws ResourceException, DelegationException, GeneralSecurityException, IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Entering getJobCredential()");
        }
        if (this.jobCredential == null) {
            JobDescriptionType jobDescription = this.getJobDescription();
            String localUserId = (String)this.getResourcePropertySet().get(ManagedJobConstants.RP_LOCAL_USER_ID).get(0);
            EndpointReferenceType credentialEndpoint = jobDescription.getJobCredentialEndpoint();
            if (credentialEndpoint == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Leaving getJobCredential()");
                }
                return null;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("job credential endpoint:\n" + credentialEndpoint));
            }
            String userSubject = (String)this.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT);
            this.jobCredential = DelegatedCredential.getDelegatedCredential(credentialEndpoint, localUserId, userSubject, userProxyDirectory);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Delegated Job Credential Object: " + this.jobCredential.toString()));
                try {
                    this.logger.debug((Object)("Using proxy with subject " + this.jobCredential.getCredential().getIdentity()));
                }
                catch (Exception e) {
                    String errorMessage = i18n.getMessage("ProxySubjectError");
                    this.logger.error((Object)errorMessage);
                }
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Leaving getJobCredential()");
        }
        return this.jobCredential;
    }

    public DelegatedCredential getStagingCredential() throws ResourceException, DelegationException, GeneralSecurityException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getStagingCredential() called");
        }
        if (this.stagingCredential == null) {
            JobDescriptionType jobDescription = this.getJobDescription();
            String localUserId = (String)this.getResourcePropertySet().get(ManagedJobConstants.RP_LOCAL_USER_ID).get(0);
            EndpointReferenceType credentialEndpoint = jobDescription.getStagingCredentialEndpoint();
            if (credentialEndpoint == null) {
                return null;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("staging credential endpoint:\n" + credentialEndpoint));
            }
            String userSubject = (String)this.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT);
            this.stagingCredential = DelegatedCredential.getDelegatedCredential(credentialEndpoint, localUserId, userSubject);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Delegated Staging Credential Object: " + this.stagingCredential.toString()));
                try {
                    this.logger.debug((Object)("Using proxy with subject " + this.stagingCredential.getCredential().getIdentity() + "to contact the staging service"));
                }
                catch (Exception e) {
                    String errorMessage = i18n.getMessage("ProxySubjectError");
                    this.logger.error((Object)errorMessage);
                }
            }
        }
        return this.stagingCredential;
    }

    public ManagedJobResourceDataType getResourceData() {
        return this.resourceData;
    }

    public void setResourceData(ManagedJobResourceDataType resourceData) {
        this.resourceData = resourceData;
    }

    public StateEnumeration getState() {
        ResourceProperty stateRP = this.getResourcePropertySet().get(ManagedJobConstants.RP_STATE);
        return (StateEnumeration)stateRP.get(0);
    }

    public void setState(StateEnumeration state) throws Exception {
        ResourceProperty stateRP = this.getResourcePropertySet().get(ManagedJobConstants.RP_STATE);
        StateEnumeration currentState = (StateEnumeration)stateRP.get(0);
        if (!currentState.equals((Object)StateEnumeration.Done) && !currentState.equals((Object)StateEnumeration.Failed)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting new state RP value " + state.getValue()));
            }
            stateRP.set(0, (Object)state);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("not setting new state RP value " + state.getValue() + ", since the current state is a terminating state"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

