/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.factory;

import java.rmi.RemoteException;
import java.util.Calendar;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.CreateManagedJobInputType;
import org.globus.exec.generated.CreateManagedJobOutputType;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.MultiJobDescriptionType;
import org.globus.exec.service.factory.FactoryServiceConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryResource;
import org.globus.exec.service.job.ManagedJobHome;
import org.globus.exec.service.job.ManagedJobResource;
import org.globus.exec.service.utils.ConfigurationHelper;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.exec.utils.rsl.RSLHelper;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.notification.SubscribeHelper;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.PerformanceLog;
import org.oasis.wsn.Subscribe;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.lifetime.UnableToSetTerminationTimeFaultType;

public class ManagedJobFactoryService {
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$factory$ManagedJobFactoryService == null ? (class$org$globus$exec$service$factory$ManagedJobFactoryService = ManagedJobFactoryService.class$("org.globus.exec.service.factory.ManagedJobFactoryService")) : class$org$globus$exec$service$factory$ManagedJobFactoryService).getName() + ".performance");
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$factory$ManagedJobFactoryService == null ? (class$org$globus$exec$service$factory$ManagedJobFactoryService = ManagedJobFactoryService.class$("org.globus.exec.service.factory.ManagedJobFactoryService")) : class$org$globus$exec$service$factory$ManagedJobFactoryService).getName());
    static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedJobFactoryService.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static FactoryServiceConfiguration SERVICE_CONFIGURATION = null;
    static String SERVICE_PATH = null;
    static /* synthetic */ Class class$org$globus$exec$service$factory$ManagedJobFactoryService;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public ManagedJobFactoryService() {
        logger.trace((Object)("Creating ManagedJobFactoryService " + this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CreateManagedJobOutputType createManagedJob(CreateManagedJobInputType jobCreationInput) throws RemoteException, BaseFaultType {
        Calendar currentTime;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering createManagedJob()");
            performanceLogger.start();
        }
        Calendar requestedTermTime = jobCreationInput.getInitialTerminationTime();
        Calendar initTermTime = currentTime = Calendar.getInstance();
        if (requestedTermTime == null) {
            initTermTime = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setting job resource termination time to null i.e. infinite");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("requested termination time: " + requestedTermTime.getTime()));
                logger.debug((Object)("current time: " + currentTime.getTime()));
            }
            if (requestedTermTime.getTime().before(currentTime.getTime())) {
                throw new UnableToSetTerminationTimeFaultType();
            }
            initTermTime = requestedTermTime;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setting job resource termination time to requested time");
            }
        }
        CreateManagedJobOutputType response = new CreateManagedJobOutputType();
        response.setCurrentTime(currentTime);
        response.setNewTerminationTime(initTermTime);
        JobDescriptionType jobDescription = jobCreationInput.getJob();
        if (jobDescription == null) {
            jobDescription = jobCreationInput.getMultiJob();
        }
        if (jobDescription == null) {
            throw new RemoteException(i18n.getMessage("rslMissing"));
        }
        try {
            jobDescription = (JobDescriptionType)ObjectSerializer.clone((Object)jobDescription);
        }
        catch (Exception e) {
            throw new RemoteException("bad RSL", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("received RSL : \n" + RSLHelper.convertToString((JobDescriptionType)jobDescription)));
        }
        EndpointReferenceType epr = new EndpointReferenceType();
        EndpointReferenceType subscriptionEPR = null;
        ResourceHomeImpl jobHome = null;
        try {
            ResourceContext ctx = ResourceContext.getResourceContext();
            ManagedJobFactoryResource factoryResource = null;
            try {
                factoryResource = (ManagedJobFactoryResource)ctx.getResource();
            }
            catch (NoSuchResourceException nsre) {
                String serviceAddress = ctx.getServiceURL().toString();
                String resourceKey = ctx.getResourceKey().getValue().toString();
                throw new RemoteException(i18n.getMessage("BAD_FACTORY_RESOURCE", (Object[])new String[]{serviceAddress, resourceKey}));
            }
            String localResourceManager = (String)factoryResource.getResourcePropertySet().get(ManagedJobFactoryConstants.RP_LOCAL_RESOURCE_MANAGER).get(0);
            SecurityManager securityManager = SecurityManager.getManager();
            String userSubject = securityManager.getCaller();
            String servicePath = ctx.getService();
            logger.debug((Object)("servicePath=" + servicePath));
            String localUserId = null;
            String[] localUserIds = securityManager.getLocalUsernames();
            String requestedLocalUserId = jobDescription.getLocalUserId();
            if (requestedLocalUserId != null) {
                boolean foundLocalUserId = false;
                for (int index = 0; index < localUserIds.length && !foundLocalUserId; ++index) {
                    if (!requestedLocalUserId.equals(localUserIds[index])) continue;
                    foundLocalUserId = true;
                }
                if (!foundLocalUserId) throw new RemoteException(i18n.getMessage("unauthorizedLocalUserId", new Object[]{requestedLocalUserId}));
                localUserId = requestedLocalUserId;
            } else {
                localUserId = localUserIds[0];
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("createManagedJob() called...\nCaller ID: " + userSubject + "\nLooked up local user ID: " + localUserId));
            }
            if (logger.isDebugEnabled()) {
                if (jobDescription instanceof MultiJobDescriptionType) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"received a multi-job RSL");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"received a single-job RSL");
                }
            }
            FactoryServiceConfiguration serviceConfiguration = ManagedJobFactoryService.getServiceConfiguration();
            String execJobServicePath = serviceConfiguration.getManagedExecutableJobServicePath();
            ManagedJobHome execJobHome = (ManagedJobHome)ConfigurationHelper.getResourceHome(execJobServicePath);
            String multiJobServicePath = serviceConfiguration.getManagedMultiJobServicePath();
            ManagedJobHome multiJobHome = (ManagedJobHome)ConfigurationHelper.getResourceHome(multiJobServicePath);
            String jobServicePath = null;
            if (localResourceManager.toLowerCase().equals("multi")) {
                jobServicePath = multiJobServicePath;
                jobHome = (ResourceHomeImpl)multiJobHome;
            } else {
                jobServicePath = execJobServicePath;
                jobHome = (ResourceHomeImpl)execJobHome;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Managed Job Service Path: " + jobServicePath));
            }
            AttributedURI idempotenceIdUri = jobCreationInput.getJobID();
            String idempotenceId = null;
            if (idempotenceIdUri != null) {
                idempotenceId = idempotenceIdUri.getSchemeSpecificPart();
            }
            String serviceURL = ServiceHost.getBaseURL() + jobServicePath;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"at create()");
            }
            ResourceKey key = null;
            ManagedJobResource resource = null;
            ManagedJobFactoryService managedJobFactoryService = this;
            synchronized (managedJobFactoryService) {
                key = ((ManagedJobHome)jobHome).create(initTermTime, currentTime, localResourceManager, jobDescription, userSubject, localUserId, idempotenceId, serviceURL);
                resource = (ManagedJobResource)jobHome.find(key);
                epr = AddressingUtils.createEndpointReference((String)serviceURL, (ResourceKey)key);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"at find()");
                }
            }
            Subscribe subscription = jobCreationInput.getSubscribe();
            if (subscription != null) {
                SubscribeHelper subscribeHelper = new SubscribeHelper(ctx, (Resource)resource, key, "java:comp/env//services/" + jobServicePath + "/home", subscription);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"at subscribe()");
                }
                subscriptionEPR = subscribeHelper.subscribe();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"at start()");
            }
            resource.start();
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("jobCreationFailed");
            logger.error((Object)errorMessage, (Throwable)e);
            throw new RemoteException(errorMessage, e);
        }
        response.setSubscriptionEndpoint(subscriptionEPR);
        response.setManagedJobEndpoint(epr);
        if (!logger.isDebugEnabled()) return response;
        logger.debug((Object)"Leaving createManagedJob()");
        performanceLogger.stop("createManagedJob");
        return response;
    }

    public static synchronized FactoryServiceConfiguration getServiceConfiguration() {
        if (SERVICE_CONFIGURATION == null) {
            try {
                SERVICE_CONFIGURATION = (FactoryServiceConfiguration)ConfigurationHelper.getServiceConfiguration("ManagedJobFactoryService");
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("JndiMJFSConfigError");
                logger.error((Object)errorMessage, (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
        }
        return SERVICE_CONFIGURATION;
    }

    public static String getServicePath() {
        return SERVICE_PATH;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

