/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.monitoring.JobStateChangeListener;
import org.globus.exec.monitoring.JobStateMonitor;
import org.globus.exec.monitoring.JobStateRecoveryListener;
import org.globus.exec.service.exec.ManagedExecutableJobHome;
import org.globus.exec.service.factory.DelegationFactoryEndpointResourceProperty;
import org.globus.exec.service.factory.StagingDelegationFactoryEndpointResourceProperty;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.mds.usefulrp.ServiceMetaDataResourceProperty;
import org.globus.mds.usefulrp.rpprovider.GLUEResourcePropertyConfig;
import org.globus.mds.usefulrp.rpprovider.ResourcePropertyProviderCollection;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.ReflectionResource;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;

public class ManagedJobFactoryResource
extends ReflectionResource
implements SecureResource,
JobStateRecoveryListener {
    private static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$service$factory$ManagedJobFactoryResource == null ? (class$org$globus$exec$service$factory$ManagedJobFactoryResource = ManagedJobFactoryResource.class$("org.globus.exec.service.factory.ManagedJobFactoryResource")) : class$org$globus$exec$service$factory$ManagedJobFactoryResource));
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedJobFactoryResource.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static Timer SUB_DEF_REFRESH_TIMER = new Timer(true);
    protected Properties substitutionDefinitions = null;
    private JobStateMonitor monitor;
    private File timestampPath;
    private ResourcePropertyProviderCollection glueRP;
    private boolean enableDefaultSoftwareEnvironment;
    private ResourceSecurityDescriptor securityDescriptor = null;
    static /* synthetic */ Class class$org$globus$exec$service$factory$ManagedJobFactoryResource;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public void initialize(Object resourceBean, QName resourceElementQName, Object key, String subDefFile, String subDefRefreshPeriod, String enableDefaultSoftEnv) throws ResourceException {
        long refreshPeriod;
        super.initialize(resourceBean, resourceElementQName, key);
        String globusLocation = this.getStringProperty(ManagedJobFactoryConstants.RP_GLOBUS_LOCATION);
        if (globusLocation == null) {
            String errorMessage = i18n.getMessage("RPnotFound", (Object)ManagedJobFactoryConstants.RP_GLOBUS_LOCATION);
            throw new ResourceException(errorMessage);
        }
        String segUserName = "dummy";
        String schedulerName = this.getStringProperty(ManagedJobFactoryConstants.RP_LOCAL_RESOURCE_MANAGER);
        if (schedulerName == null) {
            String errorMessage = i18n.getMessage("RPnotFound", (Object)ManagedJobFactoryConstants.RP_LOCAL_RESOURCE_MANAGER);
            throw new ResourceException(errorMessage);
        }
        schedulerName = schedulerName.toLowerCase();
        ManagedExecutableJobHome home = ManagedExecutableJobHome.getHome();
        if (!(home instanceof JobStateChangeListener)) {
            String errorMessage = i18n.getMessage("InternalError");
            throw new ResourceException(errorMessage);
        }
        ManagedExecutableJobHome jobStateChangeListener = home;
        ManagedJobFactoryResource recoveryListener = this;
        this.timestampPath = new File(globusLocation + File.separator + "var" + File.separator + "globus-jsm-" + schedulerName + ".stamp");
        if (!schedulerName.equals("multi")) {
            this.monitor = JobStateMonitor.getInstance((File)new File(globusLocation), (String)segUserName, (String)schedulerName, (JobStateChangeListener)jobStateChangeListener, (JobStateRecoveryListener)recoveryListener, (boolean)true);
            this.monitor.start(this.getRestartTimestamp());
        }
        try {
            refreshPeriod = Long.parseLong(subDefRefreshPeriod) * 60000L;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SUB_DEF_REFRESH_TIMER.schedule((TimerTask)new SubstitutionDefinitionsRefreshTask(this, subDefFile), refreshPeriod, refreshPeriod);
        this.enableDefaultSoftwareEnvironment = new Boolean(enableDefaultSoftEnv);
        class RecoveryThread
        extends Thread {
            ManagedExecutableJobHome home;

            public RecoveryThread(ManagedExecutableJobHome home) {
                this.home = home;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.debug((Object)"recovery thread active");
                try {
                    ManagedExecutableJobHome managedExecutableJobHome = this.home;
                    synchronized (managedExecutableJobHome) {
                        while (!this.home.isInitialized()) {
                            try {
                                this.home.wait();
                            }
                            catch (Exception exception) {}
                        }
                        this.home.recover();
                    }
                }
                catch (ResourceException re) {
                    logger.warn((Object)"Recovery exception", (Throwable)re);
                }
                logger.debug((Object)"recovery thread finished");
            }
        }
        RecoveryThread recoveryThread = new RecoveryThread(home);
        recoveryThread.start();
        this.createNewGLUEResourceProperty();
    }

    private String getStringProperty(QName propertyName) {
        ResourcePropertySet props = this.getResourcePropertySet();
        return (String)props.get(propertyName).get(0);
    }

    public void updateJobMonitorRecoveryTimeStamp(JobStateMonitor monitor, Date timeStamp) {
        try {
            if (monitor != this.monitor) {
                return;
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.timestampPath));
            oos.writeObject(timeStamp);
            oos.close();
        }
        catch (IOException ioe) {
            logger.warn((Object)ioe);
        }
    }

    private Date getRestartTimestamp() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.timestampPath));
            if (ois == null) {
                return null;
            }
            Object o = ois.readObject();
            ois.close();
            if (o == null || !(o instanceof Date)) {
                return null;
            }
            return (Date)o;
        }
        catch (IOException ioe) {
            logger.debug((Object)ioe);
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            logger.warn((Object)cnfe);
            return null;
        }
    }

    public JobStateMonitor getJobStateMonitor() {
        return this.monitor;
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        return this.securityDescriptor;
    }

    protected ResourceProperty createNewResourceProperty(ResourcePropertyMetaData metaData, Object resourceBean) throws Exception {
        QName rpQName = metaData.getName();
        logger.debug((Object)("Creating resource property for: " + rpQName));
        if (rpQName.equals(ServiceMetaDataResourceProperty.SERVICE_METADATA)) {
            return this.createNewMDSMetaDataResourceProperty(rpQName);
        }
        if (rpQName.equals(ManagedJobFactoryConstants.RP_DELEGATION_FACTORY_ENDPOINT)) {
            return DelegationFactoryEndpointResourceProperty.getInstance();
        }
        if (rpQName.equals(ManagedJobFactoryConstants.RP_STAGING_DELEGATION_FACTORY_ENDPOINT)) {
            return StagingDelegationFactoryEndpointResourceProperty.getInstance();
        }
        return super.createNewResourceProperty(metaData, resourceBean);
    }

    protected ResourceProperty createNewMDSMetaDataResourceProperty(QName rpQName) {
        ServiceMetaDataResourceProperty metadata = null;
        try {
            metadata = new ServiceMetaDataResourceProperty();
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to add ServiceMetaData RP");
        }
        return metadata;
    }

    protected void createNewGLUEResourceProperty() {
        try {
            String globusLocation = this.getStringProperty(ManagedJobFactoryConstants.RP_GLOBUS_LOCATION);
            String schedulerName = this.getStringProperty(ManagedJobFactoryConstants.RP_LOCAL_RESOURCE_MANAGER);
            if (schedulerName == null) {
                logger.warn((Object)"No scheduler name found while attempting to create GLUE RP - resource property will not be available");
                return;
            }
            if (schedulerName.equalsIgnoreCase("Multi")) {
                return;
            }
            String glueConfigFile = globusLocation + File.separator + "etc/gram-service-" + schedulerName + File.separator + "gluerp-config.xml";
            File configFile = new File(glueConfigFile);
            if (!new File(glueConfigFile).exists()) {
                GLUEResourcePropertyConfig.generateDefaultConfig((String)glueConfigFile, (String)schedulerName, null);
            }
            this.glueRP = new ResourcePropertyProviderCollection(glueConfigFile, this.getResourcePropertySet(), true);
        }
        catch (Exception e) {
            logger.warn((Object)("Exception while creating GLUE Resource Property: " + e));
        }
    }

    public EndpointReferenceType getStagingDelegationFactoryEndpoint() {
        ResourcePropertySet props = this.getResourcePropertySet();
        return (EndpointReferenceType)props.get(ManagedJobFactoryConstants.RP_STAGING_DELEGATION_FACTORY_ENDPOINT).get(0);
    }

    public boolean isDefaultSoftwareEnvironmentEnabled() {
        return this.enableDefaultSoftwareEnvironment;
    }

    public Set substitutionDefinitionSet() {
        return this.substitutionDefinitions.entrySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SubstitutionDefinitionsRefreshTask
    extends TimerTask {
        ManagedJobFactoryResource factoryResource = null;
        String subDefFile = null;

        public SubstitutionDefinitionsRefreshTask(ManagedJobFactoryResource factoryResource, String subDefFile) {
            this.factoryResource = factoryResource;
            this.subDefFile = subDefFile;
            this.refresh();
        }

        private void refresh() {
            try {
                this.factoryResource.substitutionDefinitions = new Properties();
                this.factoryResource.substitutionDefinitions.load(new FileInputStream(this.subDefFile));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Refreshed Substitution Definitions:\n" + this.factoryResource.substitutionDefinitions.toString()));
            }
        }

        public void run() {
            this.refresh();
        }
    }
}

