/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.factory;

import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.ManagedJobFactoryResourceProperties;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.FactoryResourceConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryResource;
import org.globus.exec.service.factory.ManagedJobFactoryService;
import org.globus.exec.service.utils.AuthorizationHelper;
import org.globus.exec.service.utils.ConfigurationHelper;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.exec.utils.service.ManagedJobHelper;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.servicegroup.client.MDSConfiguration;
import org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.ContextUtils;

public class ManagedJobFactoryHome
extends ResourceHomeImpl {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$factory$ManagedJobFactoryHome == null ? (class$org$globus$exec$service$factory$ManagedJobFactoryHome = ManagedJobFactoryHome.class$("org.globus.exec.service.factory.ManagedJobFactoryHome")) : class$org$globus$exec$service$factory$ManagedJobFactoryHome).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedJobFactoryHome.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static FactoryHomeConfiguration CONFIGURATION;
    private boolean registerToMDS = false;
    private boolean initialized = false;
    static /* synthetic */ Class class$org$globus$exec$service$factory$ManagedJobFactoryHome;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$javax$naming$Reference;
    static /* synthetic */ Class class$org$globus$exec$service$factory$FactoryResourceConfiguration;

    public synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        if (ManagedJobFactoryService.SERVICE_PATH == null) {
            MessageContext context = MessageContext.getCurrentContext();
            if (context == null) {
                throw new RuntimeException("No Context!");
            }
            ManagedJobFactoryService.SERVICE_PATH = ContextUtils.getTargetServicePath((MessageContext)context);
        }
        AuthorizationHelper.initialize();
        this.keyTypeName = ManagedJobFactoryConstants.RESOURCE_KEY_QNAME;
        super.initialize();
        logger.debug((Object)"Creating ManagedJobFactoryHome");
        ResourceContext ctx = ResourceContext.getResourceContext();
        InitialContext initialContext = new InitialContext();
        CONFIGURATION = (FactoryHomeConfiguration)ConfigurationHelper.getResourceHomeConfiguration();
        try {
            String config = "java:comp/env//services/" + ResourceContext.getResourceContext().getService() + "/mdsConfiguration";
            MDSConfiguration mdsConfiguration = (MDSConfiguration)initialContext.lookup(config);
            this.registerToMDS = mdsConfiguration.getRegAsBoolean();
            logger.debug((Object)("Register to MDS: " + this.registerToMDS));
        }
        catch (Exception e) {
            logger.debug((Object)("Couldn't load MDS config: " + e));
        }
        NamingEnumeration<Binding> objects = initialContext.listBindings(ConfigurationHelper.getServiceJNDILocation());
        while (objects.hasMore()) {
            Class<?> boundJNDIObjectClazz;
            Binding binding = objects.next();
            logger.debug((Object)("JNDI: binding found " + binding));
            Object boundJNDIObject = binding.getObject();
            if (boundJNDIObject == null) continue;
            if ((class$javax$naming$Reference == null ? ManagedJobFactoryHome.class$("javax.naming.Reference") : class$javax$naming$Reference).isAssignableFrom(boundJNDIObjectClazz = boundJNDIObject.getClass())) {
                boundJNDIObjectClazz = Class.forName(((Reference)boundJNDIObject).getClassName());
            }
            logger.debug((Object)("boundJNDIObjectClazz=" + boundJNDIObjectClazz));
            if (!(class$org$globus$exec$service$factory$FactoryResourceConfiguration == null ? ManagedJobFactoryHome.class$("org.globus.exec.service.factory.FactoryResourceConfiguration") : class$org$globus$exec$service$factory$FactoryResourceConfiguration).isAssignableFrom(boundJNDIObjectClazz)) continue;
            FactoryResourceConfiguration lrmConfig = (FactoryResourceConfiguration)ConfigurationHelper.getJNDIObjectForCurrentService(binding.getName());
            String strLRM = lrmConfig.getLocalResourceManagerName();
            logger.debug((Object)("Creating factory resource for " + strLRM));
            String scratchDirectory = lrmConfig.getScratchDirectory();
            String subDefFile = lrmConfig.getSubstitutionDefinitionsFile();
            String subDefRefreshPeriod = lrmConfig.getSubstitutionDefinitionsRefreshPeriod();
            String enableDefaultSoftwareEnvironment = lrmConfig.getEnableDefaultSoftwareEnvironment();
            this.create(strLRM, scratchDirectory, subDefFile, subDefRefreshPeriod, enableDefaultSoftwareEnvironment);
        }
        this.initialized = true;
    }

    private ManagedJobFactoryResource create(String localResourceManager, String scratchDirectory, String subDefFile, String subDefRefreshPeriod, String enableDefaultSoftwareEnvironment) throws Exception {
        SimpleResourceKey key = ManagedJobHelper.getResourceKey((String)localResourceManager);
        ManagedJobFactoryResource factoryResource = new ManagedJobFactoryResource();
        factoryResource.initialize(this.createResourceBean(localResourceManager, scratchDirectory), ManagedJobFactoryConstants.RESOURCE_PROPERTY_SET, key, subDefFile, subDefRefreshPeriod, enableDefaultSoftwareEnvironment);
        this.add((ResourceKey)key, (Resource)factoryResource);
        return factoryResource;
    }

    protected void add(ResourceKey key, Resource resource) {
        EndpointReferenceType epr;
        ResourceContext ctx;
        logger.debug((Object)"In custom add");
        super.add(key, resource);
        if (!this.registerToMDS) {
            return;
        }
        logger.debug((Object)"registering to MDS");
        try {
            ctx = ResourceContext.getResourceContext();
        }
        catch (ResourceContextException e) {
            logger.error((Object)("Could not get ResourceContext: " + (Object)((Object)e)));
            return;
        }
        try {
            epr = AddressingUtils.createEndpointReference((ResourceContext)ctx, (ResourceKey)key);
        }
        catch (Exception e) {
            logger.error((Object)("Could not form EPR: " + e));
            return;
        }
        try {
            ServiceGroupRegistrationClient.register((ResourceContext)ctx, (EndpointReferenceType)epr, (String)"/etc/gram-service/registration.xml");
        }
        catch (Exception e) {
            logger.error((Object)("Exception when trying to register to MDS: " + e));
        }
    }

    private ManagedJobFactoryResourceProperties createResourceBean(String localResourceManager, String scratchDirectory) {
        ManagedJobFactoryResourceProperties resourceProperties = new ManagedJobFactoryResourceProperties();
        resourceProperties.setLocalResourceManager(localResourceManager);
        resourceProperties.setScratchBaseDirectory(scratchDirectory);
        resourceProperties.setGlobusLocation(CONFIGURATION.getGlobusLocation());
        resourceProperties.setHostCPUType(CONFIGURATION.getHostCpuType());
        resourceProperties.setHostManufacturer(CONFIGURATION.getHostManufacturer());
        resourceProperties.setHostOSName(CONFIGURATION.getHostOsName());
        resourceProperties.setHostOSVersion(CONFIGURATION.getHostOsVersion());
        resourceProperties.setCondorArchitecture(CONFIGURATION.getCondorArchitecture());
        resourceProperties.setCondorOS(CONFIGURATION.getCondorOS());
        return resourceProperties;
    }

    public static ManagedJobFactoryHome getHome() throws NamingException {
        logger.trace((Object)"getHome() called");
        ManagedJobFactoryHome home = (ManagedJobFactoryHome)ConfigurationHelper.getResourceHome("ManagedJobFactoryService");
        logger.trace((Object)("getHome() returning " + (home == null ? "null" : ((Object)((Object)home)).toString())));
        return home;
    }

    public static FactoryHomeConfiguration getConfiguration() {
        return CONFIGURATION;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

