/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec.utils;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.service.exec.ManagedExecutableJobHome;
import org.globus.exec.service.exec.ManagedExecutableJobResource;
import org.globus.exec.service.exec.StagingListener;
import org.globus.exec.service.exec.utils.StagingHelper;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.utils.DelegatedCredential;
import org.globus.exec.utils.FaultUtils;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.rft.generated.BaseRequestType;
import org.globus.rft.generated.CreateReliableFileTransferInputType;
import org.globus.rft.generated.CreateReliableFileTransferOutputType;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.ReliableFileTransferFactoryPortType;
import org.globus.rft.generated.ReliableFileTransferPortType;
import org.globus.rft.generated.RequestStatusType;
import org.globus.rft.generated.Start;
import org.globus.rft.generated.StartOutputType;
import org.globus.rft.generated.TransferRequestType;
import org.globus.rft.generated.service.ReliableFileTransferFactoryServiceAddressingLocator;
import org.globus.rft.generated.service.ReliableFileTransferServiceAddressingLocator;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.util.I18n;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.utils.PerformanceLog;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.SubscriptionManager;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;

public class WSStagingHelper
extends StagingHelper {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$exec$utils$WSStagingHelper == null ? (class$org$globus$exec$service$exec$utils$WSStagingHelper = WSStagingHelper.class$("org.globus.exec.service.exec.utils.WSStagingHelper")) : class$org$globus$exec$service$exec$utils$WSStagingHelper).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = WSStagingHelper.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$exec$utils$WSStagingHelper == null ? (class$org$globus$exec$service$exec$utils$WSStagingHelper = WSStagingHelper.class$("org.globus.exec.service.exec.utils.WSStagingHelper")) : class$org$globus$exec$service$exec$utils$WSStagingHelper).getName() + ".performance");
    static /* synthetic */ Class class$org$globus$exec$service$exec$utils$WSStagingHelper;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$rft$generated$RequestStatusType;
    static /* synthetic */ Class class$org$globus$exec$generated$FaultType;

    public EndpointReferenceType submitStagingRequest(ManagedExecutableJobResource resource, BaseRequestType stagingRequest) throws Exception {
        logger.trace((Object)(this.getLoggingPrefix(resource) + "Entering sumbitStagingRequest()"));
        ReliableFileTransferFactoryServiceAddressingLocator factoryLocator = new ReliableFileTransferFactoryServiceAddressingLocator();
        ReliableFileTransferFactoryPortType factoryPort = factoryLocator.getReliableFileTransferFactoryPortTypePort(resource.getReliableFileTransferFactoryEndpoint());
        ManagedExecutableJobHome.getHome().enableLocalTransport((Stub)factoryPort);
        this.setStagingStubSecurity(resource, (Stub)factoryPort);
        CreateReliableFileTransferInputType createInput = new CreateReliableFileTransferInputType();
        if (stagingRequest instanceof TransferRequestType) {
            createInput.setTransferRequest((TransferRequestType)stagingRequest);
        } else {
            createInput.setDeleteRequest((DeleteRequestType)stagingRequest);
        }
        Calendar terminationTime = Calendar.getInstance();
        terminationTime.add(10, 12);
        createInput.setInitialTerminationTime(terminationTime);
        logger.trace((Object)(this.getLoggingPrefix(resource) + "calling RFTF.createReliableFileTransfer()"));
        CreateReliableFileTransferOutputType createOutput = factoryPort.createReliableFileTransfer(createInput);
        EndpointReferenceType transferJobEndpoint = createOutput.getReliableTransferEPR();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RFT service URL: " + transferJobEndpoint.getAddress().toString()));
        }
        StartOutputType startResponse = this.startTransferJob(resource, transferJobEndpoint);
        logger.trace((Object)(this.getLoggingPrefix(resource) + "Leaving sumbitStagingRequest()"));
        return transferJobEndpoint;
    }

    public StartOutputType startTransferJob(ManagedExecutableJobResource resource, EndpointReferenceType transferJobEndpoint) throws Exception {
        logger.trace((Object)(this.getLoggingPrefix(resource) + "Entering startTransferJob()"));
        StagingListener.registerTransferJob(transferJobEndpoint, (ResourceKey)resource.getID());
        ReliableFileTransferServiceAddressingLocator transferLocator = new ReliableFileTransferServiceAddressingLocator();
        ReliableFileTransferPortType transferJobPort = transferLocator.getReliableFileTransferPortTypePort(transferJobEndpoint);
        ManagedExecutableJobHome.getHome().enableLocalTransport((Stub)transferJobPort);
        this.setStagingStubSecurity(resource, (Stub)transferJobPort);
        NotificationConsumerManager notificationConsumerManager = ManagedExecutableJobHome.getNotificationConsumerManager();
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(RFTConstants.REQUEST_STATUS_RESOURCE);
        ResourceSecurityDescriptor securityDescriptor = new ResourceSecurityDescriptor();
        securityDescriptor.setAuthz("none");
        Vector<Object> authMethod = new Vector<Object>();
        FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
        String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
        if (wsTransportProtocol == null) {
            wsTransportProtocol = ServiceHost.getDefaultProtocol();
        }
        if (wsTransportProtocol.equals("http")) {
            authMethod.add(GSISecureMsgAuthMethod.BOTH);
        } else {
            authMethod.add(GSITransportAuthMethod.BOTH);
        }
        securityDescriptor.setAuthMethods(authMethod);
        notificationConsumerManager.startListening();
        EndpointReferenceType notificationConsumerEndpoint = notificationConsumerManager.createNotificationConsumer(topicPath, (NotifyCallback)StagingListener.getInstance(), securityDescriptor);
        resource.setResourceDatum("notificationConsumerEndpoint", notificationConsumerEndpoint);
        Subscribe subscriptionRequest = new Subscribe();
        Object resourceHandle = null;
        subscriptionRequest.setConsumerReference(notificationConsumerEndpoint);
        TopicExpressionType topicExpression = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)RFTConstants.REQUEST_STATUS_RESOURCE);
        subscriptionRequest.setTopicExpression(topicExpression);
        SubscribeResponse subscribeResponse = transferJobPort.subscribe(subscriptionRequest);
        EndpointReferenceType subscriptionEndpoint = subscribeResponse.getSubscriptionReference();
        resource.setResourceDatum("subscriptionEndpoint", subscriptionEndpoint);
        logger.trace((Object)(this.getLoggingPrefix(resource) + "calling RFT.start()"));
        StartOutputType startResponse = transferJobPort.start(new Start());
        logger.trace((Object)(this.getLoggingPrefix(resource) + "Leaving startTransferJob()"));
        return startResponse;
    }

    public void destroyTransferJob(ManagedExecutableJobResource resource, EndpointReferenceType transferJobEndpoint) throws Exception {
        EndpointReferenceType notificationConsumerEndpoint;
        EndpointReferenceType subscriptionEndpoint;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Entering destroyTransferJob()"));
        }
        if ((subscriptionEndpoint = (EndpointReferenceType)resource.getResourceDatum("subscriptionEndpoint")) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getLoggingPrefix(resource) + "Destroying transfer notification subscription."));
            }
            SubscriptionManager subscriptionPort = new WSBaseNotificationServiceAddressingLocator().getSubscriptionManagerPort(subscriptionEndpoint);
            ManagedExecutableJobHome.getHome().enableLocalTransport((Stub)subscriptionPort);
            this.setStagingStubSecurity(resource, (Stub)subscriptionPort);
            resource.setResourceDatum("subscriptionEndpoint", null);
            subscriptionPort.destroy(new Destroy());
        }
        if (transferJobEndpoint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getLoggingPrefix(resource) + "Unregister transfer from staging listener."));
            }
            StagingListener.unregisterTransferJob(transferJobEndpoint);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getLoggingPrefix(resource) + "Destroying transfer."));
            }
            ReliableFileTransferServiceAddressingLocator transferLocator = new ReliableFileTransferServiceAddressingLocator();
            ReliableFileTransferPortType transferJobPort = transferLocator.getReliableFileTransferPortTypePort(transferJobEndpoint);
            ManagedExecutableJobHome.getHome().enableLocalTransport((Stub)transferJobPort);
            this.setStagingStubSecurity(resource, (Stub)transferJobPort);
            transferJobPort.destroy(new Destroy());
        }
        if ((notificationConsumerEndpoint = (EndpointReferenceType)resource.getResourceDatum("notificationConsumerEndpoint")) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getLoggingPrefix(resource) + "Destroying transfer notification consumer."));
            }
            NotificationConsumerManager notificationConsumerManager = ManagedExecutableJobHome.getNotificationConsumerManager();
            notificationConsumerManager.startListening();
            notificationConsumerManager.removeNotificationConsumer(notificationConsumerEndpoint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Leaving destroyTransferJob()"));
        }
    }

    public RequestStatusType poll(ManagedExecutableJobResource resource, EndpointReferenceType transferJobEndpoint) {
        try {
            if (transferJobEndpoint != null) {
                ReliableFileTransferServiceAddressingLocator transferLocator = new ReliableFileTransferServiceAddressingLocator();
                ReliableFileTransferPortType transferJobPort = transferLocator.getReliableFileTransferPortTypePort(transferJobEndpoint);
                ManagedExecutableJobHome.getHome().enableLocalTransport((Stub)transferJobPort);
                this.setStagingStubSecurity(resource, (Stub)transferJobPort);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getLoggingPrefix(resource) + "polling for transfer job status."));
                }
                GetResourcePropertyResponse response = transferJobPort.getResourceProperty(RFTConstants.REQUEST_STATUS_RESOURCE);
                MessageElement[] any = response.get_any();
                RequestStatusType status = (RequestStatusType)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$globus$rft$generated$RequestStatusType == null ? (class$org$globus$rft$generated$RequestStatusType = WSStagingHelper.class$("org.globus.rft.generated.RequestStatusType")) : class$org$globus$rft$generated$RequestStatusType));
                return status;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"unable to poll for transfer job status", (Throwable)e);
        }
        return null;
    }

    private void setStagingStubSecurity(ManagedExecutableJobResource resource, Stub stub) throws RemoteException {
        String errorMessage;
        FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
        String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
        String securityType = "org.globus.security.transport.type";
        if (wsTransportProtocol == null) {
            wsTransportProtocol = "local";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Transport Protocol: " + wsTransportProtocol));
        }
        if (wsTransportProtocol.equals("http") || wsTransportProtocol.equals("local")) {
            securityType = "org.globus.security.secMsg.msg.type";
        }
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        if (securityType.equals("org.globus.security.secMsg.msg.type")) {
            secDesc.setGSISecureMsg(GSIConstants.SIGNATURE);
        } else {
            secDesc.setGSITransport(GSIConstants.SIGNATURE);
        }
        DelegatedCredential stagingCredential = null;
        try {
            stagingCredential = resource.getStagingCredential();
        }
        catch (Exception e) {
            errorMessage = i18n.getMessage("CredentialAcquisitionError");
            FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = WSStagingHelper.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
            resource.setFault(fault);
        }
        if (stagingCredential == null) {
            String errorMessage2 = i18n.getMessage("MissingStagingCredential");
            throw new RemoteException(errorMessage2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Delegated Staging Credential Object: " + stagingCredential.toString()));
            try {
                logger.debug((Object)(this.getLoggingPrefix(resource) + "Using proxy with subject " + stagingCredential.getCredential().getIdentity() + "to contact the staging service"));
            }
            catch (Exception e) {
                errorMessage = i18n.getMessage("ProxySubjectError");
                logger.error((Object)errorMessage);
            }
        }
        try {
            secDesc.setGSSCredential((GSSCredential)new GlobusGSSCredentialImpl(stagingCredential.getCredential(), 0));
        }
        catch (Exception e) {
            errorMessage = i18n.getMessage("GlobusCredentialToGSSError");
            throw new RemoteException(errorMessage, e);
        }
        String stagingSubject = factoryHomeConfiguration.getStagingSubject();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Using RFT Authorization subject " + stagingSubject));
        }
        logger.debug((Object)(this.getLoggingPrefix(resource) + "Staging Subject: -->" + stagingSubject + "<--"));
        if (stagingSubject != null && !stagingSubject.equals("")) {
            secDesc.setAuthz((Authorization)new IdentityAuthorization(stagingSubject));
        } else {
            ContainerSecurityConfig containerSecurityConfig = null;
            ContainerSecurityDescriptor containerSecurityDescriptor = null;
            Subject containerSubject = null;
            Set<Principal> principals = null;
            try {
                containerSecurityConfig = ContainerSecurityConfig.getConfig();
                containerSecurityDescriptor = containerSecurityConfig.getSecurityDescriptor();
                containerSubject = containerSecurityDescriptor.getSubject();
                if (containerSubject != null) {
                    principals = containerSubject.getPrincipals();
                }
            }
            catch (Exception e) {
                String errorMessage3 = i18n.getMessage("CredentialConfigurationError");
                throw new RuntimeException(errorMessage3);
            }
            if (containerSubject != null) {
                if (containerSecurityConfig.getSecurityDescriptorFile() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Using default creds. Assume identity authz");
                    }
                    secDesc.setAuthz((Authorization)new IdentityAuthorization(((Object)principals.iterator().next()).toString()));
                } else if (containerSecurityDescriptor.getProxyFilename() != null) {
                    logger.debug((Object)"Found proxy file configuration");
                    secDesc.setAuthz((Authorization)new IdentityAuthorization(((Object)principals.iterator().next()).toString()));
                } else if (containerSecurityDescriptor.getCertFilename() != null && containerSecurityDescriptor.getKeyFilename() != null) {
                    logger.debug((Object)"Found host and cert configuration.");
                    secDesc.setAuthz((Authorization)HostAuthorization.getInstance());
                } else {
                    logger.debug((Object)"No credentials specified, assuming user creds");
                    secDesc.setAuthz((Authorization)new IdentityAuthorization(((Object)principals.iterator().next()).toString()));
                }
            } else {
                String errorMessage4 = i18n.getMessage("CredentialConfigurationError");
                throw new RuntimeException(errorMessage4);
            }
        }
        stub._setProperty("clientDescriptor", (Object)secDesc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

