/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec.utils;

import java.rmi.RemoteException;
import java.util.Calendar;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.service.exec.ManagedExecutableJobResource;
import org.globus.exec.service.exec.StagingListener;
import org.globus.exec.service.exec.utils.LocalInvocationHelper;
import org.globus.exec.service.exec.utils.StagingHelper;
import org.globus.exec.service.utils.DelegatedCredential;
import org.globus.exec.utils.FaultUtils;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.service.ManagedJobHelper;
import org.globus.rft.generated.BaseRequestType;
import org.globus.rft.generated.CreateReliableFileTransferInputType;
import org.globus.rft.generated.CreateReliableFileTransferOutputType;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.RequestStatusType;
import org.globus.rft.generated.Start;
import org.globus.rft.generated.StartOutputType;
import org.globus.rft.generated.TransferRequestType;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;

public class LocalStagingHelper
extends StagingHelper {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$exec$utils$LocalStagingHelper == null ? (class$org$globus$exec$service$exec$utils$LocalStagingHelper = LocalStagingHelper.class$("org.globus.exec.service.exec.utils.LocalStagingHelper")) : class$org$globus$exec$service$exec$utils$LocalStagingHelper).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = LocalStagingHelper.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    static /* synthetic */ Class class$org$globus$exec$service$exec$utils$LocalStagingHelper;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$rft$generated$RequestStatusType;
    static /* synthetic */ Class class$org$globus$exec$generated$FaultType;

    public EndpointReferenceType submitStagingRequest(ManagedExecutableJobResource resource, BaseRequestType stagingRequest) throws Exception {
        logger.trace((Object)(this.getLoggingPrefix(resource) + "Entering sumbitStagingRequest()"));
        this.checkForCredential(resource);
        CreateReliableFileTransferInputType createInput = new CreateReliableFileTransferInputType();
        if (stagingRequest instanceof TransferRequestType) {
            createInput.setTransferRequest((TransferRequestType)stagingRequest);
        } else {
            createInput.setDeleteRequest((DeleteRequestType)stagingRequest);
        }
        Calendar terminationTime = Calendar.getInstance();
        terminationTime.add(10, 12);
        createInput.setInitialTerminationTime(terminationTime);
        logger.debug((Object)"creating RFT resource");
        CreateReliableFileTransferOutputType createOutput = (CreateReliableFileTransferOutputType)LocalInvocationHelper.getInstance().callService("ReliableFileTransferFactoryService", "createReliableFileTransfer", (String)resource.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT), new Object[]{createInput}, null);
        EndpointReferenceType transferJobEndpoint = createOutput.getReliableTransferEPR();
        logger.debug((Object)"created RFT resource");
        StartOutputType startResponse = this.startTransferJob(resource, transferJobEndpoint);
        logger.debug((Object)(this.getLoggingPrefix(resource) + "Leaving sumbitStagingRequest()"));
        return transferJobEndpoint;
    }

    public StartOutputType startTransferJob(ManagedExecutableJobResource resource, EndpointReferenceType transferJobEndpoint) throws Exception {
        logger.trace((Object)(this.getLoggingPrefix(resource) + "Entering startTransferJob()"));
        this.checkForCredential(resource);
        StagingListener.registerTransferJob(transferJobEndpoint, (ResourceKey)resource.getID());
        Subscribe subscriptionRequest = new Subscribe();
        TopicExpressionType topicExpression = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)RFTConstants.REQUEST_STATUS_RESOURCE);
        subscriptionRequest.setTopicExpression(topicExpression);
        logger.debug((Object)"subscribing for state changes of RFT resource");
        EndpointReferenceType subscriptionEndpoint = LocalInvocationHelper.getInstance().subscribe("ReliableFileTransferService", ManagedJobHelper.getResourceKey((EndpointReferenceType)transferJobEndpoint), (String)resource.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT), subscriptionRequest, StagingListener.getInstance());
        logger.debug((Object)"subscribed for state changes of RFT resource");
        resource.setResourceDatum("subscriptionEndpoint", subscriptionEndpoint);
        logger.debug((Object)"starting transfer");
        StartOutputType startResponse = (StartOutputType)LocalInvocationHelper.getInstance().callService("ReliableFileTransferService", "start", (String)resource.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT), new Object[]{new Start()}, ManagedJobHelper.getResourceKey((EndpointReferenceType)transferJobEndpoint));
        logger.debug((Object)"started transfer");
        return startResponse;
    }

    public void destroyTransferJob(ManagedExecutableJobResource resource, EndpointReferenceType transferJobEndpoint) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Entering destroyTransferJob()"));
        }
        this.checkForCredential(resource);
        EndpointReferenceType subscriptionEndpoint = (EndpointReferenceType)resource.getResourceDatum("subscriptionEndpoint");
        if (subscriptionEndpoint != null) {
            resource.setResourceDatum("subscriptionEndpoint", null);
            logger.debug((Object)"destroying subscription resource");
            LocalInvocationHelper.getInstance().destroyResource("SubscriptionManagerService", ManagedJobHelper.getResourceKey((EndpointReferenceType)subscriptionEndpoint), (String)resource.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT));
            logger.debug((Object)"destroyed subscription resource");
        }
        if (transferJobEndpoint != null) {
            StagingListener.unregisterTransferJob(transferJobEndpoint);
            logger.debug((Object)"destroying rft resource");
            LocalInvocationHelper.getInstance().destroyResource("ReliableFileTransferService", ManagedJobHelper.getResourceKey((EndpointReferenceType)transferJobEndpoint), (String)resource.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT));
            logger.debug((Object)"destroyed rft resource");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Leaving destroyTransferJob()"));
        }
    }

    public RequestStatusType poll(ManagedExecutableJobResource resource, EndpointReferenceType transferJobEndpoint) {
        RequestStatusType requestStatus;
        block9: {
            GetResourcePropertyResponse response = null;
            requestStatus = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getLoggingPrefix(resource) + "Entering poll()"));
            }
            try {
                this.checkForCredential(resource);
                if (transferJobEndpoint == null) break block9;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getLoggingPrefix(resource) + "polling for transfer job status."));
                }
                response = LocalInvocationHelper.getInstance().getResourceProperty("ReliableFileTransferService", ManagedJobHelper.getResourceKey((EndpointReferenceType)transferJobEndpoint), RFTConstants.REQUEST_STATUS_RESOURCE, (String)resource.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT));
                MessageElement[] any = response.get_any();
                try {
                    requestStatus = (RequestStatusType)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$globus$rft$generated$RequestStatusType == null ? (class$org$globus$rft$generated$RequestStatusType = LocalStagingHelper.class$("org.globus.rft.generated.RequestStatusType")) : class$org$globus$rft$generated$RequestStatusType));
                }
                catch (Exception e) {
                    try {
                        requestStatus = (RequestStatusType)any[0].getObjectValue(class$org$globus$rft$generated$RequestStatusType == null ? (class$org$globus$rft$generated$RequestStatusType = LocalStagingHelper.class$("org.globus.rft.generated.RequestStatusType")) : class$org$globus$rft$generated$RequestStatusType);
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Polling for requestStatus of transfer resource failed: " + ex.toString()));
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"unable to poll for transfer job status", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getLoggingPrefix(resource) + "Leaving poll()"));
        }
        return requestStatus;
    }

    private void checkForCredential(ManagedExecutableJobResource resource) throws RemoteException {
        DelegatedCredential stagingCredential = null;
        try {
            stagingCredential = resource.getStagingCredential();
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("CredentialAcquisitionError");
            FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = LocalStagingHelper.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
            resource.setFault(fault);
        }
        if (stagingCredential == null) {
            String errorMessage = i18n.getMessage("MissingStagingCredential");
            throw new RemoteException(errorMessage);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

