/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.types.UnsignedShort;
import org.apache.axis.utils.XMLUtils;
import org.globus.exec.generated.FileSystemMapType;
import org.globus.exec.generated.FileSystemPathMappingType;
import org.globus.exec.generated.FtpServerType;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.encoding.SerializationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileMappingConfig {
    private Document doc;
    private File path;
    public static final String DEFAULT_MAP_FILE = "/etc/gram-service/globus_gram_fs_map_config.xml";
    private static final String GLOBUS_HOSTNAME_EXEC = "/bin/globus-hostname";
    private static Properties env;
    private static final String GRAM_NS = "http://www.globus.org/namespaces/2004/10/gram/job";
    private static final QName MAP_QNAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMappingConfig(File config) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        FileInputStream sourceInput = null;
        try {
            this.path = config;
            sourceInput = new FileInputStream(config);
            this.doc = XMLUtils.newDocument((InputStream)sourceInput);
        }
        finally {
            if (sourceInput != null) {
                sourceInput.close();
            }
        }
    }

    private Node getOldMap(String scheduler) {
        String text;
        Node node;
        int i;
        NodeList oldMapping = this.doc.getElementsByTagName("scheduler");
        int len = oldMapping.getLength();
        for (i = 0; i < len; ++i) {
            node = oldMapping.item(i);
            if (node == null || (text = node.getFirstChild().getNodeValue()) == null || !text.equals(scheduler)) continue;
            return node.getParentNode();
        }
        oldMapping = this.doc.getElementsByTagNameNS(GRAM_NS, "scheduler");
        len = oldMapping.getLength();
        for (i = 0; i < len; ++i) {
            node = oldMapping.item(i);
            if (node == null || (text = node.getFirstChild().getNodeValue()) == null || !text.equals(scheduler)) continue;
            return node.getParentNode();
        }
        return null;
    }

    public void removeMap(String scheduler) throws DOMException {
        Node oldMap;
        do {
            if ((oldMap = this.getOldMap(scheduler)) == null) continue;
            NodeList fileSystemMaps = this.doc.getElementsByTagName("fileSystemMaps");
            fileSystemMaps.item(0).removeChild(oldMap);
        } while (oldMap != null);
    }

    public void addMap(FileSystemMapType map) throws IOException, SerializationException {
        Element newMap = ObjectSerializer.toElement((Object)map, (QName)MAP_QNAME);
        NodeList fileSystemMaps = this.doc.getElementsByTagName("fileSystemMaps");
        fileSystemMaps.item(0).appendChild(this.doc.importNode(newMap, true));
    }

    public void replaceMap(FileSystemMapType map) throws IOException, SerializationException {
        Element newMap = ObjectSerializer.toElement((Object)map, (QName)MAP_QNAME);
        this.removeMap(map.getScheduler());
        NodeList fileSystemMaps = this.doc.getElementsByTagName("fileSystemMaps");
        fileSystemMaps.item(0).appendChild(this.doc.importNode(newMap, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfig() throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(this.path);
            XMLUtils.DocumentToStream((Document)this.doc, (OutputStream)stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static void usage() {
        System.out.println("Usage: FileMappingConfig -scheduler SCHEDULER [options]\nRequired Parameters:\n    -scheduler SCHEDULER                Add mapping for named scheduler\nOptions:\n    -file MAPPING-FILE                  Modify MAPPING-FILE instead\n                                        of default\n    -ftpServerHost HOST                 Host name of FTP server\n    -ftpServerPort PORT                 Port number of FTP server [2811]\n    -ftpProtocol PROTOCOL               Protocol (ftp or gsiftp) [gsiftp]\n    -mapping JOB_PATH FTP_PATH          Add path mapping for JOB_PATH to FTP_PATH\n    -help                               Print this message\n    -debug                              Print stack trace when exceptions occur\n");
    }

    private static void loadEnvironment() throws IOException {
        Runtime r = Runtime.getRuntime();
        Process envProc = r.exec("/usr/bin/env");
        env = new Properties();
        env.load(envProc.getInputStream());
    }

    private static String getHostName() throws IOException {
        Runtime r = Runtime.getRuntime();
        if (env == null) {
            FileMappingConfig.loadEnvironment();
        }
        Process globusHostname = r.exec(env.getProperty("GLOBUS_LOCATION") + GLOBUS_HOSTNAME_EXEC);
        BufferedReader input = new BufferedReader(new InputStreamReader(globusHostname.getInputStream()));
        String hostname = input.readLine();
        input.close();
        return hostname;
    }

    public static void main(String[] args) {
        block14: {
            boolean debug = true;
            try {
                FileSystemMapType schedulerMap = new FileSystemMapType();
                FileMappingConfig.loadEnvironment();
                File mappingFile = new File(env.getProperty("GLOBUS_LOCATION") + DEFAULT_MAP_FILE);
                FtpServerType ftp = new FtpServerType();
                ftp.setProtocol("gsiftp");
                ftp.setHost(FileMappingConfig.getHostName());
                ftp.setPort(new UnsignedShort(2811L));
                schedulerMap.setFtpServer(ftp);
                Vector<FileSystemPathMappingType> mappings = new Vector<FileSystemPathMappingType>();
                debug = false;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-scheduler") && i + 1 < args.length) {
                        schedulerMap.setScheduler(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-file") && i + 1 < args.length) {
                        mappingFile = new File(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-ftpServerHost") && i + 1 < args.length) {
                        schedulerMap.getFtpServer().setHost(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-ftpServerPort") && i + 1 < args.length) {
                        schedulerMap.getFtpServer().setPort(new UnsignedShort(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-ftpProtocol") && i + 1 < args.length) {
                        if (args[++i].equals("ftp") || args[i].equals("gsiftp")) {
                            schedulerMap.getFtpServer().setProtocol(args[i]);
                            continue;
                        }
                        System.err.println("Unknown protocol: " + args[i]);
                        System.exit(1);
                        continue;
                    }
                    if (args[i].equals("-mapping") && i + 2 < args.length) {
                        mappings.add(new FileSystemPathMappingType(args[++i], args[++i]));
                        continue;
                    }
                    if (args[i].equals("-debug")) {
                        debug = true;
                        continue;
                    }
                    if (args[i].equals("-help")) {
                        FileMappingConfig.usage();
                        System.exit(0);
                        continue;
                    }
                    System.err.println("Unknown option: " + args[i] + "\n");
                    FileMappingConfig.usage();
                    System.exit(1);
                }
                if (schedulerMap.getScheduler() == null) {
                    System.err.println("Missing required parameter -scheduler\n");
                    FileMappingConfig.usage();
                    System.exit(1);
                }
                if (mappings.isEmpty()) {
                    mappings.add(new FileSystemPathMappingType("/", "/"));
                }
                schedulerMap.setMapping(mappings.toArray(new FileSystemPathMappingType[0]));
                FileMappingConfig c = new FileMappingConfig(mappingFile);
                c.replaceMap(schedulerMap);
                c.writeConfig();
            }
            catch (Exception e) {
                System.err.println("Unable to update map file" + e.toString());
                if (!debug) break block14;
                e.printStackTrace();
            }
        }
    }

    static {
        MAP_QNAME = new QName(GRAM_NS, "map");
    }
}

