/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.FileSystemMapType;
import org.globus.exec.generated.FileSystemMapsType;
import org.globus.exec.generated.FileSystemPathMappingType;
import org.globus.exec.generated.FtpServerType;
import org.globus.exec.service.exec.utils.FileMappingException;
import org.globus.util.GlobusURL;
import org.globus.util.I18n;
import org.globus.wsrf.encoding.ObjectDeserializationContext;
import org.xml.sax.InputSource;

public class FileMapping {
    static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = FileMapping.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$exec$utils$FileMapping == null ? (class$org$globus$exec$service$exec$utils$FileMapping = FileMapping.class$("org.globus.exec.service.exec.utils.FileMapping")) : class$org$globus$exec$service$exec$utils$FileMapping).getName());
    private FileSystemMapType map;
    public static final String FILE_MAP_CONFIG_FILE = "globus_gram_fs_map_config.xml";
    private static final String URL_ENCODING = "UTF-8";
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$exec$service$exec$utils$FileMapping;
    static /* synthetic */ Class class$org$globus$exec$generated$FileSystemMapsType;

    /*
     * Loose catch block
     */
    public FileMapping(String fileName, String manager) throws FileMappingException {
        block12: {
            FileInputStream in = null;
            in = new FileInputStream(fileName);
            ObjectDeserializationContext deserializer = new ObjectDeserializationContext(new InputSource(in), class$org$globus$exec$generated$FileSystemMapsType == null ? (class$org$globus$exec$generated$FileSystemMapsType = FileMapping.class$("org.globus.exec.generated.FileSystemMapsType")) : class$org$globus$exec$generated$FileSystemMapsType);
            deserializer.parse();
            FileSystemMapsType maps = (FileSystemMapsType)deserializer.getValue();
            FileSystemMapType[] map_array = maps.getMap();
            if (map_array == null) {
                String errorMessage = i18n.getMessage("FileMapConfigEmpty", (Object)fileName);
                throw new RuntimeException(errorMessage);
            }
            for (int i = 0; i < map_array.length; ++i) {
                if (!map_array[i].getScheduler().equals(manager)) continue;
                this.map = map_array[i];
                break;
            }
            Object var9_11 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block12;
            }
            catch (IOException ioe) {
                logger.warn((Object)ioe);
            }
            break block12;
            {
                catch (Exception e) {
                    String errorMessage = i18n.getMessage("FileMapInitFailed");
                    throw new FileMappingException(errorMessage, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    logger.warn((Object)ioe);
                }
                throw throwable;
            }
        }
        if (this.map == null) {
            String errorMessage = i18n.getMessage("NoFileMappingsForResourceManager", (Object)manager);
            throw new FileMappingException(errorMessage);
        }
    }

    public String mapFileName(GlobusURL url) throws FileMappingException {
        String path = url.getPath();
        if (path == null) {
            path = "/";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapping filename " + path));
        }
        try {
            path = URLDecoder.decode(path, URL_ENCODING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int length = path.length();
        if (length < 2 || !Character.isLetter(path.charAt(0)) || path.charAt(1) != ':') {
            for (int i = 0; i < length; ++i) {
                if (path.charAt(i) == '/') continue;
                path = "/" + path.substring(i);
                break;
            }
        }
        FtpServerType ftpServer = this.map.getFtpServer();
        String protocol = ftpServer.getProtocol();
        String host = ftpServer.getHost();
        int port = ftpServer.getPort().intValue();
        FileSystemPathMappingType[] mapping = this.map.getMapping();
        int prefixLength = 0;
        String prefix = null;
        String replacement = null;
        logger.debug((Object)("Mapping length is " + Integer.toString(mapping.length)));
        for (int i = 0; i < mapping.length; ++i) {
            String tmp = mapping[i].getJobPath();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Comparing `" + tmp + "' to beginning of `" + path + "'."));
            }
            if (tmp.length() <= prefixLength || !path.startsWith(tmp)) continue;
            prefix = tmp;
            prefixLength = tmp.length();
            replacement = mapping[i].getFtpPath();
        }
        if (prefix != null) {
            StringBuffer result = new StringBuffer();
            result.append(protocol);
            result.append("://");
            result.append(ftpServer.getHost());
            result.append(":");
            result.append(ftpServer.getPort());
            if (!replacement.startsWith("/")) {
                result.append('/');
            }
            result.append(replacement);
            if (replacement.length() >= 2 && Character.isLetter(replacement.charAt(0)) && replacement.charAt(1) == ':') {
                if (!replacement.endsWith("\\") && !path.substring(prefixLength).startsWith("\\")) {
                    result.append('\\');
                }
            } else if (!replacement.endsWith("/") && !path.substring(prefixLength).startsWith("/")) {
                result.append('/');
            }
            result.append(path.substring(prefixLength));
            String resultString = result.toString();
            try {
                resultString = resultString.replaceAll("\\\\", "%5C");
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("SlashConversionFailed", (Object)path);
                throw new FileMappingException(errorMessage, e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result of mapping `" + path + "' is `" + resultString + "'"));
            }
            return resultString;
        }
        String errorMessage = i18n.getMessage("NoFileMappingForPath", (Object)path);
        throw new FileMappingException(errorMessage);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

