/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.PositiveInteger;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.InternalStateEnumeration;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.JobIdStatePairType;
import org.globus.exec.generated.JobTypeEnumeration;
import org.globus.exec.generated.ManagedExecutableJobResourceDataType;
import org.globus.exec.generated.ScriptCommandEnumeration;
import org.globus.exec.generated.ServiceLevelAgreementFaultType;
import org.globus.exec.generated.ServiceLevelAgreementType;
import org.globus.exec.generated.StagingFaultType;
import org.globus.exec.generated.StagingTypeEnumeration;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.monitoring.AlreadyRegisteredException;
import org.globus.exec.service.exec.JobManagerScript;
import org.globus.exec.service.exec.ManagedExecutableJobHome;
import org.globus.exec.service.exec.ManagedExecutableJobResource;
import org.globus.exec.service.exec.PerlJobDescription;
import org.globus.exec.service.exec.RunQueue;
import org.globus.exec.service.exec.StagingListener;
import org.globus.exec.service.exec.utils.FileMapping;
import org.globus.exec.service.exec.utils.LocalStagingHelper;
import org.globus.exec.service.exec.utils.StagingHelper;
import org.globus.exec.service.exec.utils.WSStagingHelper;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.FactoryServiceConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.factory.ManagedJobFactoryResource;
import org.globus.exec.service.factory.ManagedJobFactoryService;
import org.globus.exec.service.usage.GramUsageMonitorPacket;
import org.globus.exec.service.utils.AuditDatabaseConfiguration;
import org.globus.exec.utils.FaultUtils;
import org.globus.exec.utils.ManagedExecutableJobConstants;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.exec.utils.audit.AuditDatabaseAppender;
import org.globus.exec.utils.audit.AuditUtil;
import org.globus.exec.utils.service.ManagedJobHelper;
import org.globus.rft.generated.BaseRequestType;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.RepeatedlyStartedFaultType;
import org.globus.rft.generated.RequestStatusType;
import org.globus.rft.generated.RequestStatusTypeEnumeration;
import org.globus.rft.generated.TransferRequestType;
import org.globus.util.GlobusURL;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.container.UsageConfig;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.PerformanceLog;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsrf.faults.BaseFaultType;
import org.w3c.dom.Element;

public class StateMachine {
    static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = StateMachine.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$service$exec$StateMachine == null ? (class$org$globus$exec$service$exec$StateMachine = StateMachine.class$("org.globus.exec.service.exec.StateMachine")) : class$org$globus$exec$service$exec$StateMachine));
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$exec$StateMachine == null ? (class$org$globus$exec$service$exec$StateMachine = StateMachine.class$("org.globus.exec.service.exec.StateMachine")) : class$org$globus$exec$service$exec$StateMachine).getName() + ".performance");
    private static Log auditLogger = LogFactory.getLog((String)((class$org$globus$exec$service$exec$StateMachine == null ? (class$org$globus$exec$service$exec$StateMachine = StateMachine.class$("org.globus.exec.service.exec.StateMachine")) : class$org$globus$exec$service$exec$StateMachine).getName() + ".audit"));
    private static UsageConfig usageConfig;
    private static StagingHelper stagingHelper;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$exec$service$exec$StateMachine;
    static /* synthetic */ Class class$org$globus$exec$service$exec$ManagedExecutableJobResource;
    static /* synthetic */ Class class$org$globus$exec$generated$FaultType;

    private StateMachine() {
    }

    static void init() {
        usageConfig = UsageConfig.getUsageConfig();
        FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
        boolean localInvocations = new Boolean(factoryHomeConfiguration.getEnableLocalInvocations());
        logger.debug((Object)("local invocations: " + localInvocations));
        stagingHelper = localInvocations ? new LocalStagingHelper() : new WSStagingHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processState(ResourceKey resourceKey) throws ResourceException {
        if (logger.isTraceEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Entering processState()"));
        }
        if (logger.isTraceEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Finding resource reference for key " + resourceKey.toString()));
        }
        ManagedExecutableJobResource resource = null;
        ManagedExecutableJobHome home = null;
        try {
            home = ManagedExecutableJobHome.getHome();
            resource = home.unsyncFind(resourceKey);
        }
        catch (ResourceException re) {
            String errorMessage = i18n.getMessage("ResourceFindError", (Object[])new String[]{resourceKey.getValue().toString()});
            logger.debug((Object)errorMessage);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Found resource reference for key " + resourceKey.toString()));
        }
        Object object = resource.getStateTransitionMutex();
        synchronized (object) {
            InternalStateEnumeration internalState = resource.getInternalState();
            StateEnumeration state = resource.getState();
            if (!internalState.equals((Object)InternalStateEnumeration.Restart) && (state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Ignoring processState() since job is done"));
                }
                return;
            }
            boolean canceled = (Boolean)resource.getResourceDatum("canceled");
            boolean userCancelRequested = (Boolean)resource.getResourceDatum("userCancelRequested");
            boolean systemCancelRequested = (Boolean)resource.getResourceDatum("systemCancelRequested");
            if (!canceled && (userCancelRequested || systemCancelRequested)) {
                if (internalState.equals((Object)InternalStateEnumeration.Done) || internalState.equals((Object)InternalStateEnumeration.Failed)) {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Ignoring cancel request for terminal state " + internalState));
                } else if (internalState.equals((Object)InternalStateEnumeration.FileCleanUp) || internalState.equals((Object)InternalStateEnumeration.FileCleanUpResponse) || internalState.equals((Object)InternalStateEnumeration.FailureFileCleanUp) || internalState.equals((Object)InternalStateEnumeration.FailureFileCleanUpResponse)) {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Setting internal state to FailureCacheCleanUp"));
                    resource.setInternalState(InternalStateEnumeration.FailureCacheCleanUp);
                    internalState = InternalStateEnumeration.FailureCacheCleanUp;
                } else if (internalState.equals((Object)InternalStateEnumeration.None) || internalState.equals((Object)InternalStateEnumeration.CacheCleanUp) || internalState.equals((Object)InternalStateEnumeration.FailureCacheCleanUp)) {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Setting internal state to Failed"));
                    resource.setInternalState(InternalStateEnumeration.Failed);
                    internalState = InternalStateEnumeration.Failed;
                } else if (userCancelRequested) {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Setting internal state to UserCancel"));
                    resource.setInternalState(InternalStateEnumeration.UserCancel);
                    internalState = InternalStateEnumeration.UserCancel;
                } else {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Setting internal state to SystemCancel from " + internalState));
                    resource.setInternalState(InternalStateEnumeration.SystemCancel);
                    internalState = InternalStateEnumeration.SystemCancel;
                }
                resource.setResourceDatum("canceled", true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "processing internal state " + internalState));
                StringBuffer logMsg = new StringBuffer("\n------------------------------------------------------").append("\nPROCESSING INTERNAL STATE:  ").append("-- " + internalState + " --").append("\n------------------------------------------------------");
                logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + logMsg.toString()));
            }
            if (StateMachine.isNotifiedJobData(resource)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Handling job process state change"));
                }
                if (!internalState.equals((Object)InternalStateEnumeration.WaitingForStateChanges) && (state.equals((Object)StateEnumeration.StageOut) || state.equals((Object)StateEnumeration.CleanUp) || state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Not waiting for state changes anymore" + "--ignoring."));
                    }
                    StateMachine.removeNotifiedJobData(resource);
                }
            }
            String transitionMethodName = "process" + internalState.toString() + "State";
            Method internalStateTransitionMethod = null;
            try {
                internalStateTransitionMethod = (class$org$globus$exec$service$exec$StateMachine == null ? (class$org$globus$exec$service$exec$StateMachine = StateMachine.class$("org.globus.exec.service.exec.StateMachine")) : class$org$globus$exec$service$exec$StateMachine).getDeclaredMethod(transitionMethodName, class$org$globus$exec$service$exec$ManagedExecutableJobResource == null ? (class$org$globus$exec$service$exec$ManagedExecutableJobResource = StateMachine.class$("org.globus.exec.service.exec.ManagedExecutableJobResource")) : class$org$globus$exec$service$exec$ManagedExecutableJobResource);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("StateTransitionMethodNotFound", (Object)transitionMethodName);
                throw new RuntimeException(errorMessage, e);
            }
            try {
                internalStateTransitionMethod.invoke(null, resource);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("StateTransitionMethodError", (Object)transitionMethodName);
                throw new RuntimeException(errorMessage, e);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resourceKey) + "Leaving processState()"));
        }
    }

    static void userCancel(ManagedExecutableJobResource resource) {
        if (resource.getFault() == null) {
            FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)i18n.getMessage("UserCancel"), null, (StateEnumeration)resource.getState(), null, (int)0);
            resource.setFault(fault);
        } else {
            Exception cause = new Exception(i18n.getMessage("UserCancel"));
            cause.fillInStackTrace();
            logger.error((Object)i18n.getMessage("SecondaryFault"), (Throwable)cause);
        }
        boolean started = (Boolean)resource.getResourceDatum("started");
        StateMachine.cancel(resource, "userCancelRequested", started);
    }

    public static void systemCancel(ManagedExecutableJobResource resource, String errorMessage, Exception cause) {
        FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)cause, (StateEnumeration)resource.getState(), null, (int)0);
        resource.setFault(fault);
        StateMachine.systemCancel(resource);
    }

    static void systemCancel(ManagedExecutableJobResource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("System cancel requested for job " + ((ResourceKey)resource.getID()).getValue()));
            try {
                throw new Exception();
            }
            catch (Exception e) {
                logger.debug((Object)"systemCancel stack trace", (Throwable)e);
            }
        }
        boolean started = (Boolean)resource.getResourceDatum("started");
        StateMachine.cancel(resource, "systemCancelRequested", started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancel(ManagedExecutableJobResource resource, String cancelFlagName, boolean addToRunQueue) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering cancel()");
        }
        Object object = resource.getStateTransitionMutex();
        synchronized (object) {
            boolean canceled = (Boolean)resource.getResourceDatum("canceled");
            if (!canceled) {
                resource.setResourceDatum(cancelFlagName, true);
                if (addToRunQueue) {
                    if (logger.isDebugEnabled()) {
                        logger.trace((Object)"Adding to RunQueue.");
                    }
                    RunQueue.getInstance().add((ResourceKey)resource.getID());
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Leaving cancel()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void localJobStateChanged(ManagedExecutableJobResource resource, String jobId, Date timeStamp, StateEnumeration state, int exitCode) {
        Object object = resource.getStateTransitionMutex();
        synchronized (object) {
            StateMachine.insertNotifiedJobData(resource, jobId, state);
            resource.setResourceProperty(ManagedExecutableJobConstants.RP_EXIT_CODE, new Integer(exitCode));
            if (logger.isDebugEnabled()) {
                logger.trace((Object)"Adding to RunQueue.");
            }
            RunQueue.getInstance().add((ResourceKey)resource.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void release(ManagedExecutableJobResource resource) {
        Object object = resource.getStateTransitionMutex();
        synchronized (object) {
            boolean holding = (Boolean)resource.getResourceProperty(ManagedJobConstants.RP_HOLDING);
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
            resource.setResourceDatum("holdState", null);
            if (holding) {
                if (logger.isDebugEnabled()) {
                    logger.trace((Object)"Adding to RunQueue.");
                }
                RunQueue.getInstance().add((ResourceKey)resource.getID());
            }
        }
    }

    private static void processUnsubmittedHoldState(ManagedExecutableJobResource resource) {
        StateEnumeration state = resource.getState();
        resource.setFault((FaultType)FaultUtils.createUnsupportedFeatureFault((String)"Unsubmitted", (String)"holdState", (StateEnumeration)state, null, (int)-1, (ResourceKey)((ResourceKey)resource.getID())));
        resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
        StateMachine.systemCancel(resource);
    }

    private static void processNoneState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        resource.setResourceDatum("started", new Boolean(true));
        StateEnumeration holdState = (StateEnumeration)resource.getResourceDatum("holdState");
        if (holdState != null && holdState.equals((Object)StateEnumeration.Unsubmitted)) {
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.UnsubmittedHold, true);
            performanceLogger.stop("processNoneState");
            return;
        }
        StateMachine.processNewState(resource, InternalStateEnumeration.Start, true);
        performanceLogger.stop("processNoneState");
    }

    private static void processStartState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        try {
            StateMachine.logJobAccepted(resource);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to log accepted job message.");
        }
        JobDescriptionType jobDescription = resource.getJobDescription();
        TransferRequestType fileStageIn = jobDescription.getFileStageIn();
        StateEnumeration holdState = jobDescription.getHoldState();
        if (fileStageIn != null || holdState != null && holdState.equals(StateEnumeration.StageIn)) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Not skipping StageIn"));
            StateMachine.processNewState(resource, InternalStateEnumeration.StageIn, true);
        } else {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Skipping StageIn and going straight to Submit"));
            StateMachine.processNewState(resource, InternalStateEnumeration.Submit, true);
        }
        StateMachine.logAuditRecord(true, resource, false, false);
        performanceLogger.stop("processStartState");
    }

    private static void processRestartState(ManagedExecutableJobResource resource) {
        InternalStateEnumeration restartInternalState;
        block20: {
            FaultType fault;
            String errorMessage;
            StateEnumeration state;
            JobDescriptionType jobDescription;
            block19: {
                String[] job_ids;
                logger.debug((Object)"Entering processRestartState()");
                restartInternalState = (InternalStateEnumeration)resource.getResourceDatum("restartInternalState");
                EndpointReferenceType cleanUpEndpoint = (EndpointReferenceType)resource.getResourceDatum("cleanUpEndpoint");
                EndpointReferenceType stageOutEndpoint = (EndpointReferenceType)resource.getResourceDatum("stageOutEndpoint");
                EndpointReferenceType stageInEndpoint = (EndpointReferenceType)resource.getResourceDatum("stageInEndpoint");
                EndpointReferenceType transferJobEndpoint = null;
                if (cleanUpEndpoint != null && (restartInternalState.equals((Object)InternalStateEnumeration.FileCleanUp) || restartInternalState.equals((Object)InternalStateEnumeration.FileCleanUpResponse))) {
                    transferJobEndpoint = cleanUpEndpoint;
                } else if (stageOutEndpoint != null && (restartInternalState.equals((Object)InternalStateEnumeration.StageOut) || restartInternalState.equals((Object)InternalStateEnumeration.StageOutResponse))) {
                    transferJobEndpoint = stageOutEndpoint;
                } else if (stageInEndpoint != null && (restartInternalState.equals((Object)InternalStateEnumeration.StageIn) || restartInternalState.equals((Object)InternalStateEnumeration.StageInResponse))) {
                    transferJobEndpoint = stageInEndpoint;
                }
                if (transferJobEndpoint != null) {
                    try {
                        logger.debug((Object)"attempting to start recovered transfer job");
                        stagingHelper.startTransferJob(resource, transferJobEndpoint);
                    }
                    catch (RepeatedlyStartedFaultType rsft) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "ignoring RepeatedlyStartedFaultType from RFT"));
                        }
                    }
                    catch (Exception e) {
                        StagingTypeEnumeration stagingType = null;
                        stagingType = restartInternalState.equals((Object)InternalStateEnumeration.StageIn) || restartInternalState.equals((Object)InternalStateEnumeration.StageInResponse) ? StagingTypeEnumeration.StageIn : (restartInternalState.equals((Object)InternalStateEnumeration.StageOut) || restartInternalState.equals((Object)InternalStateEnumeration.StageOutResponse) ? StagingTypeEnumeration.StageOut : StagingTypeEnumeration.CleanUp);
                        resource.setFault(StateMachine.createStagingFault(resource, stagingType, e));
                        logger.trace((Object)(StateMachine.getLoggingPrefix(resource) + "calling systemCancel()"));
                        StateMachine.systemCancel(resource);
                    }
                }
                if ((job_ids = (String[])resource.getResourceDatum("localJobId")) != null) {
                    try {
                        StateMachine.subscribeAtJobStateMonitor(resource);
                    }
                    catch (AlreadyRegisteredException e) {
                        String errorMessage2 = i18n.getMessage("JobIdRegistrationError");
                        logger.warn((Object)("Register attempt failed for job " + ((ResourceKey)resource.getID()).getValue()));
                        StateMachine.systemCancel(resource, errorMessage2, (Exception)((Object)e));
                        return;
                    }
                }
                String localUserId = (String)resource.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID);
                File userGlobusDirectory = ManagedExecutableJobResource.getUserGlobusDirectory(localUserId);
                jobDescription = resource.getJobDescription();
                if (jobDescription.getJobCredentialEndpoint() != null) {
                    try {
                        resource.getJobCredential(userGlobusDirectory);
                    }
                    catch (Exception e) {
                        state = resource.getState();
                        if (state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) break block19;
                        errorMessage = i18n.getMessage("CredentialAcquisitionError");
                        fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
                        resource.setFault(fault);
                        StateMachine.systemCancel(resource);
                    }
                }
            }
            if (jobDescription.getStagingCredentialEndpoint() != null) {
                try {
                    resource.getStagingCredential();
                }
                catch (Exception e) {
                    state = resource.getState();
                    if (state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) break block20;
                    errorMessage = i18n.getMessage("CredentialAcquisitionError");
                    fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
                    resource.setFault(fault);
                    StateMachine.systemCancel(resource);
                }
            }
        }
        logger.debug((Object)("processRestartState with restartInternalState == " + restartInternalState.toString()));
        StateMachine.processNewState(resource, restartInternalState, true);
        logger.debug((Object)"Leaving processRestartState()");
    }

    private static void processStageInHoldState(ManagedExecutableJobResource resource) {
        boolean holding = (Boolean)resource.getResourceProperty(ManagedJobConstants.RP_HOLDING);
        if (!holding) {
            StateMachine.processNewState(resource, InternalStateEnumeration.StageIn, true);
        } else {
            JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
            if (jobDescription.getFileStageIn() == null) {
                resource.setFault(StateMachine.createStagingHoldFault(resource, StagingTypeEnumeration.StageIn));
                resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
                StateMachine.systemCancel(resource);
                return;
            }
            try {
                resource.setState(StateEnumeration.StageIn);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
                throw new RuntimeException(errorMessage, e);
            }
        }
    }

    private static void processStageInState(ManagedExecutableJobResource resource) {
        StateEnumeration holdState;
        performanceLogger.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Entering processStageInState()"));
        }
        if ((holdState = (StateEnumeration)resource.getResourceDatum("holdState")) != null && holdState.equals((Object)StateEnumeration.StageIn)) {
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.StageInHold, true);
            return;
        }
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        TransferRequestType fileStageIn = jobDescription.getFileStageIn();
        boolean staging = false;
        if (fileStageIn != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Processing fileStageIn directives."));
            }
            staging = true;
            logger.trace((Object)(StateMachine.getLoggingPrefix(resource) + "calling MEJR.setState()"));
            try {
                resource.setState(StateEnumeration.StageIn);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
                throw new RuntimeException(errorMessage, e);
            }
            try {
                logger.trace((Object)(StateMachine.getLoggingPrefix(resource) + "calling StagingHelper.submitStagingRequest()"));
                EndpointReferenceType stageInEndpoint = stagingHelper.submitStagingRequest(resource, (BaseRequestType)fileStageIn);
                resource.setResourceDatum("stageInEndpoint", stageInEndpoint);
                logger.trace((Object)(StateMachine.getLoggingPrefix(resource) + "calling MEJR.setResourceDatum()"));
            }
            catch (Exception e) {
                resource.setFault(StateMachine.createStagingFault(resource, StagingTypeEnumeration.StageIn, e));
                logger.trace((Object)(StateMachine.getLoggingPrefix(resource) + "calling systemCancel()"));
                StateMachine.systemCancel(resource);
                performanceLogger.stop("processStageInState");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Leaving processStageInState()"));
                }
                return;
            }
        }
        if (staging) {
            logger.trace((Object)(StateMachine.getLoggingPrefix(resource) + "calling processNewState(StageInResponse)"));
            StateMachine.processNewState(resource, InternalStateEnumeration.StageInResponse, false);
        } else {
            logger.trace((Object)(StateMachine.getLoggingPrefix(resource) + "calling processNewState(Submit)"));
            StateMachine.processNewState(resource, InternalStateEnumeration.Submit, true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Leaving processStageInState()"));
        }
        performanceLogger.stop("processStageInState");
    }

    private static void processStageInResponseState(ManagedExecutableJobResource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering processStageInResponseState()");
        }
        try {
            String source = null;
            String destination = null;
            String attribute = "fileStageIn";
            StateEnumeration state = (StateEnumeration)resource.getResourceProperty(ManagedJobConstants.RP_STATE);
            EndpointReferenceType transferJobEndpoint = (EndpointReferenceType)resource.getResourceDatum("stageInEndpoint");
            if (transferJobEndpoint == null) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)"Missing transfer job endpoint. Continuing...");
                }
                StateMachine.processNewState(resource, InternalStateEnumeration.Submit, true);
                return;
            }
            RequestStatusType status = StagingListener.getNextStatus(transferJobEndpoint);
            if (status == null && (status = stagingHelper.poll(resource, transferJobEndpoint)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Missing RFT status. Probably an out-of-order notification.");
                }
                return;
            }
            if (status.getRequestStatus().equals((Object)RequestStatusTypeEnumeration.Failed)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Detected a StageIn transfer failure");
                }
                BaseFaultType transferFault = stagingHelper.getTransferFaultFromRP(status.getFault());
                if (resource.getFault() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"A fault does not exist, so create one.");
                    }
                    StagingFaultType fault = null;
                    fault = transferFault != null ? FaultUtils.createStagingFault(source, destination, (String)attribute, (StateEnumeration)resource.getState(), null, (ResourceKey)((ResourceKey)resource.getID()), (Exception)transferFault) : FaultUtils.createStagingFault(source, destination, (String)attribute, (StateEnumeration)resource.getState(), null, (ResourceKey)((ResourceKey)resource.getID()));
                    resource.setFault((FaultType)fault);
                }
                try {
                    stagingHelper.destroyTransferJob(resource, transferJobEndpoint);
                }
                catch (Exception e) {
                    String errorMessage = i18n.getMessage("RFTDestroyError");
                    logger.error((Object)errorMessage, (Throwable)e);
                }
                StateMachine.systemCancel(resource);
                return;
            }
            if (!StateMachine.processCompletedStagingJob(resource, status, InternalStateEnumeration.Submit, transferJobEndpoint)) {
                StateMachine.systemCancel(resource);
            }
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("StateNotifProcessError");
            logger.error((Object)errorMessage, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving processStageInResponseState()");
        }
    }

    private static void processPendingHoldState(ManagedExecutableJobResource resource) {
        try {
            resource.setState(StateEnumeration.Pending);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
            throw new RuntimeException(errorMessage, e);
        }
        boolean holding = (Boolean)resource.getResourceProperty(ManagedJobConstants.RP_HOLDING);
        if (!holding) {
            StateMachine.processNewState(resource, InternalStateEnumeration.Submit, true);
        }
    }

    private static void processActiveHoldState(ManagedExecutableJobResource resource) {
        resource.setFault((FaultType)FaultUtils.createUnsupportedFeatureFault((String)"Active", (String)"holdState", (StateEnumeration)resource.getState(), null, (int)-1, (ResourceKey)((ResourceKey)resource.getID())));
        resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
        StateMachine.systemCancel(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSubmitState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        StateEnumeration holdState = (StateEnumeration)resource.getResourceDatum("holdState");
        if (holdState != null && holdState.equals((Object)StateEnumeration.Pending)) {
            if (logger.isDebugEnabled()) {
                logger.trace((Object)("Initiating hold on " + holdState));
            }
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.PendingHold, true);
            performanceLogger.stop("processSubmitState");
            return;
        }
        String localResourceManager = (String)resource.getResourceDatum("localResourceManager");
        PerlJobDescription perlJobDescription = resource.getPerlJobDescription();
        if (localResourceManager.equals("Fork")) {
            perlJobDescription.put("useforkstarter", "1");
        }
        perlJobDescription.put("expand_globus_home", "1");
        perlJobDescription.put("expand_globus_location", "1");
        JobManagerScript script = null;
        try {
            script = StateMachine.runScript(resource, ScriptCommandEnumeration.submit);
        }
        catch (Exception e) {
            if (script != null) {
                resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), 0, script.getFailureMessage()));
                StateMachine.systemCancel(resource);
            }
            String errorMessage = i18n.getMessage("ScriptExecutionError");
            FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
            resource.setFault(fault);
            StateMachine.systemCancel(resource);
            return;
        }
        JobManagerScript e = script;
        synchronized (e) {
            while (!script.isDone()) {
                try {
                    script.wait(2000L);
                }
                catch (Exception e2) {
                    String errorMessage = i18n.getMessage("InterruptJobScript", (Object)script.getCommand());
                    logger.error((Object)errorMessage, (Throwable)e2);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.trace((Object)("Done waiting for " + script.getCommand() + " script"));
        }
        StateEnumeration newState = script.getJobState();
        int errorCode = script.getError();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("script return code: " + errorCode));
        }
        if (errorCode != 0) {
            logger.trace((Object)"script return code means error!");
            resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), errorCode, script.getFailureMessage()));
            StateMachine.systemCancel(resource);
        } else if (script.getJobId() == null || script.getJobId().equals("")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"script returned no job ID!");
                logger.trace((Object)"Job Submission Failed");
            }
            resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), 24, script.getFailureMessage()));
            StateMachine.systemCancel(resource);
        } else {
            resource.setResourceDatum("queuedTime", new Date());
            if (holdState != null && holdState.equals((Object)StateEnumeration.Active)) {
                resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
                StateMachine.processNewState(resource, InternalStateEnumeration.ActiveHold, true);
                performanceLogger.stop("processSubmitState");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("script returned job state: " + newState.getValue()));
            }
            if (newState.equals((Object)StateEnumeration.Done)) {
                StateMachine.processNewState(resource, InternalStateEnumeration.MergeStdout, true);
            } else if (newState.equals((Object)StateEnumeration.Failed)) {
                StateMachine.systemCancel(resource);
            } else {
                String localJobId = script.getJobId();
                perlJobDescription.put("jobid", localJobId);
                StateMachine.setLocalJobId(resource, localJobId, newState);
                if (localJobId != null) {
                    try {
                        StateMachine.logJobSubmitted(resource, localJobId);
                    }
                    catch (Exception e3) {
                        logger.error((Object)"Failed to log submitted job message.", (Throwable)e3);
                    }
                }
                logger.debug((Object)("Subscribing job " + resource.getID() + " to SEG events for local " + "job ID " + localJobId));
                try {
                    StateMachine.subscribeAtJobStateMonitor(resource);
                }
                catch (AlreadyRegisteredException e4) {
                    String errorMessage = i18n.getMessage("JobIdRegistrationError");
                    logger.warn((Object)("Register attempt failed for job " + ((ResourceKey)resource.getID()).getValue().toString()));
                    StateMachine.systemCancel(resource, errorMessage, (Exception)((Object)e4));
                    return;
                }
                StateMachine.processNewState(resource, InternalStateEnumeration.WaitingForStateChanges, false);
            }
        }
        StateMachine.logAuditRecord(false, resource, false, false);
        performanceLogger.stop("processSubmitState");
    }

    private static void processOpenStdoutState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        String stdout = jobDescription.getStdout();
        if (stdout != null && !stdout.equals("/dev/null")) {
            String errorMessage;
            String stdoutUrl = null;
            FileMapping fileMapping = null;
            GlobusURL localStdoutUrl = null;
            Exception cause = null;
            try {
                fileMapping = resource.getFileSystemMapping();
                localStdoutUrl = new GlobusURL("file:///" + stdout);
                stdoutUrl = fileMapping.mapFileName(localStdoutUrl);
            }
            catch (MalformedURLException murle) {
                errorMessage = i18n.getMessage("BadOutputtUrl", (Object[])new String[]{"stdout", stdout});
                cause = new Exception(errorMessage, murle);
                cause.fillInStackTrace();
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause != null) {
                if (resource.getFault() != null) {
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"stdout", (StateEnumeration)resource.getState(), null, (int)0, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
                    resource.setFault((FaultType)((Object)fault));
                } else {
                    logger.error((Object)i18n.getMessage("SecondaryFault"), (Throwable)cause);
                }
                StateMachine.systemCancel(resource);
                return;
            }
            logger.trace((Object)("stdout URL " + stdoutUrl));
            try {
                resource.setResourceProperty(ManagedExecutableJobConstants.RP_STDOUT_URL, new URI(stdoutUrl));
            }
            catch (Exception e) {
                if (resource.getFault() != null) {
                    errorMessage = i18n.getMessage("CouldNotSetRP", (Object[])new String[]{ManagedExecutableJobConstants.RP_STDOUT_URL.getLocalPart(), stdoutUrl});
                    cause = new Exception(errorMessage);
                    cause.fillInStackTrace();
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"stdout", (StateEnumeration)resource.getState(), null, (int)0, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
                    resource.setFault((FaultType)((Object)fault));
                } else {
                    logger.error((Object)i18n.getMessage("SecondaryFault"), (Throwable)e);
                }
                StateMachine.systemCancel(resource);
            }
        }
        StateMachine.processNewState(resource, InternalStateEnumeration.OpenStderr, true);
        performanceLogger.stop("processOpenStdoutState");
    }

    private static void processOpenStderrState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        String stderr = jobDescription.getStderr();
        if (stderr != null && !stderr.equals("/dev/null")) {
            String errorMessage;
            String stderrUrl = null;
            FileMapping fileMapping = null;
            GlobusURL localStderrUrl = null;
            Exception cause = null;
            try {
                fileMapping = resource.getFileSystemMapping();
                localStderrUrl = new GlobusURL("file:///" + stderr);
                stderrUrl = fileMapping.mapFileName(localStderrUrl);
            }
            catch (MalformedURLException murle) {
                errorMessage = i18n.getMessage("BadOutputtUrl", (Object[])new String[]{"stderr", stderr});
                cause = new Exception(errorMessage, murle);
                cause.fillInStackTrace();
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause != null) {
                if (resource.getFault() != null) {
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"stderr", (StateEnumeration)resource.getState(), null, (int)0, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
                    resource.setFault((FaultType)((Object)fault));
                    StateMachine.systemCancel(resource);
                } else {
                    logger.error((Object)i18n.getMessage("SecondaryFault"), (Throwable)cause);
                }
                return;
            }
            logger.trace((Object)("stderr URL " + stderrUrl));
            try {
                resource.setResourceProperty(ManagedExecutableJobConstants.RP_STDERR_URL, new URI(stderrUrl));
            }
            catch (Exception e) {
                if (resource.getFault() != null) {
                    errorMessage = i18n.getMessage("CouldNotSetRP", (Object[])new String[]{ManagedExecutableJobConstants.RP_STDERR_URL.getLocalPart(), stderrUrl});
                    cause = new Exception(errorMessage);
                    cause.fillInStackTrace();
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"stderr", (StateEnumeration)resource.getState(), null, (int)0, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
                    resource.setFault((FaultType)((Object)fault));
                    StateMachine.systemCancel(resource);
                } else {
                    logger.error((Object)i18n.getMessage("SecondaryFault"), (Throwable)e);
                }
                return;
            }
        }
        try {
            resource.setState(StateEnumeration.Active);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
            throw new RuntimeException(errorMessage, e);
        }
        StateMachine.processNewState(resource, InternalStateEnumeration.WaitingForStateChanges, false);
        performanceLogger.stop("processOpenStderrState");
    }

    private static void processWaitingForStateChangesState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Entering processWaitingForStateChangesState()");
        }
        if (!StateMachine.isNotifiedJobData(resource)) {
            return;
        }
        StateEnumeration state = resource.getState();
        JobIdStatePairType notifiedJobData = StateMachine.removeNotifiedJobData(resource);
        String localJobId = notifiedJobData.getId();
        StateEnumeration localJobState = notifiedJobData.getState();
        if (localJobState.equals((Object)state)) {
            if (logger.isDebugEnabled()) {
                logger.trace((Object)"Ignoring redendant local job state notifications");
            }
            return;
        }
        String[] localJobIds = (String[])resource.getResourceDatum("localJobId");
        int i = 0;
        boolean jobIdFound = false;
        if (localJobIds != null) {
            for (i = 0; i < localJobIds.length; ++i) {
                if (!localJobId.equals(localJobIds[i])) continue;
                jobIdFound = true;
                break;
            }
        }
        if (!jobIdFound) {
            String errorMessage = i18n.getMessage("JobIdNotFound", (Object)localJobId);
            logger.error((Object)errorMessage);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("new job state for " + localJobId + " is " + localJobState.toString()));
        }
        ((ManagedExecutableJobResourceDataType)resource.getResourceData()).setLocalJobState(i, localJobState);
        if (state.equals((Object)StateEnumeration.Suspended) && StateMachine.allJobProcessesHaveResumed(resource)) {
            StateMachine.processNewState(resource, InternalStateEnumeration.Resume, true);
        }
        if (localJobState.equals((Object)StateEnumeration.Pending)) {
            try {
                resource.setState(localJobState);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
                throw new RuntimeException(errorMessage, e);
            }
        }
        if (localJobState.equals((Object)StateEnumeration.Active)) {
            if (StateMachine.allJobProcessesAreActive(resource)) {
                StateMachine.processNewState(resource, InternalStateEnumeration.OpenStdout, true);
            }
        } else if (localJobState.equals((Object)StateEnumeration.Suspended)) {
            try {
                resource.setState(localJobState);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
                throw new RuntimeException(errorMessage, e);
            }
            StateMachine.processNewState(resource, InternalStateEnumeration.Suspend, true);
        } else if (localJobState.equals((Object)StateEnumeration.Done)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Processing Done local job state.");
            }
            if (StateMachine.allJobProcessesAreDone(resource)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"All job processes are Done.");
                }
                StateMachine.processNewState(resource, InternalStateEnumeration.MergeStdout, true);
            }
        } else if (localJobState.equals((Object)StateEnumeration.Failed)) {
            Integer exitCode = (Integer)resource.getResourceProperty(ManagedExecutableJobConstants.RP_EXIT_CODE);
            resource.setFault(StateMachine.createFaultFromErrorCode(resource, ScriptCommandEnumeration.submit, exitCode, "ProcessDied"));
            StateMachine.systemCancel(resource);
        }
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Leaving processWaitingForStateChangesState()");
        }
        performanceLogger.stop("processWaitingForStateChangesState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processMergeStdoutState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        JobManagerScript script = null;
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        PositiveInteger countObj = jobDescription.getCount();
        int count = countObj.intValue();
        String localResourceManager = (String)resource.getResourceDatum("localResourceManager");
        if (count > 1 && (localResourceManager.equals("Fork") || localResourceManager.equals("Condor"))) {
            int errorCode;
            try {
                script = StateMachine.runScript(resource, ScriptCommandEnumeration.poll);
            }
            catch (Exception e) {
                if (script != null) {
                    resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), 0, script.getFailureMessage()));
                } else {
                    String errorMessage = i18n.getMessage("ScriptExecutionError");
                    FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
                    resource.setFault(fault);
                }
                StateMachine.systemCancel(resource);
            }
            JobManagerScript e = script;
            synchronized (e) {
                while (!script.isDone()) {
                    try {
                        script.wait(2000L);
                    }
                    catch (Exception e2) {
                        String errorMessage = i18n.getMessage("InterruptJobScript", (Object)script.getCommand());
                        logger.error((Object)errorMessage, (Throwable)e2);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.trace((Object)("Done waiting for " + script.getCommand() + " script"));
            }
            if ((errorCode = script.getError()) != 0) {
                resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), errorCode, script.getFailureMessage()));
                StateMachine.processNewState(resource, InternalStateEnumeration.SystemCancel, true);
                performanceLogger.stop("processMergeStdoutState");
                return;
            }
        }
        TransferRequestType fileStageOut = jobDescription.getFileStageOut();
        StateEnumeration holdState = jobDescription.getHoldState();
        if (fileStageOut != null || holdState != null && holdState.equals(StateEnumeration.StageOut)) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Not skipping StageOut"));
            StateMachine.processNewState(resource, InternalStateEnumeration.StageOut, true);
        } else {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Skipping StageOut and going straight to CleanUp"));
            StateMachine.processNewState(resource, InternalStateEnumeration.CleanUp, true);
        }
        performanceLogger.stop("processMergeStdoutState");
    }

    private static void processStageOutHoldState(ManagedExecutableJobResource resource) {
        boolean holding = (Boolean)resource.getResourceProperty(ManagedJobConstants.RP_HOLDING);
        if (!holding) {
            StateMachine.processNewState(resource, InternalStateEnumeration.StageOut, true);
        } else {
            JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
            if (jobDescription.getFileStageOut() == null) {
                resource.setFault(StateMachine.createStagingHoldFault(resource, StagingTypeEnumeration.StageOut));
                resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
                StateMachine.systemCancel(resource);
            } else {
                try {
                    resource.setState(StateEnumeration.StageOut);
                }
                catch (Exception e) {
                    String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
                    throw new RuntimeException(errorMessage, e);
                }
            }
        }
    }

    private static void processStageOutState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        StateEnumeration holdState = (StateEnumeration)resource.getResourceDatum("holdState");
        if (holdState != null && holdState.equals((Object)StateEnumeration.StageOut)) {
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.StageOutHold, true);
            performanceLogger.stop("processStageOutState");
            return;
        }
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        TransferRequestType fileStageOut = jobDescription.getFileStageOut();
        boolean staging = false;
        if (fileStageOut != null) {
            staging = true;
            try {
                resource.setState(StateEnumeration.StageOut);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
                throw new RuntimeException(errorMessage, e);
            }
            try {
                EndpointReferenceType stageOutEndpoint = stagingHelper.submitStagingRequest(resource, (BaseRequestType)fileStageOut);
                resource.setResourceDatum("stageOutEndpoint", stageOutEndpoint);
            }
            catch (Exception e) {
                resource.setFault(StateMachine.createStagingFault(resource, StagingTypeEnumeration.StageOut, e));
                StateMachine.systemCancel(resource);
                performanceLogger.stop("processStageOutState");
                return;
            }
        }
        if (staging) {
            StateMachine.processNewState(resource, InternalStateEnumeration.StageOutResponse, false);
        } else {
            StateMachine.processNewState(resource, InternalStateEnumeration.CleanUp, true);
        }
        performanceLogger.stop("processStageOutState");
    }

    private static void processStageOutResponseState(ManagedExecutableJobResource resource) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering processStageOutResponseState()");
        }
        String source = null;
        String destination = null;
        String attribute = "fileStageOut";
        EndpointReferenceType transferJobEndpoint = (EndpointReferenceType)resource.getResourceDatum("stageOutEndpoint");
        if (transferJobEndpoint == null) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)"Missing transfer job endpoint. Continuing...");
            }
            StateMachine.processNewState(resource, InternalStateEnumeration.CleanUp, true);
            return;
        }
        RequestStatusType status = StagingListener.getNextStatus(transferJobEndpoint);
        if (status == null && (status = stagingHelper.poll(resource, transferJobEndpoint)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Missing RFT status. Probably an out-of-order notification.");
            }
            return;
        }
        if (status.getRequestStatus().equals((Object)RequestStatusTypeEnumeration.Failed) && resource.getFault() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Detected a StageOut transfer failure");
            }
            BaseFaultType transferFault = stagingHelper.getTransferFaultFromRP(status.getFault());
            StagingFaultType fault = null;
            fault = transferFault != null ? FaultUtils.createStagingFault(source, destination, (String)attribute, (StateEnumeration)resource.getState(), null, (ResourceKey)((ResourceKey)resource.getID()), (Exception)transferFault) : FaultUtils.createStagingFault(source, destination, (String)attribute, (StateEnumeration)resource.getState(), null, (ResourceKey)((ResourceKey)resource.getID()), (Exception)((Exception)new Exception().fillInStackTrace()));
            resource.setFault((FaultType)fault);
        }
        if (!StateMachine.processCompletedStagingJob(resource, status, InternalStateEnumeration.CleanUp, transferJobEndpoint)) {
            StateMachine.systemCancel(resource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"leaving processStageOutResponseState()");
        }
    }

    private static void processCleanUpHoldState(ManagedExecutableJobResource resource) {
        boolean holding = (Boolean)resource.getResourceProperty(ManagedJobConstants.RP_HOLDING);
        if (!holding) {
            StateMachine.processNewState(resource, InternalStateEnumeration.CleanUp, true);
        } else {
            try {
                if (logger.isDebugEnabled()) {
                    logger.trace((Object)"Notifying of CleanUp state");
                }
                resource.setState(StateEnumeration.CleanUp);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
                throw new RuntimeException(errorMessage, e);
            }
        }
    }

    private static void processCleanUpState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        StateEnumeration holdState = (StateEnumeration)resource.getResourceDatum("holdState");
        if (holdState != null && holdState.equals((Object)StateEnumeration.CleanUp)) {
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.CleanUpHold, true);
            performanceLogger.stop("processCleanUpState");
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.trace((Object)"Notifying of CleanUp state");
            }
            resource.setState(StateEnumeration.CleanUp);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
            throw new RuntimeException(errorMessage, e);
        }
        JobDescriptionType jobDescription = resource.getJobDescription();
        if (jobDescription.getFileCleanUp() != null) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Not skipping FileCleanUp"));
            StateMachine.processNewState(resource, InternalStateEnumeration.FileCleanUp, true);
        } else {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Skipping FileCleanUp and going straight to CacheCleanUp"));
            StateMachine.processNewState(resource, InternalStateEnumeration.CacheCleanUp, true);
        }
        performanceLogger.stop("processCleanUpState");
    }

    private static void processUserCancelState(ManagedExecutableJobResource resource) {
        StateMachine.kill(resource);
        JobDescriptionType jobDescription = resource.getJobDescription();
        if (jobDescription.getFileCleanUp() != null) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Not skipping FailureFileCleanUp"));
            StateMachine.processNewState(resource, InternalStateEnumeration.FailureFileCleanUp, true);
        } else {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "Skipping FailureFileCleanUp and going straight to " + "FailureCacheCleanUp"));
            StateMachine.processNewState(resource, InternalStateEnumeration.FailureCacheCleanUp, true);
        }
    }

    private static void processSystemCancelState(ManagedExecutableJobResource resource) {
        StateMachine.kill(resource);
        StateMachine.processNewState(resource, InternalStateEnumeration.FailureFileCleanUp, true);
    }

    private static void processFileCleanUpState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        DeleteRequestType fileCleanUp = jobDescription.getFileCleanUp();
        if (fileCleanUp != null) {
            StateMachine.processNewState(resource, InternalStateEnumeration.FileCleanUpResponse, false);
            StateMachine.fileCleanUp(resource);
        } else {
            StateMachine.processNewState(resource, InternalStateEnumeration.CacheCleanUp, true);
        }
        performanceLogger.stop("processFileCleanUpState");
    }

    private static void processFileCleanUpResponseState(ManagedExecutableJobResource resource) {
        EndpointReferenceType transferJobEndpoint;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering processFileCleanUpResponseState()");
        }
        if ((transferJobEndpoint = (EndpointReferenceType)resource.getResourceDatum("cleanUpEndpoint")) == null) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)"Missing transfer job endpoint. Continuing...");
            }
            StateMachine.processNewState(resource, InternalStateEnumeration.CacheCleanUp, true);
            return;
        }
        RequestStatusType status = StagingListener.getNextStatus(transferJobEndpoint);
        if (status == null && (status = stagingHelper.poll(resource, transferJobEndpoint)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Missing RFT status. Probably an out-of-order notification.");
            }
            return;
        }
        if (!StateMachine.processCompletedStagingJob(resource, status, InternalStateEnumeration.CacheCleanUp, transferJobEndpoint)) {
            StateMachine.processNewState(resource, InternalStateEnumeration.FailureCacheCleanUp, true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"leaving processFileCleanUpResponseState()");
        }
    }

    private static void processFailureFileCleanUpState(ManagedExecutableJobResource resource) {
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        DeleteRequestType fileCleanUp = jobDescription.getFileCleanUp();
        if (fileCleanUp != null) {
            StateMachine.processNewState(resource, InternalStateEnumeration.FailureFileCleanUpResponse, false);
            StateMachine.fileCleanUp(resource);
        } else {
            StateMachine.processNewState(resource, InternalStateEnumeration.FailureCacheCleanUp, true);
        }
    }

    private static void processFailureFileCleanUpResponseState(ManagedExecutableJobResource resource) {
        EndpointReferenceType transferJobEndpoint;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering processFailureFileCleanUpResponseState()");
        }
        if ((transferJobEndpoint = (EndpointReferenceType)resource.getResourceDatum("cleanUpEndpoint")) == null) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)"Missing transfer job endpoint. Continuing...");
            }
            StateMachine.processNewState(resource, InternalStateEnumeration.FailureCacheCleanUp, true);
            return;
        }
        RequestStatusType status = StagingListener.getNextStatus(transferJobEndpoint);
        if (status == null && (status = stagingHelper.poll(resource, transferJobEndpoint)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Missing RFT status. Probably an out-of-order notification.");
            }
            return;
        }
        if (!StateMachine.processCompletedStagingJob(resource, status, InternalStateEnumeration.FailureCacheCleanUp, transferJobEndpoint)) {
            StateMachine.processNewState(resource, InternalStateEnumeration.FailureCacheCleanUp, true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"leaving processFailureFileCleanUpResponseState()");
        }
    }

    private static void processCacheCleanUpState(ManagedExecutableJobResource resource) {
        performanceLogger.start();
        boolean success = StateMachine.cacheCleanUp(resource);
        if (success) {
            StateMachine.processNewState(resource, InternalStateEnumeration.Done, true);
        }
        performanceLogger.stop("processCacheCleanUpState");
    }

    private static void processFailureCacheCleanUpState(ManagedExecutableJobResource resource) {
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Entering processFailureCacheCleanUpState()");
        }
        StateMachine.cacheCleanUp(resource);
        StateMachine.processNewState(resource, InternalStateEnumeration.Failed, true);
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Leaving processFailureCacheCleanUpState()");
        }
    }

    private static void sendUsagePacket(ManagedExecutableJobResource resource) {
        List targets;
        JobDescriptionType jobDescription = resource.getJobDescription();
        GramUsageMonitorPacket usagePacket = new GramUsageMonitorPacket();
        usagePacket.setTimestamp(System.currentTimeMillis());
        usagePacket.setCreationTime((Date)resource.getResourceDatum("creationTime"));
        usagePacket.setLocalResourceManager((String)resource.getResourceDatum("localResourceManager"));
        usagePacket.setJobCredentialEndpointUsed(jobDescription.getJobCredentialEndpoint() != null);
        usagePacket.setFileStageInUsed(jobDescription.getFileStageIn() != null);
        usagePacket.setFileStageOutUsed(jobDescription.getFileStageOut() != null);
        usagePacket.setFileCleanUpUsed(jobDescription.getFileCleanUp() != null);
        StateEnumeration holdState = jobDescription.getHoldState();
        if (holdState != null) {
            usagePacket.setCleanUpHoldUsed(holdState.equals((Object)StateEnumeration.CleanUp));
        } else {
            usagePacket.setCleanUpHoldUsed(false);
        }
        JobTypeEnumeration jobType = jobDescription.getJobType();
        if (jobType == null) {
            jobType = JobTypeEnumeration.multiple;
        }
        usagePacket.setJobType(jobType);
        StateEnumeration state = resource.getState();
        if (state.equals((Object)StateEnumeration.Failed)) {
            FaultType fault = resource.getFault();
            if (fault != null) {
                usagePacket.setGt2ErrorCode(fault.getGt2ErrorCode());
                usagePacket.setFaultClass(((Object)((Object)fault)).getClass());
            } else {
                logger.error((Object)i18n.getMessage("NoFaultOnFailure", (Object)((ResourceKey)resource.getID()).toString()));
            }
        }
        if (usageConfig != null && (targets = usageConfig.getTargets()) != null) {
            usagePacket.setHostIP(usageConfig.getContainerHost());
            usagePacket.sendPacket(targets);
        }
    }

    private static void processDoneHoldState(ManagedExecutableJobResource resource) {
        StateEnumeration state = resource.getState();
        resource.setFault((FaultType)FaultUtils.createUnsupportedFeatureFault((String)"Done", (String)"holdState", (StateEnumeration)state, null, (int)-1, (ResourceKey)((ResourceKey)resource.getID())));
        resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
        StateMachine.processNewState(resource, InternalStateEnumeration.Failed, true);
    }

    private static void processDoneState(ManagedExecutableJobResource resource) {
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Entering processDoneState()");
        }
        performanceLogger.start();
        StateEnumeration holdState = (StateEnumeration)resource.getResourceDatum("holdState");
        if (holdState != null && holdState.equals((Object)StateEnumeration.Done)) {
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.DoneHold, true);
            performanceLogger.stop("processDoneState");
            if (logger.isDebugEnabled()) {
                logger.trace((Object)"Leaving processDoneState() for hold");
            }
            return;
        }
        try {
            resource.setState(StateEnumeration.Done);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
            throw new RuntimeException(errorMessage, e);
        }
        StateMachine.logAuditRecord(false, resource, true, true);
        StateMachine.unsubscribeAtJobStateMonitor(resource);
        StateMachine.logJobSucceeded(resource);
        StateMachine.sendUsagePacket(resource);
        performanceLogger.stop("processDoneState");
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Leaving processDoneState()");
        }
    }

    private static void processFailedHoldState(ManagedExecutableJobResource resource) {
        StateEnumeration state = resource.getState();
        resource.setFault((FaultType)FaultUtils.createUnsupportedFeatureFault((String)"Failed", (String)"holdState", (StateEnumeration)state, null, (int)-1, (ResourceKey)((ResourceKey)resource.getID())));
        resource.setResourceDatum("holdState", null);
        resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
        StateMachine.processNewState(resource, InternalStateEnumeration.Failed, true);
    }

    private static void processFailedState(ManagedExecutableJobResource resource) {
        StateEnumeration holdState;
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Entering processFailedState()");
        }
        if ((holdState = (StateEnumeration)resource.getResourceDatum("holdState")) != null && holdState.equals((Object)StateEnumeration.Failed)) {
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.FailedHold, true);
            return;
        }
        logger.debug((Object)"fault:\n", (Throwable)resource.getFault());
        try {
            resource.setState(StateEnumeration.Failed);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
            throw new RuntimeException(errorMessage, e);
        }
        StateMachine.logAuditRecord(false, resource, false, true);
        StateMachine.unsubscribeAtJobStateMonitor(resource);
        StateMachine.logJobFailed(resource);
        StateMachine.sendUsagePacket(resource);
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"Leaving processFailedState()");
        }
    }

    private static void processSuspendedHoldState(ManagedExecutableJobResource resource) {
        StateEnumeration state = resource.getState();
        resource.setFault((FaultType)FaultUtils.createUnsupportedFeatureFault((String)"Suspended", (String)"holdState", (StateEnumeration)state, null, (int)-1, (ResourceKey)((ResourceKey)resource.getID())));
        resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, false);
        StateMachine.systemCancel(resource);
    }

    private static void processSuspendState(ManagedExecutableJobResource resource) {
        StateEnumeration holdState = (StateEnumeration)resource.getResourceDatum("holdState");
        if (holdState != null && holdState.equals((Object)StateEnumeration.Suspended)) {
            resource.setResourceProperty(ManagedJobConstants.RP_HOLDING, true);
            StateMachine.processNewState(resource, InternalStateEnumeration.SuspendedHold, true);
            return;
        }
        InternalStateEnumeration internalState = resource.getInternalState();
        resource.setResourceDatum("suspendedInternalState", internalState);
        StateMachine.processNewState(resource, InternalStateEnumeration.WaitingForStateChanges, false);
    }

    private static void processResumeState(ManagedExecutableJobResource resource) {
        try {
            resource.setState(StateEnumeration.Suspended);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("ResourceSetStateAndNotifyError");
            throw new RuntimeException(errorMessage, e);
        }
        InternalStateEnumeration suspendedInternalState = (InternalStateEnumeration)resource.getResourceDatum("suspendedInternalState");
        StateMachine.processNewState(resource, suspendedInternalState, false);
    }

    private static void processNewState(ManagedExecutableJobResource resource, InternalStateEnumeration newInternalState, boolean addToRunQueue) {
        try {
            resource.setInternalState(newInternalState);
        }
        catch (ResourceException re) {
            throw new RuntimeException(re);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + "In internal state " + newInternalState));
        }
        if (addToRunQueue) {
            if (logger.isDebugEnabled()) {
                logger.trace((Object)"Adding to RunQueue.");
            }
            RunQueue.getInstance().add((ResourceKey)resource.getID());
        }
    }

    private static boolean allJobProcessesAreActive(ManagedExecutableJobResource resource) {
        ResourcePropertySet props = resource.getResourcePropertySet();
        StateEnumeration[] localJobStates = (StateEnumeration[])resource.getResourceDatum("localJobState");
        int size = localJobStates.length;
        int active = 0;
        if (localJobStates != null) {
            for (int i = 0; i < size; ++i) {
                if (!localJobStates[i].equals((Object)StateEnumeration.Active)) continue;
                ++active;
            }
            if (active == size) {
                return true;
            }
        }
        return false;
    }

    private static boolean allJobProcessesAreDone(ManagedExecutableJobResource resource) {
        ResourcePropertySet props = resource.getResourcePropertySet();
        StateEnumeration[] localJobStates = (StateEnumeration[])resource.getResourceDatum("localJobState");
        int size = localJobStates.length;
        int done = 0;
        if (localJobStates != null) {
            for (int i = 0; i < size; ++i) {
                if (!localJobStates[i].equals((Object)StateEnumeration.Done)) continue;
                ++done;
            }
            if (done == size) {
                return true;
            }
        }
        return false;
    }

    private static boolean allJobProcessesHaveResumed(ManagedExecutableJobResource resource) {
        ResourcePropertySet props = resource.getResourcePropertySet();
        StateEnumeration[] localJobStates = (StateEnumeration[])resource.getResourceDatum("localJobState");
        int size = localJobStates.length;
        int suspended = 0;
        if (localJobStates != null) {
            for (int i = 0; i < size; ++i) {
                if (!localJobStates[i].equals((Object)StateEnumeration.Suspended)) continue;
                ++suspended;
            }
            if (suspended != size) {
                return true;
            }
        }
        return false;
    }

    protected static void insertNotifiedJobData(ManagedExecutableJobResource resource, String jobId, StateEnumeration state) {
        JobIdStatePairType[] notifiedJobData;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StateMachine.getLoggingPrefix(resource) + jobId + " " + state + " " + resource.getID()));
        }
        ArrayList<Object> newNotifiedJobData = (notifiedJobData = (JobIdStatePairType[])resource.getResourceDatum("notifiedJobData")) == null ? new ArrayList() : new ArrayList<JobIdStatePairType>(Arrays.asList(notifiedJobData));
        if (logger.isDebugEnabled()) {
            logger.trace((Object)("newNotifiedJobData is of type " + newNotifiedJobData.getClass().getName()));
        }
        newNotifiedJobData.add(new JobIdStatePairType(jobId, state));
        resource.setResourceDatum("notifiedJobData", newNotifiedJobData.toArray(new JobIdStatePairType[0]));
    }

    protected static JobIdStatePairType removeNotifiedJobData(ManagedExecutableJobResource resource) {
        JobIdStatePairType[] notifiedJobData = (JobIdStatePairType[])resource.getResourceDatum("notifiedJobData");
        List<Object> newNotifiedJobData = new ArrayList<JobIdStatePairType>(Arrays.asList(notifiedJobData));
        newNotifiedJobData = newNotifiedJobData.subList(1, newNotifiedJobData.size());
        resource.setResourceDatum("notifiedJobData", newNotifiedJobData.toArray(new JobIdStatePairType[0]));
        return notifiedJobData[0];
    }

    private static void kill(ManagedExecutableJobResource resource) {
        JobManagerScript script = null;
        try {
            script = StateMachine.runScript(resource, ScriptCommandEnumeration.cancel);
        }
        catch (Exception e) {
            if (script != null) {
                resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), 0, script.getFailureMessage()));
            }
            String errorMessage = i18n.getMessage("ScriptExecutionError");
            FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
            resource.setFault(fault);
        }
    }

    private static boolean processCompletedStagingJob(ManagedExecutableJobResource resource, RequestStatusType status, InternalStateEnumeration nextState, EndpointReferenceType transferJobEndpoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering processCompletedStagingJob()");
        }
        RequestStatusTypeEnumeration requestState = status.getRequestStatus();
        BaseFaultType transferFault = stagingHelper.getTransferFaultFromRP(status.getFault());
        if (requestState.equals((Object)RequestStatusTypeEnumeration.Done)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Transfer finished successufully.");
            }
            try {
                stagingHelper.destroyTransferJob(resource, transferJobEndpoint);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("RFTDestroyError");
                logger.error((Object)errorMessage, (Throwable)e);
            }
            StateMachine.processNewState(resource, nextState, true);
        } else if (requestState.equals((Object)RequestStatusTypeEnumeration.Failed)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handling non-StageIn failures");
            }
            try {
                stagingHelper.destroyTransferJob(resource, transferJobEndpoint);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("RFTDestroyError");
                logger.error((Object)errorMessage, (Throwable)e);
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving processCompletedStagingJob()");
        }
        return true;
    }

    private static boolean fileCleanUp(ManagedExecutableJobResource resource) {
        JobDescriptionType jobDescription = ((ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT)).getJob();
        DeleteRequestType fileCleanUp = jobDescription.getFileCleanUp();
        if (fileCleanUp != null) {
            try {
                EndpointReferenceType cleanUpEndpoint = stagingHelper.submitStagingRequest(resource, (BaseRequestType)fileCleanUp);
                resource.setResourceDatum("cleanUpEndpoint", cleanUpEndpoint);
            }
            catch (Exception e) {
                if (resource.getFault() == null) {
                    resource.setFault(StateMachine.createStagingFault(resource, StagingTypeEnumeration.CleanUp, e));
                } else {
                    logger.error((Object)i18n.getMessage("SecondaryFault"), (Throwable)e);
                }
                StateMachine.processNewState(resource, InternalStateEnumeration.FailureCacheCleanUp, true);
                return false;
            }
        } else {
            RunQueue.getInstance().add((ResourceKey)resource.getID());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheCleanUp(ManagedExecutableJobResource resource) {
        JobManagerScript script = null;
        try {
            script = StateMachine.runScript(resource, ScriptCommandEnumeration.cache_cleanup);
        }
        catch (Exception e) {
            if (script != null) {
                if (resource.getFault() != null) {
                    resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), 0, script.getFailureMessage()));
                }
            } else {
                String errorMessage = i18n.getMessage("ScriptExecutionError");
                FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = StateMachine.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)resource.getID()), (String)errorMessage, (Exception)e, (StateEnumeration)resource.getState(), null, (int)0);
                resource.setFault(fault);
            }
            StateMachine.systemCancel(resource);
            return false;
        }
        JobManagerScript e = script;
        synchronized (e) {
            while (!script.isDone()) {
                try {
                    script.wait(2000L);
                }
                catch (Exception e2) {
                    String errorMessage = i18n.getMessage("InterruptJobScript", (Object)script.getCommand());
                    logger.error((Object)errorMessage, (Throwable)e2);
                    return false;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.trace((Object)("Done waiting for " + script.getCommand() + " script"));
        }
        int errorCode = script.getError();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("script return code: " + errorCode));
        }
        if (errorCode != 0) {
            logger.debug((Object)"script return code means error!");
            boolean canceled = (Boolean)resource.getResourceDatum("canceled");
            if (!canceled && resource.getFault() != null) {
                resource.setFault(StateMachine.createFaultFromErrorCode(resource, script.getCommand(), errorCode, script.getFailureMessage()));
            }
            StateMachine.processNewState(resource, InternalStateEnumeration.Failed, true);
            return false;
        }
        return true;
    }

    protected static JobManagerScript runScript(ManagedExecutableJobResource resource, ScriptCommandEnumeration scriptCommand) throws IOException {
        String globusLocation = null;
        globusLocation = ManagedJobFactoryHome.getConfiguration().getGlobusLocation();
        String perlAttributesString = resource.getPerlJobDescription().toPerlString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Perl Job Description: " + perlAttributesString));
        }
        JobManagerScript newScript = new JobManagerScript((String)resource.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID), globusLocation, (String)resource.getResourceDatum("localResourceManager"), scriptCommand, perlAttributesString, resource.getScriptEnvironment());
        resource.setScript(newScript);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("running script " + newScript.getCommand()));
        }
        newScript.start();
        return newScript;
    }

    protected static void setLocalJobId(ManagedExecutableJobResource resource, String localJobId, StateEnumeration state) {
        StringTokenizer tokenizer = new StringTokenizer(localJobId, ",");
        int tokenCount = tokenizer.countTokens();
        String[] localJobIds = (String[])resource.getResourceDatum("localJobId");
        String[] localJobStates = (String[])resource.getResourceDatum("localJobState");
        ArrayList<Object> newLocalJobIds = localJobIds == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(localJobIds));
        if (logger.isDebugEnabled()) {
            logger.trace((Object)("newLocalJobIds is of type " + newLocalJobIds.getClass().getName()));
        }
        ArrayList<Object> newLocalJobStates = localJobStates == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(localJobStates));
        for (int i = 0; i < tokenCount; ++i) {
            String token = tokenizer.nextToken();
            logger.debug((Object)("Saving local job ID " + token));
            newLocalJobIds.add(token);
            newLocalJobStates.add(state);
        }
        resource.setResourceDatum("localJobId", newLocalJobIds.toArray(new String[0]));
        resource.setResourceDatum("localJobState", newLocalJobStates.toArray(new StateEnumeration[0]));
    }

    protected static boolean isNotifiedJobData(ManagedExecutableJobResource resource) {
        JobIdStatePairType[] notifiedJobData = (JobIdStatePairType[])resource.getResourceDatum("notifiedJobData");
        return notifiedJobData != null && notifiedJobData.length > 0;
    }

    private static FaultType createStagingHoldFault(ManagedExecutableJobResource resource, StagingTypeEnumeration stagingType) {
        String attribute = null;
        attribute = stagingType.equals((Object)StagingTypeEnumeration.StageIn) ? "fileStageIn" : (stagingType.equals((Object)StagingTypeEnumeration.StageOut) ? "fileStageOut" : "fileCleanUp");
        Exception cause = new Exception(i18n.getMessage("badHoldRequest", (Object[])new String[]{stagingType.toString()}));
        cause.fillInStackTrace();
        return FaultUtils.createStagingFault(null, null, (String)attribute, (StateEnumeration)resource.getState(), (String)stagingType.toString(), (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
    }

    private static FaultType createStagingFault(ManagedExecutableJobResource resource, StagingTypeEnumeration stagingType, Exception cause) {
        String attribute = null;
        attribute = stagingType.equals((Object)StagingTypeEnumeration.StageIn) ? "fileStageIn" : (stagingType.equals((Object)StagingTypeEnumeration.StageOut) ? "fileStageOut" : "fileCleanUp");
        return FaultUtils.createStagingFault(null, null, (String)attribute, (StateEnumeration)resource.getState(), (String)stagingType.toString(), (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
    }

    private static FaultType createFaultFromErrorCode(ManagedExecutableJobResource resource, ScriptCommandEnumeration scriptCommand, int errorCode) {
        return StateMachine.createFaultFromErrorCode(resource, scriptCommand, errorCode, null);
    }

    private static FaultType createFaultFromErrorCode(ManagedExecutableJobResource resource, ScriptCommandEnumeration scriptCommand, int errorCode, String failureMessage) {
        Exception cause = null;
        if (failureMessage != null) {
            cause = new Exception(failureMessage);
            cause.fillInStackTrace();
        }
        JobDescriptionType jobDescription = resource.getJobDescription();
        logger.trace((Object)("Creating fault from error code " + Integer.toString(errorCode)));
        switch (errorCode) {
            case 21: {
                cause = new Exception(i18n.getMessage("BAD_SCRIPT_ARG_FILE"));
                cause.fillInStackTrace();
                return FaultUtils.createInternalFault((StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 4: {
                return FaultUtils.createInvalidPathFault((String)jobDescription.getDirectory(), (String)"directory", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 136: {
                String manager = ((ManagedExecutableJobResourceDataType)resource.getResourceData()).getLocalResourceManager();
                ManagedJobFactoryResource factoryResource = null;
                try {
                    ManagedJobFactoryHome home = ManagedJobFactoryHome.getHome();
                    factoryResource = (ManagedJobFactoryResource)home.find((ResourceKey)ManagedJobHelper.getResourceKey((String)manager));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                String scratchDir = (String)factoryResource.getResourcePropertySet().get(ManagedJobFactoryConstants.RP_SCRATCH_BASE_DIRECTORY).get(0);
                return FaultUtils.createInvalidPathFault((String)scratchDir, (String)"scratchDir", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 5: {
                return FaultUtils.createInvalidPathFault((String)jobDescription.getExecutable(), (String)"executable", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 11: {
                return FaultUtils.createInvalidPathFault((String)jobDescription.getStdin(), (String)"stdin", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 14: {
                return FaultUtils.createServiceLevelAgreementFault((String)"count", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 17: {
                return FaultUtils.createExecutionFailedFault((String)"stdin", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 19: 
            case 26: {
                JobTypeEnumeration jobType = jobDescription.getJobType();
                if (jobType == null) {
                    jobType = JobTypeEnumeration.single;
                }
                return FaultUtils.createUnsupportedFeatureFault((String)jobType.toString(), (String)"jobType", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 72: {
                return FaultUtils.createFilePermissionsFault((String)jobDescription.getExecutable(), (String)"executable", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 73: {
                return FaultUtils.createFilePermissionsFault((String)jobDescription.getStdout(), (String)"stdout", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 74: {
                return FaultUtils.createFilePermissionsFault((String)jobDescription.getStderr(), (String)"stderr", (StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
            case 24: {
                return FaultUtils.createInternalFault((StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
            }
        }
        String warnMessage = i18n.getMessage("UnknownGRAMFaultCode", (Object)Integer.toString(errorCode));
        logger.warn((Object)warnMessage);
        logger.debug((Object)("Offending Script Command: " + scriptCommand.toString()));
        return FaultUtils.createFault((StateEnumeration)resource.getState(), (String)scriptCommand.toString(), (int)errorCode, (ResourceKey)((ResourceKey)resource.getID()), (Exception)cause);
    }

    private static void logAuditRecord(boolean insertRecord, ManagedExecutableJobResource resource, boolean succeeded, boolean finished) {
        StringBuffer auditRecord = new StringBuffer();
        if (insertRecord) {
            auditRecord.append("insert: ");
        } else {
            auditRecord.append("update: ");
        }
        try {
            FactoryServiceConfiguration serviceConfiguration = ManagedJobFactoryService.getServiceConfiguration();
            String jobServicePath = serviceConfiguration.getManagedExecutableJobServicePath();
            String serviceURL = ServiceHost.getBaseURL() + jobServicePath;
            EndpointReferenceType jobEndpoint = AddressingUtils.createEndpointReference((String)serviceURL, (ResourceKey)((ResourceKey)resource.getID()));
            Class resourceKeyType = ManagedExecutableJobHome.getHome().getKeyTypeClass();
            String jobGridId = AuditUtil.eprToGridId((EndpointReferenceType)jobEndpoint);
            auditRecord.append(AuditDatabaseAppender.format((String)jobGridId)).append(",");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringBuffer localJobIdsString = new StringBuffer();
        String[] localJobIds = (String[])resource.getResourceDatum("localJobId");
        if (localJobIds != null) {
            for (int index = 0; index < localJobIds.length; ++index) {
                localJobIdsString.append(localJobIds[index]);
                if (index >= localJobIds.length - 1) continue;
                localJobIdsString.append(";");
            }
        } else {
            localJobIdsString.append("NULL");
        }
        auditRecord.append(AuditDatabaseAppender.format((String)localJobIdsString.toString())).append(",");
        auditRecord.append(AuditDatabaseAppender.format((String)((String)resource.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT)))).append(",");
        auditRecord.append(AuditDatabaseAppender.format((String)((String)resource.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID)))).append(",");
        String idempotenceId = (String)resource.getResourceDatum("idempotenceId");
        if (idempotenceId == null) {
            idempotenceId = "NULL";
        }
        auditRecord.append(AuditDatabaseAppender.format((String)idempotenceId)).append(",");
        auditRecord.append(AuditDatabaseAppender.format((String)resource.getResourceDatum("creationTime").toString())).append(",");
        Date queuedTime = (Date)resource.getResourceDatum("queuedTime");
        String queuedTimeString = queuedTime != null ? queuedTime.toString() : "NULL";
        auditRecord.append(AuditDatabaseAppender.format((String)queuedTimeString)).append(",");
        EndpointReferenceType stageInEndpoint = (EndpointReferenceType)resource.getResourceDatum("stageInEndpoint");
        String stageInEndpointString = null;
        if (stageInEndpoint == null) {
            stageInEndpointString = "NULL";
        } else {
            try {
                Class resourceKeyType = ManagedExecutableJobHome.getHome().getKeyTypeClass();
                stageInEndpointString = AuditUtil.eprToGridId((EndpointReferenceType)stageInEndpoint);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        auditRecord.append(AuditDatabaseAppender.format((String)stageInEndpointString)).append(",");
        EndpointReferenceType stageOutEndpoint = (EndpointReferenceType)resource.getResourceDatum("stageOutEndpoint");
        String stageOutEndpointString = null;
        if (stageOutEndpoint == null) {
            stageOutEndpointString = "NULL";
        } else {
            try {
                Class resourceKeyType = ManagedExecutableJobHome.getHome().getKeyTypeClass();
                stageOutEndpointString = AuditUtil.eprToGridId((EndpointReferenceType)stageOutEndpoint);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        auditRecord.append(AuditDatabaseAppender.format((String)stageOutEndpointString)).append(",");
        EndpointReferenceType cleanUpEndpoint = (EndpointReferenceType)resource.getResourceDatum("cleanUpEndpoint");
        String cleanUpEndpointString = null;
        if (cleanUpEndpoint == null) {
            cleanUpEndpointString = "NULL";
        } else {
            try {
                Class resourceKeyType = ManagedExecutableJobHome.getHome().getKeyTypeClass();
                cleanUpEndpointString = AuditUtil.eprToGridId((EndpointReferenceType)cleanUpEndpoint);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        auditRecord.append(AuditDatabaseAppender.format((String)cleanUpEndpointString)).append(",");
        AuditDatabaseConfiguration auditDatabaseConfiguration = ManagedExecutableJobHome.getAuditDatabaseConfiguration();
        String globusToolkitVersion = auditDatabaseConfiguration.getGlobusVersion();
        auditRecord.append(AuditDatabaseAppender.format((String)globusToolkitVersion)).append(",");
        auditRecord.append(AuditDatabaseAppender.format((String)((String)resource.getResourceDatum("localResourceManager")))).append(",");
        ServiceLevelAgreementType jobDescription = (ServiceLevelAgreementType)resource.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT);
        Element jobDescriptionElement = null;
        try {
            jobDescriptionElement = ObjectSerializer.toElement((Object)jobDescription, (QName)ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        auditRecord.append(AuditDatabaseAppender.format((String)XmlUtils.toString((Element)jobDescriptionElement))).append(",");
        auditRecord.append(AuditDatabaseAppender.format((String)new Boolean(succeeded).toString())).append(",");
        auditRecord.append(AuditDatabaseAppender.format((String)new Boolean(finished).toString()));
        auditLogger.debug((Object)auditRecord.toString());
    }

    public static String getLoggingPrefix(ManagedExecutableJobResource resource) {
        return StateMachine.getLoggingPrefix((ResourceKey)resource.getID());
    }

    public static String getLoggingPrefix(ResourceKey resourceKey) {
        return new String("[resourceKey:" + resourceKey.getValue() + "] ");
    }

    private static void logJobAccepted(ManagedExecutableJobResource resource) throws ResourceException {
        logger.info((Object)("Job " + ((ResourceKey)resource.getID()).getValue() + " accepted for local user '" + (String)resource.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID) + "'"));
    }

    private static void logJobSubmitted(ManagedExecutableJobResource resource, String localJobId) {
        logger.info((Object)("Job " + ((ResourceKey)resource.getID()).getValue() + " submitted with local job ID '" + localJobId + "'"));
    }

    private static void logJobSucceeded(ManagedExecutableJobResource resource) {
        logger.info((Object)("Job " + ((ResourceKey)resource.getID()).getValue() + " finished successfully"));
    }

    private static void logJobFailed(ManagedExecutableJobResource resource) {
        logger.info((Object)("Job " + ((ResourceKey)resource.getID()).getValue() + " failed"));
    }

    static void subscribeAtJobStateMonitor(ManagedExecutableJobResource resource) throws AlreadyRegisteredException {
        logger.debug((Object)"subscribing resource for JSM notifications");
        String[] localJobIds = (String[])resource.getResourceDatum("localJobId");
        if (localJobIds != null) {
            int size = localJobIds.length;
            for (int i = 0; i < size; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Registering job ID " + localJobIds[i] + " for JSM subscriber " + resource.getID()));
                }
                resource.getJobStateMonitor().registerJobID(localJobIds[i], (ResourceKey)resource.getID());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting subscribeForNotifications()");
        }
    }

    static void unsubscribeAtJobStateMonitor(ManagedExecutableJobResource resource) {
        String[] localJobIds;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"unsubscribing resource for JSM notifications");
        }
        if ((localJobIds = (String[])resource.getResourceDatum("localJobId")) != null) {
            int size = localJobIds.length;
            for (int i = 0; i < size; ++i) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Unregistering job ID from JSM subscribers");
                    }
                    resource.getJobStateMonitor().unregisterJobID(localJobIds[i]);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Job ID Unregistered.");
                    continue;
                }
                catch (Exception e) {
                    String errorMessage = i18n.getMessage("JobIdUnregistrationError");
                    logger.debug((Object)errorMessage, (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        stagingHelper = null;
    }
}

