/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.service.exec.RunQueue;
import org.globus.rft.generated.RequestStatusType;
import org.globus.rft.generated.RequestStatusTypeEnumeration;
import org.globus.util.I18n;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;

public class StagingListener
implements NotifyCallback,
Serializable {
    static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$service$exec$StagingListener == null ? (class$org$globus$exec$service$exec$StagingListener = StagingListener.class$("org.globus.exec.service.exec.StagingListener")) : class$org$globus$exec$service$exec$StagingListener));
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = StagingListener.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static StagingListener INSTANCE = new StagingListener();
    protected static Hashtable execJobMap = new Hashtable();
    private static Hashtable statusMap = new Hashtable();
    static /* synthetic */ Class class$org$globus$exec$service$exec$StagingListener;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$rft$generated$RequestStatusType;

    private StagingListener() {
    }

    public static StagingListener getInstance() {
        return INSTANCE;
    }

    public static synchronized StagingListener registerTransferJob(EndpointReferenceType transferJobEndpoint, ResourceKey execJobKey) {
        String transferJobKey = StagingListener.endpointToKey(transferJobEndpoint);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Entering registerTransferJob()"));
        }
        execJobMap.put(transferJobKey, execJobKey);
        logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Leaving registerTransferJob()"));
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void unregisterTransferJob(EndpointReferenceType transferJobEndpoint) {
        String transferJobKey = StagingListener.endpointToKey(transferJobEndpoint);
        logger.debug((Object)(StagingListener.getLoggingPrefix(null, transferJobKey) + "Entering unregisterTransferJob()"));
        Hashtable hashtable = execJobMap;
        synchronized (hashtable) {
            execJobMap.remove(transferJobKey);
        }
        hashtable = statusMap;
        synchronized (hashtable) {
            statusMap.remove(transferJobKey);
        }
        logger.debug((Object)(StagingListener.getLoggingPrefix(null, transferJobKey) + "Leaving unregisterTransferJob()"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RequestStatusType getNextStatus(EndpointReferenceType transferJobEndpoint) {
        String transferJobKey = StagingListener.endpointToKey(transferJobEndpoint);
        RequestStatusType status = null;
        Hashtable hashtable = statusMap;
        synchronized (hashtable) {
            Vector statusEntries = (Vector)statusMap.get(transferJobKey);
            if (statusEntries == null) {
                return null;
            }
            status = (RequestStatusType)statusEntries.remove(0);
            if (statusEntries.size() == 0) {
                statusMap.remove(transferJobKey);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deliver(List topicPath, EndpointReferenceType producerEndpoint, Object messageWrapper) {
        String transferJobKey = StagingListener.endpointToKey(producerEndpoint);
        ResourceKey execJobKey = (ResourceKey)execJobMap.get(transferJobKey);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Entering deliver()"));
        }
        if (execJobKey == null) {
            logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "No resource mapping for transfer job."));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Received notification from RFT."));
        }
        try {
            ResourcePropertyValueChangeNotificationType message = ((ResourcePropertyValueChangeNotificationElementType)messageWrapper).getResourcePropertyValueChangeNotification();
            RequestStatusType status = null;
            try {
                status = (RequestStatusType)ObjectDeserializer.getFirstAsObject((AnyContentType)message.getNewValue(), (Class)(class$org$globus$rft$generated$RequestStatusType == null ? (class$org$globus$rft$generated$RequestStatusType = StagingListener.class$("org.globus.rft.generated.RequestStatusType")) : class$org$globus$rft$generated$RequestStatusType));
            }
            catch (Exception e) {
                try {
                    status = (RequestStatusType)message.getNewValue().get_any()[0].getObjectValue(class$org$globus$rft$generated$RequestStatusType == null ? (class$org$globus$rft$generated$RequestStatusType = StagingListener.class$("org.globus.rft.generated.RequestStatusType")) : class$org$globus$rft$generated$RequestStatusType);
                }
                catch (Exception ex) {
                    logger.error((Object)("Notification from RFT can't be deserialized properly: " + ex.toString()));
                }
            }
            RequestStatusTypeEnumeration requestState = status.getRequestStatus();
            if (requestState != null) {
                if (!requestState.equals((Object)RequestStatusTypeEnumeration.Done) && !requestState.equals((Object)RequestStatusTypeEnumeration.Failed)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Notification is irrelevant (" + requestState.getValue() + ") and will not be processed"));
                    }
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Notification is relevant (" + requestState.getValue() + ")"));
                }
            }
            Hashtable hashtable = statusMap;
            synchronized (hashtable) {
                Vector<RequestStatusType> statusEntries = (Vector<RequestStatusType>)statusMap.get(transferJobKey);
                if (statusEntries == null) {
                    statusEntries = new Vector<RequestStatusType>();
                    statusMap.put(transferJobKey, statusEntries);
                }
                statusEntries.add(status);
            }
            RunQueue.getInstance().add(execJobKey);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Processed notification. Job is in RunQueue."));
            }
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("StateNotifProcessError");
            logger.error((Object)errorMessage, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StagingListener.getLoggingPrefix(execJobKey, transferJobKey) + "Leaving deliver()"));
        }
    }

    private static String endpointToKey(EndpointReferenceType transferJobEndpoint) {
        String transferJobKey = null;
        try {
            ReferencePropertiesType referenceProperties = transferJobEndpoint.getProperties();
            MessageElement[] any = referenceProperties.get_any();
            transferJobKey = any[0].getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("notification missing RFT resource ID");
        }
        return transferJobKey;
    }

    static String getLoggingPrefix(ResourceKey execJobKey, String transferJobKey) {
        if (execJobKey != null) {
            return new String("[execJobKey:" + execJobKey.getValue() + "," + "transferJobKey:" + transferJobKey + "] ");
        }
        return new String();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

