/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.service.exec.RunThread;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceKey;

class RunQueue {
    private static Log logger;
    private static I18n i18n;
    private static RunQueue RUN_QUEUE;
    private static final int MINIMUM_RUN_THREAD_COUNT = 1;
    private static final int DEFAULT_RUN_THREAD_COUNT = 10;
    private LinkedList readyQueue = new LinkedList();
    static /* synthetic */ Class class$org$globus$exec$service$exec$RunQueue;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    private RunQueue() {
    }

    public synchronized void add(ResourceKey resourceKey) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering add()");
        }
        this.readyQueue.add(resourceKey);
        this.notify();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("adding " + resourceKey.toString() + " to queue."));
            this.printRunQueueGraph();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Leaving add()");
        }
    }

    public synchronized ResourceKey remove() {
        ResourceKey resourceKey = (ResourceKey)this.readyQueue.removeFirst();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removing " + resourceKey.toString() + " from queue."));
            this.printRunQueueGraph();
        }
        return resourceKey;
    }

    private synchronized void printRunQueueGraph() {
        int queuedJobCount = this.readyQueue.size();
        StringBuffer asterisks = new StringBuffer();
        for (int index = 0; index < queuedJobCount; ++index) {
            asterisks.append("*");
        }
        logger.debug((Object)("\nRunQueue Graph: " + asterisks.toString()));
    }

    public synchronized int size() {
        return this.readyQueue.size();
    }

    public static RunQueue getInstance() {
        return RUN_QUEUE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int runThreadCount;
        logger = LogFactory.getLog((Class)(class$org$globus$exec$service$exec$RunQueue == null ? (class$org$globus$exec$service$exec$RunQueue = RunQueue.class$("org.globus.exec.service.exec.RunQueue")) : class$org$globus$exec$service$exec$RunQueue));
        i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = RunQueue.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
        FactoryHomeConfiguration homeConfig = ManagedJobFactoryHome.getConfiguration();
        try {
            runThreadCount = Integer.parseInt(homeConfig.getRunQueueThreadCount());
        }
        catch (Exception e) {
            logger.warn((Object)i18n.getMessage("BadRunQueueThreadCount"), (Throwable)e);
            runThreadCount = 10;
        }
        if (runThreadCount < 1) {
            logger.warn((Object)i18n.getMessage("BadRunQueueThreadCount"));
            runThreadCount = 10;
        }
        RUN_QUEUE = new RunQueue();
        for (int threadIndex = 0; threadIndex < runThreadCount; ++threadIndex) {
            RunThread runThread = new RunThread("RunQueueThread_" + threadIndex, RUN_QUEUE);
            runThread.setDaemon(true);
            runThread.start();
        }
        logger.debug((Object)("created RunQueue with " + runThreadCount + " threads"));
    }
}

