/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.ExtensionsType;
import org.globus.exec.generated.FilePairType;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.NameValuePairType;
import org.globus.exec.utils.JobDescriptionMap;
import org.globus.wsrf.utils.AnyHelper;

public class PerlJobDescription
extends JobDescriptionMap {
    static final String RSL_ARGUMENTS = "arguments";
    static final String RSL_COUNT = "count";
    static final String RSL_DIRECTORY = "directory";
    static final String RSL_DRY_RUN = "dryrun";
    static final String RSL_ENVIRONMENT = "environment";
    static final String RSL_GRAM_MY_JOB = "grammyjobtype";
    static final String RSL_HOST_COUNT = "hostcount";
    static final String RSL_JOB_TYPE = "jobtype";
    static final String RSL_MAX_CPU_TIME = "maxcputime";
    static final String RSL_MAX_MEMORY = "maxmemory";
    static final String RSL_MAX_TIME = "maxtime";
    static final String RSL_MAX_WALL_TIME = "maxwalltime";
    static final String RSL_MIN_MEMORY = "minmemory";
    static final String RSL_REMOTE_IO_URL = "remoteiourl";
    static final String RSL_SAVE_STATE = "savestate";
    static final String RSL_TWO_PHASE = "twophase";
    static final String RSL_FILE_STAGE_IN = "filestagein";
    static final String RSL_FILE_STAGE_OUT = "filestageout";
    static final String RSL_STDOUT = "stdout";
    static final String RSL_STDERR = "stderr";
    static final String RSL_STDIN = "stdin";
    static final String RSL_FILE_CLEAN_UP = "filecleanup";
    static final String RSL_LIBRARY_PATH = "librarypath";
    static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$service$exec$PerlJobDescription == null ? (class$org$globus$exec$service$exec$PerlJobDescription = PerlJobDescription.class$("org.globus.exec.service.exec.PerlJobDescription")) : class$org$globus$exec$service$exec$PerlJobDescription));
    static /* synthetic */ Class class$org$globus$exec$service$exec$PerlJobDescription;
    static /* synthetic */ Class class$org$globus$exec$generated$NameValuePairType;
    static /* synthetic */ Class class$org$globus$exec$generated$FilePairType;

    public PerlJobDescription() {
    }

    public PerlJobDescription(JobDescriptionType jobDescription) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        super(jobDescription);
    }

    public PerlJobDescription(JobDescriptionType jobDescription, NameValuePairType[] extraEnvironment) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        super(jobDescription);
        String[] arguments = (String[])this.remove("argument");
        this.put(RSL_ARGUMENTS, arguments);
        if (extraEnvironment == null) {
            return;
        }
        NameValuePairType[] environment = (NameValuePairType[])this.get(RSL_ENVIRONMENT);
        if (environment == null) {
            environment = new NameValuePairType[]{};
        }
        NameValuePairType[] extendedEnvironment = new NameValuePairType[environment.length + extraEnvironment.length];
        System.arraycopy(environment, 0, extendedEnvironment, 0, environment.length);
        System.arraycopy(extraEnvironment, 0, extendedEnvironment, environment.length, extraEnvironment.length);
        this.put(RSL_ENVIRONMENT, extendedEnvironment);
    }

    public String toPerlString() {
        StringBuffer description = new StringBuffer();
        description.append("$description = {\n");
        Iterator attributeNames = this.keySet().iterator();
        while (attributeNames.hasNext()) {
            String origName = (String)attributeNames.next();
            String name = this.canonicalize(origName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processing attribute name " + origName + "/" + name));
            }
            if (name.equals(RSL_FILE_STAGE_IN) || name.equals(RSL_FILE_STAGE_OUT)) continue;
            Object value = this.get(origName);
            if (value == null) {
                if (name.equals(RSL_DIRECTORY)) {
                    description.append("    directory => [ '" + System.getProperty("user.home") + "' ],\n");
                    continue;
                }
                if (name.equals(RSL_STDIN)) {
                    logger.debug((Object)"appending stdin = /dev/null");
                    description.append("    stdin => [ '/dev/null' ],\n");
                    continue;
                }
                if (name.equals(RSL_COUNT)) {
                    description.append("    count => [ 1 ],\n");
                    continue;
                }
                if (!name.equals(RSL_JOB_TYPE)) continue;
                description.append("    jobtype => [ 'multiple' ],\n");
                continue;
            }
            description.append("    ");
            Class<?> valueClass = value.getClass();
            String valueClassName = valueClass.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attribute " + name + " is of type " + valueClassName));
            }
            if (valueClass.isArray()) {
                Class<?> componentClass = valueClass.getComponentType();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attribute " + name + " has component type " + componentClass.getName()));
                }
                if (componentClass.equals(class$org$globus$exec$generated$NameValuePairType == null ? PerlJobDescription.class$("org.globus.exec.generated.NameValuePairType") : class$org$globus$exec$generated$NameValuePairType)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attribute " + name + " being processed as " + "NameValuePairType[]"));
                    }
                    description.append(name).append(" => [ ").append(this.makeStringFromNameValuePairs((NameValuePairType[])value));
                    description.append(" ]");
                } else if (componentClass.equals(class$org$globus$exec$generated$FilePairType == null ? PerlJobDescription.class$("org.globus.exec.generated.FilePairType") : class$org$globus$exec$generated$FilePairType)) {
                    description.append(name).append(" => [ ").append(this.makeStringFromFilePairs((FilePairType[])value)).append(" ]");
                } else {
                    description.append(name).append(" => [ ").append(this.makeStringList(value)).append(" ]");
                }
            } else if (value instanceof Boolean) {
                description.append(name).append(" => [ '").append((Boolean)value != false ? "yes" : "no").append("' ]");
            } else if (value instanceof NameValuePairType) {
                NameValuePairType nvp = (NameValuePairType)value;
                description.append(name).append(" => [ [ ").append(this.makeString(nvp.getName())).append(", ").append(this.makeString(nvp.getValue())).append("]  ]");
            } else if (value instanceof FilePairType) {
                description.append(name).append(" => [ [ ").append(this.makeString(((FilePairType)value).getSourceFile())).append(", ").append(this.makeString(((FilePairType)value).getDestinationFile())).append("]  ]");
            } else {
                description.append(name).append(" => [ ").append(this.makeString(value)).append(" ]");
            }
            if (attributeNames.hasNext()) {
                description.append(",\n");
                continue;
            }
            description.append("\n");
        }
        description.append("};\n");
        return description.toString();
    }

    private String makeStringFromNestedList(Object o) {
        StringBuffer buffer = new StringBuffer();
        if (o instanceof Object[]) {
            Object[] tmp = (Object[])o;
            buffer.append("[ ");
            for (int i = 0; i < tmp.length; ++i) {
                buffer.append(this.makeStringFromNestedList(tmp[i]));
                if (i + 1 >= tmp.length) continue;
                buffer.append(", ");
            }
            buffer.append(" ]");
        } else if (o instanceof String) {
            String tmp = (String)o;
            buffer.append(this.makeString(tmp));
        }
        return buffer.toString();
    }

    private String makeString(Object o) {
        char[] chars = null;
        if (o instanceof ExtensionsType) {
            ExtensionsType extensions = (ExtensionsType)o;
            try {
                chars = AnyHelper.toSingleString((MessageElement[])extensions.get_any()).toCharArray();
            }
            catch (Exception e) {
                logger.error((Object)"unable to convert extensions to string");
                return null;
            }
        } else {
            chars = o.toString().toCharArray();
        }
        StringBuffer str = new StringBuffer();
        boolean j = false;
        str.append('\'');
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\'' || chars[i] == '\\') {
                str.append('\\');
                str.append(chars[i]);
                continue;
            }
            str.append(chars[i]);
        }
        str.append('\'');
        return str.toString();
    }

    private String makeStringList(Object values) {
        Class<?> valuesClass = values.getClass();
        if (!valuesClass.isArray()) {
            return null;
        }
        return this.makeStringList((Object[])values);
    }

    private String makeStringList(Object[] values) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            buffer.append(this.makeString(values[i].toString()));
            if (i + 1 >= values.length) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private String makeStringFromNameValuePairs(NameValuePairType[] nvpairs) {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < nvpairs.length; ++index) {
            buffer.append("[ ").append(this.makeString(nvpairs[index].getName())).append(", ").append(this.makeString(nvpairs[index].getValue())).append(" ]");
            if (nvpairs.length - index <= 0) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private String makeStringFromHash(Hashtable table) {
        StringBuffer buffer = new StringBuffer();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buffer.append("[ " + this.makeString(key) + ", " + this.makeString((String)table.get(key)) + " ]");
            if (!e.hasMoreElements()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private String makeStringFromFilePairs(FilePairType[] filePairs) {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < filePairs.length; ++index) {
            buffer.append("[ ").append(this.makeString(filePairs[index].getSourceFile())).append(", ").append(this.makeString(filePairs[index].getDestinationFile())).append(" ]");
            if (filePairs.length - index <= 0) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private String canonicalize(String s) {
        char[] chars = s.toCharArray();
        char[] canonical = new char[chars.length];
        int j = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '_') continue;
            canonical[j++] = Character.toLowerCase(chars[i]);
        }
        return new String(canonical, 0, j);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

