/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.util.Util;
import org.globus.exec.generated.FaultResourcePropertyType;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.InternalStateEnumeration;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.ManagedExecutableJobResourceDataType;
import org.globus.exec.generated.ManagedExecutableJobResourceStateType;
import org.globus.exec.generated.ManagedJobResourceDataType;
import org.globus.exec.generated.NameValuePairType;
import org.globus.exec.generated.ServiceLevelAgreementFaultType;
import org.globus.exec.generated.StagingFaultType;
import org.globus.exec.generated.StateChangeNotificationMessageType;
import org.globus.exec.generated.StateChangeNotificationMessageWrapperType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.monitoring.JobStateMonitor;
import org.globus.exec.service.exec.JobManagerScript;
import org.globus.exec.service.exec.ManagedExecutableJobHome;
import org.globus.exec.service.exec.PerlJobDescription;
import org.globus.exec.service.exec.RunQueue;
import org.globus.exec.service.exec.StateMachine;
import org.globus.exec.service.exec.utils.FileMapping;
import org.globus.exec.service.exec.utils.FileMappingException;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.factory.ManagedJobFactoryResource;
import org.globus.exec.service.job.ManagedJobResourceImpl;
import org.globus.exec.service.utils.DelegatedCredential;
import org.globus.exec.utils.FaultUtils;
import org.globus.exec.utils.ManagedExecutableJobConstants;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.exec.utils.service.ManagedJobHelper;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.DeleteType;
import org.globus.rft.generated.TransferRequestType;
import org.globus.rft.generated.TransferType;
import org.globus.security.gridmap.GridMap;
import org.globus.util.GlobusURL;
import org.globus.util.I18n;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.Topic;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.SimpleTopic;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.PerformanceLog;

public class ManagedExecutableJobResource
extends ManagedJobResourceImpl
implements RemoveCallback,
SecureResource {
    private static Log staticLogger = LogFactory.getLog((String)(class$org$globus$exec$service$exec$ManagedExecutableJobResource == null ? (class$org$globus$exec$service$exec$ManagedExecutableJobResource = ManagedExecutableJobResource.class$("org.globus.exec.service.exec.ManagedExecutableJobResource")) : class$org$globus$exec$service$exec$ManagedExecutableJobResource).getName());
    private Log logger;
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedExecutableJobResource.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private Map variableMap;
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$exec$ManagedExecutableJobResource == null ? (class$org$globus$exec$service$exec$ManagedExecutableJobResource = ManagedExecutableJobResource.class$("org.globus.exec.service.exec.ManagedExecutableJobResource")) : class$org$globus$exec$service$exec$ManagedExecutableJobResource).getName() + ".performance");
    JobStateMonitor jobMonitor = null;
    private String[] scriptEnvironment;
    private JobManagerScript script;
    private PerlJobDescription perlJobDescription;
    private static String STDIN_FILE_NAME = "stdin";
    private static int MAX_VARIABLE_DEPTH = 10;
    private EndpointReferenceType reliableFileTransferFactoryEndpoint = null;
    private Object stateTransitionMutex = new Object();
    private ResourceSecurityDescriptor securityDescriptor = null;
    static /* synthetic */ Class class$org$globus$exec$service$exec$ManagedExecutableJobResource;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$exec$generated$FaultType;
    static /* synthetic */ Class class$org$globus$exec$service$exec$PerlJobDescription;

    public void initializeWholeState(Object wholeResourceState, QName resourceElementQName, Object key) throws ResourceException {
        super.initializeWholeState(wholeResourceState, resourceElementQName, key);
        ManagedExecutableJobResourceStateType wholeJobState = (ManagedExecutableJobResourceStateType)wholeResourceState;
        this.setResourceData((ManagedJobResourceDataType)wholeJobState.getResourceData());
        this.initialize(wholeJobState.getResourceProperties(), resourceElementQName, key);
    }

    public void initialize(Object resourceBean, QName resourceElementQName, Object key) throws ResourceException {
        this.logger = LogFactory.getLog((String)((class$org$globus$exec$service$exec$ManagedExecutableJobResource == null ? (class$org$globus$exec$service$exec$ManagedExecutableJobResource = ManagedExecutableJobResource.class$("org.globus.exec.service.exec.ManagedExecutableJobResource")) : class$org$globus$exec$service$exec$ManagedExecutableJobResource).getName() + "." + ((ResourceKey)key).getValue().toString()));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Entering initialize()");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"at super.initialize()");
        }
        super.initialize(resourceBean, resourceElementQName, key);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"at initSecurity()");
        }
        this.initSecurity();
        JobDescriptionType jobDescription = this.getJobDescription();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"at initVariableMap()");
        }
        this.initVariableMap();
        String directory = jobDescription.getDirectory();
        if (directory == null) {
            jobDescription.setDirectory("${GLOBUS_USER_HOME}");
        }
        try {
            this.resolveVariables();
        }
        catch (FaultType f) {
            this.setFault(f);
            StateMachine.systemCancel(this);
        }
        catch (Exception e) {
            FaultType fault = FaultUtils.makeFault((Class)(class$org$globus$exec$generated$FaultType == null ? (class$org$globus$exec$generated$FaultType = ManagedExecutableJobResource.class$("org.globus.exec.generated.FaultType")) : class$org$globus$exec$generated$FaultType), (ResourceKey)((ResourceKey)this.getID()), (String)i18n.getMessage("VariableResolutionError"), (Exception)e, (StateEnumeration)this.getState(), null, (int)0);
            this.setFault(fault);
            if (this.logger.isDebugEnabled()) {
                this.logger.trace((Object)"setting state and notifying");
            }
            StateMachine.systemCancel(this);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"at initPerlJobDescription()");
        }
        this.initPerlJobDescription();
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)("Perl Job Description: " + this.perlJobDescription.toPerlString()));
        }
        this.initVariableMap();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Leaving initialize()");
        }
    }

    protected void initializeTopics() {
        super.initializeTopics();
        SimpleTopic stateChangeTopic = new SimpleTopic(ManagedJobConstants.RP_STATE);
        this.getTopicList().addTopic((Topic)stateChangeTopic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws ResourceException {
        performanceLogger.start();
        InternalStateEnumeration internalState = null;
        StateEnumeration state = null;
        this.logger.trace((Object)"acquring lock on resource...");
        ManagedExecutableJobResource managedExecutableJobResource = this;
        synchronized (managedExecutableJobResource) {
            this.logger.trace((Object)"acquired lock on resource...");
            internalState = this.getInternalState();
            state = this.getState();
            boolean canceled = (Boolean)this.getResourceDatum("canceled");
            if (!(internalState.equals((Object)InternalStateEnumeration.Done) || state.equals((Object)InternalStateEnumeration.Done) || internalState.equals((Object)InternalStateEnumeration.Failed) || state.equals((Object)InternalStateEnumeration.Failed) || canceled)) {
                StateMachine.userCancel(this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Remove called with external state " + state + " and internal state " + internalState));
            }
            while (!(internalState.equals((Object)InternalStateEnumeration.Done) || state.equals((Object)InternalStateEnumeration.Done) || internalState.equals((Object)InternalStateEnumeration.Failed) || state.equals((Object)InternalStateEnumeration.Done))) {
                this.logger.debug((Object)("Waiting to be Done or Failed. Current state: " + internalState));
                try {
                    this.wait(2000L);
                }
                catch (Exception e) {
                    String errorMessage = i18n.getMessage("InterruptResourceRemove");
                    this.logger.error((Object)errorMessage, (Throwable)e);
                }
                internalState = this.getInternalState();
                state = this.getState();
            }
            this.logger.trace((Object)"releasing lock on resource...");
        }
        this.logger.trace((Object)"released lock on resource...");
        performanceLogger.stop("remove");
    }

    public void initSecurity() throws ResourceException {
        String localUserId;
        block10: {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Entering initSecurity()");
            }
            localUserId = (String)this.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID);
            File userGlobusDirectory = ManagedExecutableJobResource.getUserGlobusDirectory(localUserId);
            JobDescriptionType jobDescription = this.getJobDescription();
            if (jobDescription.getJobCredentialEndpoint() != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"at getJobCredential()");
                }
                try {
                    this.getJobCredential(userGlobusDirectory);
                }
                catch (Exception e) {
                    StateEnumeration state = this.getState();
                    if (state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) break block10;
                    throw new ResourceException((Throwable)e);
                }
            }
        }
        ResourceSecurityConfig securityConfig = new ResourceSecurityConfig("etc/gram-service/managed-job-security-config.xml");
        try {
            securityConfig.init();
        }
        catch (Exception e) {
            throw new ResourceException(i18n.getMessage("resourceSecurityInitializationFailed"), (Throwable)e);
        }
        this.securityDescriptor = securityConfig.getSecurityDescriptor();
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)("resource credential subject:\n" + this.securityDescriptor.getSubject()));
        }
        String userSubject = (String)this.getResourceProperty(ManagedJobConstants.RP_USER_SUBJECT);
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)("setting resource securty grid map...\nSubject: " + userSubject + "\nLocal user ID: " + localUserId));
        }
        GridMap gridMap = new GridMap();
        gridMap.map(userSubject, localUserId);
        this.securityDescriptor.setGridMap(gridMap);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Leaving initSecurity()");
        }
    }

    public File getJobDirectory(String localUserId) {
        return new File(ManagedExecutableJobResource.getUserGlobusDirectory(localUserId), ((ResourceKey)this.getID()).getValue().toString());
    }

    public static File getUserGlobusDirectory(String localUserId) {
        return new File(ManagedExecutableJobHome.getUserHomeDirectory(localUserId) + File.separator + ".globus");
    }

    private File getUserProxyFile(String localUserId) throws ResourceException {
        DelegatedCredential jobCredential;
        block3: {
            jobCredential = null;
            try {
                jobCredential = this.getJobCredential(ManagedExecutableJobResource.getUserGlobusDirectory(localUserId));
            }
            catch (Exception e) {
                StateEnumeration state = this.getState();
                if (state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) break block3;
                throw new ResourceException((Throwable)e);
            }
        }
        if (jobCredential == null) {
            return null;
        }
        return jobCredential.getUserProxyFile();
    }

    protected boolean envVarAlreadySet(String varName) {
        JobDescriptionType jobDescription = this.getJobDescription();
        NameValuePairType[] envVars = jobDescription.getEnvironment();
        if (envVars == null) {
            return false;
        }
        boolean varFound = false;
        for (int index = 0; !varFound && index < envVars.length; ++index) {
            if (!envVars[index].getName().equals(varName)) continue;
            varFound = true;
        }
        return varFound;
    }

    private NameValuePairType[] initExtraEnvironment() throws ResourceException {
        File userProxyFile;
        String x509UserProxy;
        String x509CertDir;
        String globusLocation;
        FactoryHomeConfiguration factoryHomeConfiguration;
        String localUserId;
        block14: {
            localUserId = (String)this.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID);
            factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
            globusLocation = factoryHomeConfiguration.getGlobusLocation();
            x509CertDir = factoryHomeConfiguration.getX509CertDir();
            x509UserProxy = null;
            userProxyFile = null;
            try {
                userProxyFile = this.getUserProxyFile(localUserId);
            }
            catch (ResourceException re) {
                StateEnumeration state = this.getState();
                if (state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) break block14;
                throw re;
            }
        }
        x509UserProxy = userProxyFile == null ? "" : userProxyFile.toString();
        String tcpPortRange = factoryHomeConfiguration.getTcpPortRange();
        int index = 0;
        String userHome = ManagedExecutableJobHome.getUserHomeDirectory(localUserId);
        this.scriptEnvironment = new String[6];
        this.scriptEnvironment[index++] = new String("HOME=" + userHome);
        this.scriptEnvironment[index++] = new String("GLOBUS_LOCATION=" + globusLocation);
        this.scriptEnvironment[index++] = new String("X509_CERT_DIR=" + x509CertDir);
        this.scriptEnvironment[index++] = new String("X509_USER_PROXY=" + x509UserProxy);
        this.scriptEnvironment[index++] = new String("X509_USER_CERT=" + x509UserProxy);
        this.scriptEnvironment[index++] = new String("X509_USER_KEY=" + x509UserProxy);
        Vector<NameValuePairType> extraProcEnvironment = new Vector<NameValuePairType>();
        index = 0;
        JobDescriptionType jobDescription = this.getJobDescription();
        try {
            if (!this.envVarAlreadySet("GLOBUS_LOCATION")) {
                extraProcEnvironment.add(new NameValuePairType("GLOBUS_LOCATION", globusLocation));
            }
            if (!this.envVarAlreadySet("X509_CERT_DIR")) {
                extraProcEnvironment.add(new NameValuePairType("X509_CERT_DIR", x509CertDir));
            }
            if (!this.envVarAlreadySet("X509_USER_PROXY")) {
                extraProcEnvironment.add(new NameValuePairType("X509_USER_PROXY", x509UserProxy));
            }
            if (!this.envVarAlreadySet("X509_USER_CERT")) {
                extraProcEnvironment.add(new NameValuePairType("X509_USER_CERT", x509UserProxy));
            }
            if (!this.envVarAlreadySet("X509_USER_KEY")) {
                extraProcEnvironment.add(new NameValuePairType("X509_USER_KEY", x509UserProxy));
            }
            if (!this.envVarAlreadySet("HOME")) {
                extraProcEnvironment.add(new NameValuePairType("HOME", this.resolveVariableInString("environment", "${GLOBUS_USER_HOME}")));
            }
            if (!this.envVarAlreadySet("LOGNAME")) {
                extraProcEnvironment.add(new NameValuePairType("LOGNAME", this.resolveVariableInString("environment", "${GLOBUS_USER_NAME}")));
            }
            if (!this.envVarAlreadySet("GLOBUS_TCP_PORT_RANGE") && tcpPortRange != null && !tcpPortRange.equals("")) {
                extraProcEnvironment.add(new NameValuePairType("GLOBUS_TCP_PORT_RANGE", tcpPortRange));
            }
            if (!this.envVarAlreadySet("SCRATCH_DIRECTORY")) {
                extraProcEnvironment.add(new NameValuePairType("SCRATCH_DIRECTORY", this.resolveVariableInString("environment", "${GLOBUS_SCRATCH_DIR}")));
            }
            if (!this.envVarAlreadySet("JAVA_HOME")) {
                extraProcEnvironment.add(new NameValuePairType("JAVA_HOME", System.getProperty("java.home", "")));
            }
            extraProcEnvironment.add(new NameValuePairType("GLOBUS_GRAM_JOB_HANDLE", this.getResourceData().getHandle()));
        }
        catch (ServiceLevelAgreementFaultType slaf) {
            throw new ResourceException((Throwable)slaf);
        }
        return extraProcEnvironment.toArray(new NameValuePairType[0]);
    }

    private void initExtraAttributes() {
        String[] localJobIds;
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)"Adding extra attributes to the Perl job attribute map");
        }
        ManagedExecutableJobResourceDataType resourceData = (ManagedExecutableJobResourceDataType)this.getResourceData();
        String localUserId = (String)this.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID);
        this.perlJobDescription.put("jobdir", this.getJobDirectory(localUserId).toString());
        String localResourceManager = resourceData.getLocalResourceManager();
        if (localResourceManager.equals("Fork")) {
            this.perlJobDescription.put("useForkStarter", "1");
        }
        this.perlJobDescription.put("xml_extensions", "1");
        this.logger.trace((Object)("checking for condorness of " + localResourceManager));
        if (localResourceManager.equals("Condor")) {
            this.logger.trace((Object)"adding emitCondorProcesses attribute");
            this.perlJobDescription.put("emitCondorProcesses", "1");
        }
        ManagedJobFactoryHome factoryHome = null;
        ManagedJobFactoryResource factoryResource = null;
        try {
            factoryHome = ManagedJobFactoryHome.getHome();
            factoryResource = (ManagedJobFactoryResource)factoryHome.find((ResourceKey)ManagedJobHelper.getResourceKey((String)localResourceManager));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (factoryResource.isDefaultSoftwareEnvironmentEnabled()) {
            this.perlJobDescription.put("enableDefaultSoftwareEnvironment", "1");
        }
        if ((localJobIds = resourceData.getLocalJobId()) != null) {
            int size = localJobIds.length;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                sb.append(localJobIds[i]);
                if (i >= size - 1) continue;
                sb.append(",");
            }
            this.perlJobDescription.put("jobid", sb.toString());
        }
        FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
        String condorOs = factoryHomeConfiguration.getCondorOS();
        this.perlJobDescription.put("condorOs", condorOs);
        String condorArch = factoryHomeConfiguration.getCondorArchitecture();
        this.perlJobDescription.put("condorArch", condorArch);
    }

    private void initVariableMap() throws ResourceException {
        this.variableMap = new HashMap();
        String localUserId = (String)this.getResourceProperty(ManagedJobConstants.RP_LOCAL_USER_ID);
        this.variableMap.put("GLOBUS_USER_NAME", localUserId);
        this.variableMap.put("GLOBUS_USER_HOME", ManagedExecutableJobHome.getUserHomeDirectory(localUserId));
        String localResourceManager = ((ManagedExecutableJobResourceDataType)this.getResourceData()).getLocalResourceManager();
        ManagedJobFactoryHome factoryHome = null;
        try {
            factoryHome = ManagedJobFactoryHome.getHome();
        }
        catch (NamingException ne) {
            throw new ResourceException((Throwable)ne);
        }
        ManagedJobFactoryResource factoryResource = (ManagedJobFactoryResource)factoryHome.find((ResourceKey)ManagedJobHelper.getResourceKey((String)localResourceManager));
        String scratchDir = (String)factoryResource.getResourcePropertySet().get(ManagedJobFactoryConstants.RP_SCRATCH_BASE_DIRECTORY).get(0);
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)("GLOBUS_SCRATCH_DIR:" + scratchDir));
        }
        this.variableMap.put("GLOBUS_SCRATCH_DIR", scratchDir);
        this.variableMap.put("GLOBUS_JOB_ID", ((ResourceKey)this.getID()).getValue());
        Iterator subDefIterator = factoryResource.substitutionDefinitionSet().iterator();
        while (subDefIterator.hasNext()) {
            Map.Entry subDef = (Map.Entry)subDefIterator.next();
            this.variableMap.put(subDef.getKey(), subDef.getValue());
        }
    }

    private void initPerlJobDescription() {
        JobDescriptionType jobDescription = this.getJobDescription();
        try {
            NameValuePairType[] extraEnvironment = this.initExtraEnvironment();
            this.perlJobDescription = new PerlJobDescription(jobDescription, extraEnvironment);
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("objectCreationFailed", new Object[]{(class$org$globus$exec$service$exec$PerlJobDescription == null ? (class$org$globus$exec$service$exec$PerlJobDescription = ManagedExecutableJobResource.class$("org.globus.exec.service.exec.PerlJobDescription")) : class$org$globus$exec$service$exec$PerlJobDescription).getName()});
            throw new RuntimeException(errorMessage, e);
        }
        this.initExtraAttributes();
    }

    private static String cleanUrl(String urlString) throws MalformedURLException {
        GlobusURL url = new GlobusURL(urlString);
        String protocol = url.getProtocol();
        String host = url.getHost();
        if (protocol.equals("file") && host.length() > 0) {
            throw new MalformedURLException(i18n.getMessage("UnallowedFileUrlHost", (Object[])new String[]{url.getURL(), url.getHost()}));
        }
        if (!protocol.equals("file") && host.length() == 0) {
            throw new MalformedURLException(i18n.getMessage("MissingUrlHost", (Object[])new String[]{url.getURL()}));
        }
        String cleanedPath = url.getPath();
        if (cleanedPath != null) {
            cleanedPath = cleanedPath.replaceAll("/+", "/").replaceFirst("^/", "");
        }
        int port = url.getPort();
        String cleanedUrlString = url.getProtocol() + "://" + url.getHost() + (port >= 0 ? ":" + port : "") + "/" + (cleanedPath != null ? cleanedPath : "");
        staticLogger.debug((Object)("Cleaned URL: " + cleanedUrlString));
        return cleanedUrlString;
    }

    public void resolveVariables() throws ServiceLevelAgreementFaultType, MalformedURLException, FileMappingException {
        DeleteRequestType deleteRequest;
        GlobusURL url;
        TransferRequestType stageOut;
        this.logger.debug((Object)"Entering resolveVariables()");
        JobDescriptionType jobDescription = this.getJobDescription();
        FileMapping fsMap = null;
        TransferRequestType stageIn = jobDescription.getFileStageIn();
        if (stageIn != null) {
            if (fsMap == null) {
                fsMap = this.getFileSystemMapping();
            }
            TransferType[] stageInList = stageIn.getTransfer();
            for (int index = 0; index < stageInList.length; ++index) {
                GlobusURL url2;
                String sourceUrl = null;
                String destinationUrl = null;
                try {
                    sourceUrl = ManagedExecutableJobResource.cleanUrl(stageInList[index].getSourceUrl());
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + stageInList[index].getSourceUrl() + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageIn", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                try {
                    destinationUrl = ManagedExecutableJobResource.cleanUrl(stageInList[index].getDestinationUrl());
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + stageInList[index].getDestinationUrl() + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageIn", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("fileStageIn sourceUrl before: " + sourceUrl));
                }
                sourceUrl = this.resolveVariableInString("fileStageIn", sourceUrl);
                try {
                    url2 = new GlobusURL(sourceUrl);
                    if (url2.getProtocol().equals("file")) {
                        sourceUrl = null;
                    }
                }
                catch (MalformedURLException mue) {
                    this.logger.warn((Object)mue);
                    sourceUrl = null;
                }
                if (sourceUrl == null) {
                    StagingFaultType fault = FaultUtils.createStagingFault((String)"null", (String)destinationUrl, (String)"fileStageIn", (StateEnumeration)this.getState(), (String)null, (ResourceKey)((ResourceKey)this.getID()));
                    this.logger.debug((Object)"sourceUrl fault", (Throwable)fault);
                    throw fault;
                }
                try {
                    stageInList[index].setSourceUrl(ManagedExecutableJobResource.cleanUrl(sourceUrl));
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + sourceUrl + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageIn", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.trace((Object)("fileStageIn sourceUrl after:" + sourceUrl));
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("fileStageIn destinationUrl before: " + destinationUrl));
                }
                if ((url2 = new GlobusURL(destinationUrl = this.resolveVariableInString("fileStageIn", destinationUrl))).getProtocol().equals("file")) {
                    destinationUrl = fsMap.mapFileName(url2);
                }
                if (destinationUrl == null) {
                    StagingFaultType fault = FaultUtils.createStagingFault((String)sourceUrl, (String)"null", (String)"fileStageIn", (StateEnumeration)this.getState(), (String)null, (ResourceKey)((ResourceKey)this.getID()));
                    this.logger.debug((Object)"sourceUrl fault", (Throwable)fault);
                    throw fault;
                }
                try {
                    stageInList[index].setDestinationUrl(ManagedExecutableJobResource.cleanUrl(destinationUrl));
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + destinationUrl + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageIn", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)("fileStageIn destinationUrl after: " + destinationUrl));
            }
        }
        if ((stageOut = jobDescription.getFileStageOut()) != null) {
            if (fsMap == null) {
                fsMap = this.getFileSystemMapping();
            }
            TransferType[] stageOutList = stageOut.getTransfer();
            for (int index = 0; index < stageOutList.length; ++index) {
                String sourceUrl = null;
                String destinationUrl = null;
                try {
                    sourceUrl = ManagedExecutableJobResource.cleanUrl(stageOutList[index].getSourceUrl());
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + stageOutList[index].getSourceUrl() + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageOut", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                try {
                    destinationUrl = ManagedExecutableJobResource.cleanUrl(stageOutList[index].getDestinationUrl());
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + stageOutList[index].getDestinationUrl() + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageOut", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.trace((Object)("fileStageOut sourceUrl before:" + sourceUrl));
                }
                sourceUrl = this.resolveVariableInString("fileStageOut", sourceUrl);
                try {
                    url = new GlobusURL(sourceUrl);
                    if (url.getProtocol().equals("file")) {
                        sourceUrl = fsMap.mapFileName(url);
                    }
                }
                catch (MalformedURLException mue) {
                    sourceUrl = null;
                }
                if (sourceUrl == null) {
                    throw FaultUtils.createStagingFault((String)"null", (String)destinationUrl, (String)"fileStageOut", (StateEnumeration)this.getState(), (String)null, (ResourceKey)((ResourceKey)this.getID()));
                }
                try {
                    stageOutList[index].setSourceUrl(ManagedExecutableJobResource.cleanUrl(sourceUrl));
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + sourceUrl + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageOut", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.trace((Object)("fileStageOut sourceUrl after:" + sourceUrl));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.trace((Object)("fileStageOut destinationUrl before:" + destinationUrl));
                }
                destinationUrl = this.resolveVariableInString("fileStageOut", destinationUrl);
                try {
                    url = new GlobusURL(destinationUrl);
                    if (url.getProtocol().equals("file")) {
                        destinationUrl = null;
                    }
                }
                catch (MalformedURLException mue) {
                    destinationUrl = null;
                }
                if (destinationUrl == null) {
                    throw FaultUtils.createStagingFault((String)sourceUrl, (String)"null", (String)"fileStageOut", (StateEnumeration)this.getState(), (String)null, (ResourceKey)((ResourceKey)this.getID()));
                }
                try {
                    stageOutList[index].setDestinationUrl(ManagedExecutableJobResource.cleanUrl(destinationUrl));
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + destinationUrl + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileStageOut", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.trace((Object)("fileStageOut destinationUrl after:" + destinationUrl));
            }
        }
        if ((deleteRequest = jobDescription.getFileCleanUp()) != null) {
            if (fsMap == null) {
                fsMap = this.getFileSystemMapping();
            }
            DeleteType[] deletionList = deleteRequest.getDeletion();
            for (int index = 0; index < deletionList.length; ++index) {
                String fileUrl = null;
                try {
                    fileUrl = ManagedExecutableJobResource.cleanUrl(deletionList[index].getFile());
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + deletionList[index].getFile() + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileCleanUp", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.trace((Object)("fileCleanUp file before:" + fileUrl));
                }
                fileUrl = this.resolveVariableInString("fileCleanUp", fileUrl);
                try {
                    url = new GlobusURL(fileUrl);
                    if (url.getProtocol().equals("file")) {
                        fileUrl = fsMap.mapFileName(url);
                    }
                }
                catch (MalformedURLException mue) {
                    this.logger.warn((Object)mue);
                    fileUrl = null;
                }
                if (fileUrl == null) {
                    throw FaultUtils.createServiceLevelAgreementFault((String)"fileCleanUp", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()));
                }
                try {
                    deletionList[index].setFile(ManagedExecutableJobResource.cleanUrl(fileUrl));
                }
                catch (Exception e) {
                    this.logger.debug((Object)("unable to clean URL \"" + fileUrl + "\""), (Throwable)e);
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)"fileCleanUp", (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)e);
                    throw fault;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.trace((Object)("fileCleanUp file after:" + fileUrl));
            }
        }
        String str = jobDescription.getExecutable();
        str = this.resolveVariableInString("executable", str);
        str = str.replaceAll("/+", "/");
        jobDescription.setExecutable(str);
        str = jobDescription.getDirectory();
        str = this.resolveVariableInString("directory", str);
        if (!str.startsWith("/") && !str.matches("^[a-zA-Z]:.*")) {
            str = "${GLOBUS_USER_HOME}" + File.separator + str;
            str = this.resolveVariableInString("directory", str);
        }
        str = str.replaceAll("/+", "/");
        jobDescription.setDirectory(str);
        String[] arr = jobDescription.getArgument();
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.resolveVariableInString("argument", arr[i]);
            }
        }
        jobDescription.setArgument(arr);
        NameValuePairType[] env = jobDescription.getEnvironment();
        if (env != null) {
            for (int i = 0; i < env.length; ++i) {
                env[i].setName(this.resolveVariableInString("environment", env[i].getName()));
                env[i].setValue(this.resolveVariableInString("environment", env[i].getValue()));
            }
        }
        jobDescription.setEnvironment(env);
        str = jobDescription.getStdin();
        str = this.resolveVariableInString("stdin", str);
        jobDescription.setStdin(str);
        str = jobDescription.getStdout();
        if (str == null) {
            this.logger.trace((Object)"No stdout set. Setting to /dev/null.");
            jobDescription.setStdout("/dev/null");
        } else {
            if (!(str = this.resolveVariableInString("stdout", str)).startsWith("/") && !str.matches("^[a-zA-Z]:.*")) {
                str = jobDescription.getDirectory() + File.separator + str;
                str = this.resolveVariableInString("stdout", str);
            }
            str = str.replaceAll("/+", "/");
            jobDescription.setStdout(str);
        }
        str = jobDescription.getStderr();
        if (str == null) {
            this.logger.trace((Object)"No stderr set. Setting to /dev/null.");
            jobDescription.setStderr("/dev/null");
        } else {
            if (!(str = this.resolveVariableInString("stderr", str)).startsWith("/") && !str.matches("^[a-zA-Z]:.*")) {
                str = jobDescription.getDirectory() + File.separator + str;
                str = this.resolveVariableInString("stderr", str);
            }
            str = str.replaceAll("/+", "/");
            jobDescription.setStderr(str);
        }
        arr = jobDescription.getLibraryPath();
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.resolveVariableInString("libraryPath", arr[i]);
            }
        }
        jobDescription.setLibraryPath(arr);
        this.logger.debug((Object)"Leaving resolveVariables()");
    }

    private String resolveVariableInString(String attribute, String s) throws ServiceLevelAgreementFaultType {
        int dollar_idx;
        if (s == null) {
            return null;
        }
        int index = 0;
        int nestingDepth = 0;
        int nestingIndex = 0;
        int close_idx = -1;
        StringBuffer buffer = new StringBuffer(s);
        String variableName = null;
        Object variableValue = null;
        this.logger.trace((Object)("resolving variables in attribute " + attribute));
        while (index < buffer.length() && (dollar_idx = buffer.indexOf("$", index)) != -1) {
            this.logger.trace((Object)("looking at string " + buffer.toString()));
            this.logger.trace((Object)("found $ at index " + Integer.toString(dollar_idx)));
            if (buffer.length() > dollar_idx + 3 && buffer.charAt(dollar_idx + 1) == '{') {
                this.logger.trace((Object)"found '{'---looks like a reference");
                if (index < nestingIndex) {
                    if (++nestingDepth >= MAX_VARIABLE_DEPTH) {
                        Exception cause = new Exception(i18n.getMessage("VariableDepthExceeded", (Object[])new String[]{variableName, variableValue.toString()}));
                        ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)attribute, (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)cause);
                        throw fault;
                    }
                } else {
                    nestingDepth = 0;
                }
                if ((close_idx = buffer.indexOf("}")) == -1) {
                    this.logger.trace((Object)"didn't find '}'---bailing");
                    return buffer.toString();
                }
                variableName = buffer.substring(dollar_idx + 2, close_idx);
                this.logger.trace((Object)("looking up " + variableName + " in " + this.variableMap));
                variableValue = this.variableMap.get(variableName);
                this.logger.trace((Object)("mapped " + variableName + " to value " + variableValue));
                if (variableValue == null) {
                    Exception cause = new Exception(i18n.getMessage("NullVariableValue", (Object[])new String[]{variableName}));
                    ServiceLevelAgreementFaultType fault = FaultUtils.createServiceLevelAgreementFault((String)attribute, (StateEnumeration)this.getState(), (String)null, (int)0, (ResourceKey)((ResourceKey)this.getID()), (Exception)cause);
                    throw fault;
                }
                buffer.replace(dollar_idx, close_idx + 1, variableValue.toString());
                index = dollar_idx;
                nestingIndex = index + variableValue.toString().length();
                continue;
            }
            this.logger.trace((Object)"No '{' after $, not a variable");
            ++index;
        }
        s = buffer.toString();
        this.logger.trace((Object)("Final string is " + s));
        return s;
    }

    public synchronized void start() {
        boolean started = (Boolean)this.getResourceDatum("started");
        if (!started) {
            if (this.logger.isDebugEnabled()) {
                this.logger.trace((Object)"Adding to RunQueue.");
            }
            this.setResourceDatum("started", new Boolean(true));
        }
        RunQueue.getInstance().add((ResourceKey)this.getID());
    }

    FileMapping getFileSystemMapping() throws FileMappingException {
        FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
        String globusLocation = factoryHomeConfiguration.getGlobusLocation();
        ManagedExecutableJobResourceDataType resourceData = (ManagedExecutableJobResourceDataType)this.getResourceData();
        String localResourceManager = resourceData.getLocalResourceManager();
        String filePathConfig = new File(globusLocation + File.separator + "etc" + File.separator + "gram-service", "globus_gram_fs_map_config.xml").toString();
        return new FileMapping(filePathConfig, localResourceManager);
    }

    public void setState(StateEnumeration state) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)("receiving request for state change to " + state.getValue()));
        }
        super.setState(state);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("State of job " + this.getID() + " changed to: " + state.toString()));
        }
        Boolean holding = (Boolean)this.getResourcePropertySet().get(ManagedJobConstants.RP_HOLDING).get(0);
        if (this.logger.isDebugEnabled()) {
            this.logger.trace((Object)("Holding: " + holding));
        }
        ResourceProperty faultRP = this.getResourcePropertySet().get(ManagedJobConstants.RP_FAULT);
        FaultResourcePropertyType fault = null;
        if (state.equals((Object)StateEnumeration.Failed)) {
            fault = (FaultResourcePropertyType)faultRP.get(0);
        }
        ResourceProperty exitCodeRP = this.getResourcePropertySet().get(ManagedExecutableJobConstants.RP_EXIT_CODE);
        Integer exitCode = null;
        if (state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) {
            exitCode = (Integer)exitCodeRP.get(0);
        }
        StateChangeNotificationMessageType message = new StateChangeNotificationMessageType();
        message.setState(state);
        message.setHolding(holding.booleanValue());
        message.setFault(fault);
        if (exitCode != null) {
            this.logger.trace((Object)("Setting exitCode to " + exitCode.toString()));
            message.setExitCode(exitCode.intValue());
        } else {
            this.logger.trace((Object)"exitCode is null");
        }
        StateChangeNotificationMessageWrapperType messageWrapper = new StateChangeNotificationMessageWrapperType();
        messageWrapper.setStateChangeNotificationMessage(message);
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(ManagedJobConstants.RP_STATE);
        Topic stateChangeTopic = this.getTopicList().getTopic(topicPath);
        this.logger.trace((Object)"Notifying of job state change to topic listeners");
        stateChangeTopic.notify((Object)messageWrapper);
    }

    public JobStateMonitor getJobStateMonitor() {
        if (this.jobMonitor == null) {
            this.logger.trace((Object)"job monitor is null");
            try {
                ManagedJobFactoryHome factoryHome = ManagedJobFactoryHome.getHome();
                String localResourceManager = ((ManagedExecutableJobResourceDataType)this.getResourceData()).getLocalResourceManager();
                ManagedJobFactoryResource factoryResource = (ManagedJobFactoryResource)factoryHome.find((ResourceKey)ManagedJobHelper.getResourceKey((String)localResourceManager));
                this.jobMonitor = factoryResource.getJobStateMonitor();
            }
            catch (NamingException ne) {
                this.logger.warn((Object)ne);
            }
            catch (ResourceException re) {
                this.logger.warn((Object)re);
            }
        }
        return this.jobMonitor;
    }

    public void setScriptEnvironment(String[] env) {
        this.scriptEnvironment = env;
    }

    public String[] getScriptEnvironment() {
        return this.scriptEnvironment;
    }

    public void setScript(JobManagerScript script) {
        this.script = script;
    }

    public JobManagerScript getScript() {
        return this.script;
    }

    public void setPerlJobDescription(PerlJobDescription perlJobDescription) {
        this.perlJobDescription = perlJobDescription;
    }

    public PerlJobDescription getPerlJobDescription() {
        return this.perlJobDescription;
    }

    public EndpointReferenceType getReliableFileTransferFactoryEndpoint() {
        if (this.reliableFileTransferFactoryEndpoint == null) {
            FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
            String name = "ReliableFileTransferFactoryService";
            String nameOverride = factoryHomeConfiguration.getStagingFactoryName();
            if (nameOverride != null) {
                name = nameOverride;
            }
            String localResourceManager = (String)this.getResourceDatum("localResourceManager");
            SimpleResourceKey factoryKey = ManagedJobHelper.getResourceKey((String)localResourceManager);
            ManagedJobFactoryResource factoryResource = null;
            try {
                factoryResource = (ManagedJobFactoryResource)ManagedJobFactoryHome.getHome().find((ResourceKey)factoryKey);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            EndpointReferenceType endpoint = factoryResource.getStagingDelegationFactoryEndpoint();
            AttributedURI address = endpoint.getAddress();
            File path = new File(address.getPath());
            URL serviceUrl = null;
            String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
            try {
                String scheme = null;
                scheme = wsTransportProtocol == null ? "local" : address.getScheme();
                serviceUrl = new URL(scheme, address.getHost(), address.getPort(), path.getParent() + "/" + name);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("RFT Factory EPR: " + serviceUrl.toString()));
                }
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("StagingEPRCreationError", serviceUrl);
                throw new RuntimeException(errorMessage, e);
            }
            try {
                this.reliableFileTransferFactoryEndpoint = AddressingUtils.createEndpointReference((String)serviceUrl.toString(), null);
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("StagingEPRCreationError", (Object)serviceUrl);
                throw new RuntimeException(errorMessage, e);
            }
        }
        return this.reliableFileTransferFactoryEndpoint;
    }

    public Object getStateTransitionMutex() {
        return this.stateTransitionMutex;
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        if (this.securityDescriptor != null) {
            this.logger.trace((Object)("MJR security descriptor authz: " + this.securityDescriptor.getAuthz()));
        } else {
            this.logger.trace((Object)"MRJR security descriptor is null");
        }
        return this.securityDescriptor;
    }

    public Log getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalStateEnumeration getInternalState() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getting resource datum internalState");
        }
        InternalStateEnumeration internalState = null;
        ManagedExecutableJobResourceDataType resourceData = (ManagedExecutableJobResourceDataType)this.getResourceData();
        this.logger.trace((Object)"Obtaining lock on resourceData");
        ManagedExecutableJobResourceDataType managedExecutableJobResourceDataType = resourceData;
        synchronized (managedExecutableJobResourceDataType) {
            this.logger.trace((Object)"Obtained lock on resourceData");
            internalState = resourceData.getInternalState();
            this.logger.trace((Object)"Releasing lock on resourceData");
        }
        this.logger.trace((Object)"Released lock on resourceData");
        return internalState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInternalState(InternalStateEnumeration internalState) throws ResourceException {
        Log logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting resource datum internalState to value " + internalState));
        }
        ManagedExecutableJobResourceDataType resourceData = (ManagedExecutableJobResourceDataType)this.getResourceData();
        logger.trace((Object)"Obtaining lock on resourceData");
        ManagedExecutableJobResourceDataType managedExecutableJobResourceDataType = resourceData;
        synchronized (managedExecutableJobResourceDataType) {
            logger.trace((Object)"Obtained lock on resourceData");
            resourceData.setInternalState(internalState);
            logger.trace((Object)"Releasing lock on resourceData");
        }
        logger.trace((Object)"Released lock on resourceData");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Util.registerTransport();
    }
}

