/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.xml.rpc.Stub;
import org.apache.axis.MessageContext;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.PositiveInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.transport.local.LocalTransportUtils;
import org.globus.exec.generated.InternalStateEnumeration;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.ManagedExecutableJobResourceDataType;
import org.globus.exec.generated.ManagedExecutableJobResourcePropertiesType;
import org.globus.exec.generated.ManagedExecutableJobResourceStateType;
import org.globus.exec.generated.MultiJobDescriptionType;
import org.globus.exec.generated.ServiceLevelAgreementType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.monitoring.JobStateChangeListener;
import org.globus.exec.service.exec.ManagedExecutableJobResource;
import org.globus.exec.service.exec.RunQueue;
import org.globus.exec.service.exec.StateMachine;
import org.globus.exec.service.exec.utils.LocalTransportClient;
import org.globus.exec.service.factory.FactoryHomeConfiguration;
import org.globus.exec.service.factory.FactoryServiceConfiguration;
import org.globus.exec.service.factory.ManagedJobFactoryHome;
import org.globus.exec.service.job.ManagedJobHome;
import org.globus.exec.service.utils.AuditDatabaseConfiguration;
import org.globus.exec.service.utils.ConfigurationHelper;
import org.globus.exec.service.utils.GlobusShToolsProperties;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.audit.AuditDatabaseAppender;
import org.globus.exec.utils.service.ManagedJobHelper;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.PersistentResource;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.PerformanceLog;
import org.globus.wsrf.utils.XmlPersistenceHelper;

public class ManagedExecutableJobHome
extends ResourceHomeImpl
implements JobStateChangeListener,
ManagedJobHome {
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$exec$service$exec$ManagedExecutableJobHome == null ? (class$org$globus$exec$service$exec$ManagedExecutableJobHome = ManagedExecutableJobHome.class$("org.globus.exec.service.exec.ManagedExecutableJobHome")) : class$org$globus$exec$service$exec$ManagedExecutableJobHome).getName());
    static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = ManagedExecutableJobHome.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    private static ManagedExecutableJobHome INSTANCE = null;
    private static Map userHomeMap = Collections.synchronizedMap(new HashMap());
    private static AuditDatabaseConfiguration AUDIT_DATABASE_CONFIGURATION = null;
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$exec$service$exec$ManagedExecutableJobHome == null ? (class$org$globus$exec$service$exec$ManagedExecutableJobHome = ManagedExecutableJobHome.class$("org.globus.exec.service.exec.ManagedExecutableJobHome")) : class$org$globus$exec$service$exec$ManagedExecutableJobHome).getName() + ".performance");
    private boolean recovered = false;
    private boolean initialized = false;
    private MessageContext cachedContext = null;
    private Hashtable idempotenceIdMap = null;
    private static NotificationConsumerManager NOTIFICATION_CONSUMER_MANAGER;
    private static final PositiveInteger DEFAULT_PROCESS_COUNT;
    private static UUIDGen uuidGen;
    static /* synthetic */ Class class$org$globus$exec$service$exec$ManagedExecutableJobHome;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$globus$exec$generated$ManagedExecutableJobResourceStateType;
    static /* synthetic */ Class class$org$globus$wsrf$PersistentResource;

    public ManagedExecutableJobHome() {
        logger.debug((Object)"Entering ManagedExecutableJobHome()");
        logger.debug((Object)"Leaving ManagedExecutableJobHome()");
    }

    public synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        logger.debug((Object)"Entering initialize()");
        RunQueue.getInstance();
        this.idempotenceIdMap = new Hashtable();
        this.cachedContext = MessageContext.getCurrentContext();
        this.keyTypeName = ManagedJobConstants.RESOURCE_KEY_QNAME;
        super.initialize();
        StateMachine.init();
        AuditDatabaseConfiguration auditDatabaseConfiguration = ManagedExecutableJobHome.getAuditDatabaseConfiguration();
        AuditDatabaseAppender.initialize((String)auditDatabaseConfiguration.getDriverClass(), (String)auditDatabaseConfiguration.getUrl(), (String)auditDatabaseConfiguration.getUser(), (String)auditDatabaseConfiguration.getPassword());
        this.initialized = true;
        this.notifyAll();
        logger.debug((Object)"Leaving initialize()");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recover() throws ResourceException {
        if (this.recovered) {
            return;
        }
        logger.debug((Object)"Entering recover()");
        if (!this.isResourcePersistent()) {
            String errorMessage = i18n.getMessage("PreconditionViolation", (Object)"!this.isResourcePersistent()");
            throw new RuntimeException(errorMessage);
        }
        logger.debug((Object)"Loading the home's list of resource keys");
        List resourceKeyValueList = null;
        try {
            XmlPersistenceHelper persistenceHelper = new XmlPersistenceHelper(class$org$globus$exec$generated$ManagedExecutableJobResourceStateType == null ? (class$org$globus$exec$generated$ManagedExecutableJobResourceStateType = ManagedExecutableJobHome.class$("org.globus.exec.generated.ManagedExecutableJobResourceStateType")) : class$org$globus$exec$generated$ManagedExecutableJobResourceStateType);
            resourceKeyValueList = persistenceHelper.list();
        }
        catch (Exception e) {
            throw new ResourceException(i18n.getMessage("persistedResourcePropertiesDirectoryMissing"), (Throwable)e);
        }
        Iterator it = resourceKeyValueList.iterator();
        while (it.hasNext()) {
            String keyValue = (String)it.next();
            SimpleResourceKey key = ManagedJobHelper.getResourceKey((String)keyValue);
            ManagedExecutableJobResource resource = (ManagedExecutableJobResource)this.find((ResourceKey)key);
            logger.info((Object)("Recovered resource with ID " + keyValue + "."));
            Object object = resource.getStateTransitionMutex();
            synchronized (object) {
                ManagedExecutableJobResourceDataType resourceData = (ManagedExecutableJobResourceDataType)resource.getResourceData();
                InternalStateEnumeration restartInternalState = resourceData.getRestartInternalState();
                InternalStateEnumeration internalState = resourceData.getInternalState();
                if (restartInternalState == null || !internalState.equals((Object)InternalStateEnumeration.Restart)) {
                    resourceData.setRestartInternalState(internalState);
                    resourceData.setInternalState(InternalStateEnumeration.Restart);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Adding to RunQueue.");
                }
                RunQueue.getInstance().add((ResourceKey)resource.getID());
            }
        }
        this.recovered = true;
        logger.debug((Object)"Leaving recover()");
    }

    public ResourceKey create(Calendar initialTerminationTime, Calendar currentTime, String localResourceManager, JobDescriptionType jobDescription, String userSubject, String localUserId, String idempotenceId, String serviceURL) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entering create()");
        }
        SimpleResourceKey key = null;
        ManagedExecutableJobResource resource = null;
        if (idempotenceId != null && (key = (SimpleResourceKey)this.idempotenceIdMap.get(idempotenceId)) != null) {
            try {
                resource = (ManagedExecutableJobResource)this.find((ResourceKey)key);
                return key;
            }
            catch (NoSuchResourceException nsre) {
                logger.debug((Object)"JobID Specified, but not a duplicate job id");
            }
        }
        if (jobDescription instanceof MultiJobDescriptionType) {
            throw new RemoteException(i18n.getMessage("multiJobNotSupported", new Object[]{localResourceManager}));
        }
        ManagedExecutableJobHome.getNotificationConsumerManager();
        key = ManagedJobHelper.getResourceKey((String)uuidGen.nextUUID());
        if (idempotenceId != null) {
            this.idempotenceIdMap.put(idempotenceId, key);
        }
        EndpointReferenceType epr = AddressingUtils.createEndpointReference((String)serviceURL, (ResourceKey)key);
        String handle = ManagedJobHelper.getHandle((EndpointReferenceType)epr);
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"at find()");
            }
            resource = (ManagedExecutableJobResource)this.find((ResourceKey)key);
        }
        catch (NoSuchResourceException nsre) {
            logger.debug((Object)"new resource being created");
        }
        if (resource == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"at createNewInstance()");
            }
        } else {
            return key;
        }
        resource = (ManagedExecutableJobResource)this.createNewInstance();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"at initializeWholeState()");
        }
        resource.initializeWholeState(ManagedExecutableJobHome.createResourceState(initialTerminationTime, currentTime, localResourceManager, jobDescription, userSubject, localUserId, handle, idempotenceId), ManagedJobConstants.RESOURCE_PROPERTY_SET, key);
        logger.debug((Object)("Created ManagedExecutableJobResource with key value " + key.getValue()));
        if (this.isResourcePersistent()) {
            ((PersistentResource)resource).store();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"at add()");
        }
        this.add((ResourceKey)key, resource);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Leaving create()");
        }
        return key;
    }

    public static NotificationConsumerManager getNotificationConsumerManager() {
        if (NOTIFICATION_CONSUMER_MANAGER == null) {
            FactoryHomeConfiguration factoryHomeConfiguration = ManagedJobFactoryHome.getConfiguration();
            String wsTransportProtocol = factoryHomeConfiguration.getStagingProtocol();
            if (wsTransportProtocol == null) {
                wsTransportProtocol = ServiceHost.getDefaultProtocol();
            }
            if (wsTransportProtocol.equals("http")) {
                NOTIFICATION_CONSUMER_MANAGER = NotificationConsumerManager.getInstance();
            } else {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
                NOTIFICATION_CONSUMER_MANAGER = NotificationConsumerManager.getInstance(properties);
            }
        }
        return NOTIFICATION_CONSUMER_MANAGER;
    }

    public boolean isResourcePersistent() {
        return (class$org$globus$wsrf$PersistentResource == null ? (class$org$globus$wsrf$PersistentResource = ManagedExecutableJobHome.class$("org.globus.wsrf.PersistentResource")) : class$org$globus$wsrf$PersistentResource).isAssignableFrom(this.resourceClass);
    }

    private static ManagedExecutableJobResourceStateType createResourceState(Calendar initialTerminationTime, Calendar currentTime, String localResourceManager, JobDescriptionType jobDescription, String userSubject, String localUserId, String handle, String idempotenceId) {
        ManagedExecutableJobResourceStateType resourceState = new ManagedExecutableJobResourceStateType();
        ManagedExecutableJobResourcePropertiesType resourceBean = ManagedExecutableJobHome.createResourcePropertiesBean(initialTerminationTime, currentTime, jobDescription, userSubject, localUserId);
        resourceState.setResourceProperties(resourceBean);
        ManagedExecutableJobResourceDataType internalData = new ManagedExecutableJobResourceDataType();
        internalData.setInternalState(InternalStateEnumeration.None);
        internalData.setStarted(false);
        internalData.setHoldState(jobDescription.getHoldState());
        internalData.setLocalResourceManager(localResourceManager);
        internalData.setHandle(handle);
        internalData.setCreationTime(new Date());
        internalData.setIdempotenceId(idempotenceId);
        resourceState.setResourceData(internalData);
        return resourceState;
    }

    private static ManagedExecutableJobResourcePropertiesType createResourcePropertiesBean(Calendar initialTerminationTime, Calendar currentTime, JobDescriptionType jobDescription, String userSubject, String localUserId) {
        ManagedExecutableJobResourcePropertiesType jobResourceProperties = new ManagedExecutableJobResourcePropertiesType();
        jobResourceProperties.setTerminationTime(initialTerminationTime);
        jobResourceProperties.setCurrentTime(currentTime);
        jobResourceProperties.setState(StateEnumeration.Unsubmitted);
        PositiveInteger countObj = jobDescription.getCount();
        if (countObj == null) {
            countObj = DEFAULT_PROCESS_COUNT;
            jobDescription.setCount(countObj);
        }
        jobResourceProperties.setServiceLevelAgreement(new ServiceLevelAgreementType(jobDescription, null));
        jobResourceProperties.setLocalUserId(localUserId);
        jobResourceProperties.setUserSubject(userSubject);
        jobResourceProperties.setCapacity(countObj.intValue());
        jobResourceProperties.setRegistrantData(null);
        jobResourceProperties.setRendezvousCompleted(false);
        return jobResourceProperties;
    }

    public void jobStateChanged(ResourceKey resourceKey, String localJobId, Date timestamp, StateEnumeration state, int exitCode) {
        ManagedExecutableJobResource resource;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Receiving jobStateChange event for resource key " + resourceKey + " with: " + "\ntimestamp\t" + timestamp + "\n(new) state\t" + state.getValue() + "\nexitCode\t" + exitCode));
        }
        try {
            resource = (ManagedExecutableJobResource)this.find(resourceKey);
        }
        catch (ResourceException re) {
            String errorMessage = i18n.getMessage("NotificationTargetResourceNotFound");
            logger.error((Object)errorMessage, (Throwable)re);
            return;
        }
        StateMachine.localJobStateChanged(resource, localJobId, timestamp, state, exitCode);
    }

    public static ManagedExecutableJobHome getHome() throws ResourceException {
        if (INSTANCE == null) {
            try {
                FactoryServiceConfiguration factoryConfiguration = (FactoryServiceConfiguration)ConfigurationHelper.getServiceConfiguration();
                INSTANCE = (ManagedExecutableJobHome)ConfigurationHelper.getResourceHome(factoryConfiguration.getManagedExecutableJobServicePath());
                logger.debug((Object)"created MEJH instance");
            }
            catch (NamingException ne) {
                throw new ResourceException((Throwable)ne);
            }
            catch (ResourceContextException rce) {
                throw new ResourceException((Throwable)rce);
            }
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getUserHomeDirectory(String localUserId) {
        String userHome;
        block42: {
            block38: {
                IOException e22222222;
                OutputStream out;
                InputStream err;
                BufferedReader homeReader;
                block34: {
                    block41: {
                        userHome = null;
                        if (!userHomeMap.containsKey(localUserId)) break block41;
                        userHome = (String)userHomeMap.get(localUserId);
                        break block42;
                    }
                    GlobusShToolsProperties toolPathProps = GlobusShToolsProperties.getInstance();
                    String perl = toolPathProps.getProperty("GLOBUS_SH_PERL");
                    String[] command = new String[]{perl, "-e", "print '' . (getpwnam('" + localUserId + "'))[7] . \"\\n\""};
                    if (logger.isDebugEnabled()) {
                        StringBuffer commandBuffer = new StringBuffer(command.length * 2);
                        for (int index = 0; index < command.length; ++index) {
                            if (index > 0) {
                                commandBuffer.append(" ");
                            }
                            commandBuffer.append(command[index]);
                        }
                        logger.debug((Object)("Executing command:\n" + commandBuffer.toString()));
                    }
                    homeReader = null;
                    err = null;
                    out = null;
                    Process proc = Runtime.getRuntime().exec(command);
                    err = proc.getErrorStream();
                    out = proc.getOutputStream();
                    homeReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    userHome = homeReader.readLine();
                    proc.waitFor();
                    Object var10_12 = null;
                    if (homeReader == null) break block34;
                    try {
                        homeReader.close();
                    }
                    catch (IOException e22222222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e22222222) {
                        // empty catch block
                    }
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (IOException e22222222) {}
                }
                break block38;
                {
                    catch (InterruptedException ie) {
                        IOException e22222222;
                        Object var10_13 = null;
                        if (homeReader != null) {
                            try {
                                homeReader.close();
                            }
                            catch (IOException e22222222) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e22222222) {
                                // empty catch block
                            }
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (IOException e22222222) {}
                        }
                        break block38;
                    }
                    catch (IOException ioe) {
                        IOException e22222222;
                        Object var10_14 = null;
                        if (homeReader != null) {
                            try {
                                homeReader.close();
                            }
                            catch (IOException e22222222) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e22222222) {
                                // empty catch block
                            }
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (IOException e22222222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException e22222222;
                    Object var10_15 = null;
                    if (homeReader != null) {
                        try {
                            homeReader.close();
                        }
                        catch (IOException e22222222) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e22222222) {
                            // empty catch block
                        }
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (IOException e22222222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            userHomeMap.put(localUserId, userHome);
        }
        return userHome;
    }

    public int getResourceCount() {
        return this.resources.size();
    }

    ManagedExecutableJobResource unsyncFind(ResourceKey key) throws ResourceException {
        ManagedExecutableJobResource resource = (ManagedExecutableJobResource)this.resources.get(key);
        if (resource == null) {
            resource = (ManagedExecutableJobResource)this.find(key);
        }
        return resource;
    }

    public void enableLocalTransport(Stub stub) {
        LocalTransportClient.enableLocalTransport(this.cachedContext, stub);
    }

    public static AuditDatabaseConfiguration getAuditDatabaseConfiguration() {
        if (AUDIT_DATABASE_CONFIGURATION == null) {
            try {
                AUDIT_DATABASE_CONFIGURATION = (AuditDatabaseConfiguration)ConfigurationHelper.getAuditDatabaseConfiguration();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return AUDIT_DATABASE_CONFIGURATION;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LocalTransportUtils.init();
        NOTIFICATION_CONSUMER_MANAGER = null;
        DEFAULT_PROCESS_COUNT = new PositiveInteger("1");
        uuidGen = UUIDGenFactory.getUUIDGen();
    }
}

