/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.service.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;
import org.globus.exec.generated.FilePairType;
import org.globus.exec.generated.ScriptCommandEnumeration;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.service.exec.ScriptCallback;
import org.globus.exec.service.utils.AuthorizationHelper;
import org.globus.exec.service.utils.GlobusShToolsProperties;
import org.globus.util.I18n;
import org.globus.util.Util;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;

public class JobManagerScript
extends Thread {
    protected static final String JOB_STATE = "GRAM_SCRIPT_JOB_STATE";
    protected static final String ERROR = "GRAM_SCRIPT_ERROR";
    protected static final String JOB_ID = "GRAM_SCRIPT_JOB_ID";
    protected static final String SCRATCH_DIR = "GRAM_SCRIPT_SCRATCH_DIR";
    protected static final String STAGED_IN = "GRAM_SCRIPT_STAGED_IN";
    protected static final String STAGED_IN_SHARED = "GRAM_SCRIPT_STAGED_IN_SHARED";
    protected static final String STAGED_OUT = "GRAM_SCRIPT_STAGED_OUT";
    protected static final String X509_USER_PROXY = "GRAM_SCRIPT_X509_USER_PROXY";
    protected static final String REMOTE_IO_FILE = "GRAM_SCRIPT_REMOTE_IO_FILE";
    protected static final String FAILURE_TYPE = "GRAM_SCRIPT_GT3_FAILURE_TYPE";
    protected static final String FAILURE_MESSAGE = "GRAM_SCRIPT_GT3_FAILURE_MESSAGE";
    protected static final String FAILURE_SOURCE = "GRAM_SCRIPT_GT3_FAILURE_SOURCE";
    protected static final String FAILURE_DESTINATION = "GRAM_SCRIPT_GT3_FAILURE_DESTINATION";
    protected static final int CUSTOM_ERROR_MISCONFIGURED_SUDO = 200;
    protected static final int CUSTOM_ERROR_UNHANDLED_STDERR = 201;
    protected static final int CUSTOM_ERROR_EXEC_FAILED = 202;
    static final int COMMAND_SIZE_WITHOUT_SUDO = 9;
    static final int COMMAND_SIZE_WITH_SUDO = 13;
    private static final String SCRIPT = "/libexec/globus-job-manager-script.pl";
    private static final String GLOBUS_GRIDMAP_AND_EXECUTE = "/libexec/globus-gridmap-and-execute";
    private String username;
    private File descriptionFile;
    private ScriptCommandEnumeration command;
    private String[] commandWithArgs;
    private Process p;
    private int jobState;
    private int error;
    private String jobId;
    private String scratchDir;
    private String x509UserProxy;
    private String remoteIoFile;
    private List stageInList;
    private List stageOutList;
    private String failureType;
    private String failureMessage;
    private String failureSource;
    private String failureDestination;
    private boolean done;
    private ScriptCallback callback;
    private String[] environment;
    private String scriptStderr;
    static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$service$exec$JobManagerScript == null ? (class$org$globus$exec$service$exec$JobManagerScript = JobManagerScript.class$("org.globus.exec.service.exec.JobManagerScript")) : class$org$globus$exec$service$exec$JobManagerScript));
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = JobManagerScript.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    static /* synthetic */ Class class$org$globus$exec$service$exec$JobManagerScript;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    public JobManagerScript(String username, String globusLocation, String type, ScriptCommandEnumeration command, String perlJobDescription, String[] environment) throws IOException {
        logger.trace((Object)"Initializing script thread");
        this.username = username;
        this.command = command;
        this.descriptionFile = File.createTempFile("gram_job_mgr", null, new File(globusLocation + File.separator + "tmp"));
        Util.setFilePermissions((String)this.descriptionFile.toString(), (int)644);
        FileOutputStream out = new FileOutputStream(this.descriptionFile);
        out.write(perlJobDescription.getBytes());
        out.close();
        GlobusShToolsProperties toolPathProps = GlobusShToolsProperties.getInstance();
        String gridMapAndExecute = new File(globusLocation + GLOBUS_GRIDMAP_AND_EXECUTE).toString();
        String gridMapFile = null;
        try {
            gridMapFile = ContainerSecurityConfig.getConfig().getSecurityDescriptor().getGridMapFile();
        }
        catch (Exception e) {
            throw new ChainedIOException(i18n.getMessage("GRIDMAP_CONFIGURATION_ERROR"), (Throwable)e);
        }
        boolean authzGridmap = AuthorizationHelper.isAuthorizationGridmap();
        String sudo = toolPathProps.getProperty("GLOBUS_SH_SUDO");
        if (sudo == null || sudo.length() == 0) {
            throw new IOException(i18n.getMessage("MissingSudo"));
        }
        Vector<String> commandVector = new Vector<String>();
        if (!System.getProperty("user.name").equals(this.username)) {
            commandVector.add(sudo);
            commandVector.add("-H");
            commandVector.add("-u");
            commandVector.add(this.username);
            commandVector.add("-S");
            if (authzGridmap) {
                commandVector.add(gridMapAndExecute);
                if (gridMapFile != null) {
                    commandVector.add("-g");
                    commandVector.add(gridMapFile);
                }
            }
        }
        commandVector.add(new File(globusLocation + SCRIPT).toString());
        commandVector.add("-m");
        commandVector.add(type.toLowerCase());
        commandVector.add("-f");
        commandVector.add(this.descriptionFile.toString());
        commandVector.add("-c");
        commandVector.add(command.toString());
        this.commandWithArgs = commandVector.toArray(new String[0]);
        this.done = false;
        this.environment = new String[environment.length];
        System.arraycopy(environment, 0, this.environment, 0, environment.length);
        this.stageInList = new LinkedList();
        this.stageOutList = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block67: {
            IOException e2;
            BufferedReader scriptOutputReader;
            block63: {
                if (logger.isDebugEnabled()) {
                    StringBuffer commandBuffer = new StringBuffer(this.commandWithArgs.length * 2);
                    for (int index = 0; index < this.commandWithArgs.length; ++index) {
                        if (index > 0) {
                            commandBuffer.append(" ");
                        }
                        commandBuffer.append(this.commandWithArgs[index]);
                    }
                    logger.debug((Object)("Executing command:\n" + commandBuffer.toString()));
                }
                scriptOutputReader = null;
                this.p = Runtime.getRuntime().exec(this.commandWithArgs, this.environment);
                this.p.getOutputStream().close();
                scriptOutputReader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
                String line = scriptOutputReader.readLine();
                logger.debug((Object)("first line: " + line));
                while (line != null) {
                    String to;
                    String from;
                    if (logger.isDebugEnabled()) {
                        logger.trace((Object)("Read line: " + line));
                    }
                    if (line.startsWith(JOB_STATE)) {
                        line = line.substring(JOB_STATE.length() + 1).trim();
                        this.jobState = Integer.parseInt(line);
                    } else if (line.startsWith(ERROR)) {
                        line = line.substring(ERROR.length() + 1).trim();
                        this.error = Integer.parseInt(line);
                    } else if (line.startsWith(JOB_ID)) {
                        this.jobId = line = line.substring(JOB_ID.length() + 1).trim();
                        logger.debug((Object)("Received local job ID " + this.jobId));
                    } else if (line.startsWith(SCRATCH_DIR)) {
                        this.scratchDir = line = line.substring(SCRATCH_DIR.length() + 1).trim();
                    } else if (line.startsWith(STAGED_IN)) {
                        line = line.substring(STAGED_IN.length() + 1).trim();
                        from = line.substring(0, line.indexOf(32));
                        to = line.substring(line.indexOf(32) + 1);
                        FilePairType stageInDatum = new FilePairType();
                        stageInDatum.setSourceFile(from);
                        stageInDatum.setDestinationFile(to);
                        this.addStageInDatum(stageInDatum);
                    } else if (line.startsWith(STAGED_OUT)) {
                        line = line.substring(STAGED_OUT.length() + 1).trim();
                        from = line.substring(0, line.indexOf(32));
                        to = line.substring(line.indexOf(32) + 1);
                        FilePairType stageOutDatum = new FilePairType();
                        stageOutDatum.setSourceFile(from);
                        stageOutDatum.setDestinationFile(to);
                        this.addStageOutDatum(stageOutDatum);
                    } else if (line.startsWith(X509_USER_PROXY)) {
                        this.x509UserProxy = line = line.substring(X509_USER_PROXY.length() + 1).trim();
                    } else if (line.startsWith(REMOTE_IO_FILE)) {
                        this.remoteIoFile = line = line.substring(REMOTE_IO_FILE.length() + 1).trim();
                    } else if (line.startsWith(FAILURE_TYPE)) {
                        this.failureType = line = line.substring(FAILURE_TYPE.length() + 1).trim();
                    } else if (line.startsWith(FAILURE_MESSAGE)) {
                        line = line.substring(FAILURE_MESSAGE.length() + 1).trim();
                        this.failureMessage = line.replaceAll("\\\\n", "\n");
                    } else if (line.startsWith(FAILURE_SOURCE)) {
                        this.failureSource = line = line.substring(FAILURE_SOURCE.length() + 1).trim();
                    } else if (line.startsWith(FAILURE_DESTINATION)) {
                        this.failureDestination = line = line.substring(FAILURE_DESTINATION.length() + 1).trim();
                    }
                    line = scriptOutputReader.readLine();
                }
                Object var7_8 = null;
                if (scriptOutputReader == null) break block63;
                try {
                    scriptOutputReader.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            if (this.p == null) break block67;
            try {
                this.p.getOutputStream().close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            BufferedReader stderr = null;
            stderr = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            StringBuffer stderrBuffer = new StringBuffer();
            String stderrLine = null;
            try {
                while ((stderrLine = stderr.readLine()) != null) {
                    stderrBuffer.append(stderrLine);
                }
            }
            catch (IOException ioe) {
                String errorMessage = i18n.getMessage("ScriptStderrReadError");
                logger.error((Object)errorMessage);
            }
            if (stderrBuffer.length() > 0) {
                this.scriptStderr = stderrBuffer.toString();
                if (this.scriptStderr.trim().indexOf("Password:") == 0) {
                    this.error = 200;
                    this.failureMessage = i18n.getMessage("MisconfiguredSudo", (Object[])new String[]{"globus-job-manager-script.pl", this.username});
                } else {
                    this.error = 201;
                    this.failureMessage = i18n.getMessage("StderrExistsForJob", (Object)this.scriptStderr);
                }
            }
            try {
                stderr.close();
            }
            catch (IOException e3) {
                // empty catch block
            }
            logger.debug((Object)("failure message: " + this.failureMessage));
            {
                break block67;
                catch (Exception e4) {
                    this.error = 202;
                    this.failureMessage = e4.getMessage();
                    logger.debug((Object)"adapter script execution failed", (Throwable)e4);
                    Object var7_9 = null;
                    if (scriptOutputReader != null) {
                        try {
                            scriptOutputReader.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    if (this.p == null) break block67;
                    try {
                        this.p.getOutputStream().close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    stderr = null;
                    stderr = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                    stderrBuffer = new StringBuffer();
                    stderrLine = null;
                    try {
                        while ((stderrLine = stderr.readLine()) != null) {
                            stderrBuffer.append(stderrLine);
                        }
                    }
                    catch (IOException ioe) {
                        String errorMessage = i18n.getMessage("ScriptStderrReadError");
                        logger.error((Object)errorMessage);
                    }
                    if (stderrBuffer.length() > 0) {
                        this.scriptStderr = stderrBuffer.toString();
                        if (this.scriptStderr.trim().indexOf("Password:") == 0) {
                            this.error = 200;
                            this.failureMessage = i18n.getMessage("MisconfiguredSudo", (Object[])new String[]{"globus-job-manager-script.pl", this.username});
                        } else {
                            this.error = 201;
                            this.failureMessage = i18n.getMessage("StderrExistsForJob", (Object)this.scriptStderr);
                        }
                    }
                    try {
                        stderr.close();
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    logger.debug((Object)("failure message: " + this.failureMessage));
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (scriptOutputReader != null) {
                    try {
                        scriptOutputReader.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                if (this.p != null) {
                    try {
                        this.p.getOutputStream().close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    stderr = null;
                    stderr = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                    stderrBuffer = new StringBuffer();
                    stderrLine = null;
                    try {
                        while ((stderrLine = stderr.readLine()) != null) {
                            stderrBuffer.append(stderrLine);
                        }
                    }
                    catch (IOException ioe) {
                        String errorMessage = i18n.getMessage("ScriptStderrReadError");
                        logger.error((Object)errorMessage);
                    }
                    if (stderrBuffer.length() > 0) {
                        this.scriptStderr = stderrBuffer.toString();
                        if (this.scriptStderr.trim().indexOf("Password:") == 0) {
                            this.error = 200;
                            this.failureMessage = i18n.getMessage("MisconfiguredSudo", (Object[])new String[]{"globus-job-manager-script.pl", this.username});
                        } else {
                            this.error = 201;
                            this.failureMessage = i18n.getMessage("StderrExistsForJob", (Object)this.scriptStderr);
                        }
                    }
                    try {
                        stderr.close();
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    logger.debug((Object)("failure message: " + this.failureMessage));
                }
                throw throwable;
            }
        }
        this.descriptionFile.delete();
        this.setDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDone() {
        logger.debug((Object)"script is done, setting done flag");
        JobManagerScript jobManagerScript = this;
        synchronized (jobManagerScript) {
            this.done = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStageInDatum(FilePairType data) {
        JobManagerScript jobManagerScript = this;
        synchronized (jobManagerScript) {
            this.stageInList.add(data);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStageOutDatum(FilePairType data) {
        JobManagerScript jobManagerScript = this;
        synchronized (jobManagerScript) {
            this.stageOutList.add(data);
            this.notifyAll();
        }
    }

    public synchronized FilePairType getNextStageInDatum() {
        if (this.stageInList.isEmpty()) {
            return null;
        }
        return (FilePairType)this.stageInList.remove(0);
    }

    public synchronized FilePairType getNextStageOutDatum() {
        if (this.stageOutList.isEmpty()) {
            return null;
        }
        return (FilePairType)this.stageOutList.remove(0);
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized StateEnumeration getJobState() {
        StateEnumeration result = null;
        if (this.jobState == 32) {
            result = StateEnumeration.Unsubmitted;
        } else if (this.jobState == 1) {
            result = StateEnumeration.Pending;
        } else if (this.jobState == 2) {
            result = StateEnumeration.Active;
        } else if (this.jobState == 8) {
            result = StateEnumeration.Done;
        } else if (this.jobState == 4) {
            result = StateEnumeration.Failed;
        }
        return result;
    }

    public synchronized String getJobId() {
        return this.jobId;
    }

    public synchronized ScriptCommandEnumeration getCommand() {
        return this.command;
    }

    public synchronized int getError() {
        return this.error;
    }

    public synchronized String getScratchDirectory() {
        return this.scratchDir;
    }

    public synchronized String getX509UserProxy() {
        return this.x509UserProxy;
    }

    public synchronized String getRemoteIoFile() {
        return this.remoteIoFile;
    }

    public synchronized String getFailureType() {
        return this.failureType;
    }

    public synchronized String getFailureMessage() {
        return this.failureMessage;
    }

    public synchronized String getFailureSource() {
        return this.failureSource;
    }

    public synchronized String getFailureDestination() {
        return this.failureDestination;
    }

    public String toString() {
        return super.toString() + "descriptionFile = " + this.descriptionFile + "\n" + "process = " + this.p + "\n" + "jobState = " + new Integer(this.jobState) + "\n" + "error = " + new Integer(this.error) + "\n" + "jobId = " + this.jobId + "\n" + "scratch_dir = " + this.scratchDir + "\n" + "done = " + (this.done ? "true" : "false") + "\n";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

