/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.monitoring;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.monitoring.JobStateMonitor;
import org.globus.exec.monitoring.SchedulerEvent;

class SchedulerEventGenerator
extends Thread {
    private static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$monitoring$SchedulerEventGenerator == null ? (class$org$globus$exec$monitoring$SchedulerEventGenerator = SchedulerEventGenerator.class$("org.globus.exec.monitoring.SchedulerEventGenerator")) : class$org$globus$exec$monitoring$SchedulerEventGenerator));
    private static Runtime runtime = Runtime.getRuntime();
    private File globusLocation;
    private String userName;
    private String schedulerName;
    private Process proc;
    private boolean shutdownCalled;
    private Date timeStamp;
    private JobStateMonitor monitor;
    private long lastRestart = 0L;
    private final long THROTTLE_RESTART_TIME = 120000L;
    private final long THROTTLE_RESTART_THRESHOLD = 2000L;
    private static final String SEG_EXECUTABLE_NAME = "globus-scheduler-event-generator";
    static /* synthetic */ Class class$org$globus$exec$monitoring$SchedulerEventGenerator;

    public SchedulerEventGenerator(File globusLocation, String userName, String schedulerName, JobStateMonitor monitor, boolean segDaemon) {
        this.globusLocation = globusLocation;
        this.userName = userName;
        this.schedulerName = schedulerName;
        this.proc = null;
        this.shutdownCalled = false;
        this.timeStamp = null;
        this.monitor = monitor;
        this.lastRestart = 0L;
        this.setDaemon(segDaemon);
    }

    public void run() {
        try {
            while (this.startSegProcess(this.timeStamp)) {
                String input;
                logger.debug((Object)"getting seg input");
                BufferedReader stdout = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Seg input buffer is " + (stdout.ready() ? "read" : "not ready")));
                }
                while ((input = stdout.readLine()) != null) {
                    StateEnumeration se;
                    logger.debug((Object)("seg input line: " + input));
                    StringTokenizer tok = new StringTokenizer(input, ";");
                    int tokenCount = tok.countTokens();
                    String[] tokens = new String[tok.countTokens()];
                    for (int i = 0; i < tokens.length; ++i) {
                        tokens[i] = tok.nextToken();
                    }
                    if (!tokens[0].equals("001")) continue;
                    if (tokens.length < 5) {
                        // empty if block
                    }
                    switch (Integer.parseInt(tokens[3])) {
                        case 1: {
                            se = StateEnumeration.Pending;
                            break;
                        }
                        case 2: {
                            se = StateEnumeration.Active;
                            break;
                        }
                        case 4: {
                            se = StateEnumeration.Failed;
                            break;
                        }
                        case 8: {
                            se = StateEnumeration.Done;
                            break;
                        }
                        case 16: {
                            se = StateEnumeration.Suspended;
                            break;
                        }
                        case 32: {
                            se = StateEnumeration.Unsubmitted;
                            break;
                        }
                        default: {
                            se = null;
                        }
                    }
                    SchedulerEvent e = new SchedulerEvent(new Date(Long.parseLong(tokens[1]) * 1000L), tokens[2], se, Integer.parseInt(tokens[4]));
                    this.timeStamp = e.getTimeStamp();
                    this.monitor.addEvent(e);
                }
                BufferedReader stderr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
                while ((input = stderr.readLine()) != null) {
                    logger.error((Object)("SEG Terminated with " + input));
                }
                stderr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized boolean startSegProcess(Date timeStamp) throws IOException {
        this.cleanProcess();
        this.proc = null;
        this.throttleRestart();
        if (!this.shutdownCalled) {
            logger.debug((Object)"Starting seg process");
            File path = new File(this.globusLocation + File.separator + "libexec" + File.separator + SEG_EXECUTABLE_NAME);
            String[] cmd = timeStamp != null ? new String[]{path.toString(), "-s", this.schedulerName, "-t", Long.toString(timeStamp.getTime() / 1000L)} : new String[]{path.toString(), "-s", this.schedulerName};
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"executing command: ");
                for (int i = 0; i < cmd.length; ++i) {
                    if (cmd[i] == null) continue;
                    logger.debug((Object)("->" + cmd[i]));
                }
            }
            this.proc = runtime.exec(cmd);
            return true;
        }
        return false;
    }

    private synchronized void throttleRestart() {
        logger.debug((Object)"throttleRestart called");
        long thisTime = new Date().getTime();
        long endOfWait = thisTime + 120000L;
        while (!this.shutdownCalled && thisTime - this.lastRestart < 2000L) {
            logger.debug((Object)"Throttling the restart as we just restarted the SEG");
            try {
                this.wait(endOfWait - thisTime);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            thisTime = new Date().getTime();
        }
        this.lastRestart = thisTime;
    }

    private synchronized void cleanProcess() {
        if (this.proc != null) {
            try {
                this.proc.getInputStream().close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.proc.getOutputStream().close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.proc.getErrorStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void shutdown() throws IOException {
        if (this.shutdownCalled) {
            return;
        }
        logger.debug((Object)"cleaning process");
        this.cleanProcess();
        logger.debug((Object)"setting shutdownCalled");
        this.shutdownCalled = true;
        logger.debug((Object)"notifying");
        this.notify();
        logger.debug((Object)"done");
    }

    public void start(Date timeStamp) {
        logger.debug((Object)"Starting seg thread");
        this.timeStamp = timeStamp;
        this.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

