/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.monitoring;

import java.util.Date;
import org.globus.exec.generated.StateEnumeration;

class SchedulerEvent {
    private Date timestamp;
    private String localId;
    private StateEnumeration state;
    private int exitCode;
    private static Comparator comparator = new Comparator();

    public SchedulerEvent(Date timestamp, String localId, StateEnumeration state, int exitCode) {
        this.timestamp = timestamp;
        this.localId = localId;
        this.state = state;
        this.exitCode = exitCode;
    }

    public Date getTimeStamp() {
        return this.timestamp;
    }

    public String getLocalId() {
        return this.localId;
    }

    public StateEnumeration getState() {
        return this.state;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.localId);
        sb.append(" [");
        sb.append(this.timestamp.toString());
        sb.append("] ");
        sb.append(this.state.toString());
        return sb.toString();
    }

    public static java.util.Comparator getComparator() {
        return comparator;
    }

    private static class Comparator
    implements java.util.Comparator {
        private Comparator() {
        }

        public int compare(Object o1, Object o2) throws ClassCastException {
            int ec2;
            int ec1;
            StateEnumeration s2;
            SchedulerEvent e1 = (SchedulerEvent)o1;
            SchedulerEvent e2 = (SchedulerEvent)o2;
            int rc = e1.timestamp.compareTo(e2.timestamp);
            if (rc != 0) {
                return rc;
            }
            rc = e1.localId.compareTo(e2.localId);
            if (rc != 0) {
                return rc;
            }
            StateEnumeration s1 = e1.state;
            if (!s1.equals((Object)(s2 = e2.state))) {
                if (s1.equals((Object)StateEnumeration.Done)) {
                    return 1;
                }
                if (s2.equals((Object)StateEnumeration.Done)) {
                    return -1;
                }
                if (s1.equals((Object)StateEnumeration.Failed)) {
                    return 1;
                }
                if (s2.equals((Object)StateEnumeration.Failed)) {
                    return -1;
                }
                if (s1.equals((Object)StateEnumeration.StageOut)) {
                    return 1;
                }
                if (s2.equals((Object)StateEnumeration.StageOut)) {
                    return -1;
                }
                if (s1.equals((Object)StateEnumeration.Active)) {
                    return 1;
                }
                if (s2.equals((Object)StateEnumeration.Active)) {
                    return -1;
                }
                if (s1.equals((Object)StateEnumeration.Pending)) {
                    return -1;
                }
                if (s2.equals((Object)StateEnumeration.Pending)) {
                    return 1;
                }
                if (s1.equals((Object)StateEnumeration.StageIn)) {
                    return 1;
                }
                if (s2.equals((Object)StateEnumeration.StageIn)) {
                    return -1;
                }
            }
            if ((ec1 = e1.exitCode) < (ec2 = e2.exitCode)) {
                return -1;
            }
            if (ec1 > ec2) {
                return 1;
            }
            return 0;
        }
    }
}

