/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.monitoring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.monitoring.AlreadyRegisteredException;
import org.globus.exec.monitoring.EventDispatchQueue;
import org.globus.exec.monitoring.JobStateChangeListener;
import org.globus.exec.monitoring.JobStateRecoveryListener;
import org.globus.exec.monitoring.NotRegisteredException;
import org.globus.exec.monitoring.SchedulerEvent;
import org.globus.exec.monitoring.SchedulerEventGenerator;
import org.globus.wsrf.ResourceKey;

public class JobStateMonitor {
    private static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$monitoring$JobStateMonitor == null ? (class$org$globus$exec$monitoring$JobStateMonitor = JobStateMonitor.class$("org.globus.exec.monitoring.JobStateMonitor")) : class$org$globus$exec$monitoring$JobStateMonitor));
    private SchedulerEventGenerator seg;
    private JobStateChangeListener listener;
    private EventDispatchQueue dispatchQueue;
    private JobStateRecoveryListener recoveryListener;
    private HashMap mapping;
    private SortedSet cachedEvents;
    private static final int MAX_CACHE_AGE = 300000;
    private static final long CACHE_FLUSH_PERIOD = 60000L;
    private static final long RECOVERY_PERIOD = 900000L;
    private static Timer timer = new Timer(true);
    private TimerTask cacheFlushTask;
    private TimerTask recoveryTask;
    private Date lastEventTimestamp;
    static /* synthetic */ Class class$org$globus$exec$monitoring$JobStateMonitor;

    public static JobStateMonitor getInstance(File globusLocation, String userName, String schedulerName, JobStateChangeListener listener, JobStateRecoveryListener recoveryListener, boolean segDaemon) {
        logger.debug((Object)"Constructing JobStateMonitor");
        JobStateMonitor monitor = new JobStateMonitor();
        monitor.initialize(globusLocation, userName, schedulerName, listener, recoveryListener, new SchedulerEventGenerator(globusLocation, userName, schedulerName, monitor, segDaemon));
        logger.debug((Object)("Initialized JSM (SEG daemon status " + segDaemon + ")"));
        return monitor;
    }

    private JobStateMonitor() {
    }

    void initialize(File globusLocation, String userName, String schedulerName, JobStateChangeListener listener, JobStateRecoveryListener recoveryListener, SchedulerEventGenerator seg) {
        this.cacheFlushTask = null;
        this.recoveryTask = null;
        this.listener = listener;
        this.recoveryListener = recoveryListener;
        this.seg = seg;
        this.mapping = new HashMap();
        this.cachedEvents = new TreeSet(SchedulerEvent.getComparator());
        this.dispatchQueue = new EventDispatchQueue(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJobID(String localId, ResourceKey resourceKey) throws AlreadyRegisteredException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering registerJobID: " + localId));
        }
        HashMap hashMap = this.mapping;
        synchronized (hashMap) {
            if (this.mapping.containsKey(localId)) {
                throw new AlreadyRegisteredException(localId);
            }
            this.mapping.put(localId, resourceKey);
            List events = this.getCachedEvents(localId);
            if (events != null) {
                Iterator i = events.iterator();
                while (i.hasNext()) {
                    SchedulerEvent e = (SchedulerEvent)i.next();
                    this.dispatchQueue.add(e);
                    SortedSet sortedSet = this.cachedEvents;
                    synchronized (sortedSet) {
                        if (this.cachedEvents.remove(e) && this.cachedEvents.isEmpty() && this.recoveryTask != null) {
                            TimerTask timerTask = this.recoveryTask;
                            synchronized (timerTask) {
                                this.lastEventTimestamp = e.getTimeStamp();
                            }
                        }
                    }
                }
            }
        }
        logger.debug((Object)"Exiting registerJobID");
    }

    public void start(Date timestamp) throws IllegalThreadStateException {
        logger.debug((Object)"Entering start()");
        if (timestamp == null) {
            timestamp = new Date();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("starting seg with timestamp " + timestamp.toString()));
        }
        this.seg.start(timestamp);
        this.lastEventTimestamp = timestamp;
        if (this.cacheFlushTask == null) {
            logger.debug((Object)"creating flush task");
            this.cacheFlushTask = new TimerTask(){

                public void run() {
                    JobStateMonitor.this.flushCache();
                }
            };
            timer.schedule(this.cacheFlushTask, 60000L, 60000L);
        }
        if (this.recoveryTask == null && this.recoveryListener != null) {
            logger.debug((Object)"creating recovery update task");
            this.recoveryTask = new TimerTask(){

                public void run() {
                    JobStateMonitor.this.updateRecoveryInfo();
                }
            };
            timer.schedule(this.recoveryTask, 900000L, 900000L);
        }
        logger.debug((Object)"Exiting start()");
    }

    public void stop() throws IOException {
        logger.debug((Object)"Entering stop()");
        boolean done = false;
        this.seg.shutdown();
        while (!done) {
            try {
                logger.debug((Object)"joining SEG thread");
                this.seg.join();
                logger.debug((Object)"done");
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.debug((Object)"Exiting stop()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCache() {
        logger.debug((Object)"Entering flushCache()");
        Calendar flushCalendar = Calendar.getInstance();
        flushCalendar.add(14, -300000);
        Date flushDate = flushCalendar.getTime();
        SortedSet sortedSet = this.cachedEvents;
        synchronized (sortedSet) {
            Iterator i = this.cachedEvents.iterator();
            Date d = null;
            while (i.hasNext() && (d = ((SchedulerEvent)i.next()).getTimeStamp()).compareTo(flushDate) <= 0) {
                i.remove();
            }
            if (d != null && d.compareTo(this.lastEventTimestamp) > 0 && this.recoveryTask != null) {
                TimerTask timerTask = this.recoveryTask;
                synchronized (timerTask) {
                    this.lastEventTimestamp = d;
                }
            }
        }
        logger.debug((Object)"Exiting flushCache()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecoveryInfo() {
        Date d;
        logger.debug((Object)"Entering updateRecoveryInfo()");
        TimerTask timerTask = this.recoveryTask;
        synchronized (timerTask) {
            d = this.lastEventTimestamp;
        }
        this.recoveryListener.updateJobMonitorRecoveryTimeStamp(this, d);
        logger.debug((Object)"Exiting updateRecoveryInfo()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCachedEvents(String localId) {
        logger.debug((Object)"Entering getCachedEvents()");
        ArrayList<SchedulerEvent> result = null;
        SortedSet sortedSet = this.cachedEvents;
        synchronized (sortedSet) {
            Iterator i = this.cachedEvents.iterator();
            while (i.hasNext()) {
                SchedulerEvent e = (SchedulerEvent)i.next();
                if (!e.getLocalId().equals(localId)) continue;
                if (result == null) {
                    result = new ArrayList<SchedulerEvent>(4);
                }
                logger.debug((Object)("adding " + e.toString() + "to list to replay"));
                result.add(e);
            }
        }
        logger.debug((Object)"Exiting getCachedEvents()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterJobID(String localId) throws NotRegisteredException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering unregisterJobID: " + localId));
        }
        HashMap hashMap = this.mapping;
        synchronized (hashMap) {
            Object result = this.mapping.remove(localId);
            if (result == null) {
                throw new NotRegisteredException(localId);
            }
        }
        logger.debug((Object)"Exiting unregisterJobID()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheEvent(SchedulerEvent e) {
        logger.debug((Object)"Entering cacheEvent()");
        SortedSet sortedSet = this.cachedEvents;
        synchronized (sortedSet) {
            logger.debug((Object)("caching " + e.toString()));
            this.cachedEvents.add(e);
        }
        logger.debug((Object)"Exiting cacheEvent()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceKey getMapping(String localId) {
        HashMap hashMap = this.mapping;
        synchronized (hashMap) {
            return (ResourceKey)this.mapping.get(localId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(SchedulerEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" JSM receiving scheduler event " + e));
        }
        String localId = e.getLocalId();
        HashMap hashMap = this.mapping;
        synchronized (hashMap) {
            ResourceKey mapping = this.getMapping(localId);
            if (mapping != null) {
                logger.debug((Object)("Dispatching event " + e.getLocalId() + " to job " + mapping.getValue()));
                this.dispatchQueue.add(e);
            } else {
                logger.debug((Object)("Caching event " + e.getLocalId()));
                this.cacheEvent(e);
            }
        }
    }

    public JobStateChangeListener getListener() {
        return this.listener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

