/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.monitoring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.monitoring.EventDispatchQueue;
import org.globus.exec.monitoring.JobStateChangeListener;
import org.globus.exec.monitoring.JobStateMonitor;
import org.globus.exec.monitoring.SchedulerEvent;
import org.globus.wsrf.ResourceKey;

public class EventDispatchThread
extends Thread {
    private static Log logger = LogFactory.getLog((Class)(class$org$globus$exec$monitoring$EventDispatchThread == null ? (class$org$globus$exec$monitoring$EventDispatchThread = EventDispatchThread.class$("org.globus.exec.monitoring.EventDispatchThread")) : class$org$globus$exec$monitoring$EventDispatchThread));
    private boolean done = false;
    private EventDispatchQueue dispatchQueue = null;
    private JobStateMonitor monitor = null;
    private JobStateChangeListener listener = null;
    static /* synthetic */ Class class$org$globus$exec$monitoring$EventDispatchThread;

    EventDispatchThread(String name, EventDispatchQueue queue) {
        super(name);
        this.dispatchQueue = queue;
        this.monitor = queue.getMonitor();
        this.listener = queue.getMonitor().getListener();
    }

    public synchronized void terminate() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            SchedulerEvent event;
            EventDispatchQueue eventDispatchQueue = this.dispatchQueue;
            synchronized (eventDispatchQueue) {
                while (!this.done && this.dispatchQueue.size() == 0) {
                    try {
                        this.dispatchQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            do {
                ResourceKey resourceKey;
                eventDispatchQueue = this.dispatchQueue;
                synchronized (eventDispatchQueue) {
                    if (this.dispatchQueue.size() > 0) {
                        event = this.dispatchQueue.remove();
                        logger.debug((Object)("DispatchQueueSize: " + this.dispatchQueue.size()));
                    } else {
                        event = null;
                    }
                }
                if (event == null || (resourceKey = this.monitor.getMapping(event.getLocalId())) == null) continue;
                this.listener.jobStateChanged(resourceKey, event.getLocalId(), event.getTimeStamp(), event.getState(), event.getExitCode());
                logger.debug((Object)("Job " + resourceKey.getValue() + ": EventQueueThread: dispatched event " + event.getState()));
            } while (!this.done && event != null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

