/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.client.Stub;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.Constants;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.util.Util;
import org.globus.delegation.DelegationUtil;
import org.globus.delegationService.DelegationPortType;
import org.globus.delegationService.DelegationServiceAddressingLocator;
import org.globus.exec.client.GramJobListener;
import org.globus.exec.generated.CreateManagedJobInputType;
import org.globus.exec.generated.CreateManagedJobOutputType;
import org.globus.exec.generated.FaultResourcePropertyType;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.ManagedJobFactoryPortType;
import org.globus.exec.generated.ManagedJobPortType;
import org.globus.exec.generated.MultiJobDescriptionType;
import org.globus.exec.generated.ReleaseInputType;
import org.globus.exec.generated.ServiceLevelAgreementType;
import org.globus.exec.generated.StateChangeNotificationMessageType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.utils.ManagedExecutableJobConstants;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.exec.utils.audit.AuditUtil;
import org.globus.exec.utils.client.ManagedJobClientHelper;
import org.globus.exec.utils.client.ManagedJobFactoryClientHelper;
import org.globus.exec.utils.rsl.RSLHelper;
import org.globus.exec.utils.rsl.RSLParseException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.TransferRequestType;
import org.globus.rft.generated.TransferType;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.container.ContainerException;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.GSISecureConvAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSISecureMsgAuthMethod;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.SubscriptionManager;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.ResourceUnknownFaultType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.w3c.dom.Element;

public class GramJob
implements NotifyCallback {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$client$GramJob == null ? (class$org$globus$exec$client$GramJob = GramJob.class$("org.globus.exec.client.GramJob")) : class$org$globus$exec$client$GramJob).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = GramJob.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    public static final int DEFAULT_DURATION_HOURS = 24;
    public static final Integer DEFAULT_MSG_PROTECTION = GSIConstants.SIGNATURE;
    public static final Authorization DEFAULT_AUTHZ = HostAuthorization.getInstance();
    private String securityType = null;
    private Integer msgProtectionType = DEFAULT_MSG_PROTECTION;
    private Authorization authorization = DEFAULT_AUTHZ;
    private GSSCredential proxy = null;
    private boolean limitedDelegation = true;
    private boolean delegationEnabled = false;
    private boolean personal = false;
    private JobDescriptionType jobDescription;
    private EndpointReferenceType jobEndpointReference;
    private String jobHandle;
    private String id = null;
    private FaultType fault;
    private StateEnumeration state = null;
    private Object stateMonitor = new Object();
    private boolean holding = false;
    private int error;
    private int exitCode;
    private Vector listeners;
    private boolean destroyed = false;
    private Date duration;
    private Date terminationDate;
    private boolean useDefaultNotificationConsumer = true;
    private NotificationConsumerManager notificationConsumerManager;
    private EndpointReferenceType notificationConsumerEPR;
    private EndpointReferenceType notificationProducerEPR;
    public static final int DEFAULT_TIMEOUT = 120000;
    private int axisStubTimeOut = 120000;
    private static final String BASE_SERVICE_PATH = "/wsrf/services/";
    private static final String SERVICE_PATH = "/wsrf/services/ManagedJobFactoryService";
    private static final String PERSONAL_SERVICE_PATH = "/wsrf/services/ManagedJobFactoryService";
    protected EndpointReferenceType delegationFactoryEndpoint = null;
    protected EndpointReferenceType stagingDelegationFactoryEndpoint = null;
    static /* synthetic */ Class class$org$globus$exec$client$GramJob;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReferenceType;
    static /* synthetic */ Class class$org$globus$exec$generated$StateChangeNotificationMessageType;
    static /* synthetic */ Class class$org$globus$exec$generated$FaultResourcePropertyType;
    static /* synthetic */ Class class$org$globus$exec$generated$StateEnumeration;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$globus$exec$generated$ServiceLevelAgreementType;

    public GramJob() {
    }

    public GramJob(JobDescriptionType jobDescription) {
        this();
        try {
            this.jobDescription = (JobDescriptionType)ObjectSerializer.clone((Object)jobDescription);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GramJob(File rslFile) throws RSLParseException, FileNotFoundException {
        this(RSLHelper.readRSL((File)rslFile));
    }

    public GramJob(String rsl) throws RSLParseException {
        this(RSLHelper.readRSL((String)rsl));
    }

    public void addListener(GramJobListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeListener(GramJobListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public GSSCredential getCredentials() {
        return this.proxy;
    }

    public void setCredentials(GSSCredential newProxy) {
        if (this.proxy != null) {
            throw new IllegalArgumentException("Credentials already set");
        }
        this.proxy = newProxy;
    }

    public StateEnumeration getState() {
        return this.state;
    }

    private void setState(StateEnumeration state, boolean holding) {
        if (this.state != null && state.equals((Object)this.state)) {
            return;
        }
        this.state = state;
        logger.debug((Object)("setting job state to " + state));
        this.holding = holding;
        logger.debug((Object)("holding: " + holding));
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            GramJobListener listener = (GramJobListener)this.listeners.elementAt(i);
            listener.stateChanged(this);
        }
    }

    public boolean isHolding() {
        return this.holding;
    }

    public void submit(EndpointReferenceType factoryEndpoint) throws Exception {
        this.submit(factoryEndpoint, false, true, null);
    }

    public void submit(EndpointReferenceType factoryEndpoint, boolean batch) throws Exception {
        this.submit(factoryEndpoint, batch, true, null);
    }

    public void submit(EndpointReferenceType factoryEndpoint, boolean batch, boolean limitedDelegation, String jobId) throws Exception {
        Element eprElement;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<startTime name=\"submission\">" + System.currentTimeMillis() + "</startTime>"));
        }
        this.id = jobId;
        this.limitedDelegation = limitedDelegation;
        EndpointReferenceType factoryEndpointOverride = this.jobDescription.getFactoryEndpoint();
        if (factoryEndpointOverride != null) {
            if (logger.isDebugEnabled()) {
                eprElement = ObjectSerializer.toElement((Object)factoryEndpointOverride, (QName)RSLHelper.FACTORY_ENDPOINT_ATTRIBUTE_QNAME);
                logger.debug((Object)("Factory EPR Override: " + XmlUtils.toString((Element)eprElement)));
            }
            factoryEndpoint = factoryEndpointOverride;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No Factory Endpoint Override...using supplied.");
            }
            this.jobDescription.setFactoryEndpoint(factoryEndpoint);
        }
        if (logger.isDebugEnabled()) {
            eprElement = ObjectSerializer.toElement((Object)factoryEndpoint, (QName)RSLHelper.FACTORY_ENDPOINT_ATTRIBUTE_QNAME);
            logger.debug((Object)("Factory EPR: " + XmlUtils.toString((Element)eprElement)));
        }
        if (factoryEndpoint != null) {
            this.setSecurityTypeFromEndpoint(factoryEndpoint);
            if (this.isDelegationEnabled()) {
                this.populateJobDescriptionEndpoints(factoryEndpoint);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job Submission ID: " + this.id));
        }
        ManagedJobFactoryPortType factoryPort = this.getManagedJobFactoryPortType(factoryEndpoint);
        this.jobEndpointReference = this.createJobEndpoint(factoryPort, batch);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job Endpoint:\n" + this.jobEndpointReference));
        }
    }

    private void setSecurityTypeFromEndpoint(EndpointReferenceType epr) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Endpoint Address URL Scheme:\n" + epr.getAddress().getScheme()));
        }
        if (this.securityType != null) {
            return;
        }
        if (epr.getAddress().getScheme().equals("http")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"using secure conversation");
            }
            this.securityType = "org.globus.security.secConv.msg.type";
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"using transport-level security");
            }
            this.securityType = "org.globus.security.transport.type";
        }
    }

    private void populateJobDescriptionEndpoints(EndpointReferenceType mjFactoryEndpoint) throws Exception {
        EndpointReferenceType[] delegationFactoryEndpoints = this.fetchDelegationFactoryEndpoints(mjFactoryEndpoint);
        EndpointReferenceType delegationEndpoint = this.delegate(delegationFactoryEndpoints[0], this.limitedDelegation);
        this.jobDescription.setJobCredentialEndpoint(delegationEndpoint);
        this.jobDescription.setStagingCredentialEndpoint(delegationEndpoint);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delegated credential endpoint:\n" + delegationEndpoint));
        }
        this.populateStagingDescriptionEndpoints(mjFactoryEndpoint, delegationFactoryEndpoints[1], this.jobDescription);
        if (this.jobDescription instanceof MultiJobDescriptionType) {
            JobDescriptionType[] subJobDescriptions = ((MultiJobDescriptionType)this.jobDescription).getJob();
            for (int index = 0; index < subJobDescriptions.length; ++index) {
                EndpointReferenceType subJobFactoryEndpoint = subJobDescriptions[index].getFactoryEndpoint();
                if (logger.isDebugEnabled()) {
                    Element eprElement = ObjectSerializer.toElement((Object)subJobFactoryEndpoint, (QName)RSLHelper.FACTORY_ENDPOINT_ATTRIBUTE_QNAME);
                    logger.debug((Object)("Sub-Job Factory EPR: " + XmlUtils.toString((Element)eprElement)));
                }
                if (subJobFactoryEndpoint == null) continue;
                if (subJobFactoryEndpoint.getAddress() == null) {
                    logger.error((Object)"Sub-Job Factory Endpoint Address is null.");
                }
                EndpointReferenceType[] subJobDelegationFactoryEndpoints = this.fetchDelegationFactoryEndpoints(subJobFactoryEndpoint);
                EndpointReferenceType subJobCredentialEndpoint = this.delegate(subJobDelegationFactoryEndpoints[0], true);
                subJobDescriptions[index].setJobCredentialEndpoint(subJobCredentialEndpoint);
                subJobDescriptions[index].setStagingCredentialEndpoint(subJobCredentialEndpoint);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sub-job delegated credential endpoint:\n" + subJobCredentialEndpoint));
                }
                this.populateStagingDescriptionEndpoints(subJobFactoryEndpoint, subJobDelegationFactoryEndpoints[1], subJobDescriptions[index]);
            }
        }
    }

    private void populateStagingDescriptionEndpoints(EndpointReferenceType mjFactoryEndpoint, EndpointReferenceType delegationFactoryEndpoint, JobDescriptionType jobDescription) throws Exception {
        TransferRequestType stageOut = jobDescription.getFileStageOut();
        TransferRequestType stageIn = jobDescription.getFileStageIn();
        DeleteRequestType cleanUp = jobDescription.getFileCleanUp();
        if (stageOut != null || stageIn != null || cleanUp != null) {
            String factoryAddress = mjFactoryEndpoint.getAddress().toString();
            factoryAddress = factoryAddress.replaceFirst("ManagedJobFactoryService", "ReliableFileTransferFactoryService");
            EndpointReferenceType transferCredentialEndpoint = this.delegate(delegationFactoryEndpoint, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transferCredentialEndpoint for job " + this.id + ":\n" + ObjectSerializer.toString((Object)transferCredentialEndpoint, (QName)Constants.QNAME_ENDPOINT_REFERENCE)));
            }
            if (stageOut != null) {
                stageOut.setTransferCredentialEndpoint(transferCredentialEndpoint);
            }
            if (stageIn != null) {
                stageIn.setTransferCredentialEndpoint(transferCredentialEndpoint);
            }
            if (cleanUp != null) {
                cleanUp.setTransferCredentialEndpoint(transferCredentialEndpoint);
            }
        }
    }

    public EndpointReferenceType[] fetchDelegationFactoryEndpoints(EndpointReferenceType factoryEndpoint) throws Exception {
        ManagedJobFactoryPortType factoryPort = this.getManagedJobFactoryPortType(factoryEndpoint);
        GetMultipleResourceProperties_Element request = new GetMultipleResourceProperties_Element();
        request.setResourceProperty(new QName[]{ManagedJobFactoryConstants.RP_DELEGATION_FACTORY_ENDPOINT, ManagedJobFactoryConstants.RP_STAGING_DELEGATION_FACTORY_ENDPOINT});
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<startTime name=\"fetchDelegFactoryEndoints\">" + System.currentTimeMillis() + "</startTime>"));
        }
        GetMultipleResourcePropertiesResponse response = factoryPort.getMultipleResourceProperties(request);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<endTime name=\"fetchDelegFactoryEndoints\">" + System.currentTimeMillis() + "</endTime>"));
        }
        MessageElement[] any = response.get_any();
        EndpointReferenceType[] endpoints = new EndpointReferenceType[]{(EndpointReferenceType)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$apache$axis$message$addressing$EndpointReferenceType == null ? (class$org$apache$axis$message$addressing$EndpointReferenceType = GramJob.class$("org.apache.axis.message.addressing.EndpointReferenceType")) : class$org$apache$axis$message$addressing$EndpointReferenceType)), (EndpointReferenceType)ObjectDeserializer.toObject((SOAPElement)any[1], (Class)(class$org$apache$axis$message$addressing$EndpointReferenceType == null ? (class$org$apache$axis$message$addressing$EndpointReferenceType = GramJob.class$("org.apache.axis.message.addressing.EndpointReferenceType")) : class$org$apache$axis$message$addressing$EndpointReferenceType))};
        return endpoints;
    }

    private EndpointReferenceType delegate(EndpointReferenceType delegationFactoryEndpoint, boolean limitedDelegation) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delegation Factory Endpoint:\n" + delegationFactoryEndpoint));
        }
        GlobusCredential credential = null;
        credential = this.proxy != null ? ((GlobusGSSCredentialImpl)this.proxy).getGlobusCredential() : GlobusCredential.getDefaultCredential();
        int lifetime = 86400;
        if (this.duration != null) {
            long currentTime = System.currentTimeMillis();
            lifetime = (int)(this.duration.getTime() - currentTime);
        }
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        if (this.securityType.equals("org.globus.security.secMsg.msg.type")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting GSISecureMsg protection type");
            }
            secDesc.setGSISecureMsg(this.getMessageProtectionType());
        } else if (this.securityType.equals("org.globus.security.secConv.msg.type")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting GSISecureConv protection type");
            }
            secDesc.setGSISecureConv(this.getMessageProtectionType());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting GSITransport protection type");
            }
            secDesc.setGSITransport(this.getMessageProtectionType());
        }
        secDesc.setAuthz(this.getAuthorization());
        if (this.proxy != null) {
            secDesc.setGSSCredential(this.proxy);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<startTime name=\"fetchDelegCertChainRP\">" + System.currentTimeMillis() + "</startTime>"));
        }
        X509Certificate[] certsToDelegateOn = DelegationUtil.getCertificateChainRP((EndpointReferenceType)delegationFactoryEndpoint, (ClientSecurityDescriptor)secDesc);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<endTime name=\"fetchDelegCertChainRP\">" + System.currentTimeMillis() + "</endTime>"));
        }
        X509Certificate certToSign = certsToDelegateOn[0];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delegating...using authz method " + this.getAuthorization()));
        }
        String protocol = delegationFactoryEndpoint.getAddress().getScheme();
        String host = delegationFactoryEndpoint.getAddress().getHost();
        int port = delegationFactoryEndpoint.getAddress().getPort();
        String factoryUrl = protocol + "://" + host + ":" + port + BASE_SERVICE_PATH + "DelegationFactoryService";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delegation Factory URL " + factoryUrl));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<startTime name=\"delegate\">" + System.currentTimeMillis() + "</startTime>"));
        }
        EndpointReferenceType credentialEndpoint = DelegationUtil.delegate((String)factoryUrl, (GlobusCredential)credential, (X509Certificate)certToSign, (int)lifetime, (!limitedDelegation ? 1 : 0) != 0, (ClientSecurityDescriptor)secDesc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delegated Credential Endpoint:\n" + credentialEndpoint));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<endTime name=\"delegate\">" + System.currentTimeMillis() + "</endTime>"));
        }
        return credentialEndpoint;
    }

    private String[] addPathToArray(String[] pathArray, String newPath) {
        String[] newPathArray;
        if (pathArray != null) {
            ArrayList<String> newPathList = new ArrayList<String>(Arrays.asList(pathArray));
            newPathList.add(newPath);
            newPathArray = newPathList.toArray(new String[0]);
        } else {
            newPathArray = new String[]{newPath};
        }
        return newPathArray;
    }

    private String catenate(String baseURL, String path) {
        String SEPARATOR = "/";
        String newPath = path;
        if (path.indexOf("://") < 0) {
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            if (!path.startsWith("/")) {
                baseURL = baseURL + "/";
            }
            newPath = baseURL + path;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("path " + path + " is a URL already. No prepending of URL"));
        }
        return newPath;
    }

    public void prependBaseURLtoStageInSources(String baseURL) {
        TransferRequestType stageInDirectives = this.jobDescription.getFileStageIn();
        if (stageInDirectives != null) {
            TransferType[] transferArray = stageInDirectives.getTransfer();
            for (int i = 0; i < transferArray.length; ++i) {
                String source = transferArray[i].getSourceUrl();
                transferArray[i].setSourceUrl(this.catenate(baseURL, source));
            }
        } else {
            logger.debug((Object)"no stage in directives");
        }
    }

    public void prependBaseURLtoStageOutDestinations(String baseURL) {
        TransferRequestType stageOutDirectives = this.jobDescription.getFileStageOut();
        if (stageOutDirectives != null) {
            TransferType[] transferArray = stageOutDirectives.getTransfer();
            for (int i = 0; i < transferArray.length; ++i) {
                String source = transferArray[i].getDestinationUrl();
                transferArray[i].setDestinationUrl(this.catenate(baseURL, source));
            }
        } else {
            logger.debug((Object)"no stage out directives");
        }
    }

    public JobDescriptionType getDescription() throws Exception {
        if (this.jobDescription == null) {
            this.refreshRSLAttributes();
        }
        return this.jobDescription;
    }

    private EndpointReferenceType createJobEndpoint(ManagedJobFactoryPortType factoryPort, boolean batch) throws Exception {
        logger.debug((Object)"creating ManagedJob instance");
        if (logger.isDebugEnabled()) {
            long millis = System.currentTimeMillis();
            BigDecimal seconds = new BigDecimal((double)millis / 1000.0);
            seconds = seconds.setScale(3, 5);
            logger.debug((Object)("submission time, in seconds from the Epoch:\nbefore: " + seconds.toString()));
            logger.debug((Object)("\nbefore, in milliseconds: " + millis));
        }
        ((Stub)factoryPort).setTimeout(this.axisStubTimeOut);
        CreateManagedJobInputType jobInput = new CreateManagedJobInputType();
        jobInput.setInitialTerminationTime(this.getTerminationTime());
        if (this.id != null) {
            jobInput.setJobID(new AttributedURI(this.id));
        }
        if (this.jobDescription instanceof MultiJobDescriptionType) {
            jobInput.setMultiJob((MultiJobDescriptionType)this.getDescription());
        } else {
            jobInput.setJob(this.getDescription());
        }
        if (!batch) {
            if (this.useDefaultNotificationConsumer) {
                this.setupNotificationConsumerManager();
            }
            try {
                if (this.useDefaultNotificationConsumer) {
                    this.setupNotificationConsumer();
                }
                Subscribe subscriptionRequest = new Subscribe();
                subscriptionRequest.setConsumerReference(this.notificationConsumerEPR);
                TopicExpressionType topicExpression = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)ManagedJobConstants.RP_STATE);
                subscriptionRequest.setTopicExpression(topicExpression);
                jobInput.setSubscribe(subscriptionRequest);
            }
            catch (Exception e) {
                logger.error((Object)e);
                try {
                    this.unbind();
                }
                catch (Exception unbindEx) {
                    logger.error((Object)unbindEx);
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<startTime name=\"createManagedJob\">" + System.currentTimeMillis() + "</startTime>"));
        }
        CreateManagedJobOutputType response = factoryPort.createManagedJob(jobInput);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("<endTime name=\"createManagedJob\">" + System.currentTimeMillis() + "</endTime"));
        }
        EndpointReferenceType jobEPR = response.getManagedJobEndpoint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job Handle: " + AuditUtil.eprToGridId((EndpointReferenceType)jobEPR)));
            Element jobEndpointElement = null;
            try {
                jobEndpointElement = ObjectSerializer.toElement((Object)jobEPR, (QName)new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "EndpointReferenceType"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.debug((Object)("Job EPR: " + XmlUtils.toString((Element)jobEndpointElement)));
        }
        this.notificationProducerEPR = response.getSubscriptionEndpoint();
        if (logger.isDebugEnabled()) {
            Calendar terminationTime = response.getNewTerminationTime();
            Calendar serviceCurrentTime = response.getCurrentTime();
            logger.debug((Object)("Termination time granted by the factory to the job resource: " + terminationTime.getTime()));
            logger.debug((Object)("Current time seen by the factory service on creation: " + serviceCurrentTime.getTime()));
        }
        return jobEPR;
    }

    private void setupNotificationConsumerManager() throws GSSException, ContainerException {
        logger.debug((Object)("Security Type: " + this.securityType));
        if (this.securityType.equals("org.globus.security.secMsg.msg.type") || this.securityType.equals("org.globus.security.secConv.msg.type")) {
            logger.debug((Object)"Setting up a non-secure consumer manager.");
            this.notificationConsumerManager = NotificationConsumerManager.getInstance();
        } else {
            logger.debug((Object)"Setting up a secure consumer manager.");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
            if (this.proxy != null) {
                ContainerSecurityDescriptor containerSecDesc = new ContainerSecurityDescriptor();
                SecurityManager secManager = SecurityManager.getManager();
                containerSecDesc.setSubject(JaasGssUtil.createSubject((GSSCredential)this.proxy));
                properties.put("container.descriptor", (String)containerSecDesc);
            }
            this.notificationConsumerManager = NotificationConsumerManager.getInstance(properties);
        }
        this.notificationConsumerManager.startListening();
    }

    private void setupNotificationConsumer() throws SecurityDescriptorException, ResourceException {
        logger.debug((Object)"Setting up notification consumer.");
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(ManagedJobConstants.RP_STATE);
        ResourceSecurityDescriptor securityDescriptor = new ResourceSecurityDescriptor();
        String authz = null;
        if (this.authorization == null) {
            authz = "none";
        } else if (this.authorization instanceof HostAuthorization) {
            authz = "none";
        } else if (this.authorization instanceof SelfAuthorization) {
            authz = "self";
        } else if (this.authorization instanceof IdentityAuthorization) {
            GridMap gridMap = new GridMap();
            gridMap.map(((IdentityAuthorization)this.authorization).getIdentity(), "HaCk");
            securityDescriptor.setGridMap(gridMap);
            authz = "gridmap";
        } else {
            logger.error((Object)("Unsupported authorization method class " + this.authorization.getClass().getName()));
            return;
        }
        securityDescriptor.setAuthz(authz);
        Vector<Object> authMethod = new Vector<Object>();
        logger.debug((Object)("Security Type: " + this.securityType));
        if (this.securityType.equals("org.globus.security.secMsg.msg.type")) {
            authMethod.add(GSISecureMsgAuthMethod.BOTH);
        } else if (this.securityType.equals("org.globus.security.secConv.msg.type")) {
            authMethod.add(GSISecureConvAuthMethod.BOTH);
        } else {
            authMethod.add(GSITransportAuthMethod.BOTH);
        }
        securityDescriptor.setAuthMethods(authMethod);
        this.notificationConsumerEPR = this.notificationConsumerManager.createNotificationConsumer(topicPath, (NotifyCallback)this, securityDescriptor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("notification consumer endpoint:\n" + this.notificationConsumerEPR));
        }
    }

    public boolean isRequested() {
        return this.jobEndpointReference != null;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    private ManagedJobFactoryPortType getManagedJobFactoryPortType(EndpointReferenceType factoryEndpoint) throws Exception {
        ManagedJobFactoryPortType factoryPort = ManagedJobFactoryClientHelper.getPort((EndpointReferenceType)factoryEndpoint);
        this.setStubSecurityProperties((javax.xml.rpc.Stub)factoryPort);
        return factoryPort;
    }

    public void cancel() throws Exception {
        logger.debug((Object)"destroy() called in cancel()");
        this.destroy();
        this.setState(StateEnumeration.Failed, false);
    }

    public void bind() throws Exception {
        logger.debug((Object)"bind() called");
        if (this.useDefaultNotificationConsumer) {
            this.setupNotificationConsumerManager();
        }
        try {
            if (this.useDefaultNotificationConsumer) {
                this.setupNotificationConsumer();
            }
            Subscribe request = new Subscribe();
            request.setConsumerReference(this.notificationConsumerEPR);
            TopicExpressionType topicExpression = new TopicExpressionType("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple", (Object)ManagedJobConstants.RP_STATE);
            request.setTopicExpression(topicExpression);
            ManagedJobPortType jobPort = ManagedJobClientHelper.getPort((EndpointReferenceType)this.jobEndpointReference);
            this.setStubSecurityProperties((javax.xml.rpc.Stub)jobPort);
            SubscribeResponse response = jobPort.subscribe(request);
            this.notificationProducerEPR = response.getSubscriptionReference();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notification producer endpoint:\n" + this.notificationProducerEPR));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            try {
                this.unbind();
            }
            catch (Exception unbindEx) {
                logger.error((Object)unbindEx);
            }
        }
    }

    public void unbind() throws NoSuchResourceException, Exception {
        if (this.notificationProducerEPR != null) {
            SubscriptionManager subscriptionPort = new WSBaseNotificationServiceAddressingLocator().getSubscriptionManagerPort(this.notificationProducerEPR);
            this.setStubSecurityProperties((javax.xml.rpc.Stub)subscriptionPort);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("<startTime name=\"subscriptionDestroy\">" + System.currentTimeMillis() + "</startTime>"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calling destroy on notificationProducerEPR:\n" + ObjectSerializer.toString((Object)this.notificationProducerEPR, (QName)Constants.QNAME_ENDPOINT_REFERENCE)));
            }
            subscriptionPort.destroy(new Destroy());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("<endTime name=\"subscriptionDestroy\">" + System.currentTimeMillis() + "</endTime>"));
            }
        }
        if (!this.notificationConsumerManager.isListening()) {
            String errorMessage = i18n.getMessage("PreconditionViolation", (Object)"!notificationConsumerManager.isListening()");
            throw new RuntimeException(errorMessage);
        }
        if (this.notificationConsumerEPR != null) {
            logger.debug((Object)"removing the notification consumer");
            this.notificationConsumerManager.removeNotificationConsumer(this.notificationConsumerEPR);
        }
        logger.debug((Object)"stopping the consumer manager from listening");
        this.notificationConsumerManager.stopListening();
    }

    public synchronized void destroy() throws Exception {
        if (!this.destroyed) {
            logger.debug((Object)"destroy() called");
            if (this.isDelegationEnabled()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Job Description for job " + this.id + " (BEFORE):\n" + this.toString()));
                }
                this.getDescription();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Job Description for job " + this.id + " (AFTER):\n" + this.toString()));
                }
            }
            try {
                if (this.notificationConsumerManager != null && this.notificationConsumerManager.isListening()) {
                    this.unbind();
                }
            }
            catch (NoSuchResourceException noSuchResEx) {
                String warnMessage = i18n.getMessage("RemoteResourceDestructionError");
                logger.warn((Object)warnMessage, (Throwable)noSuchResEx);
            }
            ManagedJobPortType jobPort = ManagedJobClientHelper.getPort((EndpointReferenceType)this.jobEndpointReference);
            this.setStubSecurityProperties((javax.xml.rpc.Stub)jobPort);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("<startTime name=\"destroy\">" + System.currentTimeMillis() + "</startTime>"));
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Calling destroy on jobEndpointReference:\n" + ObjectSerializer.toString((Object)this.jobEndpointReference, (QName)Constants.QNAME_ENDPOINT_REFERENCE)));
                }
                jobPort.destroy(new Destroy());
            }
            catch (ResourceUnknownFaultType resUnknownFault) {
                String warnMessage = i18n.getMessage("RemoteResourceDestructionError");
                logger.warn((Object)warnMessage, (Throwable)resUnknownFault);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("<endTime name=\"destroy\">" + System.currentTimeMillis() + "</endTime>"));
            }
            if (this.isDelegationEnabled()) {
                this.destroyDelegatedCredentials();
            }
            this.destroyed = true;
        } else {
            logger.warn((Object)"destroy() already called");
        }
    }

    private void destroyDelegatedCredentials() throws Exception {
        EndpointReferenceType jobCredentialEndpoint = this.jobDescription.getJobCredentialEndpoint();
        if (jobCredentialEndpoint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calling destroy on jobCredentialEndpoint:\n" + ObjectSerializer.toString((Object)jobCredentialEndpoint, (QName)Constants.QNAME_ENDPOINT_REFERENCE)));
            }
            this.destroyDelegatedCredential(jobCredentialEndpoint);
        }
        this.destroyTransferDelegatedCredential(this.jobDescription);
        if (this.jobDescription instanceof MultiJobDescriptionType) {
            JobDescriptionType[] subJobDescriptions = ((MultiJobDescriptionType)this.jobDescription).getJob();
            for (int index = 0; index < subJobDescriptions.length; ++index) {
                EndpointReferenceType subJobCredentialEndpoint = subJobDescriptions[index].getJobCredentialEndpoint();
                if (jobCredentialEndpoint != null) {
                    this.destroyDelegatedCredential(subJobCredentialEndpoint);
                }
                this.destroyTransferDelegatedCredential(subJobDescriptions[index]);
            }
        }
    }

    private void destroyTransferDelegatedCredential(JobDescriptionType jobDescription) throws Exception {
        TransferRequestType stageOut = jobDescription.getFileStageOut();
        TransferRequestType stageIn = jobDescription.getFileStageIn();
        DeleteRequestType cleanUp = jobDescription.getFileCleanUp();
        EndpointReferenceType transferCredentialEndpoint = null;
        if (stageOut != null) {
            transferCredentialEndpoint = stageOut.getTransferCredentialEndpoint();
        } else if (stageIn != null) {
            transferCredentialEndpoint = stageIn.getTransferCredentialEndpoint();
        } else if (cleanUp != null) {
            transferCredentialEndpoint = cleanUp.getTransferCredentialEndpoint();
        }
        if (transferCredentialEndpoint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calling destroy on transferCredentialEndpoint for job " + this.id + ":\n" + ObjectSerializer.toString((Object)transferCredentialEndpoint, (QName)Constants.QNAME_ENDPOINT_REFERENCE)));
            }
            this.destroyDelegatedCredential(transferCredentialEndpoint);
        }
    }

    private void destroyDelegatedCredential(EndpointReferenceType credentialEndpoint) throws Exception {
        block4: {
            DelegationPortType delegatedCredentialPort = new DelegationServiceAddressingLocator().getDelegationPortTypePort(credentialEndpoint);
            this.setStubSecurityProperties((javax.xml.rpc.Stub)delegatedCredentialPort);
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("<startTime name=\"delegatedCredentialDestroy\">" + System.currentTimeMillis() + "</startTime>"));
                }
                delegatedCredentialPort.destroy(new Destroy());
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("<endTime name=\"delegatedCredentialDestroy\">" + System.currentTimeMillis() + "</endTime>"));
                }
            }
            catch (ResourceUnknownFaultType resUnknownFault) {
                logger.warn((Object)"Unable to destroy resource");
                if (!logger.isDebugEnabled()) break block4;
                resUnknownFault.printStackTrace();
            }
        }
    }

    public synchronized boolean isLocallyDestroyed() {
        return this.destroyed;
    }

    public void release() throws Exception {
        ManagedJobPortType jobPort = ManagedJobClientHelper.getPort((EndpointReferenceType)this.jobEndpointReference);
        this.setStubSecurityProperties((javax.xml.rpc.Stub)jobPort);
        Stub s = (Stub)jobPort;
        s.setTimeout(this.axisStubTimeOut);
        logger.debug((Object)("setting timeout for Axis to " + this.axisStubTimeOut + " ms"));
        logger.debug((Object)"releasing ManagedJob from hold");
        jobPort.release(new ReleaseInputType());
    }

    protected void setError(int code) {
        this.error = this.error;
    }

    public int getError() {
        return this.error;
    }

    public FaultType getFault() {
        return this.fault;
    }

    public EndpointReferenceType getEndpoint() {
        return this.jobEndpointReference;
    }

    public void setEndpoint(EndpointReferenceType endpoint) throws Exception {
        this.jobEndpointReference = endpoint;
        if (this.jobEndpointReference != null) {
            this.setSecurityTypeFromEndpoint(this.jobEndpointReference);
        }
    }

    public String getID() {
        return this.id;
    }

    public String getHandle() {
        if (this.jobHandle == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Generating handle from endpoint " + this.jobEndpointReference));
            }
            this.jobHandle = ManagedJobClientHelper.getHandle((EndpointReferenceType)this.jobEndpointReference);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New handle: " + this.jobHandle));
            }
        }
        return this.jobHandle;
    }

    public void setHandle(String handle) throws Exception {
        this.jobHandle = handle;
        if (this.jobHandle != null) {
            this.jobEndpointReference = ManagedJobClientHelper.getEndpoint((String)handle);
            this.setSecurityTypeFromEndpoint(this.jobEndpointReference);
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setTimeOut(int timeout) {
        this.axisStubTimeOut = timeout;
    }

    public String toString() {
        String jobDescString = "RSL: ";
        JobDescriptionType jobDesc = null;
        try {
            jobDesc = this.getDescription();
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("FetchJobDescriptionError");
            logger.error((Object)errorMessage, (Throwable)e);
        }
        if (jobDesc != null) {
            jobDescString = jobDescString + RSLHelper.convertToString((JobDescriptionType)jobDesc);
        }
        return jobDescString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(List topicPath, EndpointReferenceType producer, Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"receiving notification");
            if (message instanceof Element) {
                logger.debug((Object)("message is of type " + message.getClass().getName()));
                logger.debug((Object)("message contents: \n" + XmlUtils.toString((Element)((Element)message))));
            }
        }
        try {
            StateChangeNotificationMessageType changeNotification = (StateChangeNotificationMessageType)ObjectDeserializer.toObject((Element)((Element)message), (Class)(class$org$globus$exec$generated$StateChangeNotificationMessageType == null ? (class$org$globus$exec$generated$StateChangeNotificationMessageType = GramJob.class$("org.globus.exec.generated.StateChangeNotificationMessageType")) : class$org$globus$exec$generated$StateChangeNotificationMessageType));
            StateEnumeration state = changeNotification.getState();
            boolean holding = changeNotification.isHolding();
            if (state.equals((Object)StateEnumeration.Failed)) {
                this.setFault(this.getFaultFromRP(changeNotification.getFault()));
            }
            if (state.equals((Object)StateEnumeration.StageOut) || state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) {
                this.exitCode = changeNotification.getExitCode();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting exit code to " + Integer.toString(this.exitCode)));
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("<endTime name=\"submission\">" + System.currentTimeMillis() + "</endTime>"));
                }
            }
            Object object = this.stateMonitor;
            synchronized (object) {
                if (this.notificationConsumerManager != null && !this.notificationConsumerManager.isListening()) {
                    return;
                }
                this.setState(state, holding);
            }
        }
        catch (Exception e) {
            String errorMessage = "Notification message processing FAILED:Could not get value or set new status.";
            logger.error((Object)errorMessage, (Throwable)e);
        }
    }

    private void setFault(FaultType fault) throws Exception {
        this.fault = fault;
    }

    private FaultType getFaultFromRP(FaultResourcePropertyType fault) {
        if (fault == null) {
            return null;
        }
        if (fault.getFault() != null) {
            return fault.getFault();
        }
        if (fault.getCredentialSerializationFault() != null) {
            return fault.getCredentialSerializationFault();
        }
        if (fault.getExecutionFailedFault() != null) {
            return fault.getExecutionFailedFault();
        }
        if (fault.getFilePermissionsFault() != null) {
            return fault.getFilePermissionsFault();
        }
        if (fault.getInsufficientCredentialsFault() != null) {
            return fault.getInsufficientCredentialsFault();
        }
        if (fault.getInternalFault() != null) {
            return fault.getInternalFault();
        }
        if (fault.getInvalidCredentialsFault() != null) {
            return fault.getInvalidCredentialsFault();
        }
        if (fault.getInvalidPathFault() != null) {
            return fault.getInvalidPathFault();
        }
        if (fault.getServiceLevelAgreementFault() != null) {
            return fault.getServiceLevelAgreementFault();
        }
        if (fault.getStagingFault() != null) {
            return fault.getStagingFault();
        }
        if (fault.getUnsupportedFeatureFault() != null) {
            return fault.getUnsupportedFeatureFault();
        }
        return null;
    }

    private FaultType deserializeFaultRP(SOAPElement any) throws DeserializationException {
        return this.getFaultFromRP((FaultResourcePropertyType)ObjectDeserializer.toObject((SOAPElement)any, (Class)(class$org$globus$exec$generated$FaultResourcePropertyType == null ? (class$org$globus$exec$generated$FaultResourcePropertyType = GramJob.class$("org.globus.exec.generated.FaultResourcePropertyType")) : class$org$globus$exec$generated$FaultResourcePropertyType)));
    }

    public void refreshStatus() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refreshing state of job with endpoint " + this.jobEndpointReference));
        }
        boolean singleJob = this.isSingleJob();
        ManagedJobPortType jobPort = ManagedJobClientHelper.getPort((EndpointReferenceType)this.jobEndpointReference);
        this.setStubSecurityProperties((javax.xml.rpc.Stub)jobPort);
        GetMultipleResourceProperties_Element request = new GetMultipleResourceProperties_Element();
        if (singleJob) {
            logger.debug((Object)"Including exitCode in the RP query.");
            request.setResourceProperty(new QName[]{ManagedJobConstants.RP_STATE, ManagedJobConstants.RP_HOLDING, ManagedJobConstants.RP_FAULT, ManagedExecutableJobConstants.RP_EXIT_CODE});
        } else {
            request.setResourceProperty(new QName[]{ManagedJobConstants.RP_STATE, ManagedJobConstants.RP_HOLDING, ManagedJobConstants.RP_FAULT});
        }
        GetMultipleResourcePropertiesResponse response = jobPort.getMultipleResourceProperties(request);
        MessageElement[] any = response.get_any();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Raw status query response message:\n" + AnyHelper.toSingleString((MessageElement[])any)));
        }
        logger.debug((Object)"Deserializing \"state\".");
        StateEnumeration state = (StateEnumeration)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$globus$exec$generated$StateEnumeration == null ? (class$org$globus$exec$generated$StateEnumeration = GramJob.class$("org.globus.exec.generated.StateEnumeration")) : class$org$globus$exec$generated$StateEnumeration));
        logger.debug((Object)"Deserializing \"holding\".");
        Boolean holding = (Boolean)ObjectDeserializer.toObject((SOAPElement)any[1], (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = GramJob.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        int exitCodeIndex = 0;
        if (state.equals((Object)StateEnumeration.Failed)) {
            logger.debug((Object)"Deserializing \"fault\".");
            FaultType fault = this.deserializeFaultRP((SOAPElement)any[2]);
            this.setFault(fault);
            exitCodeIndex = 3;
        } else {
            exitCodeIndex = 2;
        }
        if ((state.equals((Object)StateEnumeration.StageOut) || state.equals((Object)StateEnumeration.Done) || state.equals((Object)StateEnumeration.Failed)) && exitCodeIndex > 0 && singleJob && any.length == exitCodeIndex + 1) {
            logger.debug((Object)"Deserializing \"exitCode\".");
            Integer exitCodeWrapper = (Integer)ObjectDeserializer.toObject((SOAPElement)any[exitCodeIndex], (Class)(class$java$lang$Integer == null ? (class$java$lang$Integer = GramJob.class$("java.lang.Integer")) : class$java$lang$Integer));
            logger.debug((Object)("Fetched exitCode value is " + exitCodeWrapper));
            this.exitCode = exitCodeWrapper;
        }
        this.setState(state, holding);
    }

    private void refreshRSLAttributes() throws Exception {
        ManagedJobPortType jobPort = ManagedJobClientHelper.getPort((EndpointReferenceType)this.jobEndpointReference);
        this.setStubSecurityProperties((javax.xml.rpc.Stub)jobPort);
        GetResourcePropertyResponse response = jobPort.getResourceProperty(ManagedJobConstants.RP_SERVICE_LEVEL_AGREEMENT);
        MessageElement[] any = response.get_any();
        ServiceLevelAgreementType sla = (ServiceLevelAgreementType)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$globus$exec$generated$ServiceLevelAgreementType == null ? (class$org$globus$exec$generated$ServiceLevelAgreementType = GramJob.class$("org.globus.exec.generated.ServiceLevelAgreementType")) : class$org$globus$exec$generated$ServiceLevelAgreementType));
        this.jobDescription = sla.getJob();
        if (this.jobDescription == null) {
            this.jobDescription = sla.getMultiJob();
        }
    }

    public static List getJobs(EndpointReferenceType factoryEndpoint) throws Exception {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    private void setStubSecurityProperties(javax.xml.rpc.Stub stub) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting factory stub security...using authz method " + this.getAuthorization()));
        }
        ClientSecurityDescriptor secDesc = new ClientSecurityDescriptor();
        if (this.securityType.equals("org.globus.security.secMsg.msg.type")) {
            secDesc.setGSISecureMsg(this.getMessageProtectionType());
        } else if (this.securityType.equals("org.globus.security.secConv.msg.type")) {
            secDesc.setGSISecureConv(this.getMessageProtectionType());
        } else {
            secDesc.setGSITransport(this.getMessageProtectionType());
        }
        secDesc.setAuthz(this.getAuthorization());
        if (this.proxy != null) {
            secDesc.setGSSCredential(this.proxy);
        }
        stub._setProperty("clientDescriptor", (Object)secDesc);
    }

    public void setAuthorization(Authorization authz) {
        this.authorization = authz;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setMessageProtectionType(Integer protectionType) {
        this.msgProtectionType = protectionType;
    }

    public Integer getMessageProtectionType() {
        return this.msgProtectionType;
    }

    public String getDelegationLevel() {
        return this.limitedDelegation ? "gsilimited" : "gsifull";
    }

    public void setDelegationEnabled(boolean delegationEnabled) {
        this.delegationEnabled = delegationEnabled;
    }

    public boolean isDelegationEnabled() {
        return this.delegationEnabled;
    }

    public void setDuration(Date duration) {
        this.duration = duration;
    }

    public void setTerminationTime(Date termTime) {
        this.terminationDate = termTime;
    }

    private Calendar getTerminationTime() throws Exception {
        Calendar terminationTime;
        if (this.duration == null && this.terminationDate == null) {
            terminationTime = GramJob.getDefaultTerminationTime();
        } else {
            terminationTime = Calendar.getInstance();
            if (this.duration != null) {
                Calendar durationCalendar = Calendar.getInstance();
                durationCalendar.setTime(this.duration);
                int hours = durationCalendar.get(11);
                int minutes = durationCalendar.get(12);
                terminationTime.add(11, hours);
                terminationTime.add(12, minutes);
            } else {
                terminationTime.setTime(this.terminationDate);
            }
        }
        return terminationTime;
    }

    public void setServiceTerminationTime() throws Exception {
        Calendar terminationTime = this.getTerminationTime();
        logger.debug((Object)"setting job resource duration");
        SetTerminationTime request = new SetTerminationTime();
        request.setRequestedTerminationTime(terminationTime);
        SetTerminationTimeResponse response = ManagedJobClientHelper.getPort((EndpointReferenceType)this.jobEndpointReference).setTerminationTime(request);
        if (logger.isDebugEnabled()) {
            Calendar newTermTime = response.getNewTerminationTime();
            logger.debug((Object)("requested: " + terminationTime.getTime()));
            logger.debug((Object)("scheduled: " + newTermTime.getTime()));
        }
    }

    private static void addDefaultDurationTo(Calendar currentTime) {
        currentTime.add(10, 24);
    }

    private static Calendar getDefaultTerminationTime() {
        Calendar timeOut = Calendar.getInstance();
        GramJob.addDefaultDurationTo(timeOut);
        return timeOut;
    }

    public boolean isSingleJob() {
        AttributedURI address = this.jobEndpointReference.getAddress();
        String path = address.getPath();
        return path.indexOf("ManagedExecutableJobService") > 0;
    }

    public boolean isMultiJob() {
        AttributedURI address = this.jobEndpointReference.getAddress();
        String path = address.getPath();
        return path.indexOf("ManagedMultiJobService") > 0;
    }

    public EndpointReferenceType getNotificationConsumerEPR() {
        return this.notificationConsumerEPR;
    }

    public void setNotificationConsumerEPR(EndpointReferenceType notificationConsumerEPR) {
        this.useDefaultNotificationConsumer = false;
        this.notificationConsumerEPR = notificationConsumerEPR;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Util.registerTransport();
    }
}

