/*
 * Decompiled with CFR 0.152.
 */
package org.globus.exec.client;

import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.Constants;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.exec.client.GramJob;
import org.globus.exec.client.GramJobListener;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.JobDescriptionType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.utils.FaultUtils;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.exec.utils.client.ManagedJobFactoryClientHelper;
import org.globus.exec.utils.rsl.RSLHelper;
import org.globus.gsi.GSIConstants;
import org.globus.util.I18n;
import org.globus.wsrf.client.ServiceURL;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.utils.XmlUtils;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsrf.faults.BaseFaultType;
import org.w3c.dom.Element;

public class GlobusRun
implements GramJobListener {
    private static final long STATE_CHANGE_BASE_TIMEOUT_MILLIS = 60000L;
    private static final String GLOBUS_VERSION = "GT 3.9.4";
    private static Log logger = LogFactory.getLog((String)(class$org$globus$exec$client$GlobusRun == null ? (class$org$globus$exec$client$GlobusRun = GlobusRun.class$("org.globus.exec.client.GlobusRun")) : class$org$globus$exec$client$GlobusRun).getName());
    private GramJob job;
    private boolean jobCompleted = false;
    private boolean batch;
    private boolean limitedDelegation = true;
    private boolean delegationEnabled = false;
    private boolean quiet = false;
    private static final String DURATION_FORMAT = "HH:mm";
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm";
    private static final int GLOBUSRUN_ARG_QUIET = 2;
    private static final int GLOBUSRUN_ARG_DRYRUN = 4;
    private static final int GLOBUSRUN_ARG_PARSE_ONLY = 8;
    private static final int GLOBUSRUN_ARG_AUTHENTICATE_ONLY = 16;
    private static final int GLOBUSRUN_ARG_BATCH = 512;
    private static final int GLOBUSRUN_ARG_FULL_DELEGATION = 8192;
    private static final int GLOBUSRUN_ARG_LIST = 16384;
    private String submissionID = null;
    private static final String usageDesc = "ARGUMENTS: \n         [options] [<factory>] <job description>\n         -p -file <job description file name>\n         (-state | -release | -kill) <job handle>\n         -help | -usage | -version\n\nwith\n     <job description> = -file <file name> | <command line>\n     <factory>         = -factory <contact> [-type <type>]\n     <contact>         = [<protocol>://]<host>[:[port]][/<service>]\n     [options]         = [-q] [-n]\n                         [-b] [-duration] [-terminate-at]\n                         [-auth <auth>] [-xmlsec <sec>] [-personal]\n                         [-submission-id <ID>]\n\n";
    private static final String descriptionDesc = "DESCRIPTION:\nThis command is used to submit jobs to globus resources. The job\nstartup is done by submitting a client-side provided job\ndescription to the GRAM services.\nIn addition to starting jobs, it is possible to query the state of\na previously started job and parse a job description file without\nmaking any submission.\nThe existence of a valid proxy is required for essentially all\nsupported operations but job description file parsing (option -p).\n\n";
    private static final String optionsDesc = "OPTIONS:\n\nHelp:\n -help                 display help.\n -usage                display usage.\n -v, -version          display version.\n\nJob Factory Contact:\n -factory <contact>    specify the URL of the Job Factory Service\n                       to contact when submitting or listing jobs.\n                       A factory contact string can be specified in\n                       the following ways:\n                       host\n                       host:\n                       host:port\n                       host:port/service\n                       host/service\n                       host:/service\n                       It is also possible to specify the protocol\n                       by prepending   protocol://  to each of the\n                       previous possibilities, bringing the total\n                       number of supported syntaxes to 12.\n                       For those factory contacts which omit the\n                       protocol, port or service field, default\n                       values are used, as summarized in the\n                       following table:\n                       URL part | default value\n                       port     | " + Integer.toString(ServiceURL.getDefaultPort()) + "\n" + "                       protocol | " + ServiceURL.getDefaultProtocol() + "\n" + "                       service  | " + ManagedJobFactoryConstants.DEFAULT_SERVICE_URL.getFullServicePath() + "\n\n" + "                       Omitting altogether the -factory option is\n" + "                       equivalent to specifying the local host as\n" + "                       the contact string (with the implied default\n" + "                       protocol, port and service).\n" + " -type <factory type>  the type of factory resource to use. This is\n" + "                       the name of the local resource manager.\n" + "                       The default is " + "Fork" + ".\n" + "Job Specification:\n" + " <command line>        create a simple job description that only\n" + "                       consists of a command line of the form:\n" + "                           'executable (argument)*'\n" + "                       Quotes must be used if there is one or more\n" + "                       arguments.\n" + " -file <RSL filename>  read RSL from the local file <RSL filename>.\n" + "                       The RSL must be a single job request.\n" + " -p                    only parse the RSL, and then print either a\n" + "                       success message or a parser failure. No job\n" + "                       will be submitted to any factory service.\n" + "                       The RSL must be a single job request. \n" + "\n" + "Batch Operations:\n" + " -b, -batch            do not wait for started job to complete (and\n" + "                       do not destroy started job service on exit).\n" + "                       The handle of the job service will be\n" + "                       printed on the standard output.\n" + "                       incompatible with multi-request jobs.\n" + "                       Implies -quiet.\n" + " -l, -list             NOT FUNCTIONAL YET (see below)\n" + " -state <handle>       printout the state of the specified job.\n" + "                       For a list of valid states, see the GRAM\n" + "                       documentation; the current valid states are\n" + "                       Pending, Active, Done, Suspended, and Failed." + "\n" + " -r, -release <handle> release the specified job from hold.\n" + "\n" + " -k, -kill <handle>    kill the specified job.\n" + "\n" + "                       Note: The <handle> argument is printed out\n" + "                       when executing in batch mode or when using\n" + "                       the -list option.\n" + "\n" + "Job Resource Lifetime:\n" + " -duration <duration>  specify duration of job resource. The job\n" + "                       resource will destroy itself automatically\n" + "                       after the specified duration starting from\n" + "                       service creation.\n" + "                       Format: " + "HH:mm" + "\n" + "                       Default: " + 24 + " hours.\n" + "                       Incompatible with -date-time.\n" + "                       Useful with -batch.\n" + " -terminate-at <date>  specify termination date/time of job.\n" + "                       Same as -duration but with an absolute\n" + "                       date/time value.\n" + "                       Format: " + "MM/dd/yyyy HH:mm" + "\n" + "                       Default: see -duration.\n" + "                       The date expression may need to be quoted,\n" + "                       as in:     -terminate-at '08/15/2005 11:30'\n" + "                       Incompatible with -duration.\n" + "                       Useful with -batch.\n" + "\n" + "Security:\n" + " -auth <auth>          set authorization type. <auth> can be:\n" + "                           'host' for host authorization (default),\n" + "                           'self' for self authorization\n" + "                           <id> for identity authorization.\n" + " -xmlsec <sec>         set message protection level. <sec> can be:\n" + "                           'sig' for XML Signature (default),\n" + "                           'enc' for XML Encryption.\n" + " -personal             shortcut for -auth self.\n" + " -proxy <proxy file>   use <proxy file> instead of the default\n" + "                       proxy credential file.\n" + " -deleg <deleg>        set delegation type. <deleg> can be:\n" + "                           'full' for full delegation,\n" + "                           'limited' for limited delegation " + "(default),\n" + "                           or 'none' for no delegation " + "\n" + "Miscellaneous:\n" + " -q, -quiet            set quiet mode on (do not print diagnostic\n" + "                       messages when job state changes, in\n" + "                       non-batch mode). Useful when job output is\n" + "                       redirected to the local process and parsed.\n" + " -n, -no-interrupt     disable interrupt handling. By default,\n" + "                       interrupt signals (typically generated by\n" + "                       Ctrl + C) cause the program to terminate the\n" + "                       currently submitted job. This flag disables\n" + "                       that behavior.\n" + " -timeout <integer>    set timeout for HTTP socket, in milliseconds.\n" + "                       Applies to job submission only.\n" + "                       Default is " + 120000 + ".\n" + " -submission-id <ID>   set the submission ID of a previous job\n" + "                       submission for which no server response was\n" + "                       received.\n" + "                       The ID can be used after an attempted job\n" + "                       submission in order to recover the handle to\n" + "                       the job.\n" + "\n" + "GT2 globusrun options not functional (yet):\n" + " -l, -list             NOT IMPLEMENTED ON SERVER SIDE YET.\n" + "                       list previously started and not destroyed\n" + "                       job services for this user. The output of\n" + "                       this command consists of the handles and RSL\n" + "                       of the submitted jobs.\n" + "                       Requires the -factory <URL> argument.\n" + " -dryrun               NOT IMPLEMENTED ON SERVER SIDE YET.\n" + "                       augment the RSL in order to mark this job as\n" + "                       a dry run, if the RSL does not already say\n" + "                       so. This causes the job manager to stop\n" + "                       short of starting the job, but still detect\n" + "                       other RSL errors (such as bad directory,\n" + "                       bad executable, etc). An error message will\n" + "                       be displayed if the dry run fails.\n" + "                       Otherwise, a message will be displayed\n" + "                       indicating that the dryrun was successful.\n" + " -authenticate-only    NOT IMPLEMENTED ON SERVER SIDE YET.\n" + "";
    private static final String ERROR_MESSAGE_PREFIX = "Error: ";
    private static final String JOB_FAILED = "Job failed: ";
    private static final String JOB_STATE_PREFIX = "Job State: ";
    private boolean noInterruptHandling = false;
    private boolean isInterrupted = true;
    private boolean normalApplicationEnd = false;
    private String proxyPath = null;
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$exec$utils$Resources == null ? (class$org$globus$exec$utils$Resources = GlobusRun.class$("org.globus.exec.utils.Resources")) : class$org$globus$exec$utils$Resources).getName());
    static /* synthetic */ Class class$org$globus$exec$client$GlobusRun;
    static /* synthetic */ Class class$org$globus$exec$utils$Resources;

    private void exit(int exitCode) {
        if (exitCode <= 0) {
            this.normalApplicationEnd = true;
        }
        this.isInterrupted = false;
        System.exit(exitCode);
    }

    public static void main(String[] args) {
        new GlobusRun(args);
    }

    public GlobusRun(String[] args) {
        this.processArguments(args);
    }

    private void processArguments(String[] args) {
        String simpleJobCommandLine = null;
        File rslFile = null;
        String contactString = null;
        EndpointReferenceType factoryEndpoint = null;
        String factoryType = "Fork";
        Integer xmlSecurity = GSIConstants.SIGNATURE;
        SelfAuthorization authorization = null;
        int options = 0;
        boolean commandLineError = false;
        Date serviceDuration = null;
        Date serviceTerminationDate = null;
        int timeout = 120000;
        if (args.length == 0) {
            commandLineError = true;
        } else {
            boolean jobSubmission;
            boolean jobListing;
            boolean rslParsingOnly;
            block74: {
                for (int i = 0; i < args.length && !commandLineError; ++i) {
                    if (args[i].startsWith("-")) {
                        SimpleDateFormat dateFormat;
                        if (args[i].equalsIgnoreCase("-help")) {
                            System.out.println();
                            System.out.println(usageDesc);
                            System.out.println(descriptionDesc);
                            System.out.println(optionsDesc);
                            this.exit(0);
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-usage")) {
                            System.out.println(usageDesc);
                            this.exit(0);
                            continue;
                        }
                        if (args[i].equals("-v") || args[i].equalsIgnoreCase("-version")) {
                            System.out.println(GLOBUS_VERSION);
                            this.exit(0);
                            continue;
                        }
                        if (args[i].equals("-n") || args[i].equalsIgnoreCase("-no-interrupt")) {
                            this.noInterruptHandling = true;
                            continue;
                        }
                        if (args[i].equals("-p") || args[i].equalsIgnoreCase("-parse")) {
                            options |= 8;
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-auth")) {
                            if (i + 1 >= args.length) {
                                this.printError("-auth requires argument");
                                commandLineError = true;
                            }
                            if (args[++i].equalsIgnoreCase("host")) {
                                authorization = HostAuthorization.getInstance();
                                continue;
                            }
                            if (args[i].equalsIgnoreCase("self")) {
                                authorization = SelfAuthorization.getInstance();
                                continue;
                            }
                            authorization = new IdentityAuthorization(args[i]);
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-xmlsec")) {
                            if (i + 1 >= args.length) {
                                this.printError("-xmlsec requires argument");
                                commandLineError = true;
                            }
                            if (args[++i].equalsIgnoreCase("sig")) {
                                xmlSecurity = GSIConstants.SIGNATURE;
                                continue;
                            }
                            if (args[i].equalsIgnoreCase("enc")) {
                                xmlSecurity = GSIConstants.ENCRYPTION;
                                continue;
                            }
                            this.printError("unsupported -xmlsec argument: " + args[i]);
                            commandLineError = true;
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-personal")) {
                            authorization = SelfAuthorization.getInstance();
                            continue;
                        }
                        if (args[i].equals("-l") || args[i].equalsIgnoreCase("-list")) {
                            options |= 0x4000;
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-state")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-state requires a job handle");
                                continue;
                            }
                            this.state(args[i]);
                            continue;
                        }
                        if (args[i].equals("-r") || args[i].equalsIgnoreCase("-release")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-release requires a job handle");
                                continue;
                            }
                            this.release(args[i]);
                            continue;
                        }
                        if (args[i].equals("-k") || args[i].equalsIgnoreCase("-kill")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-kill requires a job handle");
                                continue;
                            }
                            this.kill(args[i]);
                            continue;
                        }
                        if (args[i].equals("-b") || args[i].equalsIgnoreCase("-batch")) {
                            options |= 0x200;
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-duration")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-duration requires a duration");
                                continue;
                            }
                            dateFormat = new SimpleDateFormat(DURATION_FORMAT);
                            try {
                                serviceDuration = dateFormat.parse(args[i]);
                            }
                            catch (Exception e) {
                                this.printError("service duration '" + args[i] + "' is malformed.\n" + "Format is " + DURATION_FORMAT);
                                commandLineError = true;
                            }
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-terminate-at")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-terminate-at requires a date");
                                continue;
                            }
                            dateFormat = new SimpleDateFormat(DATE_FORMAT);
                            try {
                                serviceTerminationDate = dateFormat.parse(args[i]);
                            }
                            catch (Exception e) {
                                this.printError("termination date/time '" + args[i] + "' is malformed.\n" + "Format is " + DATE_FORMAT);
                                commandLineError = true;
                            }
                            continue;
                        }
                        if (args[i].equals("-d") || args[i].equalsIgnoreCase("-dryrun")) {
                            options |= 4;
                            continue;
                        }
                        if (args[i].equals("-q") || args[i].equalsIgnoreCase("-quiet")) {
                            options |= 2;
                            continue;
                        }
                        if (args[i].equals("-f") || args[i].equalsIgnoreCase("-file")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-file requires a filename");
                                continue;
                            }
                            rslFile = new File(args[i]);
                            continue;
                        }
                        if (args[i].equals("-factory")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-factory requires a factory contact string");
                                break;
                            }
                            contactString = args[i];
                            continue;
                        }
                        if (args[i].equals("-type")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-type requires a factory type. For example: Fork, PBS, LSF, Condor,\nMulti (for multijobs).");
                                break;
                            }
                            factoryType = args[i];
                            if (!factoryType.equals("Multi")) continue;
                            this.limitedDelegation = false;
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-timeout")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-timeout requires a integer value");
                                continue;
                            }
                            try {
                                timeout = Integer.parseInt(args[i]);
                            }
                            catch (NumberFormatException e) {
                                this.printError("timeout '" + args[i] + "' is not an integer value.\n");
                                commandLineError = true;
                            }
                            continue;
                        }
                        if (args[i].equals("-proxy")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-proxy requires a path string");
                                break;
                            }
                            this.proxyPath = args[i];
                            continue;
                        }
                        if (args[i].equals("-deleg")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-deleg requires \"full\" , \"limited\", or \"none\"");
                                break;
                            }
                            String delegArg = args[i].toLowerCase();
                            if (delegArg.equals("full")) {
                                this.delegationEnabled = true;
                                this.limitedDelegation = false;
                                continue;
                            }
                            if (delegArg.equals("limited")) {
                                this.delegationEnabled = true;
                                continue;
                            }
                            if (delegArg.equals("none")) continue;
                            this.printError("-deleg requires either \"full\" , \"limited\", or \"none\"");
                            continue;
                        }
                        if (args[i].equals("-submission-id")) {
                            if (++i == args.length) {
                                commandLineError = true;
                                this.printError("-submission-id requires an ID");
                                break;
                            }
                            this.submissionID = args[i];
                            continue;
                        }
                        this.printError("unknown argument " + args[i]);
                        commandLineError = true;
                        continue;
                    }
                    if (i + 1 == args.length) {
                        if (rslFile != null) {
                            commandLineError = true;
                            this.printError("RSL already specified as a file");
                        }
                        logger.debug((Object)("Reading command line to execute: " + args[i]));
                        simpleJobCommandLine = args[i];
                        continue;
                    }
                    this.printError("unknown argument " + args[i]);
                    commandLineError = true;
                }
                rslParsingOnly = (options & 8) != 0;
                jobListing = (options & 0x4000) != 0;
                boolean bl = jobSubmission = !rslParsingOnly && !jobListing;
                if (jobSubmission && serviceDuration != null && serviceTerminationDate != null) {
                    this.printError("service termination time options are incompatible");
                    commandLineError = true;
                }
                if ((rslParsingOnly || jobSubmission) && simpleJobCommandLine == null && rslFile == null) {
                    this.printError("No RSL specified");
                    commandLineError = true;
                }
                if (jobListing || jobSubmission) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Factory contact string: " + contactString + "\n" + "Factory type: " + factoryType));
                    }
                    try {
                        URL factoryURL = ManagedJobFactoryClientHelper.getServiceURL(contactString).getURL();
                        factoryEndpoint = ManagedJobFactoryClientHelper.getFactoryEndpoint((URL)factoryURL, (String)factoryType);
                        if (!logger.isDebugEnabled()) break block74;
                        Element eprElement = null;
                        try {
                            eprElement = ObjectSerializer.toElement((Object)factoryEndpoint, (QName)RSLHelper.FACTORY_ENDPOINT_ATTRIBUTE_QNAME);
                        }
                        catch (Exception e) {
                            logger.debug((Object)"ERROR: could not serialize EPR", (Throwable)e);
                        }
                        logger.debug((Object)("Factory EPR: " + XmlUtils.toString((Element)eprElement)));
                    }
                    catch (Exception e) {
                        commandLineError = true;
                        this.printError("Could not create factory endpoint reference");
                    }
                }
            }
            if (!commandLineError) {
                if (jobListing) {
                    this.listUserJobs(factoryEndpoint);
                } else if (rslParsingOnly) {
                    try {
                        if (rslFile != null) {
                            RSLHelper.readRSL(rslFile);
                        }
                    }
                    catch (Exception e) {
                        String errorMessage = "Exception while parsing RSL file";
                        logger.debug((Object)errorMessage, (Throwable)e);
                        this.printError("Exception while parsing RSL file" + e.getMessage());
                        this.exit(1);
                    }
                    this.printMessage("RSL file successfully parsed.");
                } else if (jobSubmission) {
                    this.submitRSL(factoryEndpoint, simpleJobCommandLine, rslFile, (Authorization)authorization, xmlSecurity, (options & 0x200) != 0, (options & 4) != 0, (options & 2) != 0, serviceDuration, serviceTerminationDate, timeout);
                }
            }
        }
        if (commandLineError) {
            System.err.println();
            System.err.println(usageDesc);
            this.exit(1);
        }
    }

    private void listUserJobs(EndpointReferenceType factoryEndpoint) {
        List jobHandles = null;
        try {
            jobHandles = GramJob.getJobs(factoryEndpoint);
        }
        catch (Exception e) {
            logger.debug((Object)"Exception retrieving list of submitted jobs", (Throwable)e);
            this.printError("could not obtain list of submitted jobs: " + e.getMessage());
            this.exit(1);
        }
        if (jobHandles == null || jobHandles.size() == 0) {
            System.out.println("No managed jobs for user.");
            this.exit(0);
        }
        boolean error = false;
        Iterator it = jobHandles.iterator();
        while (it.hasNext()) {
            String jobHandle = (String)it.next();
            System.out.println();
            System.out.println("job handle:\n");
            System.out.println(jobHandle);
            GramJob job = this.getExistingJob(jobHandle);
            try {
                System.out.println();
                System.out.println("job RSL:\n" + RSLHelper.convertToString((JobDescriptionType)job.getDescription()));
            }
            catch (Exception e) {
                String errorMessage = i18n.getMessage("FetchJobDescriptionError");
                logger.debug((Object)errorMessage, (Throwable)e);
                this.printError("could not obtain RSL from Managed Job Service");
                error = true;
            }
        }
        if (error) {
            this.exit(1);
        }
        this.exit(0);
    }

    private void release(String jobHandle) {
        GramJob job = this.getExistingJob(jobHandle);
        try {
            job.release();
        }
        catch (Exception e) {
            logger.debug((Object)"Error while releasing job", (Throwable)e);
            this.printError("could not release job " + jobHandle + ": " + e.getMessage());
            this.exit(1);
        }
        this.exit(0);
    }

    private void kill(String jobHandle) {
        GramJob job = this.getExistingJob(jobHandle);
        try {
            logger.debug((Object)"destroyJob() called in kill()");
            this.destroyJob(job);
        }
        catch (Exception e) {
            logger.debug((Object)"Error while destroying job", (Throwable)e);
            this.printError("could not kill job " + jobHandle + ": " + e.getMessage());
            this.exit(1);
        }
        this.exit(0);
    }

    private void state(String jobHandle) {
        GramJob job = this.getExistingJob(jobHandle);
        this.refreshJobStatus(job);
        StateEnumeration jobState = job.getState();
        this.printJobState(jobState, job.isHolding());
        if (jobState.equals((Object)StateEnumeration.Failed)) {
            this.printJobFault(job);
        }
        this.exit(0);
    }

    private void refreshJobStatus(GramJob job) {
        try {
            job.refreshStatus();
        }
        catch (Exception e) {
            logger.debug((Object)"Exception while refreshing job state", (Throwable)e);
            this.printError("could not refresh job state: " + e.getMessage());
            this.exit(1);
        }
    }

    private GramJob getExistingJob(String jobHandle) {
        GramJob job = new GramJob();
        try {
            job.setHandle(jobHandle);
        }
        catch (Exception e) {
            logger.debug((Object)"Exception while setting URL of job service", (Throwable)e);
            this.printError("could not find job with endpoint: " + jobHandle);
            this.exit(1);
        }
        return job;
    }

    private void submitRSL(EndpointReferenceType factoryEndpoint, String simpleJobCommandLine, File rslFile, Authorization authorization, Integer xmlSecurity, boolean batchMode, boolean dryRunMode, boolean quiet, Date duration, Date terminationDate, int timeout) {
        this.quiet = quiet;
        boolean bl = this.batch = batchMode || dryRunMode;
        if (batchMode) {
            this.printMessage("Warning: Will not wait for job completion, and will not destroy job service.");
        }
        if (rslFile != null) {
            try {
                this.job = new GramJob(rslFile);
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse RSL from file " + rslFile;
                logger.debug((Object)errorMessage, (Throwable)e);
                this.printError(errorMessage + " - " + e.getMessage());
                this.exit(2);
            }
        } else {
            this.job = new GramJob(RSLHelper.makeSimpleJob((String)simpleJobCommandLine));
        }
        this.job.setTimeOut(timeout);
        this.job.setAuthorization(authorization);
        this.job.setMessageProtectionType(xmlSecurity);
        this.job.setDelegationEnabled(this.delegationEnabled);
        this.job.setDuration(duration);
        this.job.setTerminationTime(terminationDate);
        try {
            ShutdownHook shutdownHook = new ShutdownHook();
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            logger.debug((Object)"Added shutdown hook");
        }
        catch (Exception e) {
            logger.warn((Object)"Exception while registering shutdown hook: ", (Throwable)e);
        }
        try {
            this.processJob(this.job, factoryEndpoint, this.batch);
        }
        catch (Exception e) {
            logger.debug((Object)"Caught exception: ", (Throwable)e);
            this.printError(e.getMessage());
            this.exit(1);
        }
    }

    private void processJob(GramJob job, EndpointReferenceType factoryEndpoint, boolean batch) {
        if (this.proxyPath != null) {
            try {
                ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
                String handle = "X509_USER_PROXY=" + this.proxyPath.toString();
                GSSCredential proxy = manager.createCredential(handle.getBytes(), 1, 0, null, 0);
                job.setCredentials(proxy);
            }
            catch (Exception e) {
                logger.debug((Object)"Exception while obtaining user proxy: ", (Throwable)e);
                this.printError("error obtaining user proxy: " + e.getMessage());
            }
        }
        if (this.submissionID == null) {
            UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
            this.submissionID = "uuid:" + uuidgen.nextUUID();
        }
        this.printMessage("Submission ID: " + this.submissionID);
        if (!batch) {
            job.addListener(this);
        }
        boolean submitted = false;
        int tries = 0;
        while (!submitted) {
            ++tries;
            try {
                job.submit(factoryEndpoint, batch, this.limitedDelegation, this.submissionID);
                submitted = true;
            }
            catch (Exception e) {
                logger.debug((Object)"Exception while submitting the job request: ", (Throwable)e);
                this.printError("error submitting job request: " + e.getMessage());
                this.exit(1);
            }
        }
        if (batch) {
            this.printMessage("CREATED MANAGED JOB SERVICE WITH HANDLE:");
            this.printMessage(job.getHandle());
        }
        if (logger.isDebugEnabled()) {
            long millis = System.currentTimeMillis();
            BigDecimal seconds = new BigDecimal((double)millis / 1000.0);
            seconds = seconds.setScale(3, 5);
            logger.debug((Object)("submission time, in seconds from the Epoch:\nafter: " + seconds.toString()));
            logger.debug((Object)("\nafter, in milliseconds: " + millis));
        }
        if (!batch) {
            this.printMessage("WAITING FOR JOB TO FINISH");
            this.waitForJobCompletion(60000L);
            try {
                this.destroyJob(this.job);
            }
            catch (Exception e) {
                this.printError("coudl not destroy");
            }
            if (this.job.getState().equals((Object)StateEnumeration.Failed)) {
                this.printJobFault(this.job);
                this.exit(1);
            }
        }
        this.exit(0);
    }

    private synchronized void waitForJobCompletion(long maxWaitPerStateNotificationMillis) {
        long durationToWait = maxWaitPerStateNotificationMillis;
        StateEnumeration oldState = this.job.getState();
        while (!this.jobCompleted) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("job not completed - waiting for state change (timeout before pulling: " + durationToWait + " ms)."));
            }
            long startTime = System.currentTimeMillis();
            try {
                this.wait(durationToWait);
            }
            catch (InterruptedException ie) {
                String errorMessage = "interrupted thread waiting for job to finish";
                logger.debug((Object)errorMessage, (Throwable)ie);
                this.printError(errorMessage);
            }
            StateEnumeration currentState = this.job.getState();
            if (currentState != null && !currentState.equals((Object)oldState)) {
                oldState = currentState;
                durationToWait = maxWaitPerStateNotificationMillis;
                continue;
            }
            long now = System.currentTimeMillis();
            long durationWaited = now - startTime;
            if (durationWaited >= durationToWait) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Did not receive any new notification of job state change after a delay of " + durationToWait + " ms.\nPulling job state."));
                }
                this.refreshJobStatus(this.job);
                durationToWait = 2L * durationToWait;
                continue;
            }
            durationToWait -= durationWaited;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(GramJob job) {
        StateEnumeration jobState = job.getState();
        boolean holding = job.isHolding();
        this.printMessage("========== State Notification ==========");
        this.printJobState(jobState, holding);
        this.printMessage("========================================");
        GlobusRun globusRun = this;
        synchronized (globusRun) {
            if (jobState.equals((Object)StateEnumeration.Done) || jobState.equals((Object)StateEnumeration.Failed)) {
                this.printMessage("Exit Code: " + Integer.toString(job.getExitCode()));
                this.jobCompleted = true;
            }
            this.notifyAll();
            if (holding && !this.batch) {
                logger.debug((Object)"Automatically releasing hold for interactive job");
                try {
                    job.release();
                }
                catch (Exception e) {
                    String errorMessage = "Unable to release job from hold";
                    logger.debug((Object)errorMessage, (Throwable)e);
                    this.printError(errorMessage + " - " + e.getMessage());
                    this.exit(1);
                }
            }
        }
    }

    private void printMessage(String message) {
        if (!this.quiet) {
            System.out.println(message);
        }
    }

    private void printError(String message) {
        System.err.println(ERROR_MESSAGE_PREFIX + message);
    }

    private void printJobState(StateEnumeration jobState, boolean holding) {
        String holdString = "";
        if (holding) {
            holdString = "HOLD ";
        }
        this.printMessage(JOB_STATE_PREFIX + holdString + jobState.getValue());
    }

    private void printJobFault(GramJob job) {
        FaultType fault = job.getFault();
        if (fault != null) {
            this.printMessage("Fault:\n" + FaultUtils.faultToString((BaseFaultType)fault));
        }
    }

    private String convertEPRtoString(EndpointReferenceType endpoint) throws Exception {
        return ObjectSerializer.toString((Object)endpoint, (QName)Constants.QNAME_ENDPOINT_REFERENCE);
    }

    private void destroyJob(GramJob job) throws Exception {
        this.printMessage("DESTROYING JOB RESOURCE");
        job.destroy();
        this.printMessage("JOB RESOURCE DESTROYED");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        private boolean destroyRequestedJob() {
            return GlobusRun.this.isInterrupted && !GlobusRun.this.noInterruptHandling || GlobusRun.this.normalApplicationEnd && !GlobusRun.this.batch || !GlobusRun.this.normalApplicationEnd && !GlobusRun.this.isInterrupted;
        }

        public void run() {
            if (logger.isDebugEnabled() && GlobusRun.this.isInterrupted && !GlobusRun.this.noInterruptHandling) {
                logger.debug((Object)"Handling shutdown signal.");
            }
            if (GlobusRun.this.job != null && GlobusRun.this.job.isRequested() && !GlobusRun.this.job.isLocallyDestroyed() && this.destroyRequestedJob()) {
                try {
                    logger.debug((Object)"destroying job service from shutdown hook");
                    logger.debug((Object)"destroyJob() called in run()");
                    GlobusRun.this.destroyJob(GlobusRun.this.job);
                }
                catch (Exception e) {
                    logger.debug((Object)"Exception while destroying job service: ", (Throwable)e);
                    GlobusRun.this.printError("could not destroy the job service: " + e.getMessage());
                }
            }
        }
    }
}

