/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.tools.wsdd;

import java.io.ByteArrayInputStream;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.globus.wsrf.tools.wsdd.WSDDEditor;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TestWSDDEditor
extends TestCase {
    static final String testServerConfig1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <deployment xmlns=\"http://xml.apache.org/axis/wsdd/\" xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\"> <globalConfiguration>   <parameter name=\"sendMultiRefs\" value=\"true\"/> <parameter name=\"adminPassword\" value=\"admin\"/> <parameter name=\"sweeperThreads\" value=\"3\"/> </globalConfiguration>  <service name=\"core/logging/OgsiLoggingManagementService\" provider=\"Handler\" style=\"wrapped\" use=\"literal\"> <parameter name=\"logBufferSize\" value=\"12\"/>  <parameter name=\"persistent\" value=\"true\"/>   <parameter name=\"allowedMethods\" value=\"*\"/> </service> <service name=\"core/admin/AdminService\" provider=\"Handler\" style=\"wrapped\" use=\"literal\"> <parameter name=\"persistent\" value=\"false\"/>   <parameter name=\"allowedMethods\" value=\"random\"/> </service> </deployment>";
    static /* synthetic */ Class class$org$globus$wsrf$tools$wsdd$TestWSDDEditor;

    public TestWSDDEditor(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$wsrf$tools$wsdd$TestWSDDEditor == null ? (class$org$globus$wsrf$tools$wsdd$TestWSDDEditor = TestWSDDEditor.class$("org.globus.wsrf.tools.wsdd.TestWSDDEditor")) : class$org$globus$wsrf$tools$wsdd$TestWSDDEditor);
    }

    public void testWSDDEditor() throws Exception {
        InputSource is = new InputSource(new ByteArrayInputStream(testServerConfig1.getBytes()));
        Document doc = XmlUtils.newDocument((InputSource)is);
        WSDDEditor testEditor = new WSDDEditor(doc);
        String value = testEditor.getGlobalParameter("adminPassword");
        TestWSDDEditor.assertTrue((boolean)value.equals("admin"));
        TestWSDDEditor.assertTrue((testEditor.getGlobalParameter("dummyparam") == null ? 1 : 0) != 0);
        String[] globalProperties = testEditor.getGlobalProperties();
        TestWSDDEditor.assertTrue((globalProperties != null ? 1 : 0) != 0);
        TestWSDDEditor.assertTrue((globalProperties.length == 3 ? 1 : 0) != 0);
        TestWSDDEditor.assertTrue((boolean)this.validateProperty(globalProperties[2], "sendMultiRefs", "true"));
        TestWSDDEditor.assertTrue((boolean)this.validateProperty(globalProperties[1], "sweeperThreads", "3"));
        TestWSDDEditor.assertTrue((boolean)this.validateProperty(globalProperties[0], "adminPassword", "admin"));
        testEditor.setGlobalParameter("adminPassword", "testPass");
        String val = testEditor.getGlobalParameter("adminPassword");
        TestWSDDEditor.assertTrue((boolean)val.equals("testPass"));
        testEditor.setGlobalParameter("newDummyParam", "testPass");
        String newTestVal = testEditor.getGlobalParameter("newDummyParam");
        TestWSDDEditor.assertTrue((boolean)newTestVal.equals("testPass"));
        testEditor.addGlobalParameter("newDummyParam", "testPass2");
        String appendedVal = testEditor.getGlobalParameter("newDummyParam");
        TestWSDDEditor.assertTrue((boolean)appendedVal.equals("testPass,testPass2"));
        String serviceName1 = "core/logging/OgsiLoggingManagementService";
        val = testEditor.getServiceParameter(serviceName1, "logBufferSize");
        TestWSDDEditor.assertTrue((boolean)val.equals("12"));
        val = testEditor.getServiceParameter(serviceName1, "dummyNewParam");
        TestWSDDEditor.assertTrue((val == null ? 1 : 0) != 0);
        String[] serviceProps = testEditor.getServiceProperties(serviceName1);
        TestWSDDEditor.assertTrue((serviceProps != null ? 1 : 0) != 0);
        TestWSDDEditor.assertTrue((serviceProps.length == 3 ? 1 : 0) != 0);
        TestWSDDEditor.assertTrue((boolean)this.validateProperty(serviceProps[0], "allowedMethods", "*"));
        TestWSDDEditor.assertTrue((boolean)this.validateProperty(serviceProps[1], "persistent", "true"));
        TestWSDDEditor.assertTrue((boolean)this.validateProperty(serviceProps[2], "logBufferSize", "12"));
        testEditor.setServiceParameter(serviceName1, "logBufferSize", "100");
        val = testEditor.getServiceParameter(serviceName1, "logBufferSize");
        TestWSDDEditor.assertTrue((boolean)val.equals("100"));
        testEditor.setServiceParameter(serviceName1, "logNewParam", "dummyVal");
        String newServiceVal = testEditor.getServiceParameter(serviceName1, "logNewParam");
        TestWSDDEditor.assertTrue((boolean)newServiceVal.equals("dummyVal"));
        testEditor.addServiceParameter(serviceName1, "logNewParam", "dummyVal2");
        String newServiceVal1 = testEditor.getServiceParameter(serviceName1, "logNewParam");
        TestWSDDEditor.assertTrue((boolean)newServiceVal1.equals("dummyVal,dummyVal2"));
    }

    private boolean validateProperty(String val, String name, String value) {
        if (val == null) {
            return false;
        }
        try {
            StringTokenizer strtok = new StringTokenizer(val, "=");
            if (strtok.countTokens() != 2) {
                return false;
            }
            if (!name.equals(strtok.nextToken())) {
                return false;
            }
            if (!value.equals(strtok.nextToken())) {
                return false;
            }
        }
        catch (Exception exp) {
            TestWSDDEditor.fail((String)("Unable to parse string" + exp));
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

