/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.globus.rft.generated.RFTOptionsType;
import org.globus.rft.generated.TransferRequestType;
import org.globus.rft.generated.TransferType;

public class TestConfig {
    public static String PORT;
    public static String HOST;
    public static String sourceHost;
    public static String destinationHost;
    public static int sourcePort;
    public static int destPort;
    public static String authType;
    public static String authzVal;
    public static String sourceSubject;
    public static String destinationSubject;
    public static String subject;
    public static Boolean binary;
    public static Integer tcpBufferSize;
    public static Integer blockSize;
    public static Boolean noTpt;
    public static Integer parallelStreams;
    public static Boolean dcau;
    public static Integer concurrency;
    public static Boolean allOrNone;
    public static Boolean backwardsCompatible;
    public static Integer maxAttempts;
    public static String sourcePath;
    public static String destPath;
    public static String PROTOCOL;
    public static String URL_ROOT;
    public static String FACTORY_URL;
    public static String SERVICE_URL;
    public static String GLOBUS_LOCATION;
    public static String GLOBUS_SHARE;
    public static String CONFIG;

    private boolean checkForNull(String property) {
        return property == null || property.equals("");
    }

    public static int toInt(String str) throws NumberFormatException {
        Integer integer = new Integer(str);
        return integer;
    }

    public static boolean toBoolean(String str) {
        Boolean bool = new Boolean(str);
        return bool;
    }

    public static String getSourceUrl() {
        String sourceUrl = "gsiftp://" + sourceHost + ":" + sourcePort + sourcePath;
        return sourceUrl;
    }

    public static String getDestUrl() {
        String destUrl = "gsiftp://" + destinationHost + ":" + destPort + destPath;
        return destUrl;
    }

    public static TransferRequestType setDefaultOptions(TransferRequestType transfer) {
        transfer.setAllOrNone(allOrNone);
        transfer.setConcurrency(concurrency);
        transfer.setMaxAttempts(maxAttempts);
        RFTOptionsType rftOptions = new RFTOptionsType();
        rftOptions.setSubjectName(subject);
        rftOptions.setIgnoreFilePermErr(backwardsCompatible);
        rftOptions.setSourceSubjectName(sourceSubject);
        transfer.setRftOptions(rftOptions);
        return transfer;
    }

    public static TransferRequestType getSingleTransfer() {
        TransferRequestType transfer = new TransferRequestType();
        TransferType[] transferArray = new TransferType[1];
        TestConfig.setDefaultOptions(transfer);
        transferArray[0] = new TransferType();
        transferArray[0].setSourceUrl(TestConfig.getSourceUrl());
        transferArray[0].setDestinationUrl(TestConfig.getDestUrl());
        transfer.setTransfer(transferArray);
        System.out.println(TestConfig.getSourceUrl() + TestConfig.getDestUrl());
        return transfer;
    }

    public static void printConfig() {
        String output = "HOST: " + HOST + " PORT: " + PORT;
        output = output + "AUTHZ " + authzVal + " AUTH: " + authType;
        output = output + " FACTORY_URL" + FACTORY_URL + " ";
        output = output + " SERVICE_URL" + SERVICE_URL + "binary:" + binary;
        TestConfig.getSingleTransfer();
        System.out.println(output);
    }

    public static void main(String[] args) {
        TestConfig.printConfig();
        TestConfig.getSingleTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        sourceSubject = null;
        destinationSubject = null;
        sourcePath = "/etc/group";
        destPath = "/tmp/rftTest.tmp";
        GLOBUS_LOCATION = System.getProperty("GLOBUS_LOCATION");
        GLOBUS_SHARE = "/share/globus_wsrf_rft_test/";
        CONFIG = GLOBUS_LOCATION + GLOBUS_SHARE + "test.properties";
        InputStream in = null;
        System.out.println("Loading: " + CONFIG);
        in = new FileInputStream(CONFIG);
        if (in == null) {
            throw new IOException("Test Configuration File not found: " + CONFIG);
        }
        Properties props = new Properties();
        props.load(in);
        HOST = props.getProperty("HOST");
        PORT = props.getProperty("PORT");
        PROTOCOL = props.getProperty("PROTOCOL");
        URL_ROOT = PROTOCOL + "://" + HOST + ":" + PORT + "/wsrf/services/";
        FACTORY_URL = URL_ROOT + "ReliableFileTransferFactoryService";
        SERVICE_URL = URL_ROOT + "ReliableFileTransferService";
        sourceHost = props.getProperty("sourceHost");
        destinationHost = props.getProperty("destinationHost");
        sourcePort = TestConfig.toInt(props.getProperty("sourcePort"));
        destPort = TestConfig.toInt(props.getProperty("destinationPort"));
        authType = props.getProperty("authType");
        authzVal = props.getProperty("authzVal");
        subject = props.getProperty("subject");
        sourceSubject = props.getProperty("sourceSubject");
        destinationSubject = props.getProperty("destinationSubject");
        binary = new Boolean(props.getProperty("binary"));
        if (!props.getProperty("tcpBufferSize").equals("")) {
            tcpBufferSize = new Integer(props.getProperty("tcpBufferSize"));
        }
        noTpt = new Boolean(props.getProperty("noTpt"));
        if (!props.getProperty("parallelStreams").equals("")) {
            parallelStreams = new Integer(props.getProperty("parallelStreams"));
        }
        dcau = new Boolean(props.getProperty("dcau"));
        concurrency = new Integer(props.getProperty("concurrency"));
        allOrNone = new Boolean(props.getProperty("allOrNone"));
        backwardsCompatible = new Boolean(props.getProperty("compatible"));
        maxAttempts = new Integer(props.getProperty("maxAttempts"));
        sourcePath = props.getProperty("sourcePath");
        destPath = props.getProperty("destPath");
        Object var3_3 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Exception ee) {}
        return;
        {
            catch (Exception e) {
                System.err.println("error " + e.getMessage());
                if (e instanceof NumberFormatException) {
                    System.err.println("Error:Badly formatted numbers in properties file" + e.getMessage());
                }
                Object var3_4 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Exception ee) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

