/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service.test;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPElement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.rft.generated.BaseRequestType;
import org.globus.rft.generated.Cancel;
import org.globus.rft.generated.CancelResponse;
import org.globus.rft.generated.GetStatus;
import org.globus.rft.generated.GetStatusResponse;
import org.globus.rft.generated.GetStatusSet;
import org.globus.rft.generated.GetStatusSetResponse;
import org.globus.rft.generated.OverallStatus;
import org.globus.rft.generated.ReliableFileTransferFactoryPortType;
import org.globus.rft.generated.ReliableFileTransferPortType;
import org.globus.rft.generated.RequestStatusType;
import org.globus.rft.generated.Start;
import org.globus.rft.generated.StartOutputType;
import org.globus.rft.generated.TotalBytesTransferredResource;
import org.globus.rft.generated.TransferStatusType;
import org.globus.rft.generated.service.ReliableFileTransferFactoryServiceAddressingLocator;
import org.globus.rft.generated.service.ReliableFileTransferServiceAddressingLocator;
import org.globus.transfer.reliable.client.BaseRFTClient;
import org.globus.transfer.reliable.client.ReliableFileDeleteClient;
import org.globus.transfer.reliable.client.ReliableFileTransferClient;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.transfer.reliable.service.test.TestConfig;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.w3c.dom.Element;

public class RFTTest
extends TestCase {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$test$RFTTest == null ? (class$org$globus$transfer$reliable$service$test$RFTTest = RFTTest.class$("org.globus.transfer.reliable.service.test.RFTTest")) : class$org$globus$transfer$reliable$service$test$RFTTest).getName());
    public static String GLOBUS_LOCATION = System.getProperty("GLOBUS_LOCATION");
    public static String GLOBUS_SHARE = "/share/globus_wsrf_rft_test/";
    public static String PREFIX = GLOBUS_LOCATION + GLOBUS_SHARE;
    private static final String G_L = System.getProperty("GLOBUS_LOCATION");
    static final String SERVICE_URL_ROOT = "/wsrf/services/";
    static NotificationConsumerManager consumer = null;
    private static ReliableFileTransferFactoryServiceAddressingLocator rftFactoryLocator = new ReliableFileTransferFactoryServiceAddressingLocator();
    private static ReliableFileTransferFactoryPortType factoryPort;
    private static ReliableFileTransferServiceAddressingLocator rftLocator;
    private static String source_file;
    private static String dest_file;
    private static String source_file2;
    private static String rftTestDir;
    private boolean dir_transfer = false;
    private boolean tpt_transfer = false;
    private boolean set_transfer = false;
    private boolean delete = false;
    private boolean empty_dir = false;
    private boolean allOrNone = false;
    private boolean delete_dir = false;
    protected static final String TRANSFER;
    private static String DIR_TRANSFER;
    private static String TPT_TRANSFER;
    private static String TRANSFER_SET;
    private static String DELETE_SET;
    private static String EMPTY_DIR;
    private static String ALL_OR_NONE;
    private static String DELETE_DIR;
    private static String host;
    private static int port;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$test$RFTTest;
    static /* synthetic */ Class class$org$globus$rft$generated$OverallStatus;
    static /* synthetic */ Class class$org$globus$rft$generated$RequestStatusType;
    static /* synthetic */ Class class$org$globus$rft$generated$TotalBytesTransferredResource;

    public RFTTest(String name) {
        super(name);
    }

    public static void main(String[] as) {
        logger.debug((Object)"MAIN");
        TestSuite testSuite = null;
        if (testSuite == null) {
            testSuite = new TestSuite(class$org$globus$transfer$reliable$service$test$RFTTest == null ? (class$org$globus$transfer$reliable$service$test$RFTTest = RFTTest.class$("org.globus.transfer.reliable.service.test.RFTTest")) : class$org$globus$transfer$reliable$service$test$RFTTest);
        }
        TestRunner.run(testSuite);
    }

    public static Test suite() {
        return new TestSuite(class$org$globus$transfer$reliable$service$test$RFTTest == null ? (class$org$globus$transfer$reliable$service$test$RFTTest = RFTTest.class$("org.globus.transfer.reliable.service.test.RFTTest")) : class$org$globus$transfer$reliable$service$test$RFTTest);
    }

    public void testTransferEPR() throws Exception {
        logger.debug((Object)"testTransferEPR()");
        EndpointReferenceType transferEPR = this.createRFT(TRANSFER);
        RFTTest.assertTrue((transferEPR != null ? 1 : 0) != 0);
        RFTTest.assertTrue((transferEPR.getAddress() != null ? 1 : 0) != 0);
        String address = transferEPR.getAddress().toString();
        System.out.println("rft service URL:" + address);
        ReferencePropertiesType props = transferEPR.getProperties();
        RFTTest.assertTrue((props.get_any() != null ? 1 : 0) != 0);
        RFTTest.assertTrue((props.get_any().length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < props.get_any().length; ++i) {
            String referenceProperty = XmlUtils.toString((Element)AnyHelper.toElement((MessageElement)props.get_any()[i]));
            System.out.println("reference property #" + i + "\n" + referenceProperty);
        }
        RFTTest.assertTrue((props.get_any()[0] != null ? 1 : 0) != 0);
        String keyValue = props.get_any()[0].getValue();
        System.out.println("transfer resource ID = " + keyValue);
    }

    public void testRepeatedlyStarted() throws Exception {
        logger.debug((Object)"testRepeatedlyStarted");
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        try {
            StartOutputType startResponse1 = rft.start(new Start());
        }
        catch (Exception es) {
            RFTTest.assertTrue((boolean)true);
        }
    }

    public void testTransfer() throws Exception {
        logger.debug((Object)"testTransfer");
        this.cleanupDestination();
        RFTTest.setupFiles();
        Thread.sleep(10000L);
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        File destFile = new File(dest_file);
        destFile.deleteOnExit();
        Thread.sleep(50000L);
        RFTTest.assertTrue((boolean)destFile.exists());
    }

    public void testGetStatus() throws Exception {
        logger.debug((Object)"testGetStatus");
        RFTTest.setupFiles();
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        Thread.sleep(50000L);
        GetStatusResponse getStatusResponse = rft.getStatus(new GetStatus("gsiftp://localhost:2811/tmp/rftTest.tmp"));
        RFTTest.assertTrue((getStatusResponse != null ? 1 : 0) != 0);
        TransferStatusType transferStatus = getStatusResponse.getTransferStatus();
        System.out.println("Status: " + transferStatus.getStatus().toString());
        RFTTest.assertTrue((transferStatus != null ? 1 : 0) != 0);
    }

    public void testGetStatusSet() throws Exception {
        logger.debug((Object)"testGetStatusSet");
        RFTTest.setupFiles();
        this.set_transfer = true;
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        Thread.sleep(50000L);
        GetStatusSetResponse getStatusSetResponse = rft.getStatusSet(new GetStatusSet(1, 9));
        RFTTest.assertTrue((getStatusSetResponse != null ? 1 : 0) != 0);
        TransferStatusType[] transferStatus = getStatusSetResponse.getTransferStatusSet();
        int length = transferStatus.length;
        System.out.println("Length of status set : " + length);
        RFTTest.assertTrue((length == 9 ? 1 : 0) != 0);
        for (int i = 0; i < transferStatus.length; ++i) {
            System.out.println("Status: " + transferStatus[i].getStatus().toString());
            RFTTest.assertTrue((transferStatus[i] != null ? 1 : 0) != 0);
        }
        RFTTest.assertTrue((transferStatus != null ? 1 : 0) != 0);
    }

    public void testCancel() throws Exception {
        logger.debug((Object)"testCancel");
        RFTTest.setupFiles();
        this.set_transfer = true;
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        Thread.sleep(100L);
        Cancel cancelParams = new Cancel(-1, -1);
        CancelResponse response = rft.cancel(cancelParams);
        RFTTest.assertTrue((response != null ? 1 : 0) != 0);
        Thread.sleep(1000L);
        GetStatusSetResponse getStatusSetResponse = rft.getStatusSet(new GetStatusSet(1, 9));
        RFTTest.assertTrue((getStatusSetResponse != null ? 1 : 0) != 0);
        TransferStatusType[] transferStatus = getStatusSetResponse.getTransferStatusSet();
        int length = transferStatus.length;
        System.out.println("Length of status set : " + length);
        RFTTest.assertTrue((length == 9 ? 1 : 0) != 0);
        for (int i = 0; i < transferStatus.length; ++i) {
            String status = transferStatus[i].getStatus().toString();
            System.out.println("Status: " + status);
            RFTTest.assertTrue((boolean)status.equals("Cancelled"));
        }
        RFTTest.assertTrue((transferStatus != null ? 1 : 0) != 0);
    }

    public void testDirTransfer() throws Exception {
        logger.debug((Object)"testDirTransfer");
        File destFile = new File(source_file);
        destFile.delete();
        this.dir_transfer = true;
        this.setupTmpDir();
        Thread.sleep(10000L);
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        Thread.sleep(50000L);
        destFile = new File(source_file);
        RFTTest.assertTrue((boolean)destFile.exists());
    }

    public void testTptTransfer() throws Exception {
        logger.debug((Object)"testTptTransfer");
        this.tpt_transfer = true;
        this.cleanupDestination();
        RFTTest.setupFiles();
        Thread.sleep(10000L);
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        File destFile = new File(dest_file);
        destFile.deleteOnExit();
        Thread.sleep(50000L);
        RFTTest.assertTrue((boolean)destFile.exists());
    }

    public void testOverallStatus() throws Exception {
        logger.debug((Object)"testOverallStatus");
        RFTTest.setupFiles();
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        GetResourcePropertyResponse response = rft.getResourceProperty(RFTConstants.OVERALL_STATUS_RESOURCE);
        MessageElement[] any = response.get_any();
        RFTTest.assertTrue((any != null ? 1 : 0) != 0);
        RFTTest.assertTrue((any.length > 0 ? 1 : 0) != 0);
        OverallStatus status = (OverallStatus)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$globus$rft$generated$OverallStatus == null ? (class$org$globus$rft$generated$OverallStatus = RFTTest.class$("org.globus.rft.generated.OverallStatus")) : class$org$globus$rft$generated$OverallStatus));
        System.out.println("status : " + status.getTransfersFinished());
        RFTTest.assertTrue((status != null ? 1 : 0) != 0);
    }

    public void testRequestStatusRP() throws Exception {
        logger.debug((Object)"testRequestStatusRP");
        RFTTest.setupFiles();
        this.set_transfer = true;
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        Thread.sleep(3000L);
        GetResourcePropertyResponse response = rft.getResourceProperty(RFTConstants.REQUEST_STATUS_RESOURCE);
        MessageElement[] any = response.get_any();
        RFTTest.assertTrue((any != null ? 1 : 0) != 0);
        RFTTest.assertTrue((any.length > 0 ? 1 : 0) != 0);
        RequestStatusType status = (RequestStatusType)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$globus$rft$generated$RequestStatusType == null ? (class$org$globus$rft$generated$RequestStatusType = RFTTest.class$("org.globus.rft.generated.RequestStatusType")) : class$org$globus$rft$generated$RequestStatusType));
        System.out.println("request status : " + status.getRequestStatus().getValue());
        RFTTest.assertTrue((status != null ? 1 : 0) != 0);
    }

    public void testTotalBytesTransferred() throws Exception {
        logger.debug((Object)"testTotalBytesTransferred");
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        Thread.sleep(10000L);
        GetResourcePropertyResponse response = rft.getResourceProperty(RFTConstants.TOTAL_BYTES_RESOURCE);
        MessageElement[] any = response.get_any();
        RFTTest.assertTrue((any != null ? 1 : 0) != 0);
        RFTTest.assertTrue((any.length > 0 ? 1 : 0) != 0);
        TotalBytesTransferredResource totalBytes = (TotalBytesTransferredResource)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$org$globus$rft$generated$TotalBytesTransferredResource == null ? (class$org$globus$rft$generated$TotalBytesTransferredResource = RFTTest.class$("org.globus.rft.generated.TotalBytesTransferredResource")) : class$org$globus$rft$generated$TotalBytesTransferredResource));
        System.out.println("Total bytes: " + totalBytes.getTotalBytes());
        RFTTest.assertTrue((totalBytes.getTotalBytes() > 0L ? 1 : 0) != 0);
    }

    public void testMultipleResourceProperties_Factory_RFT() throws Exception {
        logger.debug((Object)"testMultipleResourceProperties_Factory_RFT");
        ReliableFileTransferFactoryPortType factoryPort = BaseRFTClient.getFactoryPort((String)TestConfig.FACTORY_URL);
        BaseRFTClient.setSecurity((Stub)((Stub)factoryPort));
        QName[] propNames = new QName[]{RFTConstants.ACTIVE_RESOURCE_COUNT_FACTORY, RFTConstants.TOTAL_TRANSFER_COUNT_FACTORY, RFTConstants.DELEGATION_ENDPOINT_FACTORY, RFTConstants.RFT_FACTORY_START_TIME, RFTConstants.TOTAL_BYTES_FACTORY, RFTConstants.TOTAL_ACTIVE_TRANSFERS_FACTORY};
        GetMultipleResourceProperties_Element requestProp = new GetMultipleResourceProperties_Element();
        requestProp.setResourceProperty(propNames);
        GetMultipleResourcePropertiesResponse responseProp = factoryPort.getMultipleResourceProperties(requestProp);
        MessageElement[] any = responseProp.get_any();
        RFTTest.assertTrue((any != null ? 1 : 0) != 0);
        System.out.println("Resource Properties of factory:\n");
        for (int i = 0; i < any.length; ++i) {
            Element rpElement = AnyHelper.toElement((MessageElement)any[i]);
            System.out.println(XmlUtils.toString((Element)rpElement));
        }
        RFTTest.assertTrue((any[0] != null ? 1 : 0) != 0);
        RFTTest.assertTrue((any[1] != null ? 1 : 0) != 0);
        RFTTest.assertTrue((any.length >= 6 ? 1 : 0) != 0);
    }

    public void testMultipleResourceProperties_Resource_RFT() throws Exception {
        logger.debug((Object)"testMultipleResourceProperties_Resource_RFT");
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        Thread.sleep(30000L);
        QName[] propNamesInstance = new QName[]{RFTConstants.OVERALL_STATUS_RESOURCE};
        GetMultipleResourceProperties_Element requestPropInstance = new GetMultipleResourceProperties_Element();
        requestPropInstance.setResourceProperty(propNamesInstance);
        GetMultipleResourcePropertiesResponse responsePropInstance = rft.getMultipleResourceProperties(requestPropInstance);
        MessageElement[] anyInstance = responsePropInstance.get_any();
        RFTTest.assertTrue((anyInstance.length >= 1 ? 1 : 0) != 0);
    }

    public void testDelete() throws Exception {
        logger.debug((Object)"testDelete");
        this.delete = true;
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        File destFile = new File(dest_file);
        Thread.sleep(5000L);
        RFTTest.assertTrue((!destFile.exists() ? 1 : 0) != 0);
    }

    public void testEmptyDir() throws Exception {
        logger.debug((Object)"testEmptyDir");
        this.empty_dir = true;
        File dirCleanup = new File(rftTestDir);
        dirCleanup.delete();
        dirCleanup.mkdir();
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        String dest_file1 = "/tmp/RFT_TEST2/rftTest_Done.tmp";
        File destFile = new File(dest_file1);
        Thread.sleep(5000L);
        RFTTest.assertTrue((boolean)destFile.exists());
    }

    public void testDeleteDir() throws Exception {
        logger.debug((Object)"testDeleteDir");
        this.delete_dir = true;
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        File deleteDir = new File("/tmp/RFT_TEST/");
        Thread.sleep(5000L);
        RFTTest.assertTrue((!deleteDir.exists() ? 1 : 0) != 0);
    }

    public void testAllOrNone() throws Exception {
        logger.debug((Object)"testAllOrNone");
        this.allOrNone = true;
        ReliableFileTransferPortType rft = this.getRFTPort();
        StartOutputType startResponse = rft.start(new Start());
        RFTTest.assertTrue((startResponse != null ? 1 : 0) != 0);
        Thread.sleep(10000L);
        File destFile1 = new File("/tmp/rftTest_Done1.tmp");
        RFTTest.assertTrue((!destFile1.exists() ? 1 : 0) != 0);
    }

    private void cleanup() throws Exception {
        logger.debug((Object)"cleanup");
        File dir1 = new File(rftTestDir);
        dir1.delete();
        File dir2 = new File("/tmp/RFT_TEST2");
        dir2.delete();
        File testFile = new File(source_file);
        testFile.delete();
        File testFile2 = new File(dest_file);
        testFile2.delete();
    }

    private static void setupFiles() throws Exception {
        int c;
        logger.debug((Object)"setupFiles");
        File sourceFile = new File(source_file);
        File copyFile = new File(TRANSFER);
        FileReader in = new FileReader(copyFile);
        FileWriter out = new FileWriter(sourceFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    private void setupTmpDir() throws Exception {
        logger.debug((Object)"setupTmpDir");
        File dirFile = new File(rftTestDir);
        boolean dirExists = dirFile.mkdir();
        if (dirExists) {
            int c;
            File sourceFile = new File(source_file2);
            File copyFile = new File(TRANSFER);
            FileReader in = new FileReader(copyFile);
            FileWriter out = new FileWriter(sourceFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
    }

    private void cleanupDestination() throws Exception {
        logger.debug((Object)"cleanupDestination");
        File destFile = new File(dest_file);
        if (destFile.exists()) {
            destFile.delete();
        }
    }

    public ReliableFileTransferPortType getRFTPort() throws Exception {
        EndpointReferenceType rftEPR = this.dir_transfer ? this.createRFT(DIR_TRANSFER) : (this.tpt_transfer ? this.createRFT(TPT_TRANSFER) : (this.set_transfer ? this.createRFT(TRANSFER_SET) : (this.delete ? this.createRFT(DELETE_SET) : (this.empty_dir ? this.createRFT(EMPTY_DIR) : (this.allOrNone ? this.createRFT(ALL_OR_NONE) : (this.delete_dir ? this.createRFT(DELETE_DIR) : this.createRFT(TRANSFER)))))));
        rftEPR.setAddress((AttributedURI)new Address(TestConfig.SERVICE_URL));
        ReliableFileTransferPortType rft = rftLocator.getReliableFileTransferPortTypePort(rftEPR);
        BaseRFTClient.setSecurity((Stub)((Stub)rft));
        return rft;
    }

    private EndpointReferenceType createRFT(String reqFile) throws Exception {
        RFTTest.setOptions();
        EndpointReferenceType credEPR = BaseRFTClient.delegateCredential((String)TestConfig.HOST, (String)TestConfig.PORT);
        Object baseRequestType = this.delete ? ReliableFileDeleteClient.getDeleteRequest((String)reqFile, (EndpointReferenceType)credEPR) : (this.delete_dir ? ReliableFileDeleteClient.getDeleteRequest((String)reqFile, (EndpointReferenceType)credEPR) : ReliableFileTransferClient.getTransfer((String)reqFile, (EndpointReferenceType)credEPR));
        return BaseRFTClient.createRFT((String)TestConfig.FACTORY_URL, (BaseRequestType)baseRequestType);
    }

    public static void setOptions() {
        logger.debug((Object)"setOptions");
        BaseRFTClient.HOST = TestConfig.HOST;
        BaseRFTClient.PORT = TestConfig.PORT;
        BaseRFTClient.PROTOCOL = TestConfig.PROTOCOL;
        String authType = TestConfig.authType;
        if (authType.equals("GSI_SEC_MSG")) {
            BaseRFTClient.authType = "org.globus.security.secMsg.msg.type";
        } else if (authType.equals("GSI_SEC_CONV")) {
            BaseRFTClient.authType = "org.globus.security.secConv.msg.type";
        } else if (authType.equals("GSI_TRANSPORT")) {
            BaseRFTClient.authType = "org.globus.security.transport.type";
        }
        BaseRFTClient.authVal = GSIConstants.SIGNATURE;
        BaseRFTClient.authzVal = AuthUtil.getClientAuthorization((String)TestConfig.authzVal);
        TestConfig.printConfig();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        rftLocator = new ReliableFileTransferServiceAddressingLocator();
        source_file = "/tmp/rftTest.tmp";
        dest_file = "/tmp/rftTest_Done.tmp";
        source_file2 = "/tmp/RFT_TEST/rftTest.tmp";
        rftTestDir = "/tmp/RFT_TEST";
        TRANSFER = PREFIX + "/transfer.xfr";
        DIR_TRANSFER = PREFIX + "/dir_transfer.xfr";
        TPT_TRANSFER = PREFIX + "/tpt_transfer.xfr";
        TRANSFER_SET = PREFIX + "/transfer_set.xfr";
        DELETE_SET = PREFIX + "/delete.xfr";
        EMPTY_DIR = PREFIX + "/empty_dir.xfr";
        ALL_OR_NONE = PREFIX + "/all_or_none.xfr";
        DELETE_DIR = PREFIX + "/delete_dir.xfr";
        host = "127.0.0.1";
        port = 8080;
    }
}

